/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.callback.SourceCallback;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.SourceMethod;

public class SourceAnnotationVerifier
implements ModuleAnnotationVerifier {
    private static final String POLLING_PERIOD_FIELD = "pollingPeriod";

    public boolean shouldVerify(Module module) {
        return (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) && module.hasSources();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        for (Method method : module.getSourceMethods()) {
            try {
                if (((SourceMethod)method).shouldRunOnPrimaryNodeOnly() && !module.getMinMuleVersion().atLeastBase("3.3")) {
                    gatherer.error((Identifiable)method, (DevkitNotification)Message.PRIMARY_NODE_ONLY_ATTRIBUTE_ONLY_WORKS_WITH_MULE_33, new Object[0]);
                }
            }
            catch (IllegalArgumentException iae) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.MIN_MULE_VERSION_PARSE_ERROR, new Object[0]);
            }
            if (method.isStatic()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.SOURCE_CANNOT_BE_STATIC, new Object[0]);
            }
            if (!method.getTypeParameters().isEmpty()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.SOURCE_CANNOT_BE_GENERIC, new Object[0]);
            }
            if (!method.isPublic()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.SOURCE_MUST_BE_PUBLIC, new Object[0]);
            }
            boolean containsSourceCallback = false;
            List parameters = method.getParameters();
            for (Parameter parameter : parameters) {
                if (parameter.asTypeMirror().toString().startsWith(SourceCallback.class.getName())) {
                    containsSourceCallback = true;
                }
                if (parameter.asTypeMirror().toString().startsWith(MuleEvent.class.getName()) || parameter.asTypeMirror().toString().startsWith(MuleMessage.class.getName()) || parameter.asTypeMirror().toString().startsWith(MuleContext.class.getName())) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.SOURCE_CANNOT_HAVE_MULE_EVENT_OR_MESSAGE_AS_PARAMETER, new Object[]{parameter.getJavaType()});
                }
                if (parameter.isReservedIdentifier()) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.SOURCE_PARAMETER_USES_RESERVED_IDENTIFIER, new Object[]{parameter.getName(), parameter.getName()});
                }
                if (!parameter.getName().equals(POLLING_PERIOD_FIELD) || !((SourceMethod)method).isPolling()) continue;
                gatherer.error((Identifiable)parameter, (DevkitNotification)Message.POLLINGPERIOD_PARAMETER_RESERVED, new Object[]{parameter.getName()});
            }
            if (!containsSourceCallback) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.SOURCE_METHOD_MISSING_SOURCECALLBACK_PARAM, new Object[0]);
            }
            this.verifyPollingStrategy((SourceMethod)method, gatherer);
        }
    }

    public void verifyPollingStrategy(SourceMethod sourceMethod, NotificationGatherer gatherer) throws AnnotationVerificationException {
        if (!sourceMethod.isPolling() && sourceMethod.getPollingPeriod() != -1L) {
            gatherer.error((Identifiable)sourceMethod, (DevkitNotification)Message.POLLINGPERIOD_ONLY_ALLOWED_FOR_POLLING_SOURCESTRATEGY, new Object[]{sourceMethod.getName()});
        }
        if (sourceMethod.isPolling() && sourceMethod.getPollingPeriod() == -1L) {
            gatherer.error((Identifiable)sourceMethod, (DevkitNotification)Message.POLLINGPERIOD_REQUIRES_DEFAULT_VALUE, new Object[]{sourceMethod.getName()});
        }
    }
}

