/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.schema.global;

import java.math.BigInteger;
import java.util.List;
import javax.xml.namespace.QName;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.spring.schema.RegisteredElements;
import org.mule.devkit.generation.spring.schema.global.AbstractGlobalElementSchemaBuilder;
import org.mule.devkit.generation.spring.schema.global.util.GlobalElementSchemaBuilderResolver;
import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.EnumType;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.OAuth2Component;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.schema.Attribute;
import org.mule.devkit.model.schema.ComplexContent;
import org.mule.devkit.model.schema.ExplicitGroup;
import org.mule.devkit.model.schema.ExtensionType;
import org.mule.devkit.model.schema.GroupRef;
import org.mule.devkit.model.schema.LocalComplexType;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.devkit.model.schema.TopLevelComplexType;
import org.mule.devkit.model.schema.TopLevelElement;
import org.mule.util.StringUtils;

public class OAuthSchemaResolver
extends AbstractGlobalElementSchemaBuilder {
    private RegisteredElements registeredElements;

    public OAuthSchemaResolver(RegisteredElements registeredElements) {
        this.registeredElements = registeredElements;
    }

    @Override
    protected RegisteredElements getRegisteredElements() {
        return this.registeredElements;
    }

    @Override
    public void buildGlobalElementElement(Module module, Context ctx) {
        OAuthCapability oAuthCapability = OAuth2StrategyUtilsResolver.getOAuthCapability(module);
        OAuth2Component oAuth2Component = null;
        if (module.manager().oauth2Component().isPresent()) {
            oAuth2Component = (OAuth2Component)module.manager().oauth2Component().get();
        }
        this.registerGlobalElementElement(module, ctx, new OAuthGlobalElementSchemaBuilderResolver(oAuthCapability, oAuth2Component));
    }

    @Override
    public void registerProcessorsAndSourcesAndFilters(Module module) {
        this.registerProcessorElement(false, "authorize", "AuthorizeType", "Starts OAuth authorization process. It must be called from a flow with an http:inbound-endpoint.");
        this.registerProcessorElement(false, "unauthorize", "UnauthorizeType", "Unauthorizes the connector, forcing to re-use authorize again before accessing any protected message processor.");
        OAuthCapability oAuthCapability = OAuth2StrategyUtilsResolver.getOAuthCapability(module);
        this.registerAuthorizeType(module, oAuthCapability);
        this.registerUnauthorizeType();
    }

    private void generateOauthAccessTokenElement(String name, String docDescription, ExplicitGroup all) {
        LocalComplexType collectionComplexType = new LocalComplexType();
        GroupRef group = this.generateNestedProcessorGroup();
        collectionComplexType.setGroup(group);
        TopLevelElement collectionElement = new TopLevelElement();
        collectionElement.setName(name);
        collectionElement.setMinOccurs(BigInteger.ZERO);
        collectionElement.setMaxOccurs("1");
        collectionElement.setComplexType(collectionComplexType);
        collectionElement.setAnnotation(this.createDocAnnotation(docDescription));
        all.getParticle().add(this.getObjectFactory().createElement(collectionElement));
    }

    private void generateOAuthStoreConfigElement(ExplicitGroup all) {
        Attribute objectStoreRefAttribute = new Attribute();
        objectStoreRefAttribute.setUse("required");
        objectStoreRefAttribute.setName("objectStore-ref");
        objectStoreRefAttribute.setType(SchemaConstants.STRING);
        ExtensionType extensionType = new ExtensionType();
        extensionType.setBase(SchemaConstants.MULE_ABSTRACT_EXTENSION_TYPE);
        extensionType.getAttributeOrAttributeGroup().add(objectStoreRefAttribute);
        ComplexContent complexContent = new ComplexContent();
        complexContent.setExtension(extensionType);
        LocalComplexType localComplexType = new LocalComplexType();
        localComplexType.setComplexContent(complexContent);
        TopLevelElement collectionElement = new TopLevelElement();
        collectionElement.setName("oauth-store-config");
        collectionElement.setMinOccurs(BigInteger.ZERO);
        collectionElement.setMaxOccurs("1");
        collectionElement.setComplexType(localComplexType);
        collectionElement.setAnnotation(this.createDocAnnotation("Configuration element for storage of access tokens"));
        all.getParticle().add(this.getObjectFactory().createElement(collectionElement));
    }

    private void registerAuthorizeType(Module module, OAuthCapability oAuthCapability) {
        TopLevelComplexType complexType = new TopLevelComplexType();
        complexType.setName("AuthorizeType");
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(SchemaConstants.MULE_ABSTRACT_MESSAGE_PROCESSOR_TYPE);
        complexContent.setExtension(complexContentExtension);
        Attribute configRefAttr = this.createAttribute("config-ref", false, SchemaConstants.STRING, "Specify which configuration to use for this invocation.");
        complexContentExtension.getAttributeOrAttributeGroup().add(configRefAttr);
        ExplicitGroup all = new ExplicitGroup();
        complexContentExtension.setSequence(all);
        if (oAuthCapability.getOAuthVersion() == OAuthVersion.V2) {
            complexContentExtension.getAttributeOrAttributeGroup().add(this.createAttribute("state", true, new QName("http://www.w3.org/2001/XMLSchema", "string", "xs"), "Any value that you wish to be sent with the callback"));
        }
        if (oAuthCapability.getAuthorizationParameters() != null) {
            for (OAuthAuthorizationParameter parameter : oAuthCapability.getAuthorizationParameters()) {
                if (!this.isTypeSupported(parameter.getType().asTypeMirror()) && !parameter.getType().isEnum()) continue;
                complexContentExtension.getAttributeOrAttributeGroup().add(this.createTypeAttribute(parameter.getName(), parameter.getType(), parameter.isOptional(), parameter.getDefaultValue()));
            }
        }
        Attribute accessTokenUrlAttribute = this.createAttribute("accessTokenUrl", true, SchemaConstants.STRING, "The URL defined by the Service Provider to obtain an access token");
        complexContentExtension.getAttributeOrAttributeGroup().add(accessTokenUrlAttribute);
        Attribute accessTokenIdAttribute = this.createAttribute("accessTokenId", true, SchemaConstants.STRING, "The Id with which the obtained access token will be stored. If not provided, then it will be the config name");
        complexContentExtension.getAttributeOrAttributeGroup().add(accessTokenIdAttribute);
        Attribute authorizationUrlAttribute = this.createAttribute("authorizationUrl", true, SchemaConstants.STRING, "The URL defined by the Service Provider where the resource owner will be redirected to grant authorization to the connector");
        complexContentExtension.getAttributeOrAttributeGroup().add(authorizationUrlAttribute);
        if (oAuthCapability.getOAuthVersion() == OAuthVersion.V10A) {
            Attribute requestTokenUrlAttribute = this.createAttribute("requestTokenUrl", true, SchemaConstants.STRING, "The URL defined by the Service Provider used to obtain an un-authorized request token");
            complexContentExtension.getAttributeOrAttributeGroup().add(requestTokenUrlAttribute);
        }
        if (all.getParticle().size() == 0) {
            complexContentExtension.setSequence(null);
        }
        this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(complexType);
    }

    private Attribute createTypeAttribute(String name, Type type, boolean isOptional, String defaultValue) {
        Attribute attribute = new Attribute();
        attribute.setUse(isOptional ? "optional" : "required");
        if (this.isTypeSupported(type.asTypeMirror())) {
            attribute.setName(name);
            attribute.setType(SchemaTypeConversion.convertType((String)this.getSchema().getTargetNamespace(), (String)type.asTypeMirror().toString()));
        } else if (type.isEnum()) {
            attribute.setName(name);
            attribute.setType(new QName(this.getSchema().getTargetNamespace(), type.asType().getName() + "EnumType"));
            this.getRegisteredEnums().add((EnumType)type.asType());
        }
        attribute.setAnnotation(this.createDocAnnotation(type.getJavaDocSummary()));
        if (StringUtils.isNotBlank((String)defaultValue)) {
            attribute.setDefault(defaultValue);
        }
        return attribute;
    }

    private void registerUnauthorizeType() {
        TopLevelComplexType complexType = new TopLevelComplexType();
        complexType.setName("UnauthorizeType");
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(SchemaConstants.MULE_ABSTRACT_MESSAGE_PROCESSOR_TYPE);
        complexContent.setExtension(complexContentExtension);
        complexContentExtension.getAttributeOrAttributeGroup().add(this.createAttribute("accessTokenId", true, SchemaTypeConversion.convertType((String)this.getSchema().getTargetNamespace(), (String)"java.lang.String"), "The id of the access token that will be used to authenticate the call"));
        Attribute configRefAttr = this.createAttribute("config-ref", false, SchemaConstants.STRING, "Specify which configuration to use for this invocation.");
        complexContentExtension.getAttributeOrAttributeGroup().add(configRefAttr);
        this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(complexType);
    }

    private class OAuthGlobalElementSchemaBuilderResolver
    implements GlobalElementSchemaBuilderResolver {
        private OAuthCapability oAuthCapability;
        private OAuth2Component oAuth2Component;

        private OAuthGlobalElementSchemaBuilderResolver(OAuthCapability oAuthCapability, OAuth2Component oAuth2Component) {
            this.oAuthCapability = oAuthCapability;
            this.oAuth2Component = oAuth2Component;
        }

        @Override
        public String resolveConfigElementName(Module module) {
            String configElementName = module.getConfigElementName();
            if (this.hasOAuthComponent()) {
                configElementName = this.oAuth2Component.configElementName();
            }
            return configElementName;
        }

        @Override
        public List<Field> resolveConfigurableFields(Module module) {
            List configurableFields = module.getConfigurableFields();
            if (this.hasOAuthComponent()) {
                configurableFields.addAll(this.oAuth2Component.getConfigurableFields());
            }
            return configurableFields;
        }

        @Override
        public void resolvePostGenerationGroup(Module module, ExtensionType config, ExplicitGroup all) {
            OAuthSchemaResolver.this.generateHttpCallbackElement("oauth-callback-config", all, this.oAuthCapability);
            if (this.oAuthCapability.getOAuthVersion().equals((Object)OAuthVersion.V10A)) {
                OAuthSchemaResolver.this.generateOauthAccessTokenElement("oauth-save-access-token", "A chain of message processors processed synchronously that can be used to save OAuth state. They will be executed once the connector acquires an OAuth access token.", all);
                OAuthSchemaResolver.this.generateOauthAccessTokenElement("oauth-restore-access-token", "A chain of message processors processed synchronously that can be used to restore OAuth state. They will be executed whenever access to a protected resource is requested and the connector is not authorized yet.", all);
            } else {
                OAuthSchemaResolver.this.generateOAuthStoreConfigElement(all);
            }
            Attribute accessTokenUrlAttribute = OAuthSchemaResolver.this.createAttribute("accessTokenUrl", true, SchemaConstants.STRING, "The URL defined by the Service Provider to obtain an access token", this.oAuthCapability.getAccessTokenUrl());
            config.getAttributeOrAttributeGroup().add(accessTokenUrlAttribute);
            Attribute onNoTokenAttribute = OAuthSchemaResolver.this.createAttribute("onNoToken", true, SchemaConstants.ON_NO_TOKEN_TYPE, "The URL defined by the Service Provider to obtain an access token");
            config.getAttributeOrAttributeGroup().add(onNoTokenAttribute);
            onNoTokenAttribute.setDefault("EXCEPTION");
            onNoTokenAttribute.setType(new QName(OAuthSchemaResolver.this.getSchema().getTargetNamespace(), "OnNoTokenPolicyEnumType"));
            Attribute authorizationUrlAttribute = OAuthSchemaResolver.this.createAttribute("authorizationUrl", true, SchemaConstants.STRING, "The URL defined by the Service Provider where the resource owner will be redirected to grant authorization to the connector", this.oAuthCapability.getAuthorizationUrl());
            config.getAttributeOrAttributeGroup().add(authorizationUrlAttribute);
            if (this.oAuthCapability.getOAuthVersion() == OAuthVersion.V10A) {
                Attribute requestTokenUrlAttribute = OAuthSchemaResolver.this.createAttribute("requestTokenUrl", true, SchemaConstants.STRING, "The URL defined by the Service Provider used to obtain an un-authorized request token", this.oAuthCapability.getRequestTokenUrl());
                config.getAttributeOrAttributeGroup().add(requestTokenUrlAttribute);
            }
        }

        @Override
        public String resolveJavaDocSummary(Module module) {
            String javaDocSummary = module.getJavaDocSummary();
            if (this.hasOAuthComponent()) {
                javaDocSummary = this.oAuth2Component.getJavaDocSummary();
            }
            return javaDocSummary;
        }

        private boolean hasOAuthComponent() {
            return this.oAuth2Component != null;
        }
    }
}

