/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.beans.global;

import com.google.common.base.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.ConnectStrategy;
import org.mule.config.PoolingProfile;
import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.devkit.generation.spring.beans.global.AbstractGlobalElementDefinitionParserGenerator;
import org.mule.devkit.generation.spring.beans.global.util.GlobalElementBeanDefinitionParserResolver;
import org.mule.devkit.generation.utils.MuleGeneratorUtils;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ConnectionManagementCapability;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.devkit.utils.NameUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ConnectionManagementDefinitionParserGenerator
extends AbstractGlobalElementDefinitionParserGenerator {
    @Override
    public void generateGlobalElement(Module module) {
        if (!module.manager().connectionManagementComponents().isEmpty()) {
            for (ConnectionManagementComponent connectionManagementComponent : module.manager().connectionManagementComponents()) {
                this.generateConfigBeanDefinitionParserFor(module, new ConnectionManagementGlobalElementResolver((ConnectionManagementCapability)connectionManagementComponent, connectionManagementComponent));
            }
        } else {
            this.generateConfigBeanDefinitionParserFor(module, new ConnectionManagementGlobalElementResolver((ConnectionManagementCapability)module, null));
        }
    }

    private void generateParseConnectMethod(ConnectMethod connectMethod, GeneratedMethod parse, GeneratedVariable element, GeneratedVariable parserContext, GeneratedVariable builder) {
        for (Parameter variable : connectMethod.getParameters()) {
            String fieldName = variable.getName();
            if (SchemaTypeConversion.isSupported((String)variable.asTypeMirror().toString())) {
                this.generateParseProperty(parse.body(), element, builder, variable.getAlternativeName(), fieldName);
                continue;
            }
            if (variable.asType().isArrayOrList()) {
                this.generateParseList(parse.body(), element, builder, (Identifiable)variable, fieldName, parserContext, variable.getDefaultValue(), true, 0);
                continue;
            }
            if (variable.asType().isMap()) {
                this.generateParseMap(parse.body(), element, builder, (Identifiable)variable, fieldName, variable.getDefaultValue(), true);
                continue;
            }
            if (variable.asType().isEnum()) {
                this.generateParseProperty(parse.body(), element, builder, variable.getAlternativeName(), fieldName);
                continue;
            }
            if (!variable.asType().isSet()) continue;
            this.generateParseSet(parse.body(), element, builder, (Identifiable)variable, fieldName, parserContext, variable.getDefaultValue(), true, 0);
        }
    }

    private void parseComplexChild(GeneratedBlock body, TypeReference pojoClass, GeneratedVariable element, GeneratedVariable builder, GeneratedVariable parserContext) {
        body.decl((org.mule.devkit.model.code.Type)this.ref(BeanDefinitionBuilder.class), "connectionStrategyConfigBuilder", (GeneratedExpression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((GeneratedExpression)pojoClass.dotclass().invoke("getName")));
        GeneratedVariable connectionStrategyConfigElement = body.decl((org.mule.devkit.model.code.Type)this.ref(Element.class), "connectionStrategyConfigElement", (GeneratedExpression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((GeneratedExpression)element).arg(NameUtils.uncamel((String)pojoClass.name())));
        GeneratedBlock ifElementNotNull = body._if(connectionStrategyConfigElement.isNotNull())._then();
        GeneratedVariable child = ifElementNotNull.decl((org.mule.devkit.model.code.Type)this.ref(ChildDefinitionParser.class), "child", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ChildDefinitionParser.class)).arg(StringUtils.uncapitalize((String)pojoClass.name())).arg(pojoClass.dotclass()));
        ifElementNotNull.add((Statement)child.invoke("forceParent").arg((GeneratedExpression)builder.invoke("getBeanDefinition")));
        ifElementNotNull.add((Statement)child.invoke("parse").arg((GeneratedExpression)connectionStrategyConfigElement).arg((GeneratedExpression)parserContext));
    }

    private void generateParsePoolingProfile(String elementName, String propertyName, GeneratedMethod parse, GeneratedVariable element, GeneratedVariable builder) {
        GeneratedVariable poolingProfileBuilder = parse.body().decl((org.mule.devkit.model.code.Type)this.ref(BeanDefinitionBuilder.class), propertyName + "Builder", (GeneratedExpression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((GeneratedExpression)this.ref(PoolingProfile.class).dotclass().invoke("getName")));
        GeneratedVariable poolingProfileElement = parse.body().decl((org.mule.devkit.model.code.Type)this.ref(Element.class), propertyName + "Element", (GeneratedExpression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((GeneratedExpression)element).arg(elementName));
        GeneratedConditional ifElementNotNull = parse.body()._if(poolingProfileElement.isNotNull());
        this.generateParseProperty(ifElementNotNull._then(), poolingProfileElement, poolingProfileBuilder, "maxActive");
        this.generateParseProperty(ifElementNotNull._then(), poolingProfileElement, poolingProfileBuilder, "maxIdle");
        this.generateParseProperty(ifElementNotNull._then(), poolingProfileElement, poolingProfileBuilder, "maxWait");
        GeneratedConditional ifNotNull = ifElementNotNull._then()._if((GeneratedExpression)ExpressionFactory.invoke((String)"hasAttribute").arg((GeneratedExpression)poolingProfileElement).arg("exhaustedAction"));
        ifNotNull._then().add((Statement)poolingProfileBuilder.invoke("addPropertyValue").arg("exhaustedAction").arg((GeneratedExpression)this.ref(PoolingProfile.class).staticRef("POOL_EXHAUSTED_ACTIONS").invoke("get").arg((GeneratedExpression)poolingProfileElement.invoke("getAttribute").arg("exhaustedAction"))));
        ifNotNull = ifElementNotNull._then()._if((GeneratedExpression)ExpressionFactory.invoke((String)"hasAttribute").arg((GeneratedExpression)poolingProfileElement).arg("initialisationPolicy"));
        ifNotNull._then().add((Statement)poolingProfileBuilder.invoke("addPropertyValue").arg("initialisationPolicy").arg((GeneratedExpression)this.ref(PoolingProfile.class).staticRef("POOL_INITIALISATION_POLICIES").invoke("get").arg((GeneratedExpression)poolingProfileElement.invoke("getAttribute").arg("initialisationPolicy"))));
        ifNotNull = ifElementNotNull._then()._if((GeneratedExpression)ExpressionFactory.invoke((String)"hasAttribute").arg((GeneratedExpression)poolingProfileElement).arg("evictionCheckIntervalMillis"));
        this.generateParseProperty(ifNotNull._then(), poolingProfileElement, poolingProfileBuilder, "evictionCheckIntervalMillis");
        ifNotNull = ifElementNotNull._then()._if((GeneratedExpression)ExpressionFactory.invoke((String)"hasAttribute").arg((GeneratedExpression)poolingProfileElement).arg("minEvictionMillis"));
        this.generateParseProperty(ifNotNull._then(), poolingProfileElement, poolingProfileBuilder, "minEvictionMillis");
        ifElementNotNull._then().add((Statement)builder.invoke("addPropertyValue").arg(propertyName).arg((GeneratedExpression)poolingProfileBuilder.invoke("getBeanDefinition")));
    }

    private class ConnectionManagementGlobalElementResolver
    implements GlobalElementBeanDefinitionParserResolver {
        private ConnectionManagementCapability connectionManagementCapability;
        private ConnectionManagementComponent connectionManagementComponent;

        private ConnectionManagementGlobalElementResolver(ConnectionManagementCapability connectionManagementCapability, ConnectionManagementComponent connectionManagementComponent) {
            this.connectionManagementCapability = connectionManagementCapability;
            this.connectionManagementComponent = connectionManagementComponent;
        }

        @Override
        public String getConfigElementName(Module module) {
            if (this.hasBasicComponent()) {
                return this.connectionManagementComponent.configElementName();
            }
            return module.getConfigElementName();
        }

        @Override
        public GeneratedClass resolveModuleObject(Module module) {
            return ConnectionManagementDefinitionParserGenerator.this.getModuleObject((Type)module, this.connectionManagementComponent);
        }

        @Override
        public GeneratedClass resolveConfigBeanDefinitionParserClass(Module module) {
            return ConnectionManagementDefinitionParserGenerator.this.getConfigBeanDefinitionParserClass(module, (Optional<? extends ConnectionComponent>)Optional.fromNullable((Object)this.connectionManagementComponent));
        }

        @Override
        public void generatePostBuilder(Module module, GeneratedClass moduleObject, GeneratedMethod parseMethod, GeneratedVariable elementParam, GeneratedVariable parserContextParam, GeneratedVariable builder) {
            parseMethod.body().invoke("setInitMethodIfNeeded").arg((GeneratedExpression)builder).arg(moduleObject.dotclass());
            parseMethod.body().invoke("setDestroyMethodIfNeeded").arg((GeneratedExpression)builder).arg(moduleObject.dotclass());
            if (this.hasBasicComponent()) {
                for (Field field : this.connectionManagementComponent.getConfigurableFields()) {
                    ConnectionManagementDefinitionParserGenerator.this.generateParseVariable(parseMethod.body(), (Variable)field, elementParam, parserContextParam, builder, false, true, 0);
                }
            }
            ConnectionManagementDefinitionParserGenerator.this.generateParseConnectMethod(this.connectionManagementCapability.getConnectMethod(), parseMethod, elementParam, parserContextParam, builder);
            if (ConnectStrategy.MULTIPLE_INSTANCES.equals((Object)this.connectionManagementCapability.getConnectMethod().getStrategy())) {
                ConnectionManagementDefinitionParserGenerator.this.generateParsePoolingProfile("connection-pooling-profile", "poolingProfile", parseMethod, elementParam, builder);
            } else {
                ConnectionManagementDefinitionParserGenerator.this.parseComplexChild(parseMethod.body(), MuleGeneratorUtils.getPoolConfig(module, ConnectionManagementDefinitionParserGenerator.this.ctx()), elementParam, builder, parserContextParam);
            }
        }

        private boolean hasBasicComponent() {
            return this.connectionManagementComponent != null;
        }

        @Override
        public GeneratedExpression getClassForBeanDefinitionBuilder(Module module, GeneratedClass moduleObject) {
            return moduleObject.dotclass();
        }

        @Override
        public void generatePostBeanDefinition(GeneratedMethod parseMethod, GeneratedVariable elementParam, GeneratedVariable parserContextParam, GeneratedVariable builder, GeneratedVariable definition) {
            parseMethod.body().invoke("parseRetryPolicyTemplate").arg("reconnect").arg((GeneratedExpression)elementParam).arg((GeneratedExpression)parserContextParam).arg((GeneratedExpression)builder).arg((GeneratedExpression)definition);
            parseMethod.body().invoke("parseRetryPolicyTemplate").arg("reconnect-forever").arg((GeneratedExpression)elementParam).arg((GeneratedExpression)parserContextParam).arg((GeneratedExpression)builder).arg((GeneratedExpression)definition);
            parseMethod.body().invoke("parseRetryPolicyTemplate").arg("reconnect-custom-strategy").arg((GeneratedExpression)elementParam).arg((GeneratedExpression)parserContextParam).arg((GeneratedExpression)builder).arg((GeneratedExpression)definition);
        }
    }
}

