/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.callback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

@JustOnce
public class CallbackInterfacesGenerator
implements ModuleGenerator {
    private static final String CALLBACK_NAMESPACE = ".callback";
    private static final String HTTP_CALLBACK_INTERFACE_NAME = "HttpCallback";
    private static final String SOURCE_CALLBACK_INTERFACE_NAME = "SourceCallback";
    private static final String STOP_SOURCE_CALLBACK_INTERFACE_NAME = "StopSourceCallback";
    protected Context context;

    public boolean shouldGenerate(Module module) {
        return false;
    }

    public void generate(Module module) throws GenerationException {
        try {
            this.generateHttpCallbackInterface(module);
            this.generateSourceCallbackInterface(module);
            this.generateStopSourceCallbackInterface(module);
        }
        catch (ClassAlreadyExistsException classAlreadyExistsException) {
            // empty catch block
        }
    }

    private void generateStopSourceCallbackInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + CALLBACK_NAMESPACE);
        GeneratedClass clazz = pkg._interface(STOP_SOURCE_CALLBACK_INTERFACE_NAME);
        clazz.javadoc().append((Object)"Callback returned by methods that are annotated with @Source\n<p/>\nIt will be executed when the MessageSource is being stopped.");
        this.ctx().registerProduct(Product.STOP_SOURCE_CALLBACK_INTERFACE, (Object)clazz);
        clazz.direct("void stop() throws Exception;");
    }

    private void generateSourceCallbackInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + CALLBACK_NAMESPACE);
        GeneratedClass clazz = pkg._interface(SOURCE_CALLBACK_INTERFACE_NAME);
        clazz.javadoc().append((Object)"Callback interface used by {@link org.mule.api.annotations.Source} annotated methods to dispatch messages.");
        this.ctx().registerProduct(Product.SOURCE_CALLBACK_INTERFACE, (Object)clazz);
        clazz.direct("    /**\n     * Dispatch the current event to the flow\n     *\n     * @return The response of the flow\n     */\n    Object process() throws Exception;\n\n    /**\n     * Dispatch message to the flow\n     *\n     * @param payload The payload of the message\n     * @return The response of the flow\n     */\n    Object process(Object payload) throws Exception;\n\n    /**\n     * Dispatch message to the flow with properties\n     *\n     * @param payload    The payload of the message\n     * @param properties Properties to be attached with inbound scope\n     * @return The response of the flow\n     */\n    Object process(Object payload, java.util.Map<String, Object> properties) throws Exception;\n\n    /**\n     * Dispatch the current event to the flow\n     *\n     * @return The response of the flow\n     */\n    org.mule.api.MuleEvent processEvent(org.mule.api.MuleEvent event) throws org.mule.api.MuleException;");
    }

    private void generateHttpCallbackInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + CALLBACK_NAMESPACE);
        GeneratedClass clazz = pkg._interface(HTTP_CALLBACK_INTERFACE_NAME);
        clazz._extends(this.ref(Startable.class));
        clazz._extends(this.ref(Stoppable.class));
        clazz._extends(this.ref(MuleContextAware.class));
        this.ctx().registerProduct(Product.HTTP_CALLBACK_INTERFACE, (Object)clazz);
        clazz.direct("String getUrl();");
    }

    public List<Product> consumes() {
        return new ArrayList<Product>();
    }

    public List<Product> produces() {
        return Arrays.asList(Product.CALLBACK_INTERFACES);
    }

    public Context ctx() {
        return this.context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }

    protected TypeReference ref(Class<?> clazz) {
        return this.ctx().getCodeModel().ref(clazz);
    }

    protected Type ref(TypeMirror typeMirror) {
        return this.ctx().getCodeModel().ref(typeMirror);
    }

    protected Type ref(Module module) {
        return this.ctx().getCodeModel().ref(module.asTypeMirror());
    }
}

