/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.beans;

import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.spring.beans.AbstractBeanDefinitionParsersGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.devkit.utils.NameUtils;
import org.mule.routing.MessageFilter;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class MethodsBeanDefinitionParserGenerator
extends AbstractBeanDefinitionParsersGenerator {
    public void generate(Module module) {
        for (Method executableElement : module.getFilterMethods()) {
            this.generateBeanDefinitionParserForFilter(module, executableElement);
        }
        for (Method executableElement : module.getProcessorMethods()) {
            this.generateBeanDefinitionParserForProcessor(module, executableElement);
        }
        for (Method executableElement : module.getSourceMethods()) {
            this.generateBeanDefinitionParserForSource(module, executableElement);
        }
    }

    private void generateBeanDefinitionParserForFilter(Module module, Method filterMethod) {
        if (this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, filterMethod.parent(), filterMethod.getName()) != null) {
            return;
        }
        GeneratedClass beanDefinitionparser = this.getBeanDefinitionParserClass((Method<Type>)filterMethod);
        GeneratedClass messageProcessorClass = (GeneratedClass)this.ctx().getProduct(Product.FILTER, filterMethod.parent(), filterMethod.getName());
        this.ctx().note("Generating bean definition parser as " + beanDefinitionparser.fullName() + " for filter " + messageProcessorClass.fullName());
        GeneratedField loggerField = this.generateLoggerField(beanDefinitionparser);
        this.generateGetBeanDefinitionBuilder(beanDefinitionparser, loggerField, messageProcessorClass, module, filterMethod.getName(), "@Filter");
        this.generateFilterParseMethod(beanDefinitionparser, messageProcessorClass, filterMethod, module);
    }

    private void generateProcessorParseMethod(GeneratedClass definitionParser, GeneratedClass messageProcessorClass, Method processorMethod, Module module) {
        GeneratedMethod parse = definitionParser.method(1, (org.mule.devkit.model.code.Type)this.ref(BeanDefinition.class), "parse");
        GeneratedVariable element = parse.param((org.mule.devkit.model.code.Type)this.ref(Element.class), "element");
        GeneratedVariable parserContext = parse.param((org.mule.devkit.model.code.Type)this.ref(ParserContext.class), "parserContext");
        GeneratedVariable definition = this.generateParseCommon(messageProcessorClass, (Method<? extends Type>)processorMethod, parse, element, parserContext, true, module);
        parse.body().invoke("attachProcessorDefinition").arg((GeneratedExpression)parserContext).arg((GeneratedExpression)definition);
        parse.body()._return((GeneratedExpression)definition);
    }

    private void generateBeanDefinitionParserForProcessor(Module module, Method processorMethod) {
        if (this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, processorMethod.parent(), processorMethod.getName()) != null) {
            return;
        }
        GeneratedClass beanDefinitionparser = this.getBeanDefinitionParserClass((Method<Type>)processorMethod);
        GeneratedClass messageProcessorClass = (GeneratedClass)this.ctx().getProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName());
        GeneratedClass messageProcessorDebuggableClass = (GeneratedClass)this.ctx().getProduct(Product.MESSAGE_PROCESSOR_DEBUGGABLE, processorMethod.parent(), processorMethod.getName());
        this.ctx().note("Generating bean definition parser as " + beanDefinitionparser.fullName() + " for message processor " + messageProcessorClass.fullName());
        GeneratedField loggerField = this.generateLoggerField(beanDefinitionparser);
        this.generateGetBeanDefinitionBuilderForProcessors(beanDefinitionparser, loggerField, messageProcessorClass, messageProcessorDebuggableClass, module, processorMethod.getName());
        this.generateProcessorParseMethod(beanDefinitionparser, messageProcessorClass, processorMethod, module);
    }

    private void generateBeanDefinitionParserForSource(Module module, Method sourceMethod) {
        if (this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, sourceMethod.parent(), sourceMethod.getName()) != null) {
            return;
        }
        GeneratedClass beanDefinitionparser = this.getBeanDefinitionParserClass((Method<Type>)sourceMethod);
        GeneratedClass messageSourceClass = (GeneratedClass)this.ctx().getProduct(Product.MESSAGE_SOURCE, sourceMethod.parent(), sourceMethod.getName());
        this.ctx().note("Generating bean definition parser as " + beanDefinitionparser.fullName() + " for message source " + messageSourceClass.fullName());
        GeneratedField loggerField = this.generateLoggerField(beanDefinitionparser);
        this.generateGetBeanDefinitionBuilder(beanDefinitionparser, loggerField, messageSourceClass, module, sourceMethod.getName(), "@Source");
        this.generateSourceParseMethod(beanDefinitionparser, messageSourceClass, sourceMethod, module);
    }

    private void generateSourceParseMethod(GeneratedClass definitionParser, GeneratedClass messageProcessorClass, Method sourceMethod, Module module) {
        GeneratedMethod parse = definitionParser.method(1, (org.mule.devkit.model.code.Type)this.ref(BeanDefinition.class), "parse");
        GeneratedVariable element = parse.param((org.mule.devkit.model.code.Type)this.ref(Element.class), "element");
        GeneratedVariable parserContext = parse.param((org.mule.devkit.model.code.Type)this.ref(ParserContext.class), "parserContext");
        GeneratedVariable definition = this.generateParseCommon(messageProcessorClass, (Method<? extends Type>)sourceMethod, parse, element, parserContext, true, module);
        parse.body().invoke("attachSourceDefinition").arg((GeneratedExpression)parserContext).arg((GeneratedExpression)definition);
        parse.body()._return((GeneratedExpression)definition);
    }

    private void generateFilterParseMethod(GeneratedClass definitionParser, GeneratedClass filterClass, Method filterMethod, Module module) {
        GeneratedMethod parse = definitionParser.method(1, (org.mule.devkit.model.code.Type)this.ref(BeanDefinition.class), "parse");
        GeneratedVariable element = parse.param((org.mule.devkit.model.code.Type)this.ref(Element.class), "element");
        GeneratedVariable parserContext = parse.param((org.mule.devkit.model.code.Type)this.ref(ParserContext.class), "parserContext");
        GeneratedVariable definition = this.generateParseCommon(filterClass, (Method<? extends Type>)filterMethod, parse, element, parserContext, false, module);
        GeneratedVariable messageFilterBuilder = parse.body().decl((org.mule.devkit.model.code.Type)this.ref(BeanDefinitionBuilder.class), "messageFilterBuilder", (GeneratedExpression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((GeneratedExpression)this.ref(MessageFilter.class).dotclass().invoke("getName")));
        parse.body().invoke((GeneratedExpression)messageFilterBuilder, "addPropertyValue").arg("filter").arg((GeneratedExpression)definition);
        parse.body().invoke("attachProcessorDefinition").arg((GeneratedExpression)parserContext).arg((GeneratedExpression)messageFilterBuilder.invoke("getBeanDefinition"));
        parse.body()._return((GeneratedExpression)definition);
    }

    private GeneratedVariable generateParseCommon(GeneratedClass messageProcessorClass, Method<? extends Type> method, GeneratedMethod parse, GeneratedVariable element, GeneratedVariable parserContext, boolean hasAtrribute, Module module) {
        GeneratedVariable builder = parse.body().decl((org.mule.devkit.model.code.Type)this.ref(BeanDefinitionBuilder.class), "builder", (GeneratedExpression)ExpressionFactory.invoke((String)"getBeanDefinitionBuilder").arg((GeneratedExpression)parserContext));
        if (hasAtrribute) {
            parse.body().add((Statement)builder.invoke("addConstructorArgValue").arg(method.getName()));
        }
        parse.body().invoke((GeneratedExpression)builder, "setScope").arg((GeneratedExpression)this.ref(BeanDefinition.class).staticRef("SCOPE_PROTOTYPE"));
        if (!module.isConfigless()) {
            String scope = "@Processor";
            String hyphenatedName = NameUtils.uncamel((String)method.getName());
            GeneratedExpression expressionError = ExpressionFactory.lit((String)("It seems that the config-ref for " + (String)scope + " [" + hyphenatedName + "] within the connector [" + module.getModuleName() + "] is null or missing. Please, fill the value with the correct global element."));
            parse.body()._if(Op.not((GeneratedExpression)ExpressionFactory.invoke((String)"hasAttribute").arg((GeneratedExpression)element).arg("config-ref")))._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(BeanDefinitionParsingException.class)).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Problem.class)).arg(expressionError).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Location.class)).arg((GeneratedExpression)parserContext.invoke("getReaderContext").invoke("getResource"))).arg(ExpressionFactory._null())));
            parse.body().invoke("parseConfigRef").arg((GeneratedExpression)element).arg((GeneratedExpression)builder);
        }
        for (Parameter variable : method.getParameters()) {
            GeneratedBlock body = parse.body();
            boolean oneChildElementOnly = method.hasOnlyOneChildElement();
            if (variable.shouldBeIgnored()) continue;
            this.generateParseVariable(body, (Variable)variable, element, parserContext, builder, oneChildElementOnly, false, 0);
        }
        if (method instanceof ProcessorMethod) {
            ProcessorMethod mp = (ProcessorMethod)method;
            if (mp.canBeUsedInConnectionManagement() || mp.module().manager().connectionManagementOverride().isPresent()) {
                ConnectMethod connectMethod = mp.canBeUsedInConnectionManagement() ? mp.getManagedConnectionModule().getConnectMethod() : ((ConnectionManagementComponent)mp.module().manager().connectionManagementOverride().get()).getConnectMethod();
                for (Parameter variable : connectMethod.getParameters()) {
                    if (variable.shouldBeIgnored()) continue;
                    String fieldName = variable.getName();
                    if (SchemaTypeConversion.isSupported((String)variable.asTypeMirror().toString())) {
                        this.generateParseProperty(parse.body(), element, builder, variable.getAlternativeName(), fieldName);
                        continue;
                    }
                    if (variable.asType().isArrayOrList()) {
                        this.generateParseList(parse.body(), element, builder, (Identifiable)variable, fieldName, parserContext, variable.getDefaultValue(), false, 0);
                        continue;
                    }
                    if (variable.asType().isMap()) {
                        this.generateParseMap(parse.body(), element, builder, (Identifiable)variable, fieldName, variable.getDefaultValue(), false);
                        continue;
                    }
                    if (variable.asType().isEnum()) {
                        this.generateParseProperty(parse.body(), element, builder, variable.getAlternativeName(), fieldName);
                        continue;
                    }
                    if (!variable.asType().isSet()) continue;
                    this.generateParseSet(parse.body(), element, builder, (Identifiable)variable, fieldName, parserContext, variable.getDefaultValue(), true, 0);
                }
            }
            if (mp.canBeUsedInOAuthManagement() || mp.module().manager().oauth2Component().isPresent()) {
                this.generateParseProperty(parse.body(), element, builder, "accessTokenId");
            }
            if (mp.isPaged()) {
                this.generateParseProperty(parse.body(), element, builder, "fetchSize", "fetchSize");
            }
        }
        if (method instanceof SourceMethod && ((SourceMethod)method).isPolling()) {
            this.generateParseProperty(parse.body(), element, builder, "pollingPeriod", "pollingPeriod");
        }
        GeneratedVariable definition = parse.body().decl((org.mule.devkit.model.code.Type)this.ref(BeanDefinition.class), "definition", (GeneratedExpression)builder.invoke("getBeanDefinition"));
        parse.body().invoke("setNoRecurseOnDefinition").arg((GeneratedExpression)definition);
        return definition;
    }

    private GeneratedClass getBeanDefinitionParserClass(Method<Type> method) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((Type)method.parent()).getPackage().getName() + ".generated.config");
        GeneratedClass clazz = pkg._class(method.getCapitalizedName() + "DefinitionParser", this.ref(AbstractDevkitBasedDefinitionParser.class));
        this.ctx().registerProduct(Product.BEAN_DEFINITION_PARSER, method.parent(), method.getName(), (Object)clazz);
        return clazz;
    }
}

