/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.spring.schema.SchemaBuilder;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.schema.Schema;
import org.mule.devkit.model.schema.SchemaLocation;

public class SchemaGenerator
extends AbstractCodeGenerator
implements MultiModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.NAMESPACE_HANDLER, Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, Product.OAUTH_ADAPTER, Product.POOL_CONFIG, Product.POOL_IMPL, Product.CACHE_CONFIG, Product.CACHE_IMPL);
    private static final List<Product> PRODUCES = Arrays.asList(Product.SCHEMA);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> processableModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            processableModules.add(module);
        }
        return processableModules;
    }

    public void generate(List<Module> modules) throws GenerationException {
        for (Module module : modules) {
            String targetNamespace = module.getXmlNamespace();
            SchemaBuilder schemaBuilder = SchemaBuilder.newSchema(targetNamespace);
            schemaBuilder.importXmlNamespace().importSpringFrameworkNamespace().importMuleNamespace();
            schemaBuilder.registerConfigOrStrategyElement(module, this.ctx()).registerProcessorsAndSourcesAndFilters(module).registerTransformers(module);
            schemaBuilder.registerEnums();
            schemaBuilder.registerSimpleTypes();
            String fileName = "META-INF/mule-" + module.getModuleName() + ".xsd";
            String versionedLocation = module.getVersionedSchemaLocation();
            String currentLocation = module.getCurrentSchemaLocation();
            String namespaceHandlerName = ((GeneratedClass)this.ctx().getProduct(Product.NAMESPACE_HANDLER, null, targetNamespace)).boxify().fullName();
            Schema schema = schemaBuilder.getSchema();
            SchemaLocation versionedSchemaLocation = new SchemaLocation(schema, schema.getTargetNamespace(), fileName, versionedLocation, namespaceHandlerName);
            this.ctx().getSchemaModel().addSchemaLocation(versionedSchemaLocation);
            if (currentLocation == null) continue;
            SchemaLocation currentSchemaLocation = new SchemaLocation(null, schema.getTargetNamespace(), fileName, currentLocation, namespaceHandlerName);
            this.ctx().getSchemaModel().addSchemaLocation(currentSchemaLocation);
        }
    }
}

