/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.beans.global;

import com.google.common.base.Optional;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.spring.beans.global.AbstractGlobalElementDefinitionParserGenerator;
import org.mule.devkit.generation.spring.beans.global.util.GlobalElementBeanDefinitionParserResolver;
import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.OAuth2Component;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class OAuthDefinitionParserGenerator
extends AbstractGlobalElementDefinitionParserGenerator {
    @Override
    public void generateGlobalElement(Module module) {
        OAuthCapability oAuthCapability = OAuth2StrategyUtilsResolver.getOAuthCapability(module);
        OAuth2Component oAuth2Component = null;
        if (module.manager().oauth2Component().isPresent()) {
            oAuth2Component = (OAuth2Component)module.manager().oauth2Component().get();
        }
        this.generateConfigBeanDefinitionParserFor(module, new OAuthGlobalElementResolver(oAuthCapability, oAuth2Component));
    }

    private void generateParseOAuthStoreConfig(String elementName, GeneratedMethod parse, GeneratedVariable element, GeneratedVariable builder) {
        GeneratedVariable oauthStoreConfigElement = parse.body().decl((org.mule.devkit.model.code.Type)this.ref(Element.class), "oauthStoreConfigElement", (GeneratedExpression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((GeneratedExpression)element).arg(elementName));
        GeneratedBlock ifOAuthStoreConfigNotNull = parse.body()._if(oauthStoreConfigElement.isNotNull())._then();
        this.generateParsePropertyRef(ifOAuthStoreConfigNotNull, oauthStoreConfigElement, builder, "objectStore-ref", "accessTokenObjectStore");
    }

    private class OAuthGlobalElementResolver
    implements GlobalElementBeanDefinitionParserResolver {
        private OAuthCapability oAuthCapability;
        private OAuth2Component oAuth2Component;

        private OAuthGlobalElementResolver(OAuthCapability oAuthCapability, OAuth2Component oAuth2Component) {
            this.oAuthCapability = oAuthCapability;
            this.oAuth2Component = oAuth2Component;
        }

        @Override
        public String getConfigElementName(Module module) {
            if (this.hasOAuthComponent()) {
                return this.oAuth2Component.configElementName();
            }
            return module.getConfigElementName();
        }

        @Override
        public GeneratedClass resolveModuleObject(Module module) {
            return OAuthDefinitionParserGenerator.this.getModuleObject((Type)module, this.oAuthCapability);
        }

        @Override
        public GeneratedClass resolveConfigBeanDefinitionParserClass(Module module) {
            return OAuthDefinitionParserGenerator.this.getConfigBeanDefinitionParserClass(module, (Optional<? extends ConnectionComponent>)Optional.fromNullable((Object)this.oAuth2Component));
        }

        @Override
        public void generatePostBuilder(Module module, GeneratedClass moduleObject, GeneratedMethod parseMethod, GeneratedVariable elementParam, GeneratedVariable parserContextParam, GeneratedVariable builder) {
            if (this.oAuthCapability.getOAuthVersion().equals((Object)OAuthVersion.V10A)) {
                GeneratedClass manager = (GeneratedClass)OAuthDefinitionParserGenerator.this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)module);
                GeneratedVariable managerBuilder = parseMethod.body().decl((org.mule.devkit.model.code.Type)OAuthDefinitionParserGenerator.this.ref(BeanDefinitionBuilder.class), "managerBuilder", (GeneratedExpression)OAuthDefinitionParserGenerator.this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((GeneratedExpression)manager.dotclass().invoke("getName")));
                parseMethod.body().add((Statement)builder.invoke("addConstructorArgValue").arg((GeneratedExpression)managerBuilder.invoke("getBeanDefinition")));
            }
            GeneratedExpression managerClassReference = moduleObject.dotclass();
            if (module.hasRestCalls()) {
                String restAdapterClass = this.getRestAdapterClass(module);
                managerClassReference = ExpressionFactory.direct((String)restAdapterClass);
            }
            parseMethod.body().invoke("setInitMethodIfNeeded").arg((GeneratedExpression)builder).arg(managerClassReference);
            parseMethod.body().invoke("setDestroyMethodIfNeeded").arg((GeneratedExpression)builder).arg(managerClassReference);
            OAuthDefinitionParserGenerator.this.generateParseProperty(parseMethod.body(), elementParam, builder, "name", "name");
            OAuthDefinitionParserGenerator.this.generateParseProperty(parseMethod.body(), elementParam, builder, "authorizationUrl");
            OAuthDefinitionParserGenerator.this.generateParseProperty(parseMethod.body(), elementParam, builder, "accessTokenUrl");
            OAuthDefinitionParserGenerator.this.generateParseProperty(parseMethod.body(), elementParam, builder, "onNoToken");
            OAuthDefinitionParserGenerator.this.generateParseHttpCallback("oauth-callback-config", parseMethod, elementParam, builder, "oauthHttpCallbackConfigElement");
            if (this.oAuthCapability.getOAuthVersion() == OAuthVersion.V10A) {
                GeneratedClass saveAccessTokenCallbackFactory = (GeneratedClass)OAuthDefinitionParserGenerator.this.ctx().getProduct(Product.DEFAULT_SAVE_ACCESS_TOKEN_CALLBACK_FACTORY);
                GeneratedClass restoreAccessTokenCallbackFactory = (GeneratedClass)OAuthDefinitionParserGenerator.this.ctx().getProduct(Product.DEFAULT_RESTORE_ACCESS_TOKEN_CALLBACK_FACTORY);
                OAuthDefinitionParserGenerator.this.generateParseNestedProcessor(parseMethod.body(), elementParam, parserContextParam, builder, "oauthSaveAccessToken", false, false, (TypeReference)saveAccessTokenCallbackFactory);
                OAuthDefinitionParserGenerator.this.generateParseNestedProcessor(parseMethod.body(), elementParam, parserContextParam, builder, "oauthRestoreAccessToken", false, false, (TypeReference)restoreAccessTokenCallbackFactory);
                OAuthDefinitionParserGenerator.this.generateParseProperty(parseMethod.body(), elementParam, builder, "requestTokenUrl");
            } else {
                OAuthDefinitionParserGenerator.this.generateParseOAuthStoreConfig("oauth-store-config", parseMethod, elementParam, builder);
            }
            if (this.hasOAuthComponent()) {
                for (Field field : this.oAuth2Component.getConfigurableFields()) {
                    OAuthDefinitionParserGenerator.this.generateParseVariable(parseMethod.body(), (Variable)field, elementParam, parserContextParam, builder, false, true, 0);
                }
            }
        }

        @Override
        public GeneratedExpression getClassForBeanDefinitionBuilder(Module module, GeneratedClass moduleObject) {
            if (module.hasRestCalls()) {
                return ExpressionFactory.direct((String)this.getRestAdapterClass(module));
            }
            return moduleObject.dotclass();
        }

        @Override
        public void generatePostBeanDefinition(GeneratedMethod parseMethod, GeneratedVariable elementParam, GeneratedVariable parserContextParam, GeneratedVariable builder, GeneratedVariable definition) {
        }

        private String getRestAdapterClass(Module module) {
            if (!module.hasRestCalls()) {
                throw new RuntimeException("When asking for a rest client adapter for an OAuth component, the same has to have at least one rest call annotated method");
            }
            String restAdapterClass = null;
            restAdapterClass = this.oAuthCapability.getOAuthVersion().equals((Object)OAuthVersion.V10A) ? module.getPackage().getName() + ".adapters." + module.getClassName() + "RestClientAdapter.class" : module.getPackage().getName() + ".oauth." + module.getClassName() + "OAuthManager.class";
            return restAdapterClass;
        }

        private boolean hasOAuthComponent() {
            return this.oAuth2Component != null;
        }
    }
}

