/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.apidoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.apidoc.VelocityUtils;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.utils.NameUtils;
import org.mule.util.FileUtils;

public class ApiDocsGenerator
implements ModuleGenerator {
    private final List<Product> consumes = Arrays.asList(Product.APIDOC_MODEL);
    private final List<Product> produces = new ArrayList<Product>();
    private Context context;

    public boolean shouldGenerate(Module module) {
        return this.ctx().getMavenInformation().getShouldGenerateApidocs();
    }

    public void generate(Module module) throws GenerationException {
        try {
            String fileName = module.getModuleName() + "-apidoc";
            Path outputDir = this.getOutputDirPath();
            StringWriter writer = this.generateAsciidocApidocs();
            this.generateFile(outputDir, writer.toString(), fileName + ".adoc");
            this.generateFile(outputDir, this.generateHtmlApidocs(writer), fileName + ".html");
        }
        catch (IOException e) {
            throw new GenerationException("Error while generating the ApiDocs: " + e.getMessage(), (Throwable)e);
        }
    }

    private StringWriter generateAsciidocApidocs() {
        StringWriter writer = new StringWriter();
        VelocityEngine engine = VelocityUtils.getVelocityEngine();
        VelocityContext context = VelocityUtils.getContextBuilder().put("NameUtils", NameUtils.class).put("module", this.ctx().getApidocModel()).build();
        engine.getTemplate("apidocs-asciidoc-template.vm").merge((org.apache.velocity.context.Context)context, (Writer)writer);
        return writer;
    }

    private String generateHtmlApidocs(StringWriter writer) throws IOException {
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        File css = File.createTempFile("apidoc-style", ".css");
        FileUtils.copyStreamToFile((InputStream)this.getClass().getResourceAsStream("/apidoc-style.css"), (File)css);
        Options options = OptionsBuilder.options().headerFooter(true).safe(SafeMode.UNSAFE).attributes(AttributesBuilder.attributes().stylesDir(css.getParent()).styleSheetName(css.getName()).get()).get();
        return asciidoctor.render(writer.toString(), options);
    }

    private Path getOutputDirPath() {
        return Paths.get(this.ctx().getMavenInformation().getBuildDirectory(), "target", "apidocs").toAbsolutePath();
    }

    private void generateFile(Path outputDir, String content, String fileName) throws IOException {
        if (!outputDir.toFile().exists()) {
            Files.createDirectory(outputDir, new FileAttribute[0]);
        }
        PrintWriter printWriter = new PrintWriter(Paths.get(outputDir.toString(), fileName).toFile());
        printWriter.print(content);
        printWriter.close();
    }

    public List<Product> consumes() {
        return this.consumes;
    }

    public List<Product> produces() {
        return this.produces;
    }

    public Context ctx() {
        return this.context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }
}

