/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import javax.lang.model.type.TypeKind;
import org.mule.api.annotations.Query;
import org.mule.api.annotations.expressions.Expr;
import org.mule.api.annotations.param.CorrelationGroupSize;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.MessageRootId;
import org.mule.api.annotations.param.MessageUniqueId;
import org.mule.api.annotations.param.Optional;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.api.annotations.rest.RestCall;
import org.mule.api.callback.SourceCallback;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.EnumType;
import org.mule.devkit.model.GenericType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.streaming.PagingConfiguration;
import org.mule.streaming.ProviderAwarePagingDelegate;

public class ProcessorAnnotationVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setGatherer(gatherer);
        for (ProcessorMethod method : module.getProcessorMethods()) {
            if (method.isStatic()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.PROCESSOR_CANNOT_BE_STATIC, new Object[0]);
                continue;
            }
            if (!method.getTypeParameters().isEmpty()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.PROCESSOR_CANNOT_BE_GENERIC, new Object[0]);
                continue;
            }
            if (!method.isPublic()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.PROCESSOR_MUST_BE_PUBLIC, new Object[0]);
                continue;
            }
            if (method.isAbstract() && !method.hasAnnotation(RestCall.class)) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.PROCESSOR_CANNOT_BE_ABSTRACT_UNLESS_RESTCALL, new Object[0]);
                continue;
            }
            this.validatePaging(module, method);
            this.validateIntercepting(method);
            int payloadCount = 0;
            int queryCount = 0;
            this.validatePagedArgs(method);
            for (Parameter parameter : method.getParameters()) {
                if (parameter.isReservedIdentifier()) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.PROCESSOR_PARAMETER_USES_RESERVED_IDENTIFIER, new Object[]{parameter.getName(), parameter.getName()});
                }
                int count = 0;
                if (parameter.hasAnnotation(InboundHeaders.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(OutboundHeaders.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(InvocationHeaders.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(SessionHeaders.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(Payload.class)) {
                    ++payloadCount;
                    ++count;
                }
                if (parameter.hasAnnotation(ExceptionPayload.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(CorrelationId.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(CorrelationSequence.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(CorrelationGroupSize.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(MessageUniqueId.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(MessageRootId.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(Expr.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(Query.class)) {
                    ++queryCount;
                }
                if (count > 1) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.PROCESSOR_MULTIPLE_PARAMETERS_SAME_ANNOTATION, new Object[0]);
                }
                if (count > 0 && (parameter.hasDefaultValue() || parameter.isOptional())) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.INCOMPATIBLE_ANNOTATIONS, new Object[0]);
                }
                if (parameter.asTypeMirror().getKind().isPrimitive() && parameter.isOptional() && (!parameter.hasDefaultValue() || parameter.getDefaultValue().isEmpty())) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.OPTIONAL_PARAMS_CANNOT_BE_PRIMITIVE, new Object[0]);
                }
                if (parameter.hasDefaultValue() && parameter.hasAnnotation(Optional.class)) {
                    gatherer.warn((Identifiable)parameter, (DevkitNotification)Message.DEFAULT_IMPLIES_OPTIONAL, new Object[]{parameter.getName()});
                }
                if (!parameter.hasAnnotation(Payload.class) && parameter.asTypeMirror().getKind() == TypeKind.ARRAY) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.PROCESSOR_PARAMETERS_CANNOT_BE_ARRAYS, new Object[0]);
                }
                if (parameter.hasDefaultValue() && parameter.asType().isEnum() && !this.isDefaultValueValidForEnum((Variable)parameter)) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.DEFAULT_VALUE_INVALID_FOR_ENUM, new Object[0]);
                }
                if (!parameter.asType().isAbstract() || parameter.isRefOnly() || !parameter.asType().isComplexType()) continue;
                gatherer.error((Identifiable)parameter, (DevkitNotification)Message.PARAMETER_SHOULD_BE_CONCRETE_CLASS, new Object[0]);
            }
            if (payloadCount > 1) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.PROCESSOR_MULTIPLE_PARAMETERS_SAME_ANNOTATION, new Object[0]);
            }
            if (queryCount <= true) continue;
            gatherer.error((Identifiable)method, (DevkitNotification)Message.QUERY_ANNOTATION_ONE_PER_METHOD, new Object[0]);
        }
    }

    private void validatePaging(Module module, ProcessorMethod method) {
        if (method.isPaged()) {
            GenericType connectorType;
            String returnType = method.getReturnType().toString();
            if (!returnType.contains(ProviderAwarePagingDelegate.class.getCanonicalName())) {
                this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.PAGED_PROCESSOR_INCORRECT_TYPE, new Object[]{method.getName(), returnType, ProviderAwarePagingDelegate.class.getCanonicalName()});
                return;
            }
            if (!(method.getReturnGenericType().getGenericTypeArguments().size() <= 0 || (connectorType = (GenericType)method.getReturnGenericType().getGenericTypeArguments().get(1)).getType().equals(module.asTypeMirror()) || module.getSuperClass() != null && connectorType.getType().equals(module.getSuperClass().asType()))) {
                this.getGatherer().warn((Identifiable)method, (DevkitNotification)Message.PROVIDERAWAREPAGINGDELEGATE_INCORRECT_TYPE, new Object[]{method.getReturnGenericType().getGenericTypeArguments().get(1)});
            }
        } else if (method.getReturnType().toString().startsWith(ProviderAwarePagingDelegate.class.getCanonicalName())) {
            this.getGatherer().warn((Identifiable)method, (DevkitNotification)Message.PROVIDERAWAREPAGINGDELEGATE_MISSING_PAGED_ANNOTATION, new Object[0]);
        }
    }

    private void validatePagedArgs(ProcessorMethod method) throws AnnotationVerificationException {
        int pagingConfigurationParameters = this.pagingConfigurationParameters(method);
        if (method.isPaged()) {
            if (pagingConfigurationParameters > 1) {
                this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.PAGED_PROCESSOR_TWO_ARGUMENTS_SAME_TYPE, new Object[]{method.getName(), PagingConfiguration.class.getCanonicalName()});
            } else if (pagingConfigurationParameters < 1) {
                this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.PAGES_PROCESSOR_MISSING_REQUIRED_ARGUMENT, new Object[]{method.getName(), PagingConfiguration.class.getCanonicalName()});
            }
        } else if (pagingConfigurationParameters != 0) {
            this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.PROCESSOR_MISSING_PAGED_ANNOTATION, new Object[]{method.getName(), PagingConfiguration.class.getCanonicalName()});
        }
    }

    private int pagingConfigurationParameters(ProcessorMethod method) {
        int amountOfPagingConfiguration = 0;
        for (Parameter param : method.getParameters()) {
            if (!param.asType().getQualifiedName().toString().equals(PagingConfiguration.class.getCanonicalName())) continue;
            ++amountOfPagingConfiguration;
        }
        return amountOfPagingConfiguration;
    }

    private void validateIntercepting(ProcessorMethod method) throws AnnotationVerificationException {
        if (method.isIntercepting()) {
            if (method.isPaged()) {
                this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.PAGED_PROCESSOR_INTERCEPTING_INVALID_COMBO, new Object[]{method.getName()});
                return;
            }
            boolean containsSourceCallback = false;
            for (Parameter parameter : method.getParameters()) {
                if (!parameter.asTypeMirror().toString().startsWith(SourceCallback.class.getName())) continue;
                containsSourceCallback = true;
            }
            if (!containsSourceCallback) {
                this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.INTERCEPTING_METHOD_MISSING_SOURCECALLBACK_PARAM, new Object[0]);
            }
        }
    }

    private boolean isDefaultValueValidForEnum(Variable variable) {
        for (Identifiable enumMember : ((EnumType)variable.asType()).getEnumConstants()) {
            String enumConstant = enumMember.getName();
            if (!variable.getDefaultValue().equals(enumConstant)) continue;
            return true;
        }
        return false;
    }
}

