/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.strategies;

import java.lang.annotation.Annotation;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.lang.model.type.TypeKind;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.Configurable;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.devkit.verifiers.util.VerifierUtils;

public abstract class AbstractOAuthVerifier
extends AbstractBaseAnnotationVerifier {
    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        OAuthCapability oAuthCapability = this.getOAuthCapability(module);
        Identifiable moduleToMark = this.getConcreteIdentifiable(module);
        this.verifyIsConsumerKeyConfigurable(gatherer, oAuthCapability);
        this.verifyIsConsumerSecretConfigurable(gatherer, oAuthCapability);
        String authorizationUrl = oAuthCapability.getAuthorizationUrl();
        String accessTokenUrl = oAuthCapability.getAccessTokenUrl();
        String accessTokenRegex = oAuthCapability.getAccessTokenRegex();
        String refreshTokenRegex = oAuthCapability.getRefreshTokenRegex();
        String expirationRegex = oAuthCapability.getExpirationRegex();
        String verifierRegex = oAuthCapability.getVerifierRegex();
        this.verifyCheckForBlankFields(gatherer, moduleToMark, authorizationUrl, "authorizationUrl");
        this.verifyCheckForBlankFields(gatherer, moduleToMark, accessTokenUrl, "accessTokenUrl");
        this.checkValidRegex(moduleToMark, accessTokenRegex, "accessTokenRegex", gatherer);
        this.checkValidRegex(moduleToMark, refreshTokenRegex, "refreshTokenRegex", gatherer);
        this.checkValidRegex(moduleToMark, expirationRegex, "expirationRegex", gatherer);
        this.checkValidRegex(moduleToMark, verifierRegex, "verifierRegex", gatherer);
        this.verifyField(oAuthCapability.getConsumerKeyField(), gatherer, moduleToMark, Message.OAUTH_REQUIRES_OAUTHCONSUMERKEY);
        this.verifyField(oAuthCapability.getAccessTokenField(), gatherer, moduleToMark, Message.OAUTH_REQUIRES_OAUTHACCESSTOKEN);
        this.verifyField(oAuthCapability.getConsumerSecretField(), gatherer, moduleToMark, Message.OAUTH_REQUIRES_OAUTHCONSUMERSECRET);
        this.verifyCallbackParameters(gatherer, oAuthCapability);
        this.verifyAuthorizationParameters(gatherer, oAuthCapability);
        this.verifyPostAuthorize(oAuthCapability, gatherer);
        this.doVerify(module, gatherer);
    }

    protected abstract OAuthCapability getOAuthCapability(Module var1);

    protected abstract Identifiable getConcreteIdentifiable(Module var1);

    protected abstract void doVerify(Module var1, NotificationGatherer var2);

    private void verifyIsConsumerKeyConfigurable(NotificationGatherer gatherer, OAuthCapability oAuthModule) {
        if (!oAuthModule.getConsumerSecretField().hasAnnotation(Configurable.class)) {
            gatherer.error((Identifiable)oAuthModule.getConsumerKeyField(), (DevkitNotification)Message.CONSUMER_KEY_MUST_BE_CONFIGURABLE, new Object[0]);
        }
    }

    private void verifyIsConsumerSecretConfigurable(NotificationGatherer gatherer, OAuthCapability oAuthModule) {
        if (!oAuthModule.getConsumerKeyField().hasAnnotation(Configurable.class)) {
            gatherer.error((Identifiable)oAuthModule.getConsumerSecretField(), (DevkitNotification)Message.CONSUMER_SECRET_MUST_BE_CONFIGURABLE, new Object[0]);
        }
    }

    private void verifyCheckForBlankFields(NotificationGatherer gatherer, Identifiable identifiable, String field, String message) {
        if (StringUtils.isBlank((String)field)) {
            gatherer.error(identifiable, (DevkitNotification)Message.FIELD_CANNOT_BE_EMPTY, new Object[]{message});
        }
    }

    protected void checkValidRegex(Identifiable identifiable, String regex, String regexLabel, NotificationGatherer gatherer) {
        if (regex != null && StringUtils.isBlank((String)regex)) {
            gatherer.error(identifiable, (DevkitNotification)Message.FIELD_CANNOT_BE_EMPTY, new Object[]{regexLabel});
        } else if (regex != null) {
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException ex) {
                gatherer.error(identifiable, (DevkitNotification)Message.INVALID_REGEX, new Object[]{regexLabel, ex.getPattern()});
            }
        }
    }

    protected void verifyField(Field field, NotificationGatherer gatherer, Identifiable identifiable, Message errorMessage) {
        if (field == null) {
            gatherer.error(identifiable, (DevkitNotification)errorMessage, new Object[0]);
        } else {
            VerifierUtils.verifyFieldGetterAndSetter(field, gatherer);
        }
    }

    private void verifyCallbackParameters(NotificationGatherer gatherer, OAuthCapability authCapability) {
        if (authCapability.getCallbackParameters() != null) {
            for (Field field : authCapability.getCallbackParameters()) {
                if (field.hasSetter()) continue;
                gatherer.error((Identifiable)field, (DevkitNotification)Message.OAUTHCALLBACKPARAMETER_MISSING_SETTER, new Object[]{field.getName()});
            }
        }
    }

    private void verifyAuthorizationParameters(NotificationGatherer gatherer, OAuthCapability authCapability) {
        if (authCapability.getAuthorizationParameters() != null) {
            for (OAuthAuthorizationParameter parameter : authCapability.getAuthorizationParameters()) {
                if (SchemaTypeConversion.isSupported((String)parameter.getType().asTypeMirror().toString()) || parameter.getType().isEnum()) continue;
                gatherer.error((Identifiable)parameter.getType(), (DevkitNotification)Message.AUTH_PARAMETER_TYPE_NOT_SUPPORTED, new Object[]{parameter.getType().getName()});
            }
        }
    }

    private void verifyPostAuthorize(OAuthCapability authCapability, NotificationGatherer gatherer) {
        Method postAuthorizationMethod = authCapability.getPostAuthorizationMethod();
        if (postAuthorizationMethod != null && postAuthorizationMethod.isPrivate()) {
            gatherer.error((Identifiable)postAuthorizationMethod, (DevkitNotification)Message.OAUTHPOSTAUTHORIZATION_CANNOT_BE_PRIVATE, new Object[0]);
        }
        if (postAuthorizationMethod != null && postAuthorizationMethod.getParameters().size() > 0) {
            gatherer.error((Identifiable)postAuthorizationMethod, (DevkitNotification)Message.OAUTHPOSTAUTHORIZATION_CANNOT_HAVE_PARAMETERS, new Object[0]);
        }
        if (postAuthorizationMethod != null && postAuthorizationMethod.isStatic()) {
            gatherer.error((Identifiable)postAuthorizationMethod, (DevkitNotification)Message.OAUTHPOSTAUTHORIZATION_CANNOT_BE_STATIC, new Object[0]);
        }
        if (postAuthorizationMethod != null && postAuthorizationMethod.getReturnType().getKind() != TypeKind.VOID) {
            gatherer.error((Identifiable)postAuthorizationMethod, (DevkitNotification)Message.OAUTHPOSTAUTHORIZATION_MUST_RETURN_VOID, new Object[0]);
        }
    }

    protected boolean classHasMethodWithParameterAnnotated(Module module, Class<? extends Annotation> annotation) {
        for (Method method : module.getMethods()) {
            for (Parameter parameter : method.getParameters()) {
                if (!parameter.hasAnnotation(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    protected void checkAuthorizationParameter(OAuthModule module, NotificationGatherer gatherer) {
        if (module.getAuthorizationParameters() != null) {
            for (OAuthAuthorizationParameter parameter : module.getAuthorizationParameters()) {
                if (SchemaTypeConversion.isSupported((String)parameter.getType().asTypeMirror().toString()) || parameter.getType().isEnum()) continue;
                gatherer.error((Identifiable)module, (DevkitNotification)Message.AUTH_PARAMETER_TYPE_NOT_SUPPORTED, new Object[]{parameter.getType().getName()});
            }
        }
    }
}

