/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.api.ConnectionException;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.connectivity.AbstractManagedConnectionGenerator;
import org.mule.devkit.internal.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;

public class SingleConnectionAdapterGenerator
extends AbstractManagedConnectionGenerator
implements MultiModuleGenerator {
    public List<Product> consumes() {
        return Arrays.asList(Product.CONNECTION_KEY, Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER);
    }

    public List<Product> produces() {
        return Arrays.asList(Product.STRATEGY_ADAPTER);
    }

    public void generate(List<Module> modules) throws GenerationException {
        for (Module module : modules) {
            if (!(module instanceof ManagedConnectionModule)) continue;
            ManagedConnectionModule managedModule = (ManagedConnectionModule)module;
            GeneratedClass adapter = this.generateAdapter((Module)managedModule);
            this.generateConnectMethod(managedModule, adapter);
            this.generateDisconnectMethod(adapter, managedModule);
            this.generateConnectionIdMethod(adapter, managedModule);
            this.generateIsConnectedMethod(adapter, managedModule);
            this.generateGetStrategyMethod(adapter, managedModule);
        }
    }

    private void generateGetStrategyMethod(GeneratedClass adapter, ManagedConnectionModule component) {
        GeneratedMethod getStrategy = adapter.method(1, this.ref(component.asTypeMirror()), "getStrategy");
        getStrategy.annotate(Override.class);
        getStrategy.body()._return(ExpressionFactory._this());
    }

    private void generateConnectionIdMethod(GeneratedClass adapter, ManagedConnectionModule component) {
        GeneratedMethod connectionId = adapter.method(1, String.class, "connectionId");
        connectionId.annotate(Override.class);
        if (component.getConnectionIdentifierMethod().isPresent()) {
            connectionId.body()._return((GeneratedExpression)ExpressionFactory._super().invoke(((Method)component.getConnectionIdentifierMethod().get()).getName()));
        } else {
            connectionId.body()._return(ExpressionFactory.lit((String)""));
        }
    }

    private void generateIsConnectedMethod(GeneratedClass adapter, ManagedConnectionModule component) {
        GeneratedMethod isConnected = adapter.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isConnected");
        isConnected.annotate(Override.class);
        isConnected.body()._return((GeneratedExpression)ExpressionFactory._super().invoke(component.getValidateConnectionMethod().getName()));
    }

    private void generateDisconnectMethod(GeneratedClass adapter, ManagedConnectionModule module) {
        GeneratedMethod disconnect = adapter.method(1, (Type)this.ctx().getCodeModel().VOID, "disconnect");
        disconnect.annotate(Override.class);
        disconnect.body().add((Statement)ExpressionFactory._super().invoke(module.getDisconnectMethod().getName()));
    }

    private void generateConnectMethod(ManagedConnectionModule module, GeneratedClass adapter) {
        GeneratedMethod connect = adapter.method(1, (Type)this.ctx().getCodeModel().VOID, "connect");
        connect.annotate(Override.class);
        connect._throws(ConnectionException.class);
        GeneratedClass connectionKeyClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)module)).topLevelClass();
        GeneratedVariable connectionKey = connect.param((Type)connectionKeyClass, "connectionKey");
        GeneratedInvocation connectInvoke = ExpressionFactory._super().invoke(module.getConnectMethod().getName());
        for (Parameter methodParameter : module.getConnectMethod().getParameters()) {
            connectInvoke.arg((GeneratedExpression)connectionKey.invoke("get" + StringUtils.capitalize((String)methodParameter.getName())));
        }
        connect.body().add((Statement)connectInvoke);
    }

    private GeneratedClass generateAdapter(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".generated.connectivity");
        GeneratedClass connectionKeyClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)module)).topLevelClass();
        GeneratedClass basicConnectorAdapter = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass connectionAdapter = pkg._class(module.getName() + "Adapter", (TypeReference)basicConnectorAdapter);
        connectionAdapter._implements(this.ref(ConnectionManagementConnectionAdapter.class).narrow(Object.class).narrow((TypeReference)connectionKeyClass));
        this.ctx().registerProduct(Product.STRATEGY_ADAPTER, (Identifiable)module, (Object)connectionAdapter);
        return connectionAdapter;
    }
}

