/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.mule.api.annotations.MetaDataKeyRetriever;
import org.mule.api.annotations.MetaDataNativeQueryOutputRetriever;
import org.mule.api.annotations.MetaDataOutputRetriever;
import org.mule.api.annotations.MetaDataRetriever;
import org.mule.api.annotations.MetaDataScope;
import org.mule.api.annotations.Query;
import org.mule.api.annotations.param.MetaDataKeyParam;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.devkit.api.metadata.ComposedMetaDataKey;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.generation.spring.global.factory.ConnectionStrategyResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;
import org.mule.devkit.verifiers.metadata.MetaDataAnnotationVerifierUtils;
import org.mule.devkit.verifiers.util.VerifierUtils;
import org.mule.util.StringUtils;

public class MetaDataConnectorVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind().equals((Object)ModuleKind.CONNECTOR) || module.getKind().equals((Object)ModuleKind.GENERIC);
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.verifyManagedConnectionModules(module, gatherer);
        this.verifyConsistencyMetaDataCategoryModules(module, gatherer);
    }

    private void verifyConsistencyMetaDataCategoryModules(Module module, NotificationGatherer gatherer) {
        HashMap metaDataCategoryNameMap = new HashMap();
        Set metaDataCategoryComponents = module.manager().metaDataCategoryComponents();
        for (MetaDataCategoryComponent metaDataCategoryComponent : metaDataCategoryComponents) {
            if (metaDataCategoryNameMap.get(metaDataCategoryComponent.getName()) == null) {
                metaDataCategoryNameMap.put(metaDataCategoryComponent.getName(), new ArrayList());
            }
            ((List)metaDataCategoryNameMap.get(metaDataCategoryComponent.getName())).add(metaDataCategoryComponent);
            if (!metaDataCategoryComponent.hasNoArgConstructor()) {
                gatherer.error((Identifiable)metaDataCategoryComponent, (DevkitNotification)Message.NO_ARGS_CONSTRUCTOR_REQUIRED, new Object[0]);
            }
            if (metaDataCategoryComponent.isPrivate() || metaDataCategoryComponent.isAbstract() || metaDataCategoryComponent.isProtected()) {
                gatherer.error((Identifiable)metaDataCategoryComponent, (DevkitNotification)Message.METADATACATEGORY_CLASS_MUST_BE_PUBLIC_NON_ABSTRACT, new Object[0]);
            }
            this.verifyProperMetaDataImplementationForComponent(metaDataCategoryComponent, module.getProcessorMethods(), gatherer);
        }
        for (Map.Entry entry : metaDataCategoryNameMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            ArrayList<String> fullQualifiedNames = new ArrayList<String>();
            for (MetaDataCategoryComponent m : (List)entry.getValue()) {
                fullQualifiedNames.add(m.getQualifiedName().toString());
            }
            gatherer.error((Identifiable)((List)entry.getValue()).get(0), (DevkitNotification)Message.METADATACATEGORY_REPEATED_SIMPLE_NAMES, new Object[]{entry.getKey(), String.valueOf(((List)entry.getValue()).size()), StringUtils.join(fullQualifiedNames, (String)", ")});
        }
    }

    private void verifyManagedConnectionModules(Module module, NotificationGatherer gatherer) {
        boolean moduleImplementsMetaData;
        Set specificUsedMetaDataCategoryModules = module.manager().metaDataCategoryComponents();
        boolean bl = moduleImplementsMetaData = !specificUsedMetaDataCategoryModules.isEmpty() || module.getMetaDataKeyRetrieverMethod() != null || module.getMetaDataRetrieverMethod() != null;
        if (moduleImplementsMetaData) {
            if (!module.getMinMuleVersion().atLeast("3.4")) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.METADATA_REQUIRES_MIN_MULE_340, new Object[0]);
            }
            if (!specificUsedMetaDataCategoryModules.isEmpty()) {
                this.verifyManagedConnectionModulesWithMetaDataCategories(module, specificUsedMetaDataCategoryModules, gatherer);
            } else {
                this.verifyProperMetaDataImplementationWithoutGrouping(module, gatherer);
            }
        } else {
            this.verifyProcessorsHasNoMetaData(module, gatherer);
        }
    }

    private void verifyManagedConnectionModulesWithMetaDataCategories(Module connectorModule, Set<MetaDataCategoryComponent> usedMetaDataCategoryModules, NotificationGatherer gatherer) {
        if (connectorModule.getMetaDataRetrieverMethod() != null || connectorModule.getMetaDataKeyRetrieverMethod() != null) {
            gatherer.error((Identifiable)usedMetaDataCategoryModules.iterator().next(), (DevkitNotification)Message.METADATACATEGORY_NOT_ALLOWED, new Object[0]);
        }
        ArrayList<String> metaDataCategoryNames = new ArrayList<String>();
        for (MetaDataCategoryComponent metaDataCategoryComponent : usedMetaDataCategoryModules) {
            metaDataCategoryNames.add(metaDataCategoryComponent.getQualifiedName().toString());
            if (!metaDataCategoryComponent.getInjectedConnector().isPresent()) continue;
            Field connectorField = (Field)metaDataCategoryComponent.getInjectedConnector().get();
            if (connectorModule.asType().equals(connectorField.asType()) || connectorModule.inheritsFrom(connectorField.asType())) continue;
            gatherer.error((Identifiable)connectorField, (DevkitNotification)Message.METADATACATEGORY_INJECTED_FIELD_IS_NOT_CONNECTOR, new Object[]{connectorModule.getName(), metaDataCategoryComponent.getName(), connectorField.getName(), connectorModule.getQualifiedName(), connectorField.asType().getQualifiedName()});
        }
        ArrayList<String> unscopedProcessors = new ArrayList<String>();
        for (ProcessorMethod processorMethod : connectorModule.getProcessorMethods()) {
            if (!processorMethod.hasInputOrOutputDynamicMetaData()) continue;
            if (processorMethod.hasMetaDataScope()) {
                List<DeclaredType> usedCategories = Arrays.asList(processorMethod.metaDataScope());
                this.validateMetaDataScope(usedCategories, metaDataCategoryNames, (Identifiable)processorMethod, gatherer);
                continue;
            }
            unscopedProcessors.add(processorMethod.getName());
        }
        if (!unscopedProcessors.isEmpty()) {
            MetaDataScope metaDataScope = (MetaDataScope)connectorModule.getAnnotation(MetaDataScope.class);
            if (metaDataScope == null) {
                gatherer.error((Identifiable)connectorModule, (DevkitNotification)Message.PROCESSORS_NO_METADATASCOPE, new Object[]{StringUtils.join(unscopedProcessors, (String)",")});
            } else {
                List<DeclaredType> usedCategories = Arrays.asList(connectorModule.metaDataScope());
                this.validateMetaDataScope(usedCategories, metaDataCategoryNames, (Identifiable)connectorModule, gatherer);
            }
        }
    }

    private void verifyProperMetaDataImplementationForModule(Module module, NotificationGatherer gatherer) {
        Method metaDataKeyRetrieverMethod = module.getMetaDataKeyRetrieverMethod();
        Method metaDataRetrieverMethod = module.getMetaDataRetrieverMethod();
        this.verifyProperMetaDataImplementation((Identifiable<TypeElement>)module, metaDataKeyRetrieverMethod, module.getMethodsAnnotatedWith(MetaDataKeyRetriever.class), metaDataRetrieverMethod, module.getMethodsAnnotatedWith(MetaDataRetriever.class), null, Collections.emptyList(), null, Collections.emptyList(), module.getProcessorMethods(), gatherer);
        if (ConnectionStrategyResolver.oldScenarioSupport(module) && metaDataKeyRetrieverMethod != null && metaDataKeyRetrieverMethod.getName().equals("getMetaDataKeys")) {
            gatherer.error((Identifiable)metaDataKeyRetrieverMethod, (DevkitNotification)Message.METADATA_RESERVED_NAME, new Object[]{metaDataKeyRetrieverMethod.getName()});
        }
        if (ConnectionStrategyResolver.oldScenarioSupport(module) && metaDataRetrieverMethod != null && metaDataRetrieverMethod.getName().equals("getMetaData")) {
            gatherer.error((Identifiable)metaDataRetrieverMethod, (DevkitNotification)Message.METADATA_RESERVED_NAME, new Object[]{metaDataRetrieverMethod.getName()});
        }
    }

    private void verifyProperMetaDataImplementationForComponent(MetaDataCategoryComponent metaDataCategoryComponent, List<ProcessorMethod> processorMethods, NotificationGatherer gatherer) {
        this.verifyProperMetaDataImplementation((Identifiable<TypeElement>)metaDataCategoryComponent, metaDataCategoryComponent.getMetaDataKeyRetrieverMethod(), metaDataCategoryComponent.getMethodsAnnotatedWith(MetaDataKeyRetriever.class), metaDataCategoryComponent.getMetaDataRetrieverMethod(), metaDataCategoryComponent.getMethodsAnnotatedWith(MetaDataRetriever.class), metaDataCategoryComponent.getMetaDataOutputRetrieverMethod(), metaDataCategoryComponent.getMethodsAnnotatedWith(MetaDataOutputRetriever.class), metaDataCategoryComponent.getMetaDataNativeQueryOutputRetriever().isPresent() ? (Method)metaDataCategoryComponent.getMetaDataNativeQueryOutputRetriever().get() : null, metaDataCategoryComponent.getMethodsAnnotatedWith(MetaDataNativeQueryOutputRetriever.class), processorMethods, gatherer);
    }

    private void verifyProperMetaDataImplementation(Identifiable<TypeElement> element, Method metaDataKeyRetrieverMethod, List<Method<Type>> metaDataKeysRetrieversMethods, Method metaDataRetrieverMethod, List<Method<Type>> metaDataRetrieversMethods, Method metaDataOutputRetrieverMethod, List<Method<Type>> metaDataOutputRetrieverMethods, Method metaDataNativeQueryOutputRetrieverMethod, List<Method<Type>> metaDataNativeQueryOutputRetrieverMethods, List<ProcessorMethod> processorMethods, NotificationGatherer gatherer) {
        boolean useComposedKeys = VerifierUtils.returnTypeContainsTypeName(metaDataKeyRetrieverMethod, ComposedMetaDataKey.class.getSimpleName());
        if (metaDataKeyRetrieverMethod != null && metaDataRetrieverMethod != null) {
            MetaDataAnnotationVerifierUtils.verifyMetaDataKeyRetrieverMethod((Method<Type>)metaDataKeyRetrieverMethod, useComposedKeys, gatherer);
            MetaDataAnnotationVerifierUtils.verifyMetaDataRetrieverMethod((Method<Type>)metaDataRetrieverMethod, useComposedKeys, gatherer, MetaDataRetriever.class.getSimpleName());
            MetaDataAnnotationVerifierUtils.checkMetaDataKeyParam(processorMethods, gatherer);
        } else {
            if (metaDataKeyRetrieverMethod == null) {
                gatherer.error(element, (DevkitNotification)Message.METADATAKEYRETRIEVER_MISSING_FROM_MODULE, new Object[]{element.getName()});
            }
            if (metaDataRetrieverMethod == null) {
                gatherer.error(element, (DevkitNotification)Message.METADATARETRIEVER_MISSING_FROM_MODULE, new Object[]{element.getName()});
            }
        }
        if (metaDataOutputRetrieverMethod != null) {
            MetaDataAnnotationVerifierUtils.verifyMetaDataRetrieverMethod((Method<Type>)metaDataOutputRetrieverMethod, useComposedKeys, gatherer, MetaDataOutputRetriever.class.getSimpleName());
        }
        if (metaDataNativeQueryOutputRetrieverMethod != null) {
            MetaDataAnnotationVerifierUtils.verifyMetaDataRetrieverMethod((Method<Type>)metaDataNativeQueryOutputRetrieverMethod, useComposedKeys, gatherer, MetaDataNativeQueryOutputRetriever.class.getSimpleName());
        }
        this.verifyUniquenessMetaDataMethodFor(metaDataKeysRetrieversMethods, "@MetaDataKeyRetriever", gatherer);
        this.verifyUniquenessMetaDataMethodFor(metaDataRetrieversMethods, "@MetaDataRetriever", gatherer);
        this.verifyUniquenessMetaDataMethodFor(metaDataOutputRetrieverMethods, "@MetaDataOutputRetriever", gatherer);
        this.verifyUniquenessMetaDataMethodFor(metaDataNativeQueryOutputRetrieverMethods, "@MetaDataOutputRetriever", gatherer);
    }

    private void verifyUniquenessMetaDataMethodFor(List<Method<Type>> methodsList, String annotationType, NotificationGatherer gatherer) {
        if (methodsList != null && methodsList.size() > 1) {
            for (Method<Type> method : methodsList) {
                gatherer.error(method, (DevkitNotification)Message.MULTIPLE_ANNOTATIONS_FOUND, new Object[]{annotationType, methodsList.size()});
            }
        }
    }

    private void verifyProperMetaDataImplementationWithoutGrouping(Module module, NotificationGatherer gatherer) {
        Method metaDataOutputRetrieverMethod = module.getMetaDataOutputRetrieverMethod();
        if (metaDataOutputRetrieverMethod != null) {
            gatherer.error((Identifiable)metaDataOutputRetrieverMethod, (DevkitNotification)Message.METADATAOUTPUTRETRIEVER_INCORRECT_USAGE, new Object[0]);
        }
        this.verifyProperMetaDataImplementationForModule(module, gatherer);
    }

    private void verifyProcessorsHasNoMetaData(Module connectorModule, NotificationGatherer gatherer) {
        for (Method m : connectorModule.getProcessorMethods()) {
            for (Parameter key : m.getParameters()) {
                if (key.getAnnotation(MetaDataKeyParam.class) != null) {
                    gatherer.error((Identifiable)m, (DevkitNotification)Message.METADATARETRIEVER_NOT_DEFINED_FOR_METADATAKEYPARAM, new Object[]{m.getName()});
                }
                if (key.getAnnotation(MetaDataStaticKey.class) != null) {
                    gatherer.error((Identifiable)m, (DevkitNotification)Message.METADATARETRIEVER_NOT_DEFINED_FOR_METADATASTATICKEY, new Object[]{m.getName()});
                }
                if (key.getAnnotation(Query.class) == null) continue;
                gatherer.error((Identifiable)m, (DevkitNotification)Message.METADATARETRIEVER_NOT_DEFINED_FOR_QUERY_METHOD, new Object[]{key.getName(), m.getName()});
            }
            if (m.getAnnotation(MetaDataStaticKey.class) == null) continue;
            gatherer.error((Identifiable)m, (DevkitNotification)Message.METADATARETRIEVER_NOT_DEFINED_FOR_METADATASTATICKEY, new Object[]{m.getName()});
        }
    }

    private void validateMetaDataScope(List<DeclaredType> usedMetaDataScopes, List<String> metaDataCategoryNames, Identifiable identifiable, NotificationGatherer gatherer) {
        for (DeclaredType declaredType : usedMetaDataScopes) {
            if (metaDataCategoryNames.contains(declaredType.toString())) continue;
            String fullQUalifiedClassName = declaredType.toString();
            gatherer.error(identifiable, (DevkitNotification)Message.METADATASCOPE_INCORRECT_USAGE, new Object[]{fullQUalifiedClassName, fullQUalifiedClassName});
        }
    }
}

