/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.schema.global;

import java.util.List;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.spring.schema.RegisteredElements;
import org.mule.devkit.generation.spring.schema.global.AbstractGlobalElementSchemaBuilder;
import org.mule.devkit.generation.spring.schema.global.util.GlobalElementSchemaBuilderResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConfigurationComponent;
import org.mule.devkit.model.schema.ExplicitGroup;
import org.mule.devkit.model.schema.ExtensionType;

public class ConfigurationSchemaResolver
extends AbstractGlobalElementSchemaBuilder {
    private RegisteredElements registeredElements;

    public ConfigurationSchemaResolver(RegisteredElements registeredElements) {
        this.registeredElements = registeredElements;
    }

    @Override
    protected RegisteredElements getRegisteredElements() {
        return this.registeredElements;
    }

    @Override
    public void buildGlobalElementElement(Module module, Context ctx) {
        for (ConfigurationComponent configurationComponent : module.manager().configurationComponents()) {
            this.registerGlobalElementElement(module, ctx, new ConfigurationSchemaBuilderResolver(configurationComponent));
        }
    }

    @Override
    public void registerProcessorsAndSourcesAndFilters(Module module) {
    }

    private class ConfigurationSchemaBuilderResolver
    implements GlobalElementSchemaBuilderResolver {
        private ConfigurationComponent configurationComponent;

        private ConfigurationSchemaBuilderResolver(ConfigurationComponent configurationComponent) {
            this.configurationComponent = configurationComponent;
        }

        @Override
        public String resolveConfigElementName(Module module) {
            return this.configurationComponent.configElementName();
        }

        @Override
        public List<Field> resolveConfigurableFields(Module module) {
            List configurableFields = module.getConfigurableFields();
            configurableFields.addAll(this.configurationComponent.getConfigurableFields());
            return configurableFields;
        }

        @Override
        public void resolvePostGenerationGroup(Module module, ExtensionType config, ExplicitGroup all) {
        }

        @Override
        public String resolveJavaDocSummary(Module module) {
            return this.configurationComponent.getJavaDocSummary();
        }
    }
}

