/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleException;
import org.mule.api.annotations.MetaDataScope;
import org.mule.api.annotations.QueryCustomMetadata;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.api.callback.HttpCallback;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.api.registry.RegistrationException;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultParameterizedMapMetaDataModel;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.QueryMetadataConnector;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.metadata.util.MetaDataQueryFilter;
import org.mule.common.query.DsqlQuery;
import org.mule.common.query.dsql.parser.MuleDsqlParser;
import org.mule.devkit.api.transformer.TransformingValue;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.MessageConstants;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.mule.methods.DoProcessTemplateMethod;
import org.mule.devkit.internal.metadata.MetaDataGeneratorUtils;
import org.mule.devkit.internal.metadata.fixes.STUDIO7157;
import org.mule.devkit.internal.metadata.property.key.NativeQueryKeyProperty;
import org.mule.devkit.model.GenericType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.processor.chain.InterceptingChainLifecycleWrapper;
import org.mule.security.oauth.processor.AbstractListeningMessageProcessor;
import org.mule.streaming.ConsumerIterator;
import org.mule.streaming.ProviderAwarePagingDelegate;
import org.mule.streaming.processor.AbstractDevkitBasedPageableMessageProcessor;
import org.mule.util.NotificationUtils;

public class MessageProcessorGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, Product.OAUTH_ADAPTER, Product.POOL_MANAGER, Product.CONNECTION_MANAGER, Product.ABSTRACT_CONNECTED_PROCESSOR, Product.ABSTRACT_CONNECTED_INTERCEPTING_PROCESSOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.MESSAGE_PROCESSOR);
    public static final String OUTPUT_METADATA_SUFFIX = " Result";

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.hasProcessors() && (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC);
    }

    public void generate(Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            this.generateMessageProcessor(module, processorMethod);
        }
    }

    private void generateMessageProcessor(Module module, ProcessorMethod processorMethod) {
        if (this.ctx().getProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName()) != null) {
            return;
        }
        GeneratedClass messageProcessorClass = processorMethod.isIntercepting() ? this.getInterceptingMessageProcessorClass(module, processorMethod) : this.getMessageProcessorClass(module, processorMethod);
        this.generateCustomConstructor(messageProcessorClass);
        this.ctx().note("Generating message processor as " + messageProcessorClass.fullName() + " for method " + processorMethod.getName() + " in " + module.getName());
        this.generateMessageProcessorClassDoc(processorMethod, messageProcessorClass);
        Map<String, AbstractMuleGenerator.FieldVariableElement> fields = this.generateFieldForEachParameter(messageProcessorClass, (Method)processorMethod, this.privateFieldnames);
        this.generateInitialiseMethod(messageProcessorClass, fields, module);
        this.generateStartMethod(messageProcessorClass, fields);
        this.generateStopMethod(messageProcessorClass, fields);
        this.generateDiposeMethod(messageProcessorClass, fields);
        for (String fieldName : fields.keySet()) {
            if (this.privateFieldnames.contains(fieldName)) continue;
            messageProcessorClass.setter(fields.get(fieldName).getField());
        }
        DoProcessTemplateMethod doProcess = new DoProcessTemplateMethod(this);
        doProcess.forMethod(processorMethod).inClass(messageProcessorClass).withModule(module).withFields(fields);
        if (module.usesPooling()) {
            doProcess.withPoolObject(((GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module)).topLevelClass());
        }
        doProcess.build();
        if (processorMethod.hasDynamicMetaData()) {
            this.generateInputMetadata(module, processorMethod, messageProcessorClass);
            this.generateOutputMetadata(module, processorMethod, messageProcessorClass);
            this.generateGetPojoOrSimpleModel(module, processorMethod, messageProcessorClass);
            this.generateGetGenericMetaDataMethod(module, processorMethod, messageProcessorClass);
        }
        if (processorMethod.isContainer() || processorMethod.isContainerList()) {
            this.generateMessageProcessorContainerInterface(module, processorMethod, messageProcessorClass);
        }
    }

    private void generateMessageProcessorContainerInterface(Module module, ProcessorMethod processorMethod, GeneratedClass messageProcessorClass) {
        messageProcessorClass._implements(MessageProcessorContainer.class);
        GeneratedMethod addMessageProcessorPathElementsMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "addMessageProcessorPathElements");
        addMessageProcessorPathElementsMethod.annotate(Override.class);
        GeneratedVariable pathElementParam = addMessageProcessorPathElementsMethod.param((Type)this.ref(MessageProcessorPathElement.class), "pathElement");
        Parameter nestedProcessor = null;
        for (Parameter p : processorMethod.getParameters()) {
            if (!p.asType().isNestedProcessor() && (!p.asType().isArrayOrList() || p.getTypeArguments().size() <= 0 || !((org.mule.devkit.model.Type)p.getTypeArguments().get(0)).isNestedProcessor())) continue;
            nestedProcessor = p;
        }
        Object internalProcessorsCast = processorMethod.isContainer() ? ExpressionFactory.cast((Type)this.ref(InterceptingChainLifecycleWrapper.class), (GeneratedExpression)ExpressionFactory._this().ref(nestedProcessor.getName())).invoke("getMessageProcessors") : ExpressionFactory.cast((Type)this.ref(List.class), (GeneratedExpression)ExpressionFactory._this().ref(nestedProcessor.getName()));
        GeneratedVariable mpsVar = addMessageProcessorPathElementsMethod.body().decl((Type)this.ref(List.class).narrow(MessageProcessor.class), "mps", (GeneratedExpression)internalProcessorsCast);
        addMessageProcessorPathElementsMethod.body().add((Statement)this.ref(NotificationUtils.class).staticInvoke("addMessageProcessorPathElements").arg((GeneratedExpression)mpsVar).arg((GeneratedExpression)pathElementParam));
    }

    private void generateOutputMetadata(Module module, ProcessorMethod processorMethod, GeneratedClass messageProcessorClass) {
        GeneratedMethod getOutputMetadata = messageProcessorClass.method(1, (Type)this.ref(Result.class).narrow(MetaData.class), "getOutputMetaData");
        getOutputMetadata.param((Type)this.ref(MetaData.class), "inputMetadata");
        getOutputMetadata.annotate(Override.class);
        GenericType outputGeneric = processorMethod.getReturnGenericType();
        Parameter key = processorMethod.getOutputMetaDataKeyParameter();
        if (processorMethod.hasQuery()) {
            GeneratedMethod auxOutputMetadata = messageProcessorClass.method(1, (Type)this.ref(Result.class).narrow(MetaData.class), "auxOutputMetaData");
            auxOutputMetadata.param((Type)this.ref(MetaData.class), "inputMetadata");
            GeneratedVariable auxKey = auxOutputMetadata.param((Type)this.ref(String.class), "key");
            GeneratedVariable nativeQuery = auxOutputMetadata.param((Type)this.ref(Boolean.class), "nativeQuery");
            this.generateMetaDataByKeyMethod(auxKey.name(), outputGeneric, module, auxOutputMetadata, processorMethod, TypeDescribingProperty.TypeScope.OUTPUT, (Optional<GeneratedVariable>)Optional.of((Object)nativeQuery));
            this.generateQueryMetaDataMethod(module, getOutputMetadata, auxOutputMetadata, processorMethod);
        } else if (processorMethod.hasStaticKeyOutputMetaData()) {
            String literalValue = processorMethod.getStaticKeyOutputMetaData().type();
            this.generateMetaDataByLiteralMethod(literalValue, outputGeneric, module, getOutputMetadata, processorMethod, TypeDescribingProperty.TypeScope.OUTPUT, (Optional<GeneratedVariable>)Optional.absent());
        } else if (processorMethod.hasDynamicOutputMetaData()) {
            this.generateMetaDataByKeyMethod(key.getName(), outputGeneric, module, getOutputMetadata, processorMethod, TypeDescribingProperty.TypeScope.OUTPUT, (Optional<GeneratedVariable>)Optional.absent());
        } else if (outputGeneric != null) {
            GeneratedExpression keyValue = key != null ? Op.plus((GeneratedExpression)ExpressionFactory.direct((String)key.getName()).invoke("toString"), (GeneratedExpression)ExpressionFactory.lit((String)OUTPUT_METADATA_SUFFIX)) : ExpressionFactory.lit((String)"OUTPUT_METADATA");
            this.generateMetaDataImplicitMethod(outputGeneric, module, getOutputMetadata, processorMethod, keyValue, false);
        } else {
            this.generateNullMetaDataMethod(getOutputMetadata);
        }
    }

    private void generateQueryMetaDataMethod(Module module, GeneratedMethod getOutputMetadata, GeneratedMethod auxOutputMetadata, ProcessorMethod processorMethod) {
        GeneratedTry tryParseQueryAndFilter = getOutputMetadata.body()._try();
        GeneratedVariable parser = tryParseQueryAndFilter.body().decl((Type)this.ref(MuleDsqlParser.class), "parser", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(MuleDsqlParser.class)));
        GeneratedVariable queryStr = tryParseQueryAndFilter.body().decl((Type)this.ref(String.class), "queryStr", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)ExpressionFactory.direct((String)processorMethod.getQueryParameter().getName())));
        GeneratedVariable metaData = tryParseQueryAndFilter.body().decl((Type)this.ref(MetaData.class), "metaData", ExpressionFactory._null());
        GeneratedConditional ifDsql = tryParseQueryAndFilter.body()._if(Op.cand((GeneratedExpression)Op.ne((GeneratedExpression)queryStr, (GeneratedExpression)ExpressionFactory._null()), (GeneratedExpression)queryStr.invoke("startsWith").arg(ExpressionFactory.lit((String)"dsql:"))));
        this.generateQueryThenDsql(auxOutputMetadata, processorMethod, parser, queryStr, metaData, ifDsql._then());
        this.generateQueryElseNativeQuery(module, auxOutputMetadata, processorMethod, queryStr, metaData, ifDsql._else());
        tryParseQueryAndFilter.body().add((Statement)metaData.invoke("getPayload").invoke("addProperty").arg((GeneratedExpression)this.ref(STUDIO7157.class).staticInvoke("getStructureIdentifierMetaDataModelProperty").arg(ExpressionFactory._null()).arg(ExpressionFactory.TRUE).arg(ExpressionFactory.TRUE)));
        tryParseQueryAndFilter.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg((GeneratedExpression)metaData));
        GeneratedCatchBlock catchBlock = tryParseQueryAndFilter._catch(this.ref(Exception.class));
        catchBlock.param("e");
        catchBlock.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg(ExpressionFactory.lit((String)"Failed on parsing and getting query metadata")));
    }

    private void generateQueryThenDsql(GeneratedMethod auxOutputMetadata, ProcessorMethod processorMethod, GeneratedVariable parser, GeneratedVariable queryStr, GeneratedVariable metaData, GeneratedBlock thenBlock) {
        thenBlock.assign((AssignmentTarget)queryStr, (GeneratedExpression)queryStr.invoke("substring").arg(ExpressionFactory.lit((int)5)));
        GeneratedVariable q = thenBlock.decl((Type)this.ref(DsqlQuery.class), "q", (GeneratedExpression)parser.invoke("parse").arg((GeneratedExpression)queryStr));
        if (processorMethod.getAnnotation(QueryCustomMetadata.class) != null) {
            GeneratedClass connectionManager = this.getConnectionManager(processorMethod);
            GeneratedVariable connectorManager = thenBlock.decl((Type)connectionManager, "connectorManager", (GeneratedExpression)ExpressionFactory.cast((Type)connectionManager, (GeneratedExpression)ExpressionFactory.invoke((String)"findOrCreate").arg(ExpressionFactory._null()).arg(ExpressionFactory.FALSE).arg(ExpressionFactory._null())));
            GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, (Identifiable)processorMethod.getManagedConnectionModule())).topLevelClass();
            GeneratedVariable adapter = thenBlock.decl((Type)connectorClass, "adapter", (GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)connectorManager.invoke("acquireConnection").arg((GeneratedExpression)connectorManager.invoke("getDefaultConnectionKey"))));
            thenBlock._if((GeneratedExpression)this.ref(QueryMetadataConnector.class).dotclass().invoke("isAssignableFrom").arg((GeneratedExpression)adapter.invoke("getClass")))._then()._return((GeneratedExpression)adapter.invoke("getQueryMetadata").arg((GeneratedExpression)q));
        }
        GeneratedVariable result = thenBlock.decl((Type)this.ref(Result.class).narrow(this.ref(MetaData.class)), "result", (GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)auxOutputMetadata).arg(ExpressionFactory._null()).arg((GeneratedExpression)q.invoke("getTypes").invoke("get").arg(ExpressionFactory.lit((int)0)).invoke("getName")).arg(ExpressionFactory.FALSE));
        thenBlock.assign((AssignmentTarget)metaData, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(MetaDataQueryFilter.class)).arg((GeneratedExpression)result.invoke("get")).arg((GeneratedExpression)q.invoke("getFields")).invoke("doFilter"));
    }

    private void generateQueryElseNativeQuery(Module module, GeneratedMethod auxOutputMetadata, ProcessorMethod processorMethod, GeneratedVariable queryStr, GeneratedVariable metaData, GeneratedBlock elseBlock) {
        MetaDataCategoryComponent metaDataCategoryComponent = null;
        if (processorMethod.manager().metaDataCategoryComponent().isPresent()) {
            metaDataCategoryComponent = (MetaDataCategoryComponent)processorMethod.manager().metaDataCategoryComponent().get();
        } else if (module.manager().metaDataCategoryComponent().isPresent()) {
            metaDataCategoryComponent = (MetaDataCategoryComponent)module.manager().metaDataCategoryComponent().get();
        }
        if (metaDataCategoryComponent != null && metaDataCategoryComponent.getMetaDataNativeQueryOutputRetriever().isPresent()) {
            GeneratedVariable nativeResult = elseBlock.decl((Type)this.ref(Result.class).narrow(this.ref(MetaData.class)), "nativeResult", (GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)auxOutputMetadata).arg(ExpressionFactory._null()).arg((GeneratedExpression)queryStr).arg(ExpressionFactory.TRUE));
            elseBlock.assign((AssignmentTarget)metaData, (GeneratedExpression)nativeResult.invoke("get"));
        } else {
            elseBlock._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")));
        }
    }

    private void generateInputMetadata(Module module, ProcessorMethod processorMethod, GeneratedClass messageProcessorClass) {
        GeneratedMethod getInputMetadata = messageProcessorClass.method(1, (Type)this.ref(Result.class).narrow(MetaData.class), "getInputMetaData");
        getInputMetadata.annotate(Override.class);
        Parameter key = processorMethod.getInputMetaDataKeyParameter();
        if (processorMethod.hasStaticKeyInputMetaData()) {
            Parameter input = processorMethod.getStaticKeyInputMetaData();
            String literalValue = ((MetaDataStaticKey)input.getAnnotation(MetaDataStaticKey.class)).type();
            this.generateMetaDataByLiteralMethod(literalValue, input.getGenericType(), module, getInputMetadata, processorMethod, TypeDescribingProperty.TypeScope.INPUT, (Optional<GeneratedVariable>)Optional.absent());
        } else if (processorMethod.hasDynamicInputMetadata()) {
            Parameter input = processorMethod.getPayloadParameter();
            this.generateMetaDataByKeyMethod(key.getName(), input.getGenericType(), module, getInputMetadata, processorMethod, TypeDescribingProperty.TypeScope.INPUT, (Optional<GeneratedVariable>)Optional.absent());
        } else if (processorMethod.getPayloadParameter() != null) {
            GeneratedExpression keyValue = key != null ? ExpressionFactory.direct((String)key.getName()).invoke("toString") : ExpressionFactory.lit((String)"INPUT_METADATA");
            this.generateMetaDataImplicitMethod(processorMethod.getPayloadParameter().getGenericType(), module, getInputMetadata, processorMethod, keyValue, false);
        } else {
            this.generateNullMetaDataMethod(getInputMetadata);
        }
    }

    private void generateGetPojoOrSimpleModel(Module module, ProcessorMethod processorMethod, GeneratedClass messageProcessorClass) {
        GeneratedMethod getPojoOrSimpleModel = messageProcessorClass.method(4, (Type)this.ref(MetaDataModel.class), "getPojoOrSimpleModel");
        GeneratedVariable clazz = getPojoOrSimpleModel.param((Type)this.ref(Class.class), "clazz");
        GeneratedVariable dataType = getPojoOrSimpleModel.body().decl((Type)this.ref(DataType.class), "dataType", (GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("getInstance").invoke("getDataType").arg((GeneratedExpression)clazz));
        GeneratedConditional conditional = getPojoOrSimpleModel.body()._if((GeneratedExpression)this.ref(DataType.class).staticRef("POJO").invoke("equals").arg((GeneratedExpression)dataType));
        conditional._then()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultPojoMetaDataModel.class)).arg((GeneratedExpression)clazz));
        conditional._else()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultSimpleMetaDataModel.class)).arg((GeneratedExpression)dataType));
    }

    private void generateNullMetaDataMethod(GeneratedMethod method) {
        method.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(this.ref(MetaData.class))).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.SUCCESS")));
    }

    private void generateMetaDataImplicitMethod(GenericType type, Module module, GeneratedMethod method, ProcessorMethod processorMethod, GeneratedExpression studioKey, boolean generatedStructure) {
        GeneratedInvocation defaultResultMetaData = ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMetaData.class)).arg(this.foldMetaData(type, processorMethod, method.body(), studioKey, generatedStructure, module)));
        method.body()._return((GeneratedExpression)defaultResultMetaData);
    }

    private GeneratedExpression foldMetaData(GenericType type, ProcessorMethod processorMethod, GeneratedBlock method, GeneratedExpression studioKey, boolean generatedStructure, Module module) {
        return this.foldMetaData(type, null, processorMethod, method, studioKey, generatedStructure, module);
    }

    private void generateMetaDataByLiteralMethod(String literalValue, GenericType type, Module module, GeneratedMethod method, ProcessorMethod processorMethod, TypeDescribingProperty.TypeScope scope, Optional<GeneratedVariable> nativeQueryParam) {
        this.generateMetaDataByExpressionMethod(type, module, method, processorMethod, ExpressionFactory.lit((String)literalValue), scope, nativeQueryParam);
    }

    private void generateMetaDataByKeyMethod(String typeName, GenericType type, Module module, GeneratedMethod method, ProcessorMethod processorMethod, TypeDescribingProperty.TypeScope scope, Optional<GeneratedVariable> nativeQueryParam) {
        method.body()._if(Op.cor((GeneratedExpression)Op.eq((GeneratedExpression)ExpressionFactory.direct((String)typeName), (GeneratedExpression)ExpressionFactory._null()), (GeneratedExpression)Op.eq((GeneratedExpression)ExpressionFactory.direct((String)typeName).invoke("toString"), (GeneratedExpression)ExpressionFactory._null())))._then()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg(MessageConstants.typeIsNull(module.getName(), processorMethod.getName(), typeName)));
        this.generateMetaDataByExpressionMethod(type, module, method, processorMethod, (GeneratedExpression)ExpressionFactory.direct((String)typeName).invoke("toString"), scope, nativeQueryParam);
    }

    private void generateMetaDataByExpressionMethod(GenericType type, Module module, GeneratedMethod method, ProcessorMethod processorMethod, GeneratedExpression metaDataKeyID, TypeDescribingProperty.TypeScope scope, Optional<GeneratedVariable> nativeQueryParam) {
        boolean generatedStructure = false;
        GeneratedExpression studioKey = metaDataKeyID;
        if (processorMethod.hasDynamicInputMetadata() && processorMethod.hasDynamicOutputMetaData() && scope.equals((Object)TypeDescribingProperty.TypeScope.OUTPUT)) {
            generatedStructure = true;
            studioKey = Op.plus((GeneratedExpression)metaDataKeyID, (GeneratedExpression)ExpressionFactory.lit((String)OUTPUT_METADATA_SUFFIX));
        }
        GeneratedVariable metaDataKey = this.getMetadataKey(module, method.body(), processorMethod, metaDataKeyID, "metaDataKey");
        method.body().add((Statement)metaDataKey.invoke("addProperty").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(TypeDescribingProperty.class)).arg((GeneratedExpression)this.ref(TypeDescribingProperty.TypeScope.class).staticRef(scope.toString())).arg(processorMethod.getName())));
        if (nativeQueryParam.isPresent()) {
            GeneratedVariable generatedQueryParamVariable = (GeneratedVariable)nativeQueryParam.get();
            method.body()._if((GeneratedExpression)generatedQueryParamVariable)._then().add((Statement)metaDataKey.invoke("addProperty").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(NativeQueryKeyProperty.class))));
        }
        GeneratedVariable genericMetaData = method.body().decl((Type)this.ref(Result.class).narrow(MetaData.class), "genericMetaData", (GeneratedExpression)ExpressionFactory.invoke((String)"getGenericMetaData").arg((GeneratedExpression)metaDataKey));
        method.body()._if((GeneratedExpression)ExpressionFactory.direct((String)"Result.Status.FAILURE").invoke("equals").arg((GeneratedExpression)genericMetaData.invoke("getStatus")))._then()._return((GeneratedExpression)genericMetaData);
        GeneratedExpression foldedMetaDataModelValue = this.foldMetaData(type, genericMetaData, processorMethod, method.body(), studioKey, generatedStructure, module);
        GeneratedVariable wrappedMetaDataModel = method.body().decl((Type)this.ref(MetaDataModel.class), "wrappedMetaDataModel", foldedMetaDataModelValue);
        GeneratedInvocation defaultResultMetaData = ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg((GeneratedExpression)this.ref(MetaDataGeneratorUtils.class).staticInvoke("extractPropertiesToMetaData").arg((GeneratedExpression)wrappedMetaDataModel).arg((GeneratedExpression)genericMetaData.invoke("get")));
        method.body()._return((GeneratedExpression)defaultResultMetaData);
    }

    private GeneratedVariable getMetadataKey(Module module, GeneratedBlock method, ProcessorMethod processorMethod, GeneratedExpression metaDataKeyID, String metaDataKeyNameVariable) {
        String[] split;
        GeneratedVariable metaDataKey = method.decl((Type)this.ref(DefaultMetaDataKey.class), metaDataKeyNameVariable, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMetaDataKey.class)).arg(metaDataKeyID).arg(ExpressionFactory._null()));
        String fullQualifiedName = null;
        if (processorMethod.hasMetaDataScope()) {
            fullQualifiedName = processorMethod.metaDataScope().toString();
        } else if (module.getAnnotation(MetaDataScope.class) != null) {
            fullQualifiedName = module.metaDataScope().toString();
        }
        if (fullQualifiedName != null && (split = fullQualifiedName.split("\\.")).length > 1) {
            method.add((Statement)metaDataKey.invoke("setCategory").arg(split[split.length - 1]));
        }
        return metaDataKey;
    }

    private void generateGetGenericMetaDataMethod(Module module, ProcessorMethod processorMethod, GeneratedClass messageProcessorClass) {
        GeneratedMethod getGenericMetaDataMethod = messageProcessorClass.method(1, (Type)this.ref(Result.class).narrow(MetaData.class), "getGenericMetaData");
        GeneratedVariable metaDataKeyParam = getGenericMetaDataMethod.param((Type)this.ref(MetaDataKey.class), "metaDataKey");
        GeneratedVariable connector = getGenericMetaDataMethod.body().decl((Type)this.ref(ConnectorMetaDataEnabled.class), "connector");
        GeneratedTry generatedTry = getGenericMetaDataMethod.body()._try();
        generatedTry.body().assign((AssignmentTarget)connector, (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ConnectorMetaDataEnabled.class), (GeneratedExpression)ExpressionFactory.invoke((String)"findOrCreate").arg(ExpressionFactory._null()).arg(ExpressionFactory.FALSE).arg(ExpressionFactory._null())));
        GeneratedTry metadataTry = generatedTry.body()._try();
        GeneratedVariable metadata = metadataTry.body().decl((Type)this.ref(Result.class).narrow(MetaData.class), "metadata", (GeneratedExpression)connector.invoke("getMetaData").arg((GeneratedExpression)metaDataKeyParam));
        metadataTry.body()._if((GeneratedExpression)ExpressionFactory.direct((String)"Result.Status.FAILURE").invoke("equals").arg((GeneratedExpression)metadata.invoke("getStatus")))._then()._return((GeneratedExpression)metadata);
        metadataTry.body()._if(Op.eq((GeneratedExpression)metadata.invoke("get"), (GeneratedExpression)ExpressionFactory._null()))._then()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg(MessageConstants.metaDataGetNull(module.getName(), processorMethod.getName())));
        GeneratedCatchBlock metadataCatch = metadataTry._catch(this.ref(Exception.class));
        GeneratedVariable e1 = metadataCatch.param("e");
        metadataCatch.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e1.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e1));
        metadataTry.body()._return((GeneratedExpression)metadata);
        GeneratedCatchBlock classCastExeption = generatedTry._catch(this.ref(ClassCastException.class));
        classCastExeption.param("cast");
        classCastExeption.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg(MessageConstants.noConnectionManagerAvaiableMaybeOauth()));
        GeneratedCatchBlock configException = generatedTry._catch(this.ref(ConfigurationException.class));
        GeneratedVariable e = configException.param("e");
        configException.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
        GeneratedCatchBlock registrationException = generatedTry._catch(this.ref(RegistrationException.class));
        registrationException.param("e");
        registrationException.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
        GeneratedCatchBlock illegalAccessException = generatedTry._catch(this.ref(IllegalAccessException.class));
        illegalAccessException.param("e");
        illegalAccessException.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
        GeneratedCatchBlock instantiationException = generatedTry._catch(this.ref(InstantiationException.class));
        instantiationException.param("e");
        instantiationException.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
        GeneratedCatchBlock exception = generatedTry._catch(this.ref(Exception.class));
        exception.param("e");
        exception.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
    }

    private GeneratedClass getConnectionManager(ProcessorMethod processorMethod) {
        if (processorMethod.canBeUsedInConnectionManagement()) {
            return (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGER, (Identifiable)processorMethod.getManagedConnectionModule());
        }
        throw new RuntimeException();
    }

    private GeneratedExpression foldMetaData(GenericType type, GeneratedVariable metadata, ProcessorMethod processorMethod, GeneratedBlock method, GeneratedExpression studioKey, boolean generatedStructure, Module module) {
        if (type.isCollection()) {
            return this.foldCollectionMetaData(type, metadata, processorMethod, method, studioKey, generatedStructure, module);
        }
        if (type.getElement().isPresent() && type.is(ProviderAwarePagingDelegate.class.getSimpleName())) {
            return this.foldCollectionMetaDataProviderAwarePagingDelegate(type, metadata, processorMethod, method, studioKey, generatedStructure, module);
        }
        if (type.getElement().isPresent() && type.is(TransformingValue.class.getSimpleName())) {
            return this.foldMetaData((GenericType)type.getGenericTypeArguments().get(0), metadata, processorMethod, method, studioKey, generatedStructure, module);
        }
        if (metadata != null) {
            return this.addStructureIdentifierIfNeeded((GeneratedExpression)metadata.invoke("get").invoke("getPayload"), method, studioKey, generatedStructure, module, processorMethod);
        }
        if (type.isMap()) {
            return this.foldMapMetaData(type, metadata, processorMethod, method, studioKey, generatedStructure, module);
        }
        return this.foldLeafMetaData(type, processorMethod, method, studioKey, generatedStructure, module);
    }

    private GeneratedExpression foldCollectionMetaData(GenericType type, GeneratedVariable metadata, ProcessorMethod processorMethod, GeneratedBlock method, GeneratedExpression studioKey, boolean generatedStructure, Module module) {
        GeneratedExpression arg0 = type.getGenericTypeArguments().isEmpty() ? this.foldLeafPojoOrSimpleModelMetaData(this.ref(Object.class).dotclass()) : this.foldMetaData((GenericType)type.getGenericTypeArguments().get(0), metadata, processorMethod, method, studioKey, generatedStructure, module);
        return ExpressionFactory._new((TypeReference)this.ref(DefaultListMetaDataModel.class)).arg(arg0);
    }

    private GeneratedExpression foldCollectionMetaDataProviderAwarePagingDelegate(GenericType type, GeneratedVariable metadata, ProcessorMethod processorMethod, GeneratedBlock method, GeneratedExpression studioKey, boolean generatedStructure, Module module) {
        GeneratedExpression foldCollectionMetaData = this.foldCollectionMetaData(type, metadata, processorMethod, method, studioKey, generatedStructure, module);
        GeneratedVariable listMetaDataModel = method.decl((Type)this.ref(DefaultListMetaDataModel.class), "defaultListMetaDataModel", foldCollectionMetaData);
        method.add((Statement)listMetaDataModel.invoke("setImplementationClass").arg(ExpressionFactory.lit((String)ConsumerIterator.class.getCanonicalName())));
        return listMetaDataModel;
    }

    private GeneratedExpression foldMapMetaData(GenericType type, GeneratedVariable metadata, ProcessorMethod processorMethod, GeneratedBlock method, GeneratedExpression studioKey, boolean generatedStructure, Module module) {
        GeneratedExpression arg1;
        GeneratedExpression arg0;
        if (type.getGenericTypeArguments().isEmpty()) {
            arg0 = this.foldLeafPojoOrSimpleModelMetaData(this.ref(Object.class).dotclass());
            arg1 = this.foldLeafPojoOrSimpleModelMetaData(this.ref(Object.class).dotclass());
        } else {
            arg0 = this.foldMetaData((GenericType)type.getGenericTypeArguments().get(0), metadata, processorMethod, null, null, false, null);
            arg1 = this.foldMetaData((GenericType)type.getGenericTypeArguments().get(1), metadata, processorMethod, null, null, false, null);
        }
        return this.addStructureIdentifierIfNeeded((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultParameterizedMapMetaDataModel.class)).arg(arg0).arg(arg1), method, studioKey, generatedStructure, module, processorMethod);
    }

    private GeneratedExpression foldLeafMetaData(GenericType type, ProcessorMethod processorMethod, GeneratedBlock method, GeneratedExpression studioKey, boolean generatedStructure, Module module) {
        if (type.getType() != null) {
            if (!type.getGenericTypeArguments().isEmpty()) {
                this.ctx().warn(MessageConstants.typeDoesntSupportMetaData(type, processorMethod));
            }
            DataTypeFactory.getInstance().getDataType(type.getType().getKind().getDeclaringClass());
            return this.addStructureIdentifierIfNeeded(this.foldLeafPojoOrSimpleModelMetaData(this.ref(type.getType()).dotclass()), method, studioKey, generatedStructure, module, processorMethod);
        }
        this.ctx().error(MessageConstants.errorGeneratingMetaData(processorMethod));
        return ExpressionFactory._null();
    }

    private GeneratedExpression foldLeafPojoOrSimpleModelMetaData(GeneratedExpression classDotClass) {
        return ExpressionFactory.invoke((String)"getPojoOrSimpleModel").arg(classDotClass);
    }

    private GeneratedExpression addStructureIdentifierIfNeeded(GeneratedExpression metaData, GeneratedBlock method, GeneratedExpression studioKey, boolean generatedStructure, Module module, ProcessorMethod processorMethod) {
        if (method != null) {
            GeneratedVariable metaDataPayload = method.decl((Type)this.ref(MetaDataModel.class), "metaDataPayload", metaData);
            GeneratedVariable keyForStudio = this.getMetadataKey(module, method, processorMethod, studioKey, "keyForStudio");
            method.add((Statement)metaDataPayload.invoke("addProperty").arg((GeneratedExpression)this.ref(STUDIO7157.class).staticInvoke("getStructureIdentifierMetaDataModelProperty").arg((GeneratedExpression)keyForStudio).arg(ExpressionFactory.FALSE).arg(generatedStructure ? ExpressionFactory.TRUE : ExpressionFactory.FALSE)));
            return metaDataPayload;
        }
        return metaData;
    }

    private void generateMessageProcessorClassDoc(ProcessorMethod executableElement, GeneratedClass messageProcessorClass) {
        messageProcessorClass.javadoc().add((Object)(messageProcessorClass.name() + " invokes the "));
        messageProcessorClass.javadoc().add((Object)("{@link " + ((org.mule.devkit.model.Type)executableElement.parent()).getQualifiedName().toString() + "#"));
        messageProcessorClass.javadoc().add((Object)(executableElement.getName() + "("));
        boolean first = true;
        for (Parameter variable : executableElement.getParameters()) {
            if (!first) {
                messageProcessorClass.javadoc().add((Object)", ");
            }
            messageProcessorClass.javadoc().add((Object)variable.asTypeMirror().toString().replaceAll("<[a-zA-Z\\-\\.\\<\\>\\s\\,]*>", ""));
            first = false;
        }
        messageProcessorClass.javadoc().add((Object)")} method in ");
        messageProcessorClass.javadoc().add((Object)this.ref(((org.mule.devkit.model.Type)executableElement.parent()).asTypeMirror()));
        messageProcessorClass.javadoc().add((Object)". For each argument there is a field in this processor to match it. ");
        messageProcessorClass.javadoc().add((Object)" Before invoking the actual method the processor will evaluate and transform");
        messageProcessorClass.javadoc().add((Object)" where possible to the expected argument type.");
    }

    private GeneratedClass getMessageProcessorClass(Module module, ProcessorMethod processorMethod) {
        GeneratedClass clazz;
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((org.mule.devkit.model.Type)processorMethod.parent()).getPackage().getName() + ".generated.processors");
        if (this.hasToBeConnected(module, processorMethod)) {
            TypeReference typeReference = (TypeReference)this.ctx().getProduct(processorMethod.isPaged() ? Product.ABSTRACT_PAGED_CONNECTED_PROCESOR : Product.ABSTRACT_CONNECTED_PROCESSOR);
            clazz = pkg._class(processorMethod.getCapitalizedName() + "MessageProcessor", typeReference, new Class[]{MessageProcessor.class});
        } else {
            clazz = processorMethod.isPaged() ? pkg._class(processorMethod.getCapitalizedName() + "MessageProcessor", AbstractDevkitBasedPageableMessageProcessor.class, new Class[]{MessageProcessor.class}) : pkg._class(processorMethod.getCapitalizedName() + "MessageProcessor", DevkitBasedMessageProcessor.class, new Class[]{MessageProcessor.class});
        }
        if (processorMethod.hasDynamicMetaData()) {
            clazz._implements(OperationMetaDataEnabled.class);
        }
        this.ctx().registerProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName(), (Object)clazz);
        return clazz;
    }

    private boolean hasToBeConnected(Module module, ProcessorMethod processorMethod) {
        return module instanceof ManagedConnectionModule || module instanceof OAuthModule || processorMethod.module().manager().connectionManagementOverride().isPresent();
    }

    private GeneratedClass getInterceptingMessageProcessorClass(Module module, ProcessorMethod processorMethod) {
        GeneratedClass clazz;
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((org.mule.devkit.model.Type)processorMethod.parent()).getPackage().getName() + ".generated.processors");
        if (this.hasToBeConnected(module, processorMethod)) {
            TypeReference typeReference = (TypeReference)this.ctx().getProduct(Product.ABSTRACT_CONNECTED_INTERCEPTING_PROCESSOR);
            clazz = pkg._class(processorMethod.getCapitalizedName() + "MessageProcessor", typeReference, new Class[]{InterceptingMessageProcessor.class});
        } else {
            clazz = pkg._class(processorMethod.getCapitalizedName() + "MessageProcessor", AbstractListeningMessageProcessor.class, new Class[]{InterceptingMessageProcessor.class});
        }
        if (processorMethod.hasDynamicMetaData()) {
            clazz._implements(OperationMetaDataEnabled.class);
        }
        this.ctx().registerProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName(), (Object)clazz);
        return clazz;
    }

    private void generateStartMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod startMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "start");
        startMethod._throws(this.ref(MuleException.class));
        startMethod.body().add((Statement)ExpressionFactory._super().invoke("start"));
        startMethod.annotate(Override.class);
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (variableElement.getVariable().asType().isNestedProcessor() || variableElement.getVariable().asType().isArrayOrList() && variableElement.getVariable().getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor()) {
                    boolean isList = variableElement.getVariable().asType().isArrayOrList();
                    if (!isList) {
                        GeneratedConditional ifStartable = startMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Startable.class)));
                        ifStartable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)variableElement.getField()).invoke("start"));
                        continue;
                    }
                    GeneratedConditional ifIsList = startMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                    GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                    GeneratedConditional ifStartable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Startable.class)));
                    ifStartable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)forEachProcessor.var()).invoke("start"));
                    continue;
                }
                if (!variableElement.getVariable().asTypeMirror().toString().startsWith(HttpCallback.class.getName())) continue;
                startMethod.body()._if(variableElement.getFieldType().isNotNull())._then().invoke((GeneratedExpression)variableElement.getFieldType(), "start");
            }
        }
    }

    private void generateStopMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod stopMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "stop");
        stopMethod._throws(this.ref(MuleException.class));
        stopMethod.annotate(Override.class);
        stopMethod.body().add((Statement)ExpressionFactory._super().invoke("stop"));
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (variableElement.getVariable().asType().isNestedProcessor() || variableElement.getVariable().asType().isArrayOrList() && variableElement.getVariable().getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor()) {
                    boolean isList = variableElement.getVariable().asType().isArrayOrList();
                    if (!isList) {
                        GeneratedConditional ifStoppable = stopMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Stoppable.class)));
                        ifStoppable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)variableElement.getField()).invoke("stop"));
                        continue;
                    }
                    GeneratedConditional ifIsList = stopMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                    GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                    GeneratedConditional ifStoppable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Stoppable.class)));
                    ifStoppable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)forEachProcessor.var()).invoke("stop"));
                    continue;
                }
                if (!variableElement.getVariable().asTypeMirror().toString().startsWith(HttpCallback.class.getName())) continue;
                stopMethod.body()._if(variableElement.getFieldType().isNotNull())._then().invoke((GeneratedExpression)variableElement.getFieldType(), "stop");
            }
        }
    }

    private void generateDiposeMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod diposeMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "dispose");
        diposeMethod.annotate(Override.class);
        diposeMethod.body().add((Statement)ExpressionFactory._super().invoke("dispose"));
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (!variableElement.getVariable().asType().isNestedProcessor() && (!variableElement.getVariable().asType().isArrayOrList() || variableElement.getVariable().getTypeArguments().size() <= 0 || !((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor())) continue;
                boolean isList = variableElement.getVariable().asType().isArrayOrList();
                if (!isList) {
                    GeneratedConditional ifDisposable = diposeMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Disposable.class)));
                    ifDisposable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)variableElement.getField()).invoke("dispose"));
                    continue;
                }
                GeneratedConditional ifIsList = diposeMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                GeneratedConditional ifDisposable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Disposable.class)));
                ifDisposable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)forEachProcessor.var()).invoke("dispose"));
            }
        }
    }
}

