/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MetadataAware;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.NativeQueryMetadataTranslator;
import org.mule.common.query.DsqlQuery;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.MessageConstants;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.connectivity.AbstractConnectionManagerGenerator;
import org.mule.devkit.generation.connectivity.metadata.ConnectorMetaDataEnabledUtilsGenerator;
import org.mule.devkit.internal.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.internal.connection.management.ConnectionManagementConnectionManager;
import org.mule.devkit.internal.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.internal.connection.management.UnableToAcquireConnectionException;
import org.mule.devkit.internal.connectivity.ConnectivityTestingErrorHandler;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.devkit.utils.NameUtils;

public class ConnectionManagerGenerator
extends AbstractConnectionManagerGenerator
implements MultiModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.POOL_IMPL, Product.POOL_CONFIG, Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, Product.STRATEGY_ADAPTER, Product.CONNECTION_KEY);
    private static final List<Product> PRODUCES = Arrays.asList(Product.CONNECTION_MANAGER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.manager().connectionManagementComponents().isEmpty() && !(module instanceof ManagedConnectionModule) || !module.manager().wsdlProviderComponent().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> processableModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.manager().connectionManagementComponents().isEmpty() && !(module instanceof ManagedConnectionModule)) continue;
            processableModules.add(module);
        }
        return processableModules;
    }

    public void generate(List<Module> modules) throws GenerationException {
        for (Module module : modules) {
            for (ConnectionManagementComponent connectionManagementComponent : module.manager().connectionManagementComponents()) {
                this.generateModule(module, connectionManagementComponent);
            }
            if (!(module instanceof ManagedConnectionModule)) continue;
            this.generateManagedModule((ManagedConnectionModule)module);
        }
    }

    private void generateManagedModule(ManagedConnectionModule module) {
        ConnectMethod connectMethod = module.getConnectMethod();
        GeneratedClass connectionManagerClass = this.getConnectionManagerAdapterClass(module);
        Map<String, AbstractMuleGenerator.FieldVariableElement> fields = this.generateStandardFieldForEachParameter(connectionManagerClass, (Method)connectMethod);
        Map<GeneratedField, GeneratedMethod> configurables = this.generateConfigurablesWithSettersAndGetters(connectionManagerClass, module.getConfigurableFields());
        GeneratedField muleContext = connectionManagerClass.muleContextField();
        GeneratedField connectionPool = this.generateFieldForConnectionPool(connectionManagerClass);
        GeneratedField poolingConfig = connectionManagerClass.field(2, (Type)((TypeReference)this.ctx().getProduct(Product.POOL_CONFIG)), StringUtils.uncapitalize((String)((TypeReference)this.ctx().getProduct(Product.POOL_CONFIG)).name()));
        GeneratedField retryPolicyTemplate = connectionManagerClass.field(2, (Type)this.ref(RetryPolicyTemplate.class), "retryPolicyTemplate");
        connectionManagerClass.setter(poolingConfig);
        connectionManagerClass.getter(poolingConfig);
        connectionManagerClass.setter(retryPolicyTemplate);
        connectionManagerClass.getter(retryPolicyTemplate);
        GeneratedClass connectionKeyClass = (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)module);
        this.generateInitialiseMethod(connectionManagerClass, connectionPool, poolingConfig, retryPolicyTemplate);
        this.generateDisposeMethod(connectionManagerClass, connectionPool);
        GeneratedClass connectorAdapter = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, (Identifiable)module)).topLevelClass();
        this.generateAcquireConnectionMethod(connectionManagerClass, connectionPool, connectionKeyClass, (TypeReference)connectorAdapter);
        this.generateReturnConnectionMethod(connectionManagerClass, connectionPool, connectionKeyClass, (TypeReference)connectorAdapter);
        this.generateDestroyConnectionMethod(connectionManagerClass, connectionPool, connectionKeyClass, (TypeReference)connectorAdapter);
        this.generateIsCapableOfMethod((Module)module, connectionManagerClass);
        this.generateGetConnectionManagementProcessTemplateMethod(connectionManagerClass, (Type)connectorAdapter);
        this.generateGetDefaultConnectionKey(connectMethod, connectionManagerClass, connectionKeyClass);
        this.generateGetEvaluatedConnectionKey(connectMethod, connectionManagerClass, connectionKeyClass, muleContext);
        this.generateMetadataConstantsAndGetters((Module)module, connectionManagerClass);
        this.generateGetConnectionKey((Module)module, null, connectionManagerClass, connectionKeyClass, muleContext);
        this.generateNewConnectionMethodForModule(module, connectionManagerClass, configurables);
        this.generateNewConnectorMethod(connectionManagerClass, connectionKeyClass);
        this.generateGetConnectionAdapter(connectionManagerClass);
        if (module.getMinMuleVersion().atLeastBase("3.4")) {
            this.generateTestMethodForModuleWithoutStrategies(module, connectionManagerClass, connectionKeyClass);
        }
        this.generateMetadataMethods((Module)module, connectionManagerClass, connectionKeyClass);
        this.generateNativeQueryMethod((Module)module, connectionManagerClass, connectionKeyClass);
    }

    private void generateNewConnectionMethodForModule(ManagedConnectionModule module, GeneratedClass connectionManager, Map<GeneratedField, GeneratedMethod> configurables) {
        GeneratedMethod newConnection = connectionManager.method(1, ConnectionManagementConnectionAdapter.class, "newConnection");
        newConnection.annotate(Override.class);
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.STRATEGY_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedVariable connector = newConnection.body().decl((Type)connectorClass, "connector", (GeneratedExpression)ExpressionFactory._new((TypeReference)connectorClass));
        for (GeneratedField generatedField : configurables.keySet()) {
            newConnection.body().add((Statement)connector.invoke(NameUtils.buildSetter((String)generatedField.name())).arg((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)configurables.get(generatedField))));
        }
        newConnection.body()._return((GeneratedExpression)connector);
    }

    public void generateModule(Module module, ConnectionManagementComponent component) throws GenerationException {
        ConnectMethod connectMethod = component.getConnectMethod();
        GeneratedClass connectionManagerClass = this.getConnectionManagerAdapterClass(module, component);
        this.generateStandardFieldForEachParameter(connectionManagerClass, (Method)connectMethod);
        Map<GeneratedField, GeneratedMethod> moduleConfigurables = this.generateConfigurablesWithSettersAndGetters(connectionManagerClass, module.getConfigurableFields());
        Map<GeneratedField, GeneratedMethod> componentConfigurables = this.generateConfigurablesWithSettersAndGetters(connectionManagerClass, component.getConfigurableFields());
        GeneratedField muleContext = connectionManagerClass.muleContextField();
        GeneratedField connectionPool = this.generateFieldForConnectionPool(connectionManagerClass);
        GeneratedField poolingConfig = connectionManagerClass.field(2, (Type)((TypeReference)this.ctx().getProduct(Product.POOL_CONFIG)), StringUtils.uncapitalize((String)((TypeReference)this.ctx().getProduct(Product.POOL_CONFIG)).name()));
        GeneratedField retryPolicyTemplate = connectionManagerClass.field(2, (Type)this.ref(RetryPolicyTemplate.class), "retryPolicyTemplate");
        connectionManagerClass.setter(poolingConfig);
        connectionManagerClass.getter(poolingConfig);
        connectionManagerClass.setter(retryPolicyTemplate);
        connectionManagerClass.getter(retryPolicyTemplate);
        GeneratedClass connectionKeyClass = (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)component, module.getName());
        this.generateInitialiseMethod(connectionManagerClass, connectionPool, poolingConfig, retryPolicyTemplate);
        this.generateDisposeMethod(connectionManagerClass, connectionPool);
        GeneratedClass connectorAdapter = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, (Identifiable)module)).topLevelClass();
        this.generateAcquireConnectionMethod(connectionManagerClass, connectionPool, connectionKeyClass, (TypeReference)connectorAdapter);
        this.generateReturnConnectionMethod(connectionManagerClass, connectionPool, connectionKeyClass, (TypeReference)connectorAdapter);
        this.generateDestroyConnectionMethod(connectionManagerClass, connectionPool, connectionKeyClass, (TypeReference)connectorAdapter);
        this.generateIsCapableOfMethod(module, connectionManagerClass);
        this.generateGetConnectionManagementProcessTemplateMethod(connectionManagerClass, (Type)connectorAdapter);
        this.generateGetDefaultConnectionKey(connectMethod, connectionManagerClass, connectionKeyClass);
        this.generateGetEvaluatedConnectionKey(connectMethod, connectionManagerClass, connectionKeyClass, muleContext);
        this.generateMetadataConstantsAndGetters(module, connectionManagerClass);
        this.generateGetConnectionKey(module, component, connectionManagerClass, connectionKeyClass, muleContext);
        GeneratedClass strategyAdapter = (GeneratedClass)this.ctx().getProduct(Product.STRATEGY_ADAPTER, (Identifiable)component, module.getName());
        this.generateNewConnectionMethod(connectionManagerClass, (Type)strategyAdapter, (ConnectionComponent)component);
        this.generateNewConnectorMethod(module, connectionManagerClass, (ConnectionComponent)component, connectionKeyClass, moduleConfigurables, connectorAdapter);
        this.generateGetConnectionAdapter(module, connectionManagerClass, (Type)connectorAdapter);
        if (module.getMinMuleVersion().atLeastBase("3.4")) {
            this.generateTestMethodForStrategiesEnabledConnector(connectionManagerClass, (Type)strategyAdapter);
        }
        this.generateMetadataMethods(module, connectionManagerClass, connectionKeyClass);
        this.generateNativeQueryMethod(module, connectionManagerClass, connectionKeyClass);
    }

    private void generateGetConnectionKey(Module module, ConnectionManagementComponent component, GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass, GeneratedField muleContext) {
        GeneratedMethod execute = connectionManagerClass.method(1, (Type)connectionKeyClass, "getConnectionKey");
        execute.annotate(Override.class);
        execute._throws(Exception.class);
        GeneratedVariable messageProcessor = execute.param((Type)this.ref(MessageProcessor.class), "messageProcessor");
        GeneratedVariable event = execute.param((Type)this.ref(MuleEvent.class), "event");
        if (module instanceof ManagedConnectionModule || component != null && component.overridesAtMessageProcessor()) {
            ConnectMethod connectMethod = module instanceof ManagedConnectionModule ? ((ManagedConnectionModule)module).getConnectMethod() : component.getConnectMethod();
            GeneratedClass connectivityProcessorInterface = (GeneratedClass)this.ctx().getProduct(Product.CONNECTIVITY_PROCESSOR_INTERFACE);
            GeneratedMethod hasConnectionKeysOverrideMethod = this.generateHasConnectionKeysOverride(connectMethod, connectionManagerClass, connectivityProcessorInterface, connectionKeyClass);
            GeneratedConditional ifConnectionKeyNotNull = execute.body()._if((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)hasConnectionKeysOverrideMethod).arg((GeneratedExpression)messageProcessor));
            GeneratedInvocation newKey = ExpressionFactory._new((TypeReference)connectionKeyClass);
            GeneratedVariable connectivityProcessor = ifConnectionKeyNotNull._then().decl((Type)connectivityProcessorInterface, "connectivityProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)connectivityProcessorInterface, (GeneratedExpression)messageProcessor));
            for (Parameter parameter : connectMethod.getParameters()) {
                GeneratedVariable transformedVariable = this.declareTransformedVariable((Variable)parameter, (GeneratedExpression)connectivityProcessor.invoke("get" + StringUtils.capitalize((String)parameter.getName())), (GeneratedExpression)connectivityProcessor.invoke("typeFor").arg(ExpressionFactory.lit((String)("_" + parameter.getName() + "Type"))), event, ifConnectionKeyNotNull._then(), (GeneratedExpression)muleContext);
                newKey.arg((GeneratedExpression)transformedVariable);
                if (parameter.isOptional()) continue;
                ifConnectionKeyNotNull._then()._if(transformedVariable.isNull())._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnableToAcquireConnectionException.class)).arg(MessageConstants.nullNotOptionalParameter(parameter.getName(), connectMethod.getName())));
            }
            ifConnectionKeyNotNull._then()._return((GeneratedExpression)newKey);
            ifConnectionKeyNotNull._else()._return((GeneratedExpression)ExpressionFactory.invoke((String)"getEvaluatedConnectionKey").arg((GeneratedExpression)event));
        } else {
            execute.body()._return((GeneratedExpression)ExpressionFactory.invoke((String)"getEvaluatedConnectionKey").arg((GeneratedExpression)event));
        }
    }

    private void generateNativeQueryMethod(Module module, GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass) {
        if (module.hasQueryTranslator()) {
            GeneratedMethod nativeQueryMethod = connectionManagerClass.method(1, (Type)this.ref(Result.class).narrow(String.class), "toNativeQuery");
            GeneratedVariable query = nativeQueryMethod.param((Type)this.ref(DsqlQuery.class), "query");
            nativeQueryMethod.annotate(Override.class);
            GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, (Identifiable)module)).topLevelClass();
            GeneratedVariable connection = nativeQueryMethod.body().decl((Type)connectorClass, "connection", ExpressionFactory._null());
            GeneratedVariable result = nativeQueryMethod.body().decl((Type)this.ref(Result.class).narrow(this.ref(String.class)), "result");
            GeneratedVariable defaultConnectionKey = nativeQueryMethod.body().decl((Type)connectionKeyClass, "key", (GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
            GeneratedTry tryTestConnection = nativeQueryMethod.body()._try();
            tryTestConnection.body().assign((AssignmentTarget)connection, (GeneratedExpression)ExpressionFactory.invoke((String)"acquireConnection").arg((GeneratedExpression)defaultConnectionKey));
            Method translator = module.getQueryTranslatorMethod();
            tryTestConnection.body().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(String.class)).arg((GeneratedExpression)connection.invoke(translator.getName()).arg((GeneratedExpression)query).invoke("toString")));
            GeneratedCatchBlock catchTestConnection = tryTestConnection._catch(this.ref(Exception.class));
            GeneratedVariable e = catchTestConnection.param("e");
            GeneratedTry tryDestroyConnection = catchTestConnection.body()._try();
            tryDestroyConnection.body().invoke("destroyConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
            tryDestroyConnection._catch(this.ref(Exception.class)).param("ie");
            catchTestConnection.body().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(String.class)).arg(ExpressionFactory._null()).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")));
            GeneratedBlock finallyTestConnection = tryTestConnection._finally();
            GeneratedConditional ifNotNull = finallyTestConnection._if(connection.isNotNull());
            GeneratedTry tryReleaseConnection = ifNotNull._then()._try();
            tryReleaseConnection.body().invoke("releaseConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
            tryReleaseConnection._catch(this.ref(Exception.class)).param("ie");
            nativeQueryMethod.body()._return((GeneratedExpression)result);
        }
    }

    protected GeneratedMethod generateHasConnectionKeysOverride(ConnectMethod connectMethod, GeneratedClass managedConnectionProcessInterceptorClass, GeneratedClass connectivityProcessorInterface, GeneratedClass connectionKeyClass) {
        GeneratedMethod hasConnectionKeysOverrideMethod = managedConnectionProcessInterceptorClass.method(4, Boolean.class, "hasConnectionKeysOverride");
        GeneratedVariable messageProcessorParam = hasConnectionKeysOverrideMethod.param(MessageProcessor.class, "messageProcessor");
        hasConnectionKeysOverrideMethod.javadoc().add((Object)("Validates that the current message processor has changed any of its connection parameters at processor level. If so, a new " + connectionKeyClass.name() + " must be generated"));
        hasConnectionKeysOverrideMethod.javadoc().addParam(messageProcessorParam).append((Object)"the message processor to test against the keys");
        hasConnectionKeysOverrideMethod.javadoc().addReturn("").add((Object)"true if any of the parameters in @Connect method annotated with @ConnectionKey was override in the XML, false otherwise  ");
        hasConnectionKeysOverrideMethod.body()._if(Op.cor((GeneratedExpression)messageProcessorParam.isNull(), (GeneratedExpression)Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)messageProcessorParam, (Type)connectivityProcessorInterface))))._then()._return(ExpressionFactory.lit((boolean)false));
        GeneratedVariable abstractConnectedProcessorVariable = hasConnectionKeysOverrideMethod.body().decl((Type)connectivityProcessorInterface, "connectivityProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)connectivityProcessorInterface, (GeneratedExpression)messageProcessorParam));
        for (Parameter parameter : connectMethod.getConnectionKeys()) {
            hasConnectionKeysOverrideMethod.body()._if(abstractConnectedProcessorVariable.invoke("get" + StringUtils.capitalize((String)parameter.getName())).isNotNull())._then()._return(ExpressionFactory.lit((boolean)true));
        }
        hasConnectionKeysOverrideMethod.body()._return(ExpressionFactory.lit((boolean)false));
        return hasConnectionKeysOverrideMethod;
    }

    protected void generateMetadataMethods(Module module, GeneratedClass generatedClass, GeneratedClass connectionKeyClass) {
        ConnectorMetaDataEnabledUtilsGenerator connectorMetaDataEnabledUtilsGenerator = new ConnectorMetaDataEnabledUtilsGenerator();
        connectorMetaDataEnabledUtilsGenerator.setCtx(this.ctx());
        if (connectorMetaDataEnabledUtilsGenerator.isMetaDataCapable(module)) {
            generatedClass._implements(this.ref(ConnectorMetaDataEnabled.class));
            GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, (Identifiable)module)).topLevelClass();
            this.generateMetaDataKeysMethod(module, generatedClass, connectionKeyClass, connectorClass, connectorMetaDataEnabledUtilsGenerator);
            this.generateMetaDataMethod(module, generatedClass, connectionKeyClass, connectorClass, connectorMetaDataEnabledUtilsGenerator);
        }
    }

    private void generateMetaDataMethod(Module module, GeneratedClass generatedClass, GeneratedClass connectionKeyClass, GeneratedClass connectorClass, ConnectorMetaDataEnabledUtilsGenerator connectorMetaDataEnabledUtilsGenerator) {
        GeneratedMethod getMetadata = generatedClass.method(1, (Type)this.ref(Result.class).narrow(this.ref(MetaData.class)), "getMetaData");
        getMetadata.annotate(Override.class);
        GeneratedVariable key = getMetadata.param((Type)this.ref(MetaDataKey.class), "metaDataKey");
        GeneratedVariable connection = getMetadata.body().decl((Type)connectorClass, "connection", ExpressionFactory._null());
        GeneratedVariable defaultConnectionKey = getMetadata.body().decl((Type)connectionKeyClass, "key", (GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
        GeneratedTry tryTestConnection = getMetadata.body()._try();
        GeneratedBlock bodyToResolveEntity = tryTestConnection.body();
        bodyToResolveEntity.assign((AssignmentTarget)connection, (GeneratedExpression)ExpressionFactory.invoke((String)"acquireConnection").arg((GeneratedExpression)defaultConnectionKey));
        connectorMetaDataEnabledUtilsGenerator.generateTryMetaDataEntityResolver(module, generatedClass, key, (GeneratedExpression)connection, bodyToResolveEntity);
        GeneratedCatchBlock catchTestConnection = tryTestConnection._catch(this.ref(Exception.class));
        GeneratedVariable e = catchTestConnection.param("e");
        GeneratedTry tryDestroyConnection = catchTestConnection.body()._try();
        tryDestroyConnection.body().invoke("destroyConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryDestroyConnection._catch(this.ref(Exception.class)).param("ie");
        catchTestConnection.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(DefaultResult.class).narrow(this.ref(MetaData.class)), (GeneratedExpression)this.ref(ConnectivityTestingErrorHandler.class).staticInvoke("buildFailureTestResult").arg((GeneratedExpression)e)));
        GeneratedBlock finallyTestConnection = tryTestConnection._finally();
        GeneratedConditional ifNotNull = finallyTestConnection._if(connection.isNotNull());
        GeneratedTry tryReleaseConnection = ifNotNull._then()._try();
        tryReleaseConnection.body().invoke("releaseConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryReleaseConnection._catch(this.ref(Exception.class)).param("ie");
    }

    private void generateMetaDataKeysMethod(Module module, GeneratedClass generatedClass, GeneratedClass connectionKeyClass, GeneratedClass connectorClass, ConnectorMetaDataEnabledUtilsGenerator connectorMetaDataEnabledUtilsGenerator) {
        GeneratedMethod getMetadataKeys = generatedClass.method(1, (Type)this.ref(String.class), "getMetaDataKeys");
        getMetadataKeys.annotate(Override.class);
        getMetadataKeys.type((Type)this.ref(Result.class).narrow(this.ref(List.class).narrow(this.ref(MetaDataKey.class))));
        GeneratedVariable connection = getMetadataKeys.body().decl((Type)connectorClass, "connection", ExpressionFactory._null());
        GeneratedVariable defaultConnectionKey = getMetadataKeys.body().decl((Type)connectionKeyClass, "key", (GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
        GeneratedTry tryTestConnection = getMetadataKeys.body()._try();
        GeneratedBlock bodyToResolveKeys = tryTestConnection.body();
        bodyToResolveKeys.assign((AssignmentTarget)connection, (GeneratedExpression)ExpressionFactory.invoke((String)"acquireConnection").arg((GeneratedExpression)defaultConnectionKey));
        connectorMetaDataEnabledUtilsGenerator.generateTryMetaDataKeyResolver(module, generatedClass, (GeneratedExpression)connection, bodyToResolveKeys);
        GeneratedCatchBlock catchTestConnection = tryTestConnection._catch(this.ref(Exception.class));
        GeneratedVariable e = catchTestConnection.param("e");
        GeneratedTry tryDestroyConnection = catchTestConnection.body()._try();
        tryDestroyConnection.body().invoke("destroyConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryDestroyConnection._catch(this.ref(Exception.class)).param("ie");
        catchTestConnection.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(DefaultResult.class).narrow(this.ref(List.class).narrow(MetaDataKey.class)), (GeneratedExpression)this.ref(ConnectivityTestingErrorHandler.class).staticInvoke("buildFailureTestResult").arg((GeneratedExpression)e)));
        GeneratedBlock finallyTestConnection = tryTestConnection._finally();
        GeneratedConditional ifNotNull = finallyTestConnection._if(connection.isNotNull());
        GeneratedTry tryReleaseConnection = ifNotNull._then()._try();
        tryReleaseConnection.body().invoke("releaseConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryReleaseConnection._catch(this.ref(Exception.class)).param("ie");
    }

    private void generateTestMethodForModuleWithoutStrategies(ManagedConnectionModule module, GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedMethod testMethod = connectionManagerClass.method(1, (Type)this.ref(TestResult.class), "test");
        GeneratedVariable connection = testMethod.body().decl((Type)connectorClass, "connection", ExpressionFactory._null());
        GeneratedVariable result = testMethod.body().decl((Type)this.ref(DefaultTestResult.class), "result");
        GeneratedVariable defaultConnectionKey = testMethod.body().decl((Type)connectionKeyClass, "key", (GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
        GeneratedTry tryTestConnection = testMethod.body()._try();
        tryTestConnection.body().assign((AssignmentTarget)connection, (GeneratedExpression)ExpressionFactory.invoke((String)"acquireConnection").arg((GeneratedExpression)defaultConnectionKey));
        tryTestConnection.body().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("SUCCESS")));
        GeneratedCatchBlock catchTestConnection = tryTestConnection._catch(this.ref(Exception.class));
        GeneratedVariable e = catchTestConnection.param("e");
        GeneratedTry tryDestroyConnection = catchTestConnection.body()._try();
        tryDestroyConnection.body().invoke("destroyConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryDestroyConnection._catch(this.ref(Exception.class)).param("ie");
        catchTestConnection.body().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(DefaultTestResult.class), (GeneratedExpression)this.ref(ConnectivityTestingErrorHandler.class).staticInvoke("buildFailureTestResult").arg((GeneratedExpression)e)));
        GeneratedBlock finallyTestConnection = tryTestConnection._finally();
        GeneratedConditional ifNotNull = finallyTestConnection._if(connection.isNotNull());
        GeneratedTry tryReleaseConnection = ifNotNull._then()._try();
        tryReleaseConnection.body().invoke("releaseConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryReleaseConnection._catch(this.ref(Exception.class)).param("ie");
        testMethod.body()._return((GeneratedExpression)result);
    }

    private void generateDisposeMethod(GeneratedClass connectionManagerClass, GeneratedField connectionPool) {
        GeneratedMethod disposeMethod = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "dispose");
        disposeMethod.annotate(Override.class);
        GeneratedTry tryClose = disposeMethod.body()._try();
        tryClose.body().add((Statement)connectionPool.invoke("close"));
        GeneratedCatchBlock catchBlock = tryClose._catch(this.ref(Exception.class));
        catchBlock.param("e");
    }

    private GeneratedClass getConnectionManagerAdapterClass(ManagedConnectionModule module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".generated.connectivity");
        GeneratedClass connectionKeyClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)module)).topLevelClass();
        GeneratedClass classToExtend = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass connectionManagerClass = pkg._class(module.getClassName() + "ConnectionManager");
        connectionManagerClass._implements(this.ref(Initialisable.class));
        connectionManagerClass._implements(this.ref(Capabilities.class));
        connectionManagerClass._implements(this.ref(MuleContextAware.class));
        connectionManagerClass._implements(this.ref(ConnectionManagementConnectionManager.class).narrow((TypeReference)connectionKeyClass).narrow((TypeReference)classToExtend).narrow(Object.class));
        connectionManagerClass._implements(this.ref(ProcessAdapter.class).narrow((TypeReference)classToExtend));
        connectionManagerClass._implements(this.ref(MetadataAware.class));
        connectionManagerClass._implements(this.ref(Disposable.class));
        connectionManagerClass._extends(ExpressionEvaluatorSupport.class);
        if (module.getMinMuleVersion().atLeastBase("3.4")) {
            connectionManagerClass._implements(this.ref(Testable.class));
        }
        if (module.hasQueryTranslator()) {
            connectionManagerClass._implements(this.ref(NativeQueryMetadataTranslator.class));
        }
        this.ctx().registerProduct(Product.CONNECTION_MANAGER, (Identifiable)module, (Object)connectionManagerClass);
        connectionManagerClass.javadoc().add((Object)("A {@code " + connectionManagerClass.name() + "} is a wrapper around "));
        connectionManagerClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        connectionManagerClass.javadoc().add((Object)" that adds connection management capabilities to the pojo.");
        return connectionManagerClass;
    }

    private GeneratedClass getConnectionManagerAdapterClass(Module module, ConnectionManagementComponent connectionManagementComponent) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".generated.connectivity");
        GeneratedClass connectionKeyClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)connectionManagementComponent, module.getName())).topLevelClass();
        GeneratedClass classToExtend = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass connectionManagerClass = pkg._class(module.getClassName() + NameUtils.camel((String)connectionManagementComponent.configElementName()) + "ConnectionManagement" + "ConnectionManager");
        connectionManagerClass._implements(this.ref(Initialisable.class));
        connectionManagerClass._implements(this.ref(Capabilities.class));
        connectionManagerClass._implements(this.ref(MuleContextAware.class));
        connectionManagerClass._implements(this.ref(ConnectionManagementConnectionManager.class).narrow((TypeReference)connectionKeyClass).narrow((TypeReference)classToExtend).narrow(this.ref(connectionManagementComponent.asType())));
        connectionManagerClass._implements(this.ref(ProcessAdapter.class).narrow((TypeReference)classToExtend));
        connectionManagerClass._implements(this.ref(MetadataAware.class));
        connectionManagerClass._implements(this.ref(Disposable.class));
        connectionManagerClass._extends(ExpressionEvaluatorSupport.class);
        if (module.getMinMuleVersion().atLeastBase("3.4")) {
            connectionManagerClass._implements(this.ref(Testable.class));
        }
        if (module.hasQueryTranslator()) {
            connectionManagerClass._implements(this.ref(NativeQueryMetadataTranslator.class));
        }
        this.ctx().registerProduct(Product.CONNECTION_MANAGER, (Identifiable)connectionManagementComponent, module.getName(), (Object)connectionManagerClass);
        connectionManagerClass.javadoc().add((Object)("A {@code " + connectionManagerClass.name() + "} is a wrapper around "));
        connectionManagerClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        connectionManagerClass.javadoc().add((Object)" that adds connection management capabilities to the pojo.");
        return connectionManagerClass;
    }

    private void generateGetConnectionAdapter(GeneratedClass connectionManagerClass) {
        GeneratedMethod getConnectionAdapter = connectionManagerClass.method(1, ConnectionManagementConnectionAdapter.class, "getConnectionAdapter");
        GeneratedVariable adapter = getConnectionAdapter.param((Type)this.ref(ConnectionManagementConnectorAdapter.class), "adapter");
        getConnectionAdapter.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ConnectionManagementConnectionAdapter.class), (GeneratedExpression)adapter));
    }
}

