/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.apidoc;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.apidoc.ApiDocsModelUtils;
import org.mule.devkit.generation.apidoc.SampleLoader;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.apidoc.ModuleModel;
import org.mule.devkit.model.apidoc.builder.ModuleBuilder;
import org.mule.devkit.model.module.Module;

public class ApiDocModelGenerator
implements ModuleGenerator {
    private final List<Product> consumes = new ArrayList<Product>();
    private final List<Product> produces = Collections.singletonList(Product.APIDOC_MODEL);
    private Context context;

    public Context ctx() {
        return this.context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }

    public List<Product> consumes() {
        return this.consumes;
    }

    public List<Product> produces() {
        return this.produces;
    }

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        SampleLoader sampleLoader;
        try {
            sampleLoader = new SampleLoader(module.getModuleName());
        }
        catch (IOException e) {
            throw new GenerationException("Error while processing the samples file", (Throwable)e);
        }
        ModuleModel model = ModuleBuilder.getInstance().javaName(module.getName()).xsdName(module.getModuleName()).requiresEntitlement(Boolean.valueOf(module.getRequiresEntitlement().isPresent())).requiresEnterpriseLicense(Boolean.valueOf(module.getRequiresEnterpriseLicense().isPresent())).friendlyName(module.getFriendlyName()).description(module.getJavaDocSummary()).minMuleVersion(module.getMinMuleVersion().toCompleteNumericVersion()).addProcessors(ApiDocsModelUtils.getProcessors(module, sampleLoader)).addFilters(ApiDocsModelUtils.getFilters(module, sampleLoader)).addSources(ApiDocsModelUtils.getSources(module, sampleLoader)).addTransformers(ApiDocsModelUtils.getTransformers(module, sampleLoader)).configs(ApiDocsModelUtils.getConnectorConfigs(module)).addJavadocUrl(module.asType().getPackageName(), "javadocs/").addJavadocUrl("java.", "http://docs.oracle.com/javase/7/docs/api/").addJavadocUrls(module.getJavaDocTagContent("javadoc.url")).build();
        try {
            this.generateJsonModelFile(module, model);
        }
        catch (IOException e) {
            throw new GenerationException("Error while writing json connector model file", (Throwable)e);
        }
        this.ctx().registerApidocModel(model, (Identifiable)module);
    }

    private void generateJsonModelFile(Module module, ModuleModel model) throws IOException {
        String fileName = module.getModuleName() + "-model.json";
        Path dirPath = Paths.get(this.ctx().getMavenInformation().getBuildDirectory(), "target", "connector-model");
        if (!dirPath.toFile().exists()) {
            Files.createDirectory(dirPath, new FileAttribute[0]);
        }
        PrintWriter printWriter = new PrintWriter(Paths.get(dirPath.toString(), fileName).toFile());
        printWriter.print(model.toJson());
        printWriter.close();
    }
}

