/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;

public class VerifierUtils {
    private static final Pattern VALID_NAME_REGEX = Pattern.compile("[A-Za-z]+[a-zA-Z0-9\\-_]*");

    public static void verifyGlobalElementName(Identifiable element, String name, NotificationGatherer gatherer) {
        if (StringUtils.isEmpty((String)name)) {
            gatherer.error(element, (DevkitNotification)Message.NAME_ATTRIBUTE_CANNOT_BE_EMPTY, new Object[0]);
        } else {
            if (!VALID_NAME_REGEX.matcher(name).matches()) {
                gatherer.error(element, (DevkitNotification)Message.NAME_ATTRIBUTE_INCORRECT_PATTERN, new Object[]{name});
            }
            if (!name.equals(StringUtils.trim((String)name))) {
                gatherer.error(element, (DevkitNotification)Message.NAME_ATTRIBUTE_MUST_NOT_CONTAIN_WHITESPACE, new Object[]{name});
            }
            if (name.toLowerCase().equals("test")) {
                gatherer.error(element, (DevkitNotification)Message.NAME_ATTRIBUTE_CANNOT_BE_TEST, new Object[0]);
            }
        }
    }

    public static void verifyFieldGetterAndSetter(Field field, NotificationGatherer gatherer) {
        if (!field.hasSetter()) {
            gatherer.error((Identifiable)field, (DevkitNotification)Message.CONFIGURABLE_MISSING_SETTER, new Object[]{field.getName()});
        }
        if (!field.hasGetter()) {
            gatherer.error((Identifiable)field, (DevkitNotification)Message.CONFIGURABLE_MISSING_GETTER, new Object[]{field.getName()});
        }
    }

    public static boolean returnTypeEqualsType(Method method, String name) {
        return StringUtils.equals((String)method.getReturnType().toString(), (String)name);
    }

    public static boolean returnTypeContainsTypeName(Method method, String name) {
        return method != null && StringUtils.contains((String)method.getReturnType().toString(), (String)name);
    }

    public static boolean parametersMatchExpectedTypes(Method<Type> method, String ... parameterTypes) {
        List<String> expectedTypes = Arrays.asList(parameterTypes);
        if (expectedTypes.size() != method.getParameters().size()) {
            return false;
        }
        for (Parameter param : method.getParameters()) {
            if (expectedTypes.contains(param.getJavaType())) continue;
            return false;
        }
        return true;
    }

    public static boolean parametersMatchExpectedTypes(Method method, Class ... parameterTypes) {
        LinkedList<String> expectedTypes = new LinkedList<String>();
        for (Class parameterType : parameterTypes) {
            expectedTypes.add(parameterType.getCanonicalName());
        }
        return VerifierUtils.parametersMatchExpectedTypes((Method<Type>)method, expectedTypes.toArray(new String[expectedTypes.size()]));
    }

    public static void verifyEqualParameters(Method expectedMethod, Method actualMethod, NotificationGatherer gatherer) {
        if (expectedMethod.getParameters().size() != actualMethod.getParameters().size()) {
            gatherer.error((Identifiable)actualMethod, (DevkitNotification)Message.TEST_CONNECTIVITY_INVALID_PARAMS, new Object[]{actualMethod.getParameters().size(), expectedMethod.getParameters().size()});
        } else {
            Iterator expectedIt = expectedMethod.getParameters().iterator();
            Iterator actualIt = actualMethod.getParameters().iterator();
            while (expectedIt.hasNext()) {
                Parameter expected = (Parameter)expectedIt.next();
                Parameter actual = (Parameter)actualIt.next();
                if (StringUtils.equals((String)expected.getJavaType(), (String)actual.getJavaType())) continue;
                gatherer.error((Identifiable)actual, (DevkitNotification)Message.TEST_CONNECTIVITY_INVALID_PARAMS, new Object[]{actual.getJavaType(), expected.getJavaType()});
            }
        }
    }

    public static void verifyBooleanConfigurable(NotificationGatherer gatherer, Field field) {
        if (field.asType().isBoolean() && !field.hasDefaultValue()) {
            gatherer.error((Identifiable)field, (DevkitNotification)Message.BOOLEAN_CONFIGURABLE_MUST_HAVE_DEFAULT_AVALUE, new Object[0]);
        }
    }
}

