/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.strategies;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.ValidateConnection;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.verifiers.util.VerifierUtils;

public abstract class ConnectionStrategiesVerifierUtils {
    public static void verifyNoConnectMethods(NotificationGatherer gatherer, ConnectionComponent component) {
        for (Method typeMethod : component.asType().getMethods()) {
            if (!ConnectionStrategiesVerifierUtils.hasAnyConnectManagementAnnotation((Method<Type>)typeMethod) || component instanceof ManagedConnectionModule) continue;
            gatherer.error((Identifiable)typeMethod, (DevkitNotification)Message.CONNECT_METHODS_ONLY_IN_CONNECTION_MANAGEMENT, new Object[0]);
        }
    }

    public static void verifyComponentConfigurableFields(Module module, NotificationGatherer gatherer, ConnectionComponent component) {
        HashSet<String> configurableNames = new HashSet<String>();
        for (Field field : module.getConfigurableFields()) {
            configurableNames.add(field.getName());
        }
        for (Field field : component.getConfigurableFields()) {
            if (configurableNames.contains(field.getName())) {
                gatherer.error((Identifiable)field, (DevkitNotification)Message.CONFIGURABLE_FIELDS_CRASHES, new Object[]{field.getName(), component.getName(), module.getName()});
            }
            VerifierUtils.verifyBooleanConfigurable(gatherer, field);
        }
    }

    public static boolean hasAnyConnectManagementAnnotation(Method<Type> typeMethod) {
        return typeMethod.hasAnnotation(Connect.class) || typeMethod.hasAnnotation(Disconnect.class) || typeMethod.hasAnnotation(ConnectionIdentifier.class) || typeMethod.hasAnnotation(ValidateConnection.class);
    }

    public static void verifyComponentConfigurableGetterAndSetter(NotificationGatherer gatherer, ConnectionComponent component) {
        for (Field field : component.getConfigurableFields()) {
            VerifierUtils.verifyFieldGetterAndSetter(field, gatherer);
        }
    }

    private static void verifyTestConnectionMethod(ConnectionComponent connectionComponent, List<Method<Type>> methodsAnnotatedWithTestConnectivity, boolean shouldCheckZeroParameters, NotificationGatherer gatherer) {
        if (connectionComponent.testConnectivityMethod().isPresent()) {
            Method testConnectivityMethod = (Method)connectionComponent.testConnectivityMethod().get();
            if (!testConnectivityMethod.isPublic()) {
                gatherer.error((Identifiable)testConnectivityMethod, (DevkitNotification)Message.TEST_CONNECTIVITY_MUST_BE_PUBLIC, new Object[0]);
            }
            if (testConnectivityMethod.getThrownTypes().isEmpty()) {
                gatherer.error((Identifiable)testConnectivityMethod, (DevkitNotification)Message.TEST_CONNECTIVITY_MUST_THROW_CONNECTION_EXCEPTION, new Object[0]);
            }
            if (!testConnectivityMethod.getThrownTypes().isEmpty() && !testConnectivityMethod.getThrownTypes().get(0).toString().equals("org.mule.api.ConnectionException")) {
                gatherer.error((Identifiable)testConnectivityMethod, (DevkitNotification)Message.TEST_CONNECTIVITY_MUST_THROW_CONNECTION_EXCEPTION, new Object[0]);
            }
            if (!VerifierUtils.returnTypeEqualsType(testConnectivityMethod, "void")) {
                gatherer.error((Identifiable)testConnectivityMethod, (DevkitNotification)Message.TEST_CONNECTIVITY_NO_RETURN, new Object[0]);
            }
            if (shouldCheckZeroParameters && !testConnectivityMethod.getParameters().isEmpty()) {
                gatherer.error((Identifiable)testConnectivityMethod, (DevkitNotification)Message.TEST_CONNECTIVITY_ZERO_PARAM, new Object[0]);
            }
        }
        if (methodsAnnotatedWithTestConnectivity.size() > 1) {
            gatherer.errorAll(methodsAnnotatedWithTestConnectivity, (DevkitNotification)Message.TEST_CONNECTIVITY_ONE_METHOD_ONLY, new Object[0]);
        }
    }

    public static void verifyTestConnectionMethod(ConnectionComponent connectionComponent, List<Method<Type>> methodsAnnotatedWithTestConnectivity, NotificationGatherer gatherer) {
        ConnectionStrategiesVerifierUtils.verifyTestConnectionMethod(connectionComponent, methodsAnnotatedWithTestConnectivity, true, gatherer);
    }

    public static void verifyConfigurableNamesDistinctConnectParamNames(List<Field> configurableElements, NotificationGatherer gatherer, Set<String> connectionParameterNames) {
        for (Field field : configurableElements) {
            if (!connectionParameterNames.contains(field.getName())) continue;
            gatherer.error((Identifiable)field, (DevkitNotification)Message.CONFIGURABLE_FORBIDDEN_NAME, new Object[0]);
        }
    }

    public static void verifyConnectorProcessorsParams(Module module, NotificationGatherer gatherer, Set<String> connectionParameterNames) {
        for (ProcessorMethod processor : module.getProcessorMethods()) {
            for (Parameter param : processor.getParameters()) {
                if (!connectionParameterNames.contains(param.getName())) continue;
                gatherer.error((Identifiable)param, (DevkitNotification)Message.PROCESSOR_PARAM_NAME_SAME_AS_CON_MANAGEMENT_CONNECT_PARAM, new Object[0]);
            }
        }
    }
}

