/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.ws;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Disposable;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.devkit.api.ws.authentication.WsdlSecurityStrategy;
import org.mule.devkit.api.ws.definition.ServiceDefinition;
import org.mule.devkit.api.ws.transport.WsdlTransport;
import org.mule.devkit.generation.AbstractCapabilityGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.connectivity.metadata.ConnectorMetaDataEnabledUtilsGenerator;
import org.mule.devkit.internal.ws.common.WSResolver;
import org.mule.devkit.internal.ws.common.WsdlAdapter;
import org.mule.devkit.internal.ws.metadata.WsdlMetaDataDescriptor;
import org.mule.devkit.internal.ws.model.DefaultWSResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.WsdlProviderComponent;
import org.mule.devkit.utils.NameUtils;
import org.w3c.dom.Document;

public class WsdlProviderConnectorAdapterGenerator
extends AbstractCapabilityGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.PROCESS_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.WSDL_PROVIDER_CONNECTOR_ADAPTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return !module.manager().wsdlProviderComponent().isEmpty();
    }

    public void generate(Module module) {
        for (WsdlProviderComponent wsdlProviderComponent : module.manager().wsdlProviderComponent()) {
            this.generateWsdlAdapterFor(module, wsdlProviderComponent);
        }
    }

    private void generateWsdlAdapterFor(Module module, WsdlProviderComponent wsdlProviderComponent) {
        ConnectorMetaDataEnabledUtilsGenerator connectorMetaDataEnabledUtilsGenerator = new ConnectorMetaDataEnabledUtilsGenerator();
        connectorMetaDataEnabledUtilsGenerator.setCtx(this.ctx());
        GeneratedClass wsdlProviderAdapterClass = this.createBasicAdapter(module, wsdlProviderComponent);
        this.generateClassJavaDoc(module, wsdlProviderComponent, wsdlProviderAdapterClass);
        GeneratedCast castedWsdlStrategy = this.getCastedWsdlStrategy(module, wsdlProviderComponent);
        this.generateWsdlAdapterMethods(module, wsdlProviderAdapterClass, wsdlProviderComponent, castedWsdlStrategy);
        connectorMetaDataEnabledUtilsGenerator.generateGenericTestConnectivity(module, (ConnectionComponent)wsdlProviderComponent, wsdlProviderAdapterClass);
        this.generateMetadataMethods(module, wsdlProviderAdapterClass);
        this.generateSetMuleContext(wsdlProviderComponent, wsdlProviderAdapterClass, castedWsdlStrategy);
        this.generateStartable(wsdlProviderComponent, wsdlProviderAdapterClass, castedWsdlStrategy);
        this.generateStoppable(wsdlProviderComponent, wsdlProviderAdapterClass, castedWsdlStrategy);
    }

    private GeneratedCast getCastedWsdlStrategy(Module module, WsdlProviderComponent wsdlProviderComponent) {
        GeneratedInvocation getStrategyMethod = ExpressionFactory.invoke((String)NameUtils.buildGetter((String)((Field)module.getConfigStrategy().get()).getName()));
        Type wsdlProviderStrategyClassType = this.ref(wsdlProviderComponent.asTypeMirror());
        return ExpressionFactory.cast((Type)wsdlProviderStrategyClassType, (GeneratedExpression)getStrategyMethod);
    }

    private void generateStartable(WsdlProviderComponent wsdlProviderComponent, GeneratedClass wsdlProviderAdapterClass, GeneratedCast castedWsdlStrategy) {
        Optional startable = wsdlProviderComponent.startable();
        if (startable.isPresent()) {
            GeneratedMethod startMethod = wsdlProviderAdapterClass.method(1, (Type)this.ctx().getCodeModel().VOID, "start");
            startMethod.annotate(Override.class);
            startMethod._throws(this.ref(MuleException.class));
            startMethod.body().add((Statement)castedWsdlStrategy.invoke(((Method)startable.get()).getName()));
            startMethod.body().add((Statement)ExpressionFactory._super().invoke("start"));
        }
    }

    private void generateStoppable(WsdlProviderComponent wsdlProviderComponent, GeneratedClass wsdlProviderAdapterClass, GeneratedCast castedWsdlStrategy) {
        Optional stoppable = wsdlProviderComponent.stoppable();
        if (stoppable.isPresent()) {
            GeneratedMethod stopMethod = wsdlProviderAdapterClass.method(1, (Type)this.ctx().getCodeModel().VOID, "stop");
            stopMethod.annotate(Override.class);
            stopMethod._throws(this.ref(MuleException.class));
            stopMethod.body().add((Statement)castedWsdlStrategy.invoke(((Method)stoppable.get()).getName()));
            stopMethod.body().add((Statement)ExpressionFactory._super().invoke("stop"));
        }
    }

    private void generateSetMuleContext(WsdlProviderComponent wsdlProviderComponent, GeneratedClass wsdlProviderAdapterClass, GeneratedCast castedWsdlStrategy) {
        Optional muleContext = wsdlProviderComponent.setMuleContext();
        if (muleContext.isPresent()) {
            GeneratedMethod setMuleContextMethod = wsdlProviderAdapterClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setMuleContext");
            setMuleContextMethod.annotate(Override.class);
            GeneratedVariable muleContextParam = setMuleContextMethod.param((Type)this.ref(MuleContext.class), "muleContext");
            setMuleContextMethod.body().add((Statement)castedWsdlStrategy.invoke(((Field)muleContext.get()).getSetter().getName()).arg((GeneratedExpression)muleContextParam));
            setMuleContextMethod.body().add((Statement)ExpressionFactory._super().invoke("setMuleContext").arg((GeneratedExpression)muleContextParam));
        }
    }

    private void generateClassJavaDoc(Module module, WsdlProviderComponent wsdlProviderComponent, GeneratedClass wsdlProviderAdapterClass) {
        wsdlProviderAdapterClass.javadoc().add((Object)("A <code>" + wsdlProviderAdapterClass.name() + "</code> is a wrapper around "));
        wsdlProviderAdapterClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        wsdlProviderAdapterClass.javadoc().add((Object)" that represents the WSDL generic connector ");
        wsdlProviderAdapterClass.javadoc().add((Object)this.ref(wsdlProviderComponent.asTypeMirror()));
    }

    private void generateWsdlAdapterMethods(Module module, GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent, GeneratedCast wsdlProviderCastStrategy) {
        wsdlProviderAdapterClass._implements(WsdlAdapter.class);
        GeneratedField wsResolverField = wsdlProviderAdapterClass.field(4, (Type)this.ref(WSResolver.class), "wsResolver");
        this.generateDisposeMethod(wsdlProviderAdapterClass, wsResolverField);
        this.generateServiceDefinitionsMethod(wsdlProviderAdapterClass, wsdlProviderComponent, wsdlProviderCastStrategy);
        this.generateServiceEndpointMethod(wsdlProviderAdapterClass, wsdlProviderComponent, wsdlProviderCastStrategy);
        this.generateWsdlSeparatorMethod(wsdlProviderAdapterClass, wsdlProviderComponent);
        this.generateStrategiesMethod(wsdlProviderAdapterClass, wsdlProviderComponent, wsdlProviderCastStrategy);
        this.generateTransportMethod(wsdlProviderAdapterClass, wsdlProviderComponent, wsdlProviderCastStrategy);
        this.generateHeadersMethod(wsdlProviderAdapterClass, wsdlProviderComponent, wsdlProviderCastStrategy);
        this.generateInitialiseWsResolverMethod(wsdlProviderAdapterClass, wsResolverField);
        this.generateWsResolverMethod(wsdlProviderAdapterClass, wsResolverField);
        this.generateSingleServiceDefinitionId(wsdlProviderAdapterClass, wsdlProviderComponent);
    }

    private void generateSingleServiceDefinitionId(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent) {
        GeneratedMethod wsResolverMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(Optional.class).narrow(String.class), "singleServiceDefinitionId");
        wsResolverMethod.annotate(Override.class);
        wsResolverMethod._throws(Exception.class);
        GeneratedInvocation generatedExpression = wsdlProviderComponent.hasMultipleServiceDefinition() ? this.ref(Optional.class).staticInvoke("absent") : this.ref(Optional.class).staticInvoke("of").arg((GeneratedExpression)ExpressionFactory._this().invoke("wsResolver").invoke("serviceDefinitions").invoke("values").invoke("asList").invoke("get").arg(ExpressionFactory.lit((int)0)).invoke("getId"));
        wsResolverMethod.body()._return((GeneratedExpression)generatedExpression);
    }

    private void generateInitialiseWsResolverMethod(GeneratedClass wsdlProviderAdapterClass, GeneratedField wsResolverField) {
        GeneratedMethod initializeWsResolverMethod = wsdlProviderAdapterClass.method(132, Void.TYPE, "initializeWsResolver");
        initializeWsResolverMethod._throws(Exception.class);
        initializeWsResolverMethod.body()._if(Op.eq((GeneratedExpression)wsResolverField, (GeneratedExpression)ExpressionFactory._null()))._then().assign((AssignmentTarget)wsResolverField, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultWSResolver.class)).arg(ExpressionFactory._this()));
    }

    private void generateWsResolverMethod(GeneratedClass wsdlProviderAdapterClass, GeneratedField wsResolverField) {
        GeneratedMethod wsResolverMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(WSResolver.class), "wsResolver");
        wsResolverMethod.annotate(Override.class);
        wsResolverMethod._throws(Exception.class);
        wsResolverMethod.body().invoke("initializeWsResolver");
        wsResolverMethod.body()._return((GeneratedExpression)wsResolverField);
    }

    private void generateTransportMethod(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent, GeneratedCast wsdlProviderCastStrategy) {
        GeneratedMethod transportMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(WsdlTransport.class), "transport");
        transportMethod.annotate(Override.class);
        GeneratedVariable serviceDefinitionParam = transportMethod.param(ServiceDefinition.class, "serviceDefinition");
        Optional transportOptional = wsdlProviderComponent.wsdlTransportResolver();
        Object transportMethodInvocation = transportOptional.isPresent() ? wsdlProviderCastStrategy.invoke(((Method)transportOptional.get()).getName()).arg((GeneratedExpression)serviceDefinitionParam) : ExpressionFactory._null();
        transportMethod.body()._return(transportMethodInvocation);
    }

    private void generateHeadersMethod(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent, GeneratedCast wsdlProviderCastStrategy) {
        GeneratedMethod headerMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(Optional.class).narrow(this.ref(List.class).narrow(Document.class)), "headers");
        headerMethod.annotate(Override.class);
        headerMethod._throws(Exception.class);
        GeneratedVariable serviceDefinitionParam = headerMethod.param(ServiceDefinition.class, "serviceDefinition");
        GeneratedVariable operationName = headerMethod.param(String.class, "operationName");
        Optional headersMethodOptional = wsdlProviderComponent.wsdlHeadersResolver();
        Object headerMethodInvocation = headersMethodOptional.isPresent() ? wsdlProviderCastStrategy.invoke(((Method)headersMethodOptional.get()).getName()).arg((GeneratedExpression)serviceDefinitionParam).arg((GeneratedExpression)operationName) : ExpressionFactory._null();
        headerMethod.body()._return((GeneratedExpression)this.ref(Optional.class).staticInvoke("fromNullable").arg(headerMethodInvocation));
    }

    private void generateStrategiesMethod(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent, GeneratedCast wsdlProviderCastStrategy) {
        GeneratedMethod getStrategiesMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(List.class).narrow(WsdlSecurityStrategy.class), "security");
        getStrategiesMethod.annotate(Override.class);
        getStrategiesMethod._throws(Exception.class);
        GeneratedVariable serviceDefinitionParam = getStrategiesMethod.param(ServiceDefinition.class, "serviceDefinition");
        GeneratedInvocation getStrategiesInvocation = wsdlProviderComponent.wsdlSecurityResolver().isPresent() ? wsdlProviderCastStrategy.invoke(((Method)wsdlProviderComponent.wsdlSecurityResolver().get()).getName()).arg((GeneratedExpression)serviceDefinitionParam) : this.ref(Collections.class).staticInvoke("emptyList");
        getStrategiesMethod.body()._return((GeneratedExpression)getStrategiesInvocation);
    }

    private void generateWsdlSeparatorMethod(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent) {
        GeneratedMethod tokenSeparatorMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(String.class), "wsdlSeparator");
        tokenSeparatorMethod.annotate(Override.class);
        GeneratedExpression tokenSeparatorInvocation = ExpressionFactory.lit((String)wsdlProviderComponent.keySeparator());
        tokenSeparatorMethod.body()._return(tokenSeparatorInvocation);
    }

    private void generateServiceEndpointMethod(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent, GeneratedCast wsdlProviderCastStrategy) {
        GeneratedMethod endpointMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(String.class), "endpoint");
        endpointMethod.annotate(Override.class);
        endpointMethod._throws(Exception.class);
        GeneratedVariable serviceDefinitionParam = endpointMethod.param(ServiceDefinition.class, "serviceDefinition");
        endpointMethod.body()._return((GeneratedExpression)wsdlProviderCastStrategy.invoke(wsdlProviderComponent.wsdlServiceEndpointMethod().getName()).arg((GeneratedExpression)serviceDefinitionParam));
    }

    private void generateServiceDefinitionsMethod(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent, GeneratedCast wsdlProviderCastStrategy) {
        GeneratedMethod serviceDefinitionsMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(List.class).narrow(ServiceDefinition.class), "serviceDefinitions");
        serviceDefinitionsMethod.annotate(Override.class);
        serviceDefinitionsMethod._throws(Exception.class);
        if (wsdlProviderComponent.hasMultipleServiceDefinition()) {
            serviceDefinitionsMethod.body()._return((GeneratedExpression)wsdlProviderCastStrategy.invoke(wsdlProviderComponent.wsdlServiceRetrieverMethod().getName()));
        } else {
            GeneratedInvocation servicesRetrieve = wsdlProviderCastStrategy.invoke(wsdlProviderComponent.wsdlServiceRetrieverMethod().getName());
            serviceDefinitionsMethod.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(ServiceDefinition.class)).arg((GeneratedExpression)this.ref(Arrays.class).staticInvoke("asList").arg((GeneratedExpression)servicesRetrieve)));
        }
    }

    private void generateDisposeMethod(GeneratedClass wsdlProviderAdapterClass, GeneratedField wsResolverField) {
        wsdlProviderAdapterClass._implements(Disposable.class);
        GeneratedMethod wsdlProviderDisposable = wsdlProviderAdapterClass.method(1, Void.TYPE, "dispose");
        wsdlProviderDisposable.annotate(Override.class);
        wsdlProviderDisposable.body()._if(Op.eq((GeneratedExpression)wsResolverField, (GeneratedExpression)ExpressionFactory._null()))._then()._return();
        wsdlProviderDisposable.body().add((Statement)wsResolverField.invoke("dispose"));
        wsdlProviderDisposable.body().assign((AssignmentTarget)wsResolverField, ExpressionFactory._null());
    }

    protected void generateMetadataMethods(Module module, GeneratedClass generatedClass) {
        generatedClass._implements(this.ref(ConnectorMetaDataEnabled.class));
        this.generateMetaDataKeysMethod(module, generatedClass);
        this.generateMetaDataMethod(module, generatedClass);
    }

    private void generateMetaDataKeysMethod(Module module, GeneratedClass generatedClass) {
        GeneratedMethod getMetadataKeys = generatedClass.method(1, (Type)this.ref(String.class), "getMetaDataKeys");
        getMetadataKeys.annotate(Override.class);
        getMetadataKeys.type((Type)this.ref(Result.class).narrow(this.ref(List.class).narrow(this.ref(MetaDataKey.class))));
        GeneratedVariable wsdlMetaDataResolver = getMetadataKeys.body().decl((Type)this.ref(WsdlMetaDataDescriptor.class), "wsdlMetaDataResolver", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(WsdlMetaDataDescriptor.class)));
        getMetadataKeys.body()._return((GeneratedExpression)wsdlMetaDataResolver.invoke("getMetaDataKeys").arg(ExpressionFactory._this()));
    }

    private void generateMetaDataMethod(Module module, GeneratedClass generatedClass) {
        GeneratedMethod getMetadata = generatedClass.method(1, (Type)this.ref(Result.class).narrow(this.ref(MetaData.class)), "getMetaData");
        getMetadata.annotate(Override.class);
        GeneratedVariable key = getMetadata.param((Type)this.ref(MetaDataKey.class), "metaDataKey");
        GeneratedVariable wsdlMetaDataResolver = getMetadata.body().decl((Type)this.ref(WsdlMetaDataDescriptor.class), "wsdlMetaDataResolver", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(WsdlMetaDataDescriptor.class)));
        getMetadata.body()._return((GeneratedExpression)wsdlMetaDataResolver.invoke("getMetaData").arg((GeneratedExpression)key).arg(ExpressionFactory._this()));
    }

    private GeneratedClass createBasicAdapter(Module module, WsdlProviderComponent wsdlProviderComponent) {
        GeneratedClass previous = (GeneratedClass)this.ctx().getProduct(Product.PROCESS_ADAPTER, (Identifiable)module);
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".adapters");
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass clazz = pkg._class(modifiers, module.getClassName() + wsdlProviderComponent.getClassName() + "WsdlProviderAdapter", (TypeReference)previous);
        this.ctx().registerProduct(Product.WSDL_PROVIDER_CONNECTOR_ADAPTER, (Identifiable)wsdlProviderComponent, module.getName(), (Object)clazz);
        return clazz;
    }
}

