/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.schema;

import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.mule.api.annotations.Filter;
import org.mule.api.annotations.Paged;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.spring.global.factory.AbstractGlobalElementResolver;
import org.mule.devkit.generation.spring.schema.AbstractSchemaBuilder;
import org.mule.devkit.generation.spring.schema.RegisteredElements;
import org.mule.devkit.generation.spring.schema.StrategySchemaResolver;
import org.mule.devkit.generation.spring.schema.global.ConfigurationSchemaResolver;
import org.mule.devkit.generation.spring.schema.global.ConnectionManagerSchemaResolver;
import org.mule.devkit.generation.spring.schema.global.HttpBasicAuthSchemaResolver;
import org.mule.devkit.generation.spring.schema.global.OAuthSchemaResolver;
import org.mule.devkit.generation.spring.schema.global.WsdlProviderSchemaResolver;
import org.mule.devkit.generation.spring.schema.global.util.ModuleSchemaResolver;
import org.mule.devkit.generation.utils.global.element.GlobalElementFactory;
import org.mule.devkit.model.EnumType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.FilterMethod;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.schema.Attribute;
import org.mule.devkit.model.schema.ComplexContent;
import org.mule.devkit.model.schema.ExplicitGroup;
import org.mule.devkit.model.schema.ExtensionType;
import org.mule.devkit.model.schema.GroupRef;
import org.mule.devkit.model.schema.Import;
import org.mule.devkit.model.schema.LocalSimpleType;
import org.mule.devkit.model.schema.NoFixedFacet;
import org.mule.devkit.model.schema.Restriction;
import org.mule.devkit.model.schema.Schema;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.devkit.model.schema.TopLevelComplexType;
import org.mule.devkit.model.schema.TopLevelElement;
import org.mule.devkit.model.schema.TopLevelSimpleType;
import org.mule.devkit.model.schema.Union;
import org.mule.devkit.utils.NameUtils;
import org.mule.security.oauth.OnNoTokenPolicy;
import org.mule.util.StringUtils;

public class SchemaBuilder
extends AbstractSchemaBuilder {
    private RegisteredElements registeredElements;

    @Override
    protected RegisteredElements getRegisteredElements() {
        return this.registeredElements;
    }

    private SchemaBuilder(String targetNamespace) {
        this.registeredElements = new RegisteredElements(targetNamespace);
    }

    public static SchemaBuilder newSchema(String targetNamespace) {
        return new SchemaBuilder(targetNamespace);
    }

    public SchemaBuilder importXmlNamespace() {
        Import xmlImport = new Import();
        xmlImport.setNamespace("http://www.w3.org/XML/1998/namespace");
        this.getSchema().getIncludeOrImportOrRedefine().add(xmlImport);
        return this;
    }

    public SchemaBuilder importSpringFrameworkNamespace() {
        Import springFrameworkImport = new Import();
        springFrameworkImport.setNamespace("http://www.springframework.org/schema/beans");
        springFrameworkImport.setSchemaLocation("http://www.springframework.org/schema/beans/spring-beans-3.0.xsd");
        this.getSchema().getIncludeOrImportOrRedefine().add(springFrameworkImport);
        return this;
    }

    public SchemaBuilder importMuleNamespace() {
        Import muleSchemaImport = new Import();
        muleSchemaImport.setNamespace("http://www.mulesoft.org/schema/mule/core");
        muleSchemaImport.setSchemaLocation("http://www.mulesoft.org/schema/mule/core/current/mule.xsd");
        this.getSchema().getIncludeOrImportOrRedefine().add(muleSchemaImport);
        return this;
    }

    public Schema registerSimpleTypes() {
        this.registerType(this.getSchema(), "integerType", SchemaConstants.INTEGER);
        this.registerType(this.getSchema(), "decimalType", SchemaConstants.DECIMAL);
        this.registerType(this.getSchema(), "floatType", SchemaConstants.FLOAT);
        this.registerType(this.getSchema(), "doubleType", SchemaConstants.DOUBLE);
        this.registerType(this.getSchema(), "dateTimeType", SchemaConstants.DATETIME);
        this.registerType(this.getSchema(), "longType", SchemaConstants.LONG);
        this.registerType(this.getSchema(), "byteType", SchemaConstants.BYTE);
        this.registerType(this.getSchema(), "booleanType", SchemaConstants.BOOLEAN);
        this.registerType(this.getSchema(), "anyUriType", SchemaConstants.ANYURI);
        this.registerType(this.getSchema(), "charType", SchemaConstants.STRING, 1, 1);
        return this.getSchema();
    }

    public SchemaBuilder registerConfigOrStrategyElement(Module module, Context ctx) {
        for (StrategySchemaResolver strategySchemaResolver : this.getStrategiesSchemaResolver(module)) {
            strategySchemaResolver.buildGlobalElementElement(module, ctx);
        }
        return this;
    }

    private List<StrategySchemaResolver> getStrategiesSchemaResolver(Module module) {
        return GlobalElementFactory.getGlobalElementBeanDefinitionGenerator(module, new AbstractGlobalElementResolver<StrategySchemaResolver>(){

            @Override
            public StrategySchemaResolver genericGlobalElement() {
                return new ModuleSchemaResolver(SchemaBuilder.this.getRegisteredElements());
            }

            @Override
            public List<? extends StrategySchemaResolver> connectionManagementGlobalElement() {
                return Arrays.asList(new ConnectionManagerSchemaResolver(SchemaBuilder.this.getRegisteredElements()));
            }

            @Override
            public StrategySchemaResolver oauthGlobalElement() {
                return new OAuthSchemaResolver(SchemaBuilder.this.getRegisteredElements());
            }

            @Override
            public StrategySchemaResolver httpBasicAuthGlobalElement() {
                return new HttpBasicAuthSchemaResolver(SchemaBuilder.this.getRegisteredElements());
            }

            @Override
            public List<? extends StrategySchemaResolver> basicGlobalElement() {
                return Arrays.asList(new ConfigurationSchemaResolver(SchemaBuilder.this.getRegisteredElements()));
            }

            @Override
            public List<WsdlProviderSchemaResolver> wsdlProviderGlobalElement() {
                return Arrays.asList(new WsdlProviderSchemaResolver(SchemaBuilder.this.getRegisteredElements()));
            }
        });
    }

    public SchemaBuilder registerProcessorsAndSourcesAndFilters(Module module) {
        String typeName;
        String name;
        for (StrategySchemaResolver strategySchemaResolver : this.getStrategiesSchemaResolver(module)) {
            strategySchemaResolver.registerProcessorsAndSourcesAndFilters(module);
        }
        for (FilterMethod method : module.getFilterMethods()) {
            name = method.getName();
            Filter filter = (Filter)method.getAnnotation(Filter.class);
            if (filter.name().length() > 0) {
                name = filter.name();
            }
            if (this.getRegisteredMethods().contains(name)) continue;
            this.getRegisteredMethods().add(name);
            typeName = StringUtils.capitalize((String)name) + "Type";
            this.registerFilterElement(name, typeName, method.getJavaDocSummary());
            this.registerExtendedType(SchemaConstants.MULE_ABSTRACT_FILTER_TYPE, typeName, (Method<? extends Type>)method);
        }
        for (FilterMethod method : module.getProcessorMethods()) {
            name = method.getName();
            Processor processor = (Processor)method.getAnnotation(Processor.class);
            if (processor.name().length() > 0) {
                name = processor.name();
            }
            if (this.getRegisteredMethods().contains(name)) continue;
            this.getRegisteredMethods().add(name);
            typeName = StringUtils.capitalize((String)name) + "Type";
            this.registerProcessorElement(method.isIntercepting(), name, typeName, method.getJavaDocSummary());
            this.registerProcessorType(method.isIntercepting(), typeName, (Method)method);
        }
        for (FilterMethod method : module.getSourceMethods()) {
            name = method.getName();
            Source source = (Source)method.getAnnotation(Source.class);
            if (source.name().length() > 0) {
                name = source.name();
            }
            if (this.getRegisteredMethods().contains(name)) continue;
            this.getRegisteredMethods().add(name);
            typeName = StringUtils.capitalize((String)name) + "Type";
            this.registerSourceElement(name, typeName, (Method)method);
            this.registerExtendedType(SchemaConstants.MULE_ABSTRACT_INBOUND_ENDPOINT_TYPE, typeName, (Method<? extends Type>)method);
        }
        return this;
    }

    private LocalSimpleType createOnNoTokenPolicyType() {
        LocalSimpleType enumValues = new LocalSimpleType();
        Restriction restriction = new Restriction();
        enumValues.setRestriction(restriction);
        restriction.setBase(SchemaConstants.STRING);
        NoFixedFacet exceptionPolicy = this.getObjectFactory().createNoFixedFacet();
        exceptionPolicy.setValue(OnNoTokenPolicy.EXCEPTION.toString());
        JAXBElement exceptionEnum = this.getObjectFactory().createEnumeration(exceptionPolicy);
        NoFixedFacet noStopPolicy = this.getObjectFactory().createNoFixedFacet();
        noStopPolicy.setValue(OnNoTokenPolicy.STOP_FLOW.toString());
        JAXBElement noStopEnum = this.getObjectFactory().createEnumeration(noStopPolicy);
        enumValues.getRestriction().getFacets().add(exceptionEnum);
        enumValues.getRestriction().getFacets().add(noStopEnum);
        return enumValues;
    }

    public SchemaBuilder registerTransformers(Module module) {
        for (Method method : module.getTransformerMethods()) {
            TopLevelElement transformerElement = new TopLevelElement();
            transformerElement.setName(NameUtils.uncamel((String)method.getName()));
            transformerElement.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_TRANSFORMER);
            transformerElement.setType(SchemaConstants.MULE_ABSTRACT_TRANSFORMER_TYPE);
            this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(transformerElement);
        }
        return this;
    }

    public SchemaBuilder registerEnums() {
        for (EnumType enumToBeRegistered : this.getRegisteredEnums()) {
            this.registerEnum(this.getSchema(), enumToBeRegistered);
        }
        this.registerOnNoTokenPolicyType();
        return this;
    }

    private void registerOnNoTokenPolicyType() {
        TopLevelSimpleType enumSimpleType = new TopLevelSimpleType();
        enumSimpleType.setName("OnNoTokenPolicyEnumType");
        Union union = new Union();
        union.getSimpleType().add(this.createOnNoTokenPolicyType());
        union.getSimpleType().add(this.createExpressionAndPropertyPlaceHolderSimpleType());
        enumSimpleType.setUnion(union);
        this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(enumSimpleType);
    }

    private void registerEnum(Schema schema, EnumType enumType) {
        TopLevelSimpleType enumSimpleType = new TopLevelSimpleType();
        enumSimpleType.setName(enumType.getName() + "EnumType");
        enumSimpleType.setAnnotation(this.createDocAnnotation(enumType.getJavaDocSummary()));
        Union union = new Union();
        union.getSimpleType().add(this.createEnumSimpleType(enumType));
        union.getSimpleType().add(this.createExpressionAndPropertyPlaceHolderSimpleType());
        enumSimpleType.setUnion(union);
        this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(enumSimpleType);
    }

    private LocalSimpleType createEnumSimpleType(EnumType enumType) {
        LocalSimpleType enumValues = new LocalSimpleType();
        Restriction restriction = new Restriction();
        enumValues.setRestriction(restriction);
        restriction.setBase(SchemaConstants.STRING);
        for (Identifiable identifiable : enumType.getEnumConstants()) {
            NoFixedFacet noFixedFacet = this.getObjectFactory().createNoFixedFacet();
            noFixedFacet.setValue(identifiable.getName());
            noFixedFacet.setAnnotation(this.createDocAnnotation(identifiable.getJavaDocSummary()));
            JAXBElement enumeration = this.getObjectFactory().createEnumeration(noFixedFacet);
            enumValues.getRestriction().getFacets().add(enumeration);
        }
        return enumValues;
    }

    private void registerFilterElement(String name, String typeName, String docText) {
        TopLevelElement element = new TopLevelElement();
        element.setName(NameUtils.uncamel((String)name));
        element.setType(new QName(this.getSchema().getTargetNamespace(), typeName));
        element.setAnnotation(this.createDocAnnotation(docText));
        element.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_FILTER);
        this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(element);
    }

    private void registerSourceElement(String name, String typeName, Method executableElement) {
        TopLevelElement element = new TopLevelElement();
        element.setName(NameUtils.uncamel((String)name));
        element.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_INBOUND_ENDPOINT);
        element.setType(new QName(this.getSchema().getTargetNamespace(), typeName));
        element.setAnnotation(this.createDocAnnotation(executableElement.getJavaDocSummary()));
        this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(element);
    }

    private void registerProcessorType(boolean intercepting, String name, Method element) {
        if (intercepting) {
            this.registerExtendedType(SchemaConstants.MULE_ABSTRACT_INTERCEPTING_MESSAGE_PROCESSOR_TYPE, name, (Method<? extends Type>)element);
        } else {
            this.registerExtendedType(SchemaConstants.MULE_ABSTRACT_MESSAGE_PROCESSOR_TYPE, name, (Method<? extends Type>)element);
        }
    }

    private void registerExtendedType(QName base, String name, Method<? extends Type> element) {
        TopLevelComplexType complexType = new TopLevelComplexType();
        complexType.setName(name);
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(base);
        complexContent.setExtension(complexContentExtension);
        Attribute configRefAttr = this.createAttribute("config-ref", false, SchemaConstants.STRING, "Specify which configuration to use for this invocation.");
        complexContentExtension.getAttributeOrAttributeGroup().add(configRefAttr);
        ExplicitGroup all = new ExplicitGroup();
        complexContentExtension.setSequence(all);
        if (element != null) {
            int requiredChildElements = 0;
            for (Parameter variable : element.getParameters()) {
                if (variable.shouldBeIgnored()) continue;
                if (variable.asType().isNestedProcessor() || variable.asType().isArrayOrList() && variable.getTypeArguments().size() > 0 && ((Type)variable.getTypeArguments().get(0)).isNestedProcessor()) {
                    ++requiredChildElements;
                    continue;
                }
                if (!variable.asType().isCollection()) continue;
                ++requiredChildElements;
            }
            for (Parameter variable : element.getParameters()) {
                if (variable.shouldBeIgnored()) continue;
                if (variable.asType().isNestedProcessor() || variable.asType().isArrayOrList() && variable.getTypeArguments().size() > 0 && ((Type)variable.getTypeArguments().get(0)).isNestedProcessor()) {
                    if (requiredChildElements == 1) {
                        GroupRef groupRef = this.generateNestedProcessorGroup();
                        complexContentExtension.setGroup(groupRef);
                        complexContentExtension.setAll(null);
                        continue;
                    }
                    this.generateNestedProcessorElement(all, (Variable)variable);
                    continue;
                }
                if (variable.isQuery() && variable.asType().isDsqlQueryObject()) {
                    this.generateQueryElement(all, variable, complexContentExtension);
                    continue;
                }
                if (variable.asType().isCollection() && !variable.isRefOnly()) {
                    this.generateCollectionElement(all, (Variable)variable, false);
                    continue;
                }
                if (this.isTypeSupported(variable.asTypeMirror()) || variable.asType().isEnum() || variable.asType().isHttpCallback()) {
                    if (variable.isText()) {
                        this.createParameterElement(all, (Variable)variable);
                        continue;
                    }
                    complexContentExtension.getAttributeOrAttributeGroup().add(this.createParameterAttribute((Variable)variable, false));
                    continue;
                }
                if (variable.asType().isComplexType() && !variable.isRefOnly()) {
                    this.registerComplexTypeChildElement(all, (Variable)variable, false);
                    continue;
                }
                complexContentExtension.getAttributeOrAttributeGroup().add(this.createParameterAttribute((Variable)variable, false));
            }
            if (element instanceof ProcessorMethod) {
                ProcessorMethod method = (ProcessorMethod)element;
                if (method.canBeUsedInConnectionManagement() || method.module().manager().connectionManagementOverride().isPresent()) {
                    ConnectMethod connectMethod;
                    ConnectMethod connectMethod2 = connectMethod = method.canBeUsedInConnectionManagement() ? method.getManagedConnectionModule().getConnectMethod() : ((ConnectionManagementComponent)method.module().manager().connectionManagementOverride().get()).getConnectMethod();
                    if (connectMethod != null) {
                        for (Parameter parameter : connectMethod.getParameters()) {
                            if (parameter.asType().isCollection()) {
                                this.generateCollectionElement(all, (Variable)parameter, true);
                                continue;
                            }
                            complexContentExtension.getAttributeOrAttributeGroup().add(this.createParameterAttribute((Variable)parameter, true));
                        }
                    }
                }
                if (method.canBeUsedInOAuthManagement() || method.module().manager().oauth2Component().isPresent()) {
                    complexContentExtension.getAttributeOrAttributeGroup().add(this.createAttribute("accessTokenId", true, SchemaTypeConversion.convertType((String)this.getSchema().getTargetNamespace(), (String)"java.lang.String"), "The id of the access token that will be used to authenticate the call"));
                }
                if (method.isPaged()) {
                    this.addPagingAttributes(method, complexContentExtension.getAttributeOrAttributeGroup());
                }
            }
            if (element instanceof SourceMethod && ((SourceMethod)element).isPolling()) {
                this.addPollingPeriodSourceMethodAttribute((SourceMethod)element, complexContentExtension.getAttributeOrAttributeGroup());
            }
        }
        if (all.getParticle().size() == 0) {
            complexContentExtension.setSequence(null);
        }
        this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(complexType);
    }

    private void addPagingAttributes(ProcessorMethod method, List<Attribute> attributes) {
        Paged cfg = method.getPagingAnnotation();
        attributes.add(this.createAttribute("fetchSize", true, SchemaTypeConversion.convertType((String)this.getSchema().getTargetNamespace(), (String)"int"), "The amount of items to fetch on each invocation to the data source", new Integer(cfg.defaultFetchSize()).toString()));
    }

    private void addPollingPeriodSourceMethodAttribute(SourceMethod method, List<Attribute> attributes) {
        attributes.add(this.createAttribute("pollingPeriod", true, SchemaTypeConversion.convertType((String)this.getSchema().getTargetNamespace(), (String)"long"), "Polling Period for MessageSource in ms", new Long(method.getPollingPeriod()).toString()));
    }

    private void generateQueryElement(ExplicitGroup all, Parameter variable, ExtensionType complexContentExtension) {
        complexContentExtension.getAttributeOrAttributeGroup().add(this.createStringAttribute(variable));
    }

    private Attribute createStringAttribute(Parameter variable) {
        String name = variable.getName();
        Attribute attribute = new Attribute();
        String optional = "optional";
        if (!variable.isOptional()) {
            optional = "required";
        }
        attribute.setUse(optional);
        attribute.setName(name);
        attribute.setType(SchemaConstants.STRING);
        if (variable.hasDefaultValue()) {
            attribute.setDefault(variable.getDefaultValue());
        }
        return attribute;
    }
}

