/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.global.factory;

import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;

public class ConnectionStrategyResolver {
    public static boolean oldScenarioSupport(Module module) {
        return !ConnectionStrategyResolver.supportsConnectionManagement(module) && !ConnectionStrategyResolver.supportsOAuth(module) && !ConnectionStrategyResolver.supportsHttpBasicAuth(module) && !ConnectionStrategyResolver.supportsBasic(module) && !ConnectionStrategyResolver.supportWsdlProvider(module);
    }

    public static boolean supportsOAuth(Module module) {
        return module instanceof OAuthModule || OAuth2StrategyUtilsResolver.hasOAuth2Component(module);
    }

    public static boolean supportsConnectionManagement(Module module) {
        return module instanceof ManagedConnectionModule || !module.manager().connectionManagementComponents().isEmpty();
    }

    public static boolean supportsHttpBasicAuth(Module module) {
        return module.manager().httpBasicAuthComponent().isPresent();
    }

    public static boolean supportsBasic(Module module) {
        return !module.manager().configurationComponents().isEmpty();
    }

    public static boolean supportWsdlProvider(Module module) {
        return !module.manager().wsdlProviderComponent().isEmpty();
    }
}

