/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.methods;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.Mime;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.callback.HttpCallback;
import org.mule.api.callback.SourceCallback;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.common.query.DsqlQuery;
import org.mule.common.query.dsql.parser.MuleDsqlParser;
import org.mule.devkit.api.transformer.TransformingValue;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.MessageConstants;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.internal.streaming.processor.ExceptionHandlerProviderAwarePagingDelegate;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedArray;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.exceptionhandler.OnExceptionHandlerComponent;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.devkit.utils.NameUtils;
import org.mule.security.oauth.DefaultHttpCallback;
import org.mule.security.oauth.callback.HttpCallbackAdapter;
import org.mule.security.oauth.callback.ProcessCallback;
import org.mule.streaming.PagingConfiguration;
import org.mule.streaming.PagingDelegate;
import org.mule.streaming.ProviderAwarePagingDelegate;
import org.mule.streaming.processor.ManagedPagingDelegateAdapter;
import org.mule.util.StringUtils;

public class DoProcessTemplateMethod {
    private final Set<String> privateFieldnames;
    private AbstractMuleGenerator generator;
    private ProcessorMethod processorMethod;
    private GeneratedClass messageProcessorClass;
    private Map<String, AbstractMuleGenerator.FieldVariableElement> fields;
    private GeneratedClass poolObjectClass;
    private Module module;
    private boolean isPaged;
    private String methodName;

    public DoProcessTemplateMethod(AbstractMuleGenerator generator) {
        this.generator = generator;
        this.privateFieldnames = generator.getPrivateFieldnames();
        this.processorMethod = null;
        this.messageProcessorClass = null;
        this.fields = null;
        this.poolObjectClass = null;
        this.module = null;
    }

    public DoProcessTemplateMethod forMethod(ProcessorMethod processorMethod) {
        this.processorMethod = processorMethod;
        this.isPaged = processorMethod.isPaged();
        this.methodName = processorMethod.getName();
        return this;
    }

    public DoProcessTemplateMethod inClass(GeneratedClass messageProcessorClass) {
        this.messageProcessorClass = messageProcessorClass;
        return this;
    }

    public DoProcessTemplateMethod withModule(Module module) {
        this.module = module;
        return this;
    }

    public DoProcessTemplateMethod withFields(Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        this.fields = fields;
        return this;
    }

    public DoProcessTemplateMethod withPoolObject(GeneratedClass poolObjectClass) {
        this.poolObjectClass = poolObjectClass;
        return this;
    }

    public void build() {
        if (!this.wasInitialized()) {
            throw new IllegalStateException("Failed to initialize, missing setup");
        }
        TypeReference muleEvent = this.generator.ref(MuleEvent.class);
        GeneratedMethod process = this.getProcessInvokationContainerMethod((Type)muleEvent);
        process.javadoc().add((Object)"Invokes the MessageProcessor.");
        process.javadoc().addParam("event MuleEvent to be processed");
        process.javadoc().addThrows(this.generator.ref(Exception.class));
        process._throws(Exception.class);
        GeneratedVariable event = process.param(8, (Type)muleEvent, "event");
        GeneratedVariable pagingConfiguration = null;
        if (this.isPaged) {
            pagingConfiguration = process.param(8, (Type)this.generator.ref(PagingConfiguration.class), "pagingConfiguration");
        }
        GeneratedVariable sourceCallback = null;
        if (this.processorMethod.isIntercepting()) {
            sourceCallback = process.body().decl(8, (Type)this.generator.ref(SourceCallback.class), "sourceCallback", ExpressionFactory._this());
        }
        GeneratedVariable poolObject = this.declarePoolObjectIfClassNotNull(process);
        GeneratedVariable moduleObject = process.body().decl((Type)this.generator.ref(Object.class), "moduleObject", ExpressionFactory._null());
        GeneratedTry callProcessor = this.generateDoProcessTryBlock(process, event, pagingConfiguration, sourceCallback, moduleObject);
        this.generateCatchBlock(callProcessor);
        this.generateFinallyBlock(poolObject, moduleObject, callProcessor);
    }

    private GeneratedTry generateDoProcessTryBlock(GeneratedMethod process, GeneratedVariable event, GeneratedVariable pagingConfiguration, GeneratedVariable sourceCallback, GeneratedVariable moduleObject) {
        GeneratedTry callProcessor = process.body()._try();
        this.assignModuleObjectWithFindOrCreate(event, moduleObject, callProcessor);
        this.declareHttpCallbackHandlersForCallbackFields(moduleObject, callProcessor);
        GeneratedVariable messageProcessorReference = this.createMessageProcessorReference(callProcessor);
        ArrayList<GeneratedExpression> parameters = new ArrayList<GeneratedExpression>();
        GeneratedVariable outboundHeadersMap = null;
        for (Parameter variable : this.processorMethod.getParameters()) {
            String fieldName = variable.getName();
            String variableTypeName = variable.asTypeMirror().toString();
            if (variableTypeName.startsWith(HttpCallback.class.getName())) {
                parameters.add((GeneratedExpression)this.fields.get(fieldName).getFieldType());
                continue;
            }
            if (variableTypeName.startsWith(SourceCallback.class.getName())) {
                parameters.add((GeneratedExpression)sourceCallback);
                continue;
            }
            if (variableTypeName.startsWith(PagingConfiguration.class.getName())) {
                parameters.add((GeneratedExpression)pagingConfiguration);
                continue;
            }
            if (variable.asType().isNestedProcessor() || variable.asType().isArrayOrList() && variable.getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variable.getTypeArguments().get(0)).isNestedProcessor()) {
                parameters.add((GeneratedExpression)this.generator.declareNestedProcessorParameter((GeneratedExpression)this.fields.get(fieldName).getField(), (GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"), event, callProcessor.body(), variable.asType().isArrayOrList(), fieldName));
                continue;
            }
            if (variableTypeName.startsWith(MuleMessage.class.getName())) {
                parameters.add((GeneratedExpression)event.invoke("getMessage"));
                continue;
            }
            if (variableTypeName.startsWith(MuleEvent.class.getName())) {
                parameters.add((GeneratedExpression)event);
                continue;
            }
            outboundHeadersMap = this.declareStandardParameter((Variable)variable, this.messageProcessorClass, event, callProcessor, parameters, outboundHeadersMap);
            GeneratedExpression lastTransformedVariable = (GeneratedExpression)parameters.get(parameters.size() - 1);
            if (variable.asType().isString() && variable.hasSizeLimit()) {
                this.restrictSize(callProcessor, this.methodName, lastTransformedVariable, event, "length", (Variable)variable);
            } else if (variable.hasSizeLimit()) {
                this.restrictSize(callProcessor, this.methodName, lastTransformedVariable, event, "size", (Variable)variable);
            }
            if (!variable.asType().isString() || !variable.hasPattern() && !variable.hasEmailPattern()) continue;
            this.restrictPattern(callProcessor, this.methodName, lastTransformedVariable, event, "matches", variable);
        }
        Type returnType = this.generator.ref(this.processorMethod.getReturnType());
        GeneratedVariable resultPayload = this.generateMethodCall(callProcessor.body(), parameters, event, returnType, moduleObject, messageProcessorReference);
        if (!(returnType == this.generator.ctx().getCodeModel().VOID || this.isMuleEvent(returnType) || this.isPaged || this.isTransformingValue(returnType))) {
            callProcessor.body().add((Statement)event.invoke("getMessage").invoke("setPayload").arg((GeneratedExpression)resultPayload));
        }
        if (this.isTransformingValue(returnType)) {
            GeneratedInvocation invocation = event.invoke("getMessage");
            GeneratedCast defaultMuleMessage = ExpressionFactory.cast((Type)this.generator.ref(DefaultMuleMessage.class), (GeneratedExpression)invocation);
            GeneratedCast transformingValueCasted = ExpressionFactory.cast((Type)this.generator.ref(TransformingValue.class), (GeneratedExpression)resultPayload);
            callProcessor.body().add((Statement)defaultMuleMessage.invoke("setPayload").arg((GeneratedExpression)transformingValueCasted.invoke("getValue")));
            callProcessor.body().add((Statement)defaultMuleMessage.invoke("setMimeType").arg((GeneratedExpression)transformingValueCasted.invoke("getDataType").invoke("getMimeType")));
            callProcessor.body().add((Statement)defaultMuleMessage.invoke("setEncoding").arg((GeneratedExpression)transformingValueCasted.invoke("getDataType").invoke("getEncoding")));
        }
        this.setOutboundHeadersAsEventMessageProperties(event, callProcessor, outboundHeadersMap, returnType, resultPayload);
        this.setEventMessageMimeType(event, callProcessor, returnType, resultPayload);
        this.setDoProcessReturn(event, callProcessor, returnType, resultPayload);
        return callProcessor;
    }

    private boolean wasInitialized() {
        return this.processorMethod != null && this.messageProcessorClass != null && this.module != null && this.fields != null;
    }

    private void setOutboundHeadersAsEventMessageProperties(GeneratedVariable event, GeneratedTry callProcessor, GeneratedVariable outboundHeadersMap, Type returnType, GeneratedVariable resultPayload) {
        for (Parameter variable : this.processorMethod.getParameters()) {
            OutboundHeaders outboundHeaders = (OutboundHeaders)variable.getAnnotation(OutboundHeaders.class);
            if (outboundHeaders == null) continue;
            GeneratedConditional ifNotEmpty = callProcessor.body()._if(Op.cand((GeneratedExpression)outboundHeadersMap.isNotNull(), (GeneratedExpression)Op.not((GeneratedExpression)outboundHeadersMap.invoke("isEmpty"))));
            if (this.isMuleEvent(returnType)) {
                ifNotEmpty._then().add((Statement)ExpressionFactory.cast((Type)this.generator.ref(MuleEvent.class), (GeneratedExpression)resultPayload).invoke("getMessage").invoke("addProperties").arg((GeneratedExpression)outboundHeadersMap).arg((GeneratedExpression)this.generator.ref(PropertyScope.class).staticRef("OUTBOUND")));
                continue;
            }
            ifNotEmpty._then().add((Statement)event.invoke("getMessage").invoke("addProperties").arg((GeneratedExpression)outboundHeadersMap).arg((GeneratedExpression)this.generator.ref(PropertyScope.class).staticRef("OUTBOUND")));
        }
    }

    protected GeneratedVariable createMessageProcessorReference(GeneratedTry callProcessor) {
        GeneratedVariable messageProcessorReference = null;
        if (this.isPaged) {
            messageProcessorReference = callProcessor.body().decl(8, (Type)this.generator.ref(MessageProcessor.class), "messageProcessor", ExpressionFactory._this());
        }
        return messageProcessorReference;
    }

    private void setEventMessageMimeType(GeneratedVariable event, GeneratedTry callProcessor, Type returnType, GeneratedVariable resultPayload) {
        if (this.processorMethod.getAnnotation(Mime.class) != null) {
            GeneratedInvocation invocation = this.isMuleEvent(returnType) ? ExpressionFactory.cast((Type)this.generator.ref(MuleEvent.class), (GeneratedExpression)resultPayload).invoke("getMessage") : event.invoke("getMessage");
            GeneratedCast defaultMuleMessage = ExpressionFactory.cast((Type)this.generator.ref(DefaultMuleMessage.class), (GeneratedExpression)invocation);
            GeneratedInvocation setMimeType = defaultMuleMessage.invoke("setMimeType").arg(ExpressionFactory.lit((String)((Mime)this.processorMethod.getAnnotation(Mime.class)).value()));
            callProcessor.body().add((Statement)setMimeType);
        }
    }

    private void generateFinallyBlock(GeneratedVariable poolObject, GeneratedVariable moduleObject, GeneratedTry callProcessor) {
        if (this.poolObjectClass != null) {
            GeneratedBlock fin = callProcessor._finally();
            GeneratedBlock poolObjectNotNull = fin._if(poolObject.isNotNull())._then();
            poolObjectNotNull.add((Statement)ExpressionFactory.cast((Type)((TypeReference)this.generator.ctx().getProduct(Product.POOL_MANAGER_INTERFACE)), (GeneratedExpression)moduleObject).invoke("getLifecyleEnabledObjectPool").invoke("returnObject").arg((GeneratedExpression)poolObject));
        }
    }

    private void generateCatchBlock(GeneratedTry callProcessor) {
        GeneratedCatchBlock catchMessagingException = callProcessor._catch(this.generator.ref(Exception.class));
        GeneratedVariable e = catchMessagingException.param("e");
        catchMessagingException.body()._throw((GeneratedExpression)e);
    }

    protected void setDoProcessReturn(GeneratedVariable event, GeneratedTry callProcessor, Type returnType, GeneratedVariable resultPayload) {
        if (this.isPaged) {
            callProcessor.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.generator.ref(PagingDelegate.class), (GeneratedExpression)resultPayload));
        } else if (this.isMuleEvent(returnType)) {
            callProcessor.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.generator.ref(MuleEvent.class), (GeneratedExpression)resultPayload));
        } else {
            callProcessor.body()._return((GeneratedExpression)event);
        }
    }

    private void declareHttpCallbackHandlersForCallbackFields(GeneratedVariable moduleObject, GeneratedTry callProcessor) {
        for (String fieldName : this.fields.keySet()) {
            AbstractMuleGenerator.FieldVariableElement variableElement = this.fields.get(fieldName);
            if (!variableElement.getVariable().asTypeMirror().toString().startsWith(HttpCallback.class.getName())) continue;
            GeneratedField callbackFlowName = this.fields.get(fieldName).getField();
            GeneratedBlock ifCallbackFlowNameIsNull = callProcessor.body()._if(Op.cand((GeneratedExpression)callbackFlowName.isNotNull(), (GeneratedExpression)variableElement.getFieldType().isNull()))._then();
            GeneratedVariable castedModuleObject = ifCallbackFlowNameIsNull.decl((Type)this.generator.ref(HttpCallbackAdapter.class), "castedModuleObject", (GeneratedExpression)ExpressionFactory.cast((Type)this.generator.ref(HttpCallbackAdapter.class), (GeneratedExpression)moduleObject));
            GeneratedInvocation domain = castedModuleObject.invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)"domain"));
            GeneratedInvocation localPort = castedModuleObject.invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)"localPort"));
            GeneratedInvocation remotePort = castedModuleObject.invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)"remotePort"));
            GeneratedInvocation async = castedModuleObject.invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)"async"));
            ifCallbackFlowNameIsNull.assign((AssignmentTarget)variableElement.getFieldType(), (GeneratedExpression)ExpressionFactory._new((TypeReference)this.generator.ref(DefaultHttpCallback.class)).arg((GeneratedExpression)callbackFlowName).arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext")).arg((GeneratedExpression)domain).arg((GeneratedExpression)localPort).arg((GeneratedExpression)remotePort).arg((GeneratedExpression)async));
            ifCallbackFlowNameIsNull.add((Statement)ExpressionFactory.cast((Type)this.generator.ref(DefaultHttpCallback.class), (GeneratedExpression)variableElement.getFieldType()).invoke("setForceOldHttpTransport").arg(ExpressionFactory.TRUE));
            ifCallbackFlowNameIsNull.add((Statement)variableElement.getFieldType().invoke("start"));
        }
    }

    private void assignModuleObjectWithFindOrCreate(GeneratedVariable event, GeneratedVariable moduleObject, GeneratedTry callProcessor) {
        GeneratedInvocation findOrCreate = ExpressionFactory.invoke((String)"findOrCreate").arg(ExpressionFactory._null());
        findOrCreate.arg(ExpressionFactory.FALSE);
        findOrCreate.arg((GeneratedExpression)event);
        callProcessor.body().assign((AssignmentTarget)moduleObject, (GeneratedExpression)findOrCreate);
    }

    protected GeneratedMethod getProcessInvokationContainerMethod(Type muleEvent) {
        if (this.isPaged) {
            return this.messageProcessorClass.method(1, (Type)this.generator.ref(PagingDelegate.class), "getPagingDelegate");
        }
        return this.messageProcessorClass.method(1, muleEvent, "doProcess");
    }

    private GeneratedVariable declareStandardParameter(Variable variable, GeneratedClass messageProcessorClass, GeneratedVariable muleEvent, GeneratedTry callProcessor, List<GeneratedExpression> parameters, GeneratedVariable outboundHeadersMap) {
        OutboundHeaders outboundHeaders = (OutboundHeaders)variable.getAnnotation(OutboundHeaders.class);
        if (variable.isQuery() && variable.asType().isDsqlQueryObject()) {
            GeneratedVariable transformed = this.declareTransformedVariableClass(variable, String.class, (Type)messageProcessorClass, muleEvent, callProcessor.body());
            parameters.add((GeneratedExpression)transformed);
        } else if (this.privateFieldnames.contains(variable.getName())) {
            GeneratedVariable transformed = this.declareTransformedSuperField(variable, DevkitBasedMessageProcessor.class, messageProcessorClass, muleEvent, callProcessor.body());
            parameters.add((GeneratedExpression)transformed);
        } else if (outboundHeaders == null) {
            GeneratedVariable transformed = this.generator.declareTransformedVariable(variable, (GeneratedExpression)ExpressionFactory.ref((String)variable.getName()), (Type)messageProcessorClass, muleEvent, callProcessor.body(), (GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"));
            parameters.add((GeneratedExpression)transformed);
        } else {
            TypeReference type = this.generator.ref(HashMap.class).narrow(new TypeReference[]{this.generator.ref(String.class), this.generator.ref(Object.class)});
            String name = "_transformed" + org.apache.commons.lang.StringUtils.capitalize((String)variable.getName());
            outboundHeadersMap = callProcessor.body().decl(8, (Type)type, name, (GeneratedExpression)ExpressionFactory._new((Type)type));
            parameters.add((GeneratedExpression)outboundHeadersMap);
        }
        return outboundHeadersMap;
    }

    private GeneratedVariable declareTransformedSuperField(Variable variable, Class devkitSuperMessageProcessor, GeneratedClass fieldClass, GeneratedVariable muleEvent, GeneratedBlock block) {
        GeneratedInvocation muleContext = ExpressionFactory.invoke((String)"getMuleContext");
        TypeReference type = this.generator.ref(variable.asTypeMirror()).boxify();
        String name = "_transformed" + StringUtils.capitalize((String)variable.getName());
        GeneratedInvocation getGenericType = this.generator.ref(devkitSuperMessageProcessor).dotclass().invoke("getDeclaredField").arg(ExpressionFactory.lit((String)variable.getName())).invoke("getGenericType");
        GeneratedInvocation evaluateAndTransform = ExpressionFactory.invoke((String)"evaluateAndTransform").arg((GeneratedExpression)muleContext).arg((GeneratedExpression)muleEvent).arg((GeneratedExpression)getGenericType);
        Mime mime = (Mime)variable.getAnnotation(Mime.class);
        if (mime != null) {
            evaluateAndTransform.arg(ExpressionFactory.lit((String)mime.value()));
        } else {
            evaluateAndTransform.arg(ExpressionFactory._null());
        }
        Payload payload = (Payload)variable.getAnnotation(Payload.class);
        if (payload != null) {
            evaluateAndTransform.arg("#[payload]");
        } else {
            evaluateAndTransform.arg((GeneratedExpression)ExpressionFactory._super().invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)variable.getName())));
        }
        GeneratedCast cast = ExpressionFactory.cast((Type)type, (GeneratedExpression)evaluateAndTransform);
        return block.decl(8, (Type)type, name, (GeneratedExpression)cast);
    }

    private GeneratedVariable declareTransformedVariableClass(Variable variable, Class clazz, Type fieldClass, GeneratedVariable muleEvent, GeneratedBlock block) {
        GeneratedInvocation muleContext = ExpressionFactory.invoke((String)"getMuleContext");
        TypeReference type = this.generator.ref(clazz).boxify();
        String name = "_transformed" + StringUtils.capitalize((String)variable.getName());
        GeneratedInvocation getGenericType = fieldClass.boxify().dotclass().invoke("getDeclaredField").arg(ExpressionFactory.lit((String)("_" + variable.getName() + "Type"))).invoke("getGenericType");
        GeneratedInvocation evaluateAndTransform = ExpressionFactory.invoke((String)"evaluateAndTransform").arg((GeneratedExpression)muleContext).arg((GeneratedExpression)muleEvent).arg((GeneratedExpression)getGenericType);
        Mime mime = (Mime)variable.getAnnotation(Mime.class);
        if (mime != null) {
            evaluateAndTransform.arg(ExpressionFactory.lit((String)mime.value()));
        } else {
            evaluateAndTransform.arg(ExpressionFactory._null());
        }
        Payload payload = (Payload)variable.getAnnotation(Payload.class);
        if (payload != null) {
            evaluateAndTransform.arg("#[payload]");
        } else {
            evaluateAndTransform.arg((GeneratedExpression)ExpressionFactory.ref((String)variable.getName()));
        }
        GeneratedCast cast = ExpressionFactory.cast((Type)type, (GeneratedExpression)evaluateAndTransform);
        return block.decl(8, (Type)type, name, (GeneratedExpression)cast);
    }

    private GeneratedVariable declarePoolObjectIfClassNotNull(GeneratedMethod process) {
        return this.poolObjectClass != null ? process.body().decl((Type)this.poolObjectClass, "_poolObject", ExpressionFactory._null()) : null;
    }

    private GeneratedVariable generateMethodCall(GeneratedBlock body, List<GeneratedExpression> parameters, GeneratedVariable event, Type returnType, GeneratedVariable moduleObject, GeneratedVariable messageProcessorReference) {
        GeneratedVariable resultPayload = null;
        if (returnType != this.generator.ctx().getCodeModel().VOID) {
            resultPayload = body.decl((Type)this.generator.ref(Object.class), "resultPayload");
        }
        GeneratedVariable processTemplate = this.declareProcessTemplate(body, moduleObject);
        GeneratedClass executionCallback = this.generator.ctx().getCodeModel().anonymousClass(this.generator.ref(ProcessCallback.class).narrow(this.generator.ref(Object.class)).narrow(this.generator.ref(Object.class)));
        GeneratedMethod getManagedExceptions = this.setGetManagedExceptionMethodDefinition(executionCallback);
        GeneratedMethod isProtected = this.setIsProtectedMethodDefinition(executionCallback);
        this.setProcessMethodDefinition(parameters, event, returnType, messageProcessorReference, processTemplate, executionCallback, getManagedExceptions, isProtected);
        if (this.processorMethod.hasQuery()) {
            body.assign((AssignmentTarget)resultPayload, (GeneratedExpression)processTemplate.invoke("execute").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)executionCallback)).arg(ExpressionFactory._this()).arg((GeneratedExpression)event));
        } else if (returnType != this.generator.ctx().getCodeModel().VOID) {
            body.assign((AssignmentTarget)resultPayload, (GeneratedExpression)processTemplate.invoke("execute").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)executionCallback)).arg(ExpressionFactory._this()).arg((GeneratedExpression)event));
        } else {
            body.add((Statement)processTemplate.invoke("execute").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)executionCallback)).arg(ExpressionFactory._this()).arg((GeneratedExpression)event));
        }
        return resultPayload;
    }

    private GeneratedVariable declareProcessTemplate(GeneratedBlock body, GeneratedVariable moduleObject) {
        TypeReference processTemplateType = this.generator.ref(ProcessTemplate.class).narrow(this.generator.ref(Object.class)).narrow(this.generator.ref(Object.class));
        GeneratedCast castedModuleObject = ExpressionFactory.cast((Type)this.generator.ref(ProcessAdapter.class).narrow(this.generator.ref(Object.class)), (GeneratedExpression)moduleObject);
        return body.decl(8, (Type)processTemplateType, "processTemplate", (GeneratedExpression)castedModuleObject.invoke("getProcessTemplate"));
    }

    private GeneratedMethod setGetManagedExceptionMethodDefinition(GeneratedClass executionCallback) {
        GeneratedMethod getManagedExceptions = executionCallback.method(1, (Type)this.generator.ref(List.class).narrow(this.generator.ref(Class.class).narrow(this.generator.ref(Exception.class).wildcard())), "getManagedExceptions");
        ArrayList<GeneratedExpression> exceptionClasses = new ArrayList<GeneratedExpression>();
        List reconnectionModuleExceptions = this.module.reconnectOn();
        List reconnectionProcessorExceptions = this.processorMethod.reconnectOn();
        if (!reconnectionProcessorExceptions.isEmpty()) {
            for (AnnotationValue reconnectionException : reconnectionProcessorExceptions) {
                exceptionClasses.add(this.generator.ref(reconnectionException.getValue().toString()).boxify().dotclass());
            }
        } else if (!reconnectionModuleExceptions.isEmpty()) {
            for (AnnotationValue reconnectionException : reconnectionModuleExceptions) {
                exceptionClasses.add(this.generator.ref(reconnectionException.getValue().toString()).boxify().dotclass());
            }
        } else if (this.processorMethod.invalidateConnectionOn() != null || this.processorMethod.invalidateAccessTokenOn() != null) {
            if (this.processorMethod.invalidateConnectionOn() != null) {
                exceptionClasses.add(this.generator.ref(this.processorMethod.invalidateConnectionOn()).boxify().dotclass());
            }
            if (this.processorMethod.invalidateAccessTokenOn() != null) {
                exceptionClasses.add(this.generator.ref(this.processorMethod.invalidateAccessTokenOn()).boxify().dotclass());
            }
        }
        if (exceptionClasses.isEmpty()) {
            getManagedExceptions.body()._return(ExpressionFactory._null());
        } else {
            GeneratedArray newExceptionArray = ExpressionFactory.newArray((Type)this.generator.ref(Class.class));
            for (GeneratedExpression generatedExpression : exceptionClasses) {
                newExceptionArray.add(generatedExpression);
            }
            getManagedExceptions.body()._return((GeneratedExpression)this.generator.ref(Arrays.class).staticInvoke("asList").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.generator.ref(Class.class).narrow(this.generator.ref(Exception.class).wildcard()).array(), (GeneratedExpression)newExceptionArray)));
        }
        return getManagedExceptions;
    }

    private GeneratedMethod setProcessMethodDefinition(List<GeneratedExpression> parameters, GeneratedVariable event, Type returnType, GeneratedVariable messageProcessorReference, GeneratedVariable processTemplate, GeneratedClass executionCallback, GeneratedMethod getManagedExceptions, GeneratedMethod isProtected) {
        GeneratedBlock currentBody;
        GeneratedMethod process = executionCallback.method(1, (Type)this.generator.ref(Object.class), "process");
        GeneratedVariable module = process.param((Type)this.generator.ref(Object.class), "object");
        process._throws(this.generator.ref(Exception.class));
        GeneratedInvocation transformedCall = this.getTransformedMethodInvocation(process, parameters, event, messageProcessorReference, processTemplate, getManagedExceptions, isProtected, module);
        Optional processTry = Optional.absent();
        if (this.processorMethod.manager().handlerComponent().isPresent() || this.module.manager().handlerComponent().isPresent()) {
            processTry = Optional.of((Object)process.body()._try());
            currentBody = ((GeneratedTry)processTry.get()).body();
        } else {
            currentBody = process.body();
        }
        if (this.processorMethod.hasQuery()) {
            GeneratedVariable connector = currentBody.decl(this.generator.ref((org.mule.devkit.model.Type)this.processorMethod.parent()), "connector", (GeneratedExpression)ExpressionFactory.cast((Type)this.generator.ref((org.mule.devkit.model.Type)this.processorMethod.parent()), (GeneratedExpression)module));
            GeneratedExpression transformedQuery = ExpressionFactory.direct((String)("_transformed" + StringUtils.capitalize((String)this.processorMethod.getQueryParameter().getName())));
            GeneratedVariable trimmedQuery = currentBody.decl((Type)this.generator.ref(String.class), "trimmedQuery", transformedQuery);
            GeneratedConditional ifDsql = currentBody._if(Op.cand((GeneratedExpression)Op.ne((GeneratedExpression)trimmedQuery, (GeneratedExpression)ExpressionFactory._null()), (GeneratedExpression)transformedQuery.invoke("startsWith").arg(ExpressionFactory.lit((String)"dsql:"))));
            ifDsql._then().assign((AssignmentTarget)trimmedQuery, (GeneratedExpression)transformedQuery.invoke("substring").arg(ExpressionFactory.lit((int)5)));
            GeneratedVariable parser = ifDsql._then().decl((Type)this.generator.ref(MuleDsqlParser.class), "parser", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.generator.ref(MuleDsqlParser.class)));
            GeneratedVariable query = ifDsql._then().decl((Type)this.generator.ref(DsqlQuery.class), "q", (GeneratedExpression)parser.invoke("parse").arg((GeneratedExpression)trimmedQuery));
            GeneratedInvocation methodCall = ExpressionFactory.cast((Type)this.generator.ref((org.mule.devkit.model.Type)this.processorMethod.parent()), (GeneratedExpression)module).invoke(this.methodName);
            List originalParameters = this.processorMethod.getParameters();
            for (int i = 0; i < originalParameters.size(); ++i) {
                if (((Parameter)originalParameters.get(i)).isQuery() && this.module.getQueryTranslatorMethod() != null) {
                    methodCall.arg((GeneratedExpression)connector.invoke(this.module.getQueryTranslatorMethod().getName()).arg((GeneratedExpression)query).invoke("toString"));
                    continue;
                }
                if (((Parameter)originalParameters.get(i)).isQuery() && ((Parameter)originalParameters.get(i)).asType().isDsqlQueryObject()) {
                    methodCall.arg((GeneratedExpression)query);
                    continue;
                }
                if (((Parameter)originalParameters.get(i)).isQuery() && !this.processorMethod.hasQueryParts()) {
                    methodCall.arg(parameters.get(i));
                    continue;
                }
                if (((Parameter)originalParameters.get(i)).isQueryPart()) {
                    methodCall.arg((GeneratedExpression)connector.invoke(this.module.getQueryTranslatorMethod().getName()).invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)((Parameter)originalParameters.get(i)).getName())));
                    continue;
                }
                methodCall.arg(parameters.get(i));
            }
            if (this.isPaged) {
                GeneratedInvocation paginatedMethodWrapped = methodCall;
                if (this.processorMethod.manager().handlerComponent().isPresent() || this.module.manager().handlerComponent().isPresent()) {
                    GeneratedVariable paginationProvider;
                    GeneratedVariable paginationComponent = paginationProvider = ifDsql._then().decl((Type)this.generator.ref(ProviderAwarePagingDelegate.class), "paginationProviderDsql", (GeneratedExpression)methodCall);
                    OnExceptionHandlerComponent onExceptionHandlerComponent = this.getOnExceptionHandlerComponent();
                    Type handlerRef = this.generator.ref(((TypeElement)onExceptionHandlerComponent.unwrap()).asType());
                    GeneratedVariable wrapper = ifDsql._then().decl((Type)this.generator.ref(ExceptionHandlerProviderAwarePagingDelegate.class), "wrapperdsql", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.generator.ref(ExceptionHandlerProviderAwarePagingDelegate.class)).arg((GeneratedExpression)paginationProvider).arg(handlerRef.dotclass()).arg(ExpressionFactory.lit((String)onExceptionHandlerComponent.getExceptionHandle().getName())));
                    paginatedMethodWrapped = wrapper;
                }
                methodCall = ExpressionFactory._new((TypeReference)this.generator.ref(ManagedPagingDelegateAdapter.class)).arg((GeneratedExpression)paginatedMethodWrapped).arg((GeneratedExpression)processTemplate).arg((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)getManagedExceptions)).arg((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)isProtected)).arg((GeneratedExpression)messageProcessorReference).arg((GeneratedExpression)event);
            }
            ifDsql._then()._return((GeneratedExpression)methodCall);
            if (!this.processorMethod.getQueryParameter().asType().isDsqlQueryObject()) {
                ifDsql._else()._return((GeneratedExpression)transformedCall);
            } else {
                ifDsql._else()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generator.ref(RuntimeException.class)).arg(ExpressionFactory.lit((String)"the dsql is not valid")));
            }
        } else if (returnType != this.generator.ctx().getCodeModel().VOID) {
            currentBody._return((GeneratedExpression)transformedCall);
        } else {
            currentBody.add((Statement)transformedCall);
            currentBody._return(ExpressionFactory._null());
        }
        if (processTry.isPresent()) {
            this.createOnExceptionHandlingBlock((Optional<GeneratedTry>)processTry, module);
        }
        return process;
    }

    private void createOnExceptionHandlingBlock(Optional<GeneratedTry> processTry, GeneratedVariable moduleObject) {
        GeneratedCatchBlock processCatch = ((GeneratedTry)processTry.get())._catch(this.generator.ref(Exception.class));
        GeneratedVariable exceptionVar = processCatch.param("e");
        OnExceptionHandlerComponent onExceptionHandlerComponent = this.getOnExceptionHandlerComponent();
        Type handlerRef = this.generator.ref(((TypeElement)onExceptionHandlerComponent.unwrap()).asType());
        GeneratedVariable handler = processCatch.body().decl(handlerRef, "handler", (GeneratedExpression)ExpressionFactory._new((Type)handlerRef));
        Optional moduleInjectionSetter = onExceptionHandlerComponent.getModuleInjectionSetter(((org.mule.devkit.model.Type)this.processorMethod.parent()).getQualifiedName().toString());
        if (moduleInjectionSetter.isPresent()) {
            processCatch.body().invoke((GeneratedExpression)handler, (String)moduleInjectionSetter.get()).arg((GeneratedExpression)ExpressionFactory.cast((Type)this.generator.ref((org.mule.devkit.model.Type)this.processorMethod.parent()), (GeneratedExpression)moduleObject));
        }
        processCatch.body().invoke((GeneratedExpression)handler, onExceptionHandlerComponent.getExceptionHandle().getName()).arg((GeneratedExpression)exceptionVar);
        processCatch.body()._throw((GeneratedExpression)exceptionVar);
    }

    private OnExceptionHandlerComponent getOnExceptionHandlerComponent() {
        OnExceptionHandlerComponent onExceptionHandlerComponent = this.processorMethod.manager().handlerComponent().isPresent() ? (OnExceptionHandlerComponent)this.processorMethod.manager().handlerComponent().get() : (OnExceptionHandlerComponent)this.module.manager().handlerComponent().get();
        return onExceptionHandlerComponent;
    }

    private GeneratedMethod setIsProtectedMethodDefinition(GeneratedClass executionCallback) {
        GeneratedMethod isProtected = executionCallback.method(1, (Type)this.generator.ctx().getCodeModel().BOOLEAN, "isProtected");
        if (this.processorMethod.isOAuthProtected()) {
            isProtected.body()._return(ExpressionFactory.TRUE);
        } else {
            isProtected.body()._return(ExpressionFactory.FALSE);
        }
        return isProtected;
    }

    private GeneratedInvocation getTransformedMethodInvocation(GeneratedMethod process, List<GeneratedExpression> parameters, GeneratedVariable event, GeneratedVariable messageProcessorReference, GeneratedVariable processTemplate, GeneratedMethod getManagedExceptions, GeneratedMethod isProtected, GeneratedVariable object2) {
        GeneratedInvocation transformedCall = ExpressionFactory.cast((Type)this.generator.ref((org.mule.devkit.model.Type)this.processorMethod.parent()), (GeneratedExpression)object2).invoke(this.methodName);
        for (GeneratedExpression parameter : parameters) {
            transformedCall.arg(parameter);
        }
        if (this.isPaged) {
            GeneratedVariable paginationProvider;
            GeneratedVariable paginationComponent = paginationProvider = process.body().decl((Type)this.generator.ref(ProviderAwarePagingDelegate.class), "paginationProvider", (GeneratedExpression)transformedCall);
            if (this.processorMethod.manager().handlerComponent().isPresent() || this.module.manager().handlerComponent().isPresent()) {
                GeneratedVariable wrapper;
                OnExceptionHandlerComponent onExceptionHandlerComponent = this.getOnExceptionHandlerComponent();
                Type handlerRef = this.generator.ref(((TypeElement)onExceptionHandlerComponent.unwrap()).asType());
                paginationComponent = wrapper = process.body().decl((Type)this.generator.ref(ExceptionHandlerProviderAwarePagingDelegate.class), "wrapper", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.generator.ref(ExceptionHandlerProviderAwarePagingDelegate.class)).arg((GeneratedExpression)paginationProvider).arg(handlerRef.dotclass()).arg(ExpressionFactory.lit((String)onExceptionHandlerComponent.getExceptionHandle().getName())));
            }
            transformedCall = ExpressionFactory._new((TypeReference)this.generator.ref(ManagedPagingDelegateAdapter.class)).arg((GeneratedExpression)paginationComponent).arg((GeneratedExpression)processTemplate).arg((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)getManagedExceptions)).arg((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)isProtected)).arg((GeneratedExpression)messageProcessorReference).arg((GeneratedExpression)event);
        }
        return transformedCall;
    }

    protected boolean isMuleEvent(Type type) {
        return type.fullName().startsWith(MuleEvent.class.getName());
    }

    protected boolean isTransformingValue(Type type) {
        return type != this.generator.ctx().getCodeModel().VOID && type.fullName().startsWith(TransformingValue.class.getName());
    }

    private void restrictPattern(GeneratedTry callProcessor, String methodName, GeneratedExpression trasformedVariable, GeneratedVariable event, String matches, Parameter variable) {
        GeneratedExpression optional = variable.isOptional() ? Op.ne((GeneratedExpression)trasformedVariable, (GeneratedExpression)ExpressionFactory._null()) : ExpressionFactory.TRUE;
        GeneratedConditional conditional = callProcessor.body()._if(Op.cand((GeneratedExpression)optional, (GeneratedExpression)Op.not((GeneratedExpression)trasformedVariable.invoke(matches).arg(variable.getPattern()))));
        this.generator.generateThrow("createStaticMessage", MessagingException.class, conditional._then(), (GeneratedExpression)event, "Pattern doesn't match on attribute:" + variable.getName() + MessageConstants.AT_PROCESSOR + NameUtils.uncamel((String)methodName));
    }

    private void restrictSize(GeneratedTry callProcessor, String methodName, GeneratedExpression transformedParameter, GeneratedVariable event, String sizeMethod, Variable variable) {
        GeneratedExpression optional = variable.isOptional() ? Op.ne((GeneratedExpression)transformedParameter, (GeneratedExpression)ExpressionFactory._null()) : ExpressionFactory.TRUE;
        GeneratedConditional conditional = callProcessor.body()._if(Op.cand((GeneratedExpression)optional, (GeneratedExpression)Op.cor((GeneratedExpression)Op.lt((GeneratedExpression)transformedParameter.invoke(sizeMethod), (GeneratedExpression)ExpressionFactory.lit((int)variable.getMinSizeLimit())), (GeneratedExpression)Op.lt((GeneratedExpression)ExpressionFactory.lit((int)variable.getMaxSizeLimit()), (GeneratedExpression)transformedParameter.invoke(sizeMethod)))));
        this.generator.generateThrow("createStaticMessage", MessagingException.class, conditional._then(), (GeneratedExpression)event, MessageConstants.LIMITED_SIZE_EXCEEDED + variable.getName() + MessageConstants.AT_PROCESSOR + NameUtils.uncamel((String)methodName));
    }
}

