/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.util.Arrays;
import java.util.List;
import org.mule.api.MetadataAware;
import org.mule.devkit.generation.AbstractMetadataCodeGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

public class MetadataAwareAdapterGenerator
extends AbstractMetadataCodeGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.METADATA_ADAPTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC || module.getKind() == ModuleKind.EXPRESSION_LANGUAGE;
    }

    public void generate(Module module) {
        GeneratedClass metadataAdapter = this.getMetadataAdapterClass(module);
        metadataAdapter.javadoc().add((Object)("A <code>" + metadataAdapter.name() + "</code> is a wrapper around "));
        metadataAdapter.javadoc().add((Object)this.ref((Type)module));
        metadataAdapter.javadoc().add((Object)" that adds support for querying metadata about the extension.");
        this.generateMetadataConstantsAndGetters(module, metadataAdapter);
    }

    private GeneratedClass getMetadataAdapterClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".adapters");
        GeneratedClass previous = ((GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module)).topLevelClass();
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass clazz = pkg._class(modifiers, module.getClassName() + "MetadataAdapter", (TypeReference)previous);
        clazz._implements(MetadataAware.class);
        this.ctx().registerProduct(Product.METADATA_ADAPTER, (Identifiable)module, (Object)clazz);
        return clazz;
    }
}

