/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.strategies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.TestConnectivity;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.verifiers.ConnectorAnnotationVerifier;
import org.mule.devkit.verifiers.strategies.ConnectionStrategiesVerifierUtils;
import org.mule.devkit.verifiers.util.VerifierUtils;
import org.mule.util.StringUtils;

public class ConnectionManagementVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return !module.manager().connectionManagementComponents().isEmpty();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.verifyOnlyStrategyIsBeingUsed(module, gatherer);
        this.verifyOnlyOneOverrideAtProcessors(module, gatherer);
        ConnectorAnnotationVerifier connectionVerifier = new ConnectorAnnotationVerifier();
        connectionVerifier.setGatherer(gatherer);
        for (ConnectionManagementComponent component : module.manager().connectionManagementComponents()) {
            this.verifyConnectionComponent(module, gatherer, component);
        }
    }

    private void verifyOnlyOneOverrideAtProcessors(Module module, NotificationGatherer gatherer) {
        ArrayList<ConnectionManagementComponent> overrideAtProcessors = new ArrayList<ConnectionManagementComponent>();
        for (ConnectionManagementComponent connectionManagementComponent : module.manager().connectionManagementComponents()) {
            if (!connectionManagementComponent.overridesAtMessageProcessor()) continue;
            overrideAtProcessors.add(connectionManagementComponent);
        }
        if (overrideAtProcessors.size() > 1) {
            gatherer.errorAll(overrideAtProcessors, (DevkitNotification)Message.OVERRIDE_AT_PROCESSORS_ONLY_ONCE, new Object[0]);
        }
    }

    private void verifyConnectionComponent(Module module, NotificationGatherer gatherer, ConnectionManagementComponent component) throws AnnotationVerificationException {
        this.checkConnectionMethods(module, gatherer, component);
        ConnectionStrategiesVerifierUtils.verifyComponentConfigurableGetterAndSetter(gatherer, (ConnectionComponent)component);
        ConnectionStrategiesVerifierUtils.verifyComponentConfigurableFields(module, gatherer, (ConnectionComponent)component);
    }

    private void verifyOnlyStrategyIsBeingUsed(Module module, NotificationGatherer gatherer) {
        if (module instanceof ManagedConnectionModule) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.CONNECTOR_HAS_CONNECTIONSTRATEGY_AND_CONNECT_ANNOTATIONS, new Object[]{module.getName()});
        }
    }

    public void checkConnectionMethods(Module module, NotificationGatherer gatherer, ConnectionManagementComponent component) throws AnnotationVerificationException {
        this.checkConnectorMethodsConsistency(component, gatherer);
        this.checkConnectMethod(module, component, gatherer);
        this.checkDisconnectMethod(component, gatherer);
        this.checkConnectionIdentifierMethod(component, gatherer);
        this.checkValidateConnectionMethod(component, gatherer);
    }

    private void checkConnectorMethodsConsistency(ConnectionManagementComponent component, NotificationGatherer gatherer) throws AnnotationVerificationException {
        ConnectMethod connectMethod = component.getConnectMethod();
        Method validateConnectionMethod = component.getValidateConnectionMethod();
        Method disconnectMethod = component.getDisconnectMethod();
        Method connectionIdentifierMethod = component.getConnectionIdentifierMethod();
        ArrayList<String> nonImplementedConnectorMethods = new ArrayList<String>();
        if (connectMethod == null) {
            nonImplementedConnectorMethods.add("@Connect");
        }
        if (disconnectMethod == null) {
            nonImplementedConnectorMethods.add("@Disconnect");
        }
        if (connectionIdentifierMethod == null) {
            nonImplementedConnectorMethods.add("@ConnectionIdentifier");
        }
        if (validateConnectionMethod == null) {
            nonImplementedConnectorMethods.add("@ValidateConnection");
        }
        if (!nonImplementedConnectorMethods.isEmpty()) {
            String alreadyImplementedMethods = StringUtils.join(nonImplementedConnectorMethods, (String)", ");
            gatherer.error((Identifiable)component, (DevkitNotification)Message.CONNECTION_MANAGEMENT_MISSING_CONNECTION_METHODS, new Object[]{alreadyImplementedMethods});
        }
        if (component.hasAnnotation(OAuth.class) || component.hasAnnotation(OAuth2.class)) {
            gatherer.error((Identifiable)component, (DevkitNotification)Message.CONNECTOR_USES_CONN_MGMT_AND_OAUTH, new Object[]{component.getClassName()});
        }
    }

    private void checkConnectMethod(Module module, ConnectionManagementComponent component, NotificationGatherer gatherer) throws AnnotationVerificationException {
        List connectMethods = component.getMethodsAnnotatedWith(Connect.class);
        ConnectMethod connectMethod = component.getConnectMethod();
        if (connectMethod != null) {
            if (!connectMethod.isPublic()) {
                gatherer.error((Identifiable)connectMethod, (DevkitNotification)Message.CONNECT_MUST_BE_PUBLIC, new Object[0]);
            }
            if (connectMethod.getThrownTypes().isEmpty()) {
                gatherer.error((Identifiable)connectMethod, (DevkitNotification)Message.CONNECT_MUST_THROW_CONNECTION_EXCEPTION, new Object[0]);
            }
            if (!connectMethod.getThrownTypes().isEmpty() && !((TypeMirror)connectMethod.getThrownTypes().get(0)).toString().equals("org.mule.api.ConnectionException")) {
                gatherer.error((Identifiable)connectMethod, (DevkitNotification)Message.CONNECT_MUST_THROW_CONNECTION_EXCEPTION, new Object[0]);
            }
            if (!VerifierUtils.returnTypeEqualsType((Method)connectMethod, "void")) {
                gatherer.error((Identifiable)connectMethod, (DevkitNotification)Message.CONNECT_NO_RETURN, new Object[0]);
            }
            this.checkConnectMethodParameters(component, module, gatherer);
            Method testConnectivityMethod = component.getRecursivelyFirstMethodAnnotatedWith(TestConnectivity.class);
            if (testConnectivityMethod == null) {
                gatherer.error((Identifiable)connectMethod, (DevkitNotification)Message.CONNECT_MUST_BE_TEST_CONNECTIVITY, new Object[0]);
            } else {
                VerifierUtils.verifyEqualParameters((Method)component.getConnectMethod(), testConnectivityMethod, gatherer);
            }
        }
        if (connectMethods != null && connectMethods.size() > 1) {
            for (Method method : connectMethods) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.CON_MANAGEMENT_DUPLICATED_CONNECT_METHOD, new Object[0]);
            }
        }
    }

    private void checkDisconnectMethod(ConnectionManagementComponent component, NotificationGatherer gatherer) throws AnnotationVerificationException {
        List disconnectMethods = component.getMethodsAnnotatedWith(Disconnect.class);
        Method disconnectMethod = component.getDisconnectMethod();
        if (disconnectMethod != null) {
            if (!disconnectMethod.isPublic()) {
                gatherer.error((Identifiable)disconnectMethod, (DevkitNotification)Message.DISCONNECT_MUST_BE_PUBLIC, new Object[0]);
            }
            if (!disconnectMethod.getParameters().isEmpty()) {
                gatherer.error((Identifiable)disconnectMethod, (DevkitNotification)Message.DISCONNECT_NO_ARGS, new Object[0]);
            }
            boolean throwsProperException = true;
            for (TypeMirror typeMirror : disconnectMethod.getThrownTypes()) {
                if (typeMirror.toString().equals(RuntimeException.class.getCanonicalName())) continue;
                throwsProperException = false;
                break;
            }
            if (!throwsProperException) {
                gatherer.error((Identifiable)disconnectMethod, (DevkitNotification)Message.DISCONNECT_THROW, new Object[0]);
            }
        }
        if (disconnectMethods != null && disconnectMethods.size() > 1) {
            for (Method method : disconnectMethods) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DISCONNECT_ONE_METHOD_ONLY, new Object[0]);
            }
        }
    }

    private void checkValidateConnectionMethod(ConnectionManagementComponent component, NotificationGatherer gatherer) throws AnnotationVerificationException {
        List validateConnectionMethods = component.getMethodsAnnotatedWith(ValidateConnection.class);
        Method validateConnectionMethod = component.getValidateConnectionMethod();
        if (validateConnectionMethod != null) {
            if (!validateConnectionMethod.isPublic()) {
                gatherer.error((Identifiable)validateConnectionMethod, (DevkitNotification)Message.VALIDATE_CONNECTION_PUBLIC, new Object[0]);
            }
            if (!validateConnectionMethod.getReturnType().toString().equals("boolean") && !validateConnectionMethod.getReturnType().toString().equals("java.lang.Boolean")) {
                gatherer.error((Identifiable)validateConnectionMethod, (DevkitNotification)Message.VALIDATE_CONNECTION_MUST_RETURN_BOOLEAN, new Object[0]);
            }
            if (!validateConnectionMethod.getParameters().isEmpty()) {
                gatherer.error((Identifiable)validateConnectionMethod, (DevkitNotification)Message.VALIDATE_CONNECTION_NO_ARGS, new Object[0]);
            }
        }
        if (validateConnectionMethods != null && validateConnectionMethods.size() > 1) {
            for (Method method : validateConnectionMethods) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.VALIDATE_CONNECTION_ONE_METHOD_ONLY, new Object[0]);
            }
        }
    }

    private void checkConnectionIdentifierMethod(ConnectionManagementComponent component, NotificationGatherer gatherer) throws AnnotationVerificationException {
        List connectionIdentifierMethods = component.getMethodsAnnotatedWith(ConnectionIdentifier.class);
        Method connectionIdentifierMethod = component.getConnectionIdentifierMethod();
        if (connectionIdentifierMethod != null) {
            if (!VerifierUtils.returnTypeEqualsType(connectionIdentifierMethod, "java.lang.String")) {
                gatherer.error((Identifiable)connectionIdentifierMethod, (DevkitNotification)Message.CONN_IDENTIFIER_MUST_RETURN_STRING, new Object[0]);
            }
            if (!connectionIdentifierMethod.isPublic()) {
                gatherer.error((Identifiable)connectionIdentifierMethod, (DevkitNotification)Message.CONN_IDENTIFIER_MUST_BE_PUBLIC, new Object[0]);
            }
            if (connectionIdentifierMethod.isStatic()) {
                gatherer.error((Identifiable)connectionIdentifierMethod, (DevkitNotification)Message.CONN_IDENTIFIER_MUST_BE_STATIC, new Object[0]);
            }
            if (!connectionIdentifierMethod.getParameters().isEmpty()) {
                gatherer.error((Identifiable)connectionIdentifierMethod, (DevkitNotification)Message.CONN_IDENTIFIER_NO_ARGS, new Object[0]);
            }
        }
        if (connectionIdentifierMethods != null && connectionIdentifierMethods.size() > 1) {
            for (Method method : connectionIdentifierMethods) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.CONN_IDENTIFIER_ONE_METHOD_ONLY, new Object[0]);
            }
        }
    }

    private void checkConnectMethodParameters(ConnectionManagementComponent component, Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        ConnectMethod connectMethod = component.getConnectMethod();
        HashSet<String> connectionParameterNames = new HashSet<String>();
        int connectionKeys = 0;
        for (Parameter parameter : connectMethod.getParameters()) {
            TypeKind parameterKind;
            if (parameter.isReservedIdentifier()) {
                gatherer.error((Identifiable)parameter, (DevkitNotification)Message.CONNECTOR_USES_RESERVED_IDENTIFIER, new Object[]{parameter.getName(), parameter.getName()});
            }
            if (parameter.hasAnnotation(ConnectionKey.class)) {
                ++connectionKeys;
                if (parameter.hasDefaultValue()) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.CONNECTIONKEY_PARAMETER_HAS_DEFAULT_VALUE, new Object[0]);
                }
            }
            if (parameter.asType().isEnum()) {
                gatherer.error((Identifiable)parameter, (DevkitNotification)Message.CONNECT_PARAM_RESTRICTED_TYPES, new Object[]{parameter.getName(), "Enum"});
            }
            if (parameter.asType().isCollection()) {
                gatherer.error((Identifiable)parameter, (DevkitNotification)Message.CONNECT_PARAM_RESTRICTED_TYPES, new Object[]{parameter.getName(), "Collection"});
            }
            if ((parameterKind = parameter.asTypeMirror().getKind()) == TypeKind.BYTE || parameter.getJavaType().equals(Byte.class.getName()) || parameterKind == TypeKind.SHORT || parameter.getJavaType().equals(Short.class.getName())) {
                this.getGatherer().error((Identifiable)parameter, (DevkitNotification)Message.PARAMS_NOT_SUPPORTED, new Object[]{Arrays.toString(new String[]{"byte", "short"}), parameter.getName()});
            }
            connectionParameterNames.add(parameter.getName());
        }
        if (connectionKeys == 0) {
            gatherer.error((Identifiable)connectMethod, (DevkitNotification)Message.CONNECTOR_MISSING_CONNECTION_KEY_PARAM, new Object[0]);
        }
        if (component.overridesAtMessageProcessor()) {
            ConnectionStrategiesVerifierUtils.verifyConnectorProcessorsParams(module, gatherer, connectionParameterNames);
        }
        ConnectionStrategiesVerifierUtils.verifyConfigurableNamesDistinctConnectParamNames(module.getConfigurableFields(), gatherer, connectionParameterNames);
        ConnectionStrategiesVerifierUtils.verifyConfigurableNamesDistinctConnectParamNames(component.getConfigurableFields(), gatherer, connectionParameterNames);
    }
}

