/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.schema.global;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.api.callback.HttpCallback;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.spring.schema.AbstractSchemaBuilder;
import org.mule.devkit.generation.spring.schema.StrategySchemaResolver;
import org.mule.devkit.generation.spring.schema.global.util.GlobalElementSchemaBuilderResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.schema.Attribute;
import org.mule.devkit.model.schema.ComplexContent;
import org.mule.devkit.model.schema.ExplicitGroup;
import org.mule.devkit.model.schema.ExtensionType;
import org.mule.devkit.model.schema.LocalComplexType;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.schema.TopLevelElement;

public abstract class AbstractGlobalElementSchemaBuilder
extends AbstractSchemaBuilder
implements StrategySchemaResolver {
    protected void registerGlobalElementElement(Module module, Context ctx, GlobalElementSchemaBuilderResolver globalElementSchemaBuilderResolver) {
        HashMap<QName, String> otherAttributes = new HashMap<QName, String>();
        ExtensionType config = this.registerExtension(globalElementSchemaBuilderResolver.resolveConfigElementName(module), otherAttributes);
        Attribute nameAttribute = this.createAttribute("name", false, SchemaConstants.STRING, "Give a name to this configuration so it can be later referenced by config-ref.");
        config.getAttributeOrAttributeGroup().add(nameAttribute);
        ExplicitGroup all = new ExplicitGroup();
        config.setSequence(all);
        for (Field variable : module.getInjectFields()) {
            if (!variable.asTypeMirror().toString().equals("org.mule.api.store.ObjectStore")) continue;
            config.getAttributeOrAttributeGroup().add(this.createAttribute("objectStore-ref", true, SchemaConstants.STRING, variable.getJavaDocSummary()));
        }
        List<Field> configurableFields = globalElementSchemaBuilderResolver.resolveConfigurableFields(module);
        this.registerGlobalElementConfigurableFields(config, all, configurableFields);
        globalElementSchemaBuilderResolver.resolvePostGenerationGroup(module, config, all);
        if (module.hasProcessorMethodWithParameter(HttpCallback.class)) {
            this.generateHttpCallbackElement("http-callback-config", all, null);
        }
        if (module.usesPooling()) {
            TopLevelElement poolingProfile = new TopLevelElement();
            poolingProfile.setName("pooling-profile");
            poolingProfile.setType(SchemaConstants.MULE_POOLING_PROFILE_TYPE);
            poolingProfile.setMinOccurs(BigInteger.ZERO);
            poolingProfile.setAnnotation(this.createDocAnnotation("Characteristics of the object pool."));
            all.getParticle().add(this.getObjectFactory().createElement(poolingProfile));
        }
        config.setAnnotation(this.createDocAnnotation(globalElementSchemaBuilderResolver.resolveJavaDocSummary(module)));
        if (all.getParticle().size() == 0) {
            config.setSequence(null);
        }
    }

    private ExtensionType registerExtension(String name, Map<QName, String> otherAttributes) {
        LocalComplexType complexType = new LocalComplexType();
        TopLevelElement extension = new TopLevelElement();
        extension.setName(name);
        extension.setSubstitutionGroup(SchemaConstants.MULE_ABSTRACT_EXTENSION);
        extension.setComplexType(complexType);
        extension.getOtherAttributes().putAll(otherAttributes);
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(SchemaConstants.MULE_ABSTRACT_EXTENSION_TYPE);
        complexContent.setExtension(complexContentExtension);
        this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(extension);
        return complexContentExtension;
    }

    private void registerGlobalElementConfigurableFields(ExtensionType config, ExplicitGroup all, List<Field> configurableFields) {
        for (Field variable : configurableFields) {
            if (variable.asType().isCollection()) {
                this.generateCollectionElement(all, (Variable)variable, false);
                continue;
            }
            if (variable.asType().isComplexType() && !variable.isRefOnly()) {
                this.registerComplexTypeChildElement(all, (Variable)variable, true);
                continue;
            }
            config.getAttributeOrAttributeGroup().add(this.createAttribute((Variable)variable, false));
        }
    }

    protected void generateHttpCallbackElement(String elementName, ExplicitGroup all, OAuthCapability oAuthCapability) {
        Attribute domainAttribute = this.createAttribute("domain", false, SchemaConstants.STRING, null);
        Attribute localPortAttribute = this.createAttribute("localPort", false, SchemaConstants.STRING, null);
        Attribute remotePortAttribute = this.createAttribute("remotePort", true, SchemaConstants.STRING, null);
        Attribute asyncAttribute = this.createAttribute("async", true, SchemaConstants.BOOLEAN, null);
        asyncAttribute.setDefault(SchemaConstants.ASYNC_DEFAULT_VALUE.toString());
        Attribute pathAttribute = this.createAttribute("path", false, SchemaConstants.STRING, null);
        Attribute connectorRefAttribute = this.createAttribute("connector-ref", true, SchemaConstants.STRING, null);
        TopLevelElement httpCallbackConfig = new TopLevelElement();
        httpCallbackConfig.setName(elementName);
        httpCallbackConfig.setMinOccurs(BigInteger.ONE);
        httpCallbackConfig.setMaxOccurs("1");
        httpCallbackConfig.setAnnotation(this.createDocAnnotation("Config for http callbacks."));
        ExtensionType extensionType = new ExtensionType();
        extensionType.setBase(SchemaConstants.MULE_ABSTRACT_EXTENSION_TYPE);
        extensionType.getAttributeOrAttributeGroup().add(localPortAttribute);
        extensionType.getAttributeOrAttributeGroup().add(remotePortAttribute);
        extensionType.getAttributeOrAttributeGroup().add(domainAttribute);
        extensionType.getAttributeOrAttributeGroup().add(asyncAttribute);
        extensionType.getAttributeOrAttributeGroup().add(pathAttribute);
        extensionType.getAttributeOrAttributeGroup().add(connectorRefAttribute);
        if (oAuthCapability != null && oAuthCapability.getOAuthVersion() == OAuthVersion.V2) {
            Attribute defaultAccessTokenId = this.createAttribute("defaultAccessTokenId", true, SchemaConstants.STRING, "A Mule Expression to use as access token id");
            extensionType.getAttributeOrAttributeGroup().add(defaultAccessTokenId);
        }
        ComplexContent complexContent = new ComplexContent();
        complexContent.setExtension(extensionType);
        LocalComplexType localComplexType = new LocalComplexType();
        localComplexType.setComplexContent(complexContent);
        httpCallbackConfig.setComplexType(localComplexType);
        all.getParticle().add(this.getObjectFactory().createElement(httpCallbackConfig));
    }
}

