/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.List;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.devkit.generation.AbstractCapabilityGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.connectivity.metadata.ConnectorMetaDataEnabledUtilsGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConfigurationComponent;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;

public class ConfigurationConnectorAdapterGenerator
extends AbstractCapabilityGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.PROCESS_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.BASIC_CONNECTOR_ADAPTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return !module.manager().configurationComponents().isEmpty();
    }

    public void generate(Module module) {
        for (ConfigurationComponent configurationComponent : module.manager().configurationComponents()) {
            GeneratedClass basicAdapterClass = this.createBasicAdapter(module, configurationComponent);
            ConnectorMetaDataEnabledUtilsGenerator connectorMetaDataEnabledUtilsGenerator = new ConnectorMetaDataEnabledUtilsGenerator();
            connectorMetaDataEnabledUtilsGenerator.setCtx(this.ctx());
            connectorMetaDataEnabledUtilsGenerator.generateGenericTestConnectivity(module, (ConnectionComponent)configurationComponent, basicAdapterClass);
            this.generateMetadataMethods(module, basicAdapterClass);
            basicAdapterClass.javadoc().add((Object)("A <code>" + basicAdapterClass.name() + "</code> is a wrapper around "));
            basicAdapterClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
            basicAdapterClass.javadoc().add((Object)" that represents the strategy ");
            basicAdapterClass.javadoc().add((Object)this.ref(configurationComponent.asTypeMirror()));
        }
    }

    protected void generateMetadataMethods(Module module, GeneratedClass generatedClass) {
        ConnectorMetaDataEnabledUtilsGenerator connectorMetaDataEnabledUtilsGenerator = new ConnectorMetaDataEnabledUtilsGenerator();
        connectorMetaDataEnabledUtilsGenerator.setCtx(this.ctx());
        if (connectorMetaDataEnabledUtilsGenerator.isMetaDataCapable(module)) {
            generatedClass._implements(this.ref(ConnectorMetaDataEnabled.class));
            this.generateMetaDataKeysMethod(module, generatedClass, connectorMetaDataEnabledUtilsGenerator);
            this.generateMetaDataMethod(module, generatedClass, connectorMetaDataEnabledUtilsGenerator);
        }
    }

    private void generateMetaDataMethod(Module module, GeneratedClass generatedClass, ConnectorMetaDataEnabledUtilsGenerator connectorMetaDataEnabledUtilsGenerator) {
        GeneratedMethod getMetadata = generatedClass.method(1, (Type)this.ref(Result.class).narrow(this.ref(MetaData.class)), "getMetaData");
        getMetadata.annotate(Override.class);
        GeneratedVariable key = getMetadata.param((Type)this.ref(MetaDataKey.class), "metaDataKey");
        connectorMetaDataEnabledUtilsGenerator.generateTryMetaDataEntityResolver(module, generatedClass, key, ExpressionFactory._this(), getMetadata.body());
    }

    private void generateMetaDataKeysMethod(Module module, GeneratedClass generatedClass, ConnectorMetaDataEnabledUtilsGenerator connectorMetaDataEnabledUtilsGenerator) {
        GeneratedMethod getMetadataKeys = generatedClass.method(1, (Type)this.ref(String.class), "getMetaDataKeys");
        getMetadataKeys.annotate(Override.class);
        getMetadataKeys.type((Type)this.ref(Result.class).narrow(this.ref(List.class).narrow(this.ref(MetaDataKey.class))));
        connectorMetaDataEnabledUtilsGenerator.generateTryMetaDataKeyResolver(module, generatedClass, ExpressionFactory._this(), getMetadataKeys.body());
    }

    private GeneratedClass createBasicAdapter(Module module, ConfigurationComponent configurationComponent) {
        GeneratedClass previous = (GeneratedClass)this.ctx().getProduct(Product.PROCESS_ADAPTER, (Identifiable)module);
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".adapters");
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass clazz = pkg._class(modifiers, module.getClassName() + configurationComponent.getClassName() + "BasicAdapter", (TypeReference)previous);
        this.ctx().registerProduct(Product.BASIC_CONNECTOR_ADAPTER, (Identifiable)configurationComponent, module.getName(), (Object)clazz);
        return clazz;
    }
}

