/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;

public class AbstractConnectedProcessorGenerator
extends AbstractMuleGenerator
implements MultiModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CONNECTIVITY_PROCESSOR_INTERFACE);
    private static final List<Product> PRODUCES = Arrays.asList(Product.ABSTRACT_CONNECTED_PROCESSOR);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        if (this.isProductRegistered()) {
            return false;
        }
        for (Module module : modules) {
            if (!(module instanceof ManagedConnectionModule) && !(module instanceof OAuthModule) && !module.manager().connectionManagementOverride().isPresent()) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> processableModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (!(module instanceof ManagedConnectionModule) && !(module instanceof OAuthModule) && !module.manager().connectionManagementOverride().isPresent()) continue;
            processableModules.add(module);
        }
        return processableModules;
    }

    protected boolean isProductRegistered() {
        return this.ctx().getProduct(Product.ABSTRACT_CONNECTED_PROCESSOR) != null;
    }

    public void generate(List<Module> modules) throws GenerationException {
        GeneratedClass abstractConnectedProcessorClass = this.getAbstractConnectedProcessorClass(modules.get(0));
        GeneratedMethod constructor = abstractConnectedProcessorClass.constructor(1);
        constructor.param((org.mule.devkit.model.code.Type)this.ref(String.class), "operationName");
        constructor.body().directStatement("super(operationName);");
        for (Module module : modules) {
            if (!(module instanceof ManagedConnectionModule) && !module.manager().connectionManagementOverride().isPresent()) continue;
            ConnectMethod connectMethod = module instanceof ManagedConnectionModule ? ((ManagedConnectionModule)module).getConnectMethod() : ((ConnectionManagementComponent)module.manager().connectionManagementOverride().get()).getConnectMethod();
            Map<String, AbstractMuleGenerator.FieldVariableElement> connectFields = null;
            if (connectMethod != null) {
                connectFields = this.generateFieldForEachParameter(abstractConnectedProcessorClass, (Method)connectMethod, this.privateFieldnames);
            }
            if (connectFields == null) continue;
            for (String fieldName : connectFields.keySet()) {
                abstractConnectedProcessorClass.setter(connectFields.get(fieldName).getField());
                GeneratedMethod getterMethod = abstractConnectedProcessorClass.getter(connectFields.get(fieldName).getField());
                getterMethod.annotate(Override.class);
            }
        }
        GeneratedMethod getTypeForMethod = abstractConnectedProcessorClass.method(1, (org.mule.devkit.model.code.Type)this.ref(Type.class), "typeFor");
        getTypeForMethod.annotate(Override.class);
        getTypeForMethod._throws(NoSuchFieldException.class);
        getTypeForMethod.javadoc().add((Object)"{@inheritDoc}");
        GeneratedVariable fieldNameParameter = getTypeForMethod.param(String.class, "fieldName");
        getTypeForMethod.body()._return((GeneratedExpression)abstractConnectedProcessorClass.dotclass().invoke("getDeclaredField").arg((GeneratedExpression)fieldNameParameter).invoke("getGenericType"));
    }

    protected GeneratedClass getAbstractConnectedProcessorClass(Module type) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(type.getPackage().getName() + ".processors");
        GeneratedClass clazz = pkg._class(33, "AbstractConnectedProcessor", this.ref(DevkitBasedMessageProcessor.class));
        GeneratedClass connectivityProcessorInterface = (GeneratedClass)this.ctx().getProduct(Product.CONNECTIVITY_PROCESSOR_INTERFACE);
        clazz._implements((TypeReference)connectivityProcessorInterface);
        this.ctx().registerProduct(Product.ABSTRACT_CONNECTED_PROCESSOR, (Object)clazz);
        return clazz;
    }
}

