/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.strategies;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.verifiers.strategies.ConnectionStrategiesVerifierUtils;

public class ConnectParametersVerifier
implements ModuleAnnotationVerifier {
    protected List<Parameter<Method<ManagedConnectionModule>>> cparameters;
    protected Set<String> connectionParametersNames;

    public boolean shouldVerify(Module module) {
        return module instanceof ManagedConnectionModule;
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setParameterList((ManagedConnectionModule)module);
        this.fillParameterNameList();
        ConnectionStrategiesVerifierUtils.verifyConfigurableNamesDistinctConnectParamNames(module.getConfigurableFields(), gatherer, this.connectionParametersNames);
        ConnectionStrategiesVerifierUtils.verifyConnectorProcessorsParams(module, gatherer, this.connectionParametersNames);
    }

    public void setParameterList(ManagedConnectionModule module) {
        this.cparameters = module.getConnectMethod().getParameters();
    }

    protected void fillParameterNameList() {
        this.connectionParametersNames = new HashSet<String>(this.cparameters.size());
        for (Parameter<Method<ManagedConnectionModule>> cparameter : this.cparameters) {
            this.connectionParametersNames.add(cparameter.getName());
        }
    }
}

