/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationValue;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.annotations.Mime;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.SourceThreadingModel;
import org.mule.api.annotations.param.Literal;
import org.mule.api.callback.SourceCallback;
import org.mule.api.callback.StopSourceCallback;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.source.ClusterizableMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedArray;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.GeneratedWhileLoop;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.security.oauth.callback.ProcessCallback;
import org.mule.security.oauth.processor.AbstractListeningMessageProcessor;
import org.mule.util.StringUtils;

public class MessageSourceGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, Product.OAUTH_ADAPTER, Product.CONNECTION_MANAGER, Product.POOL_MANAGER, Product.ADAPTER_INTERFACES);
    private static final List<Product> PRODUCES = Arrays.asList(Product.MESSAGE_SOURCE);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) && module.hasSources();
    }

    public void generate(Module module) {
        for (SourceMethod sourceMethod : module.getSourceMethods()) {
            this.generateMessageSource(module, sourceMethod);
        }
    }

    private void generateMessageSource(Module module, SourceMethod sourceMethod) {
        GeneratedClass poolObjectClass;
        if (this.ctx().getProduct(Product.MESSAGE_SOURCE, sourceMethod.parent(), sourceMethod.getName()) != null) {
            return;
        }
        GeneratedClass messageSourceClass = this.getMessageSourceClass(sourceMethod);
        this.generateCustomConstructor(messageSourceClass);
        messageSourceClass.javadoc().add((Object)(messageSourceClass.name() + " wraps "));
        messageSourceClass.javadoc().add((Object)("{@link " + ((org.mule.devkit.model.Type)sourceMethod.parent()).getQualifiedName().toString() + "#"));
        messageSourceClass.javadoc().add((Object)(sourceMethod.getName() + "("));
        boolean first = true;
        for (Parameter variable : sourceMethod.getParameters()) {
            if (!first) {
                messageSourceClass.javadoc().add((Object)", ");
            }
            messageSourceClass.javadoc().add((Object)variable.asTypeMirror().toString().replaceAll("<[a-zA-Z\\-\\.\\<\\>\\s\\,]*>", ""));
            first = false;
        }
        messageSourceClass.javadoc().add((Object)")} method in ");
        messageSourceClass.javadoc().add((Object)this.ref(((org.mule.devkit.model.Type)sourceMethod.parent()).asTypeMirror()));
        messageSourceClass.javadoc().add((Object)" as a message source capable of generating Mule events. ");
        messageSourceClass.javadoc().add((Object)" The POJO's method is invoked in its own thread.");
        Map<String, AbstractMuleGenerator.FieldVariableElement> fields = this.generateFieldForEachParameter(messageSourceClass, (Method)sourceMethod, this.privateFieldnames);
        GeneratedField stopSourceCallback = null;
        if (sourceMethod.getReturnType().toString().contains("StopSourceCallback")) {
            stopSourceCallback = messageSourceClass.field(4, (Type)this.ref(StopSourceCallback.class), "stopSourceCallback");
        }
        GeneratedField thread = null;
        if (sourceMethod.getThreadingModel() == SourceThreadingModel.SINGLE_THREAD) {
            thread = messageSourceClass.field(4, (Type)this.ref(Thread.class), "thread");
            thread.javadoc().add((Object)"Thread under which this message source will execute");
        }
        if (sourceMethod.isPolling()) {
            GeneratedField pollingPeriod = messageSourceClass.field(16, (Type)this.ref(Long.class), "pollingPeriod");
            pollingPeriod.javadoc().add((Object)"Polling Period for SourceStrategy.POLLING");
            messageSourceClass.setter(pollingPeriod);
        }
        this.generateInitialiseMethod(messageSourceClass, fields, module);
        for (String fieldName : fields.keySet()) {
            messageSourceClass.setter(fields.get(fieldName).getField());
        }
        if (sourceMethod.getThreadingModel() == SourceThreadingModel.SINGLE_THREAD) {
            this.generateSingleThreadStartMethod(messageSourceClass, thread);
            this.generateSingleThreadStopMethod(messageSourceClass, thread);
        } else {
            if (module.usesPooling()) {
                poolObjectClass = ((GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module)).topLevelClass();
                this.generateNoThreadStartMethod(messageSourceClass, module, sourceMethod, fields, poolObjectClass, stopSourceCallback);
            } else {
                this.generateNoThreadStartMethod(messageSourceClass, module, sourceMethod, fields, stopSourceCallback);
            }
            this.generateNoThreadStopMethod(messageSourceClass, stopSourceCallback, sourceMethod);
        }
        if (sourceMethod.getThreadingModel() == SourceThreadingModel.SINGLE_THREAD) {
            if (module.usesPooling()) {
                poolObjectClass = ((GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module)).topLevelClass();
                this.generateRunMethod(messageSourceClass, module, sourceMethod, fields, poolObjectClass, stopSourceCallback);
            } else {
                this.generateRunMethod(messageSourceClass, module, sourceMethod, fields, stopSourceCallback);
            }
        }
    }

    private void generateRunMethod(GeneratedClass messageSourceClass, Module module, SourceMethod sourceMethod, Map<String, AbstractMuleGenerator.FieldVariableElement> fields, GeneratedField stopSourceCallback) {
        this.generateRunMethod(messageSourceClass, module, sourceMethod, fields, null, stopSourceCallback);
    }

    private void generateRunMethod(GeneratedClass messageSourceClass, Module module, SourceMethod sourceMethod, Map<String, AbstractMuleGenerator.FieldVariableElement> fields, GeneratedClass poolObjectClass, GeneratedField stopSourceCallback) {
        String methodName = sourceMethod.getName();
        GeneratedMethod run = messageSourceClass.method(1, (Type)this.ctx().getCodeModel().VOID, "run");
        run.javadoc().add((Object)"Implementation {@link Runnable#run()} that will invoke the method on the pojo that this message source wraps.");
        this.generateSourceExecution(run.body(), module, sourceMethod, fields, poolObjectClass, methodName, stopSourceCallback);
    }

    private void generateSourceExecution(GeneratedBlock body, Module module, SourceMethod sourceMethod, Map<String, AbstractMuleGenerator.FieldVariableElement> fields, GeneratedClass poolObjectClass, String methodName, GeneratedField stopSourceCallback) {
        GeneratedVariable poolObject = poolObjectClass != null ? body.decl((Type)poolObjectClass, "poolObject", ExpressionFactory._null()) : null;
        GeneratedVariable moduleObject = body.decl((Type)this.ref(Object.class), "moduleObject", ExpressionFactory._null());
        GeneratedTry callSource = body._try();
        GeneratedInvocation findOrCreate = ExpressionFactory.invoke((String)"findOrCreate").arg(ExpressionFactory._null());
        findOrCreate.arg(ExpressionFactory.FALSE);
        findOrCreate.arg(ExpressionFactory._null());
        callSource.body().assign((AssignmentTarget)moduleObject, (GeneratedExpression)findOrCreate);
        GeneratedVariable processTemplate = callSource.body().decl(8, (Type)this.ref(ProcessTemplate.class).narrow(this.ref(Object.class)).narrow(this.ref(Object.class)), "processTemplate", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ProcessAdapter.class).narrow(this.ref(Object.class)), (GeneratedExpression)moduleObject).invoke("getProcessTemplate"));
        GeneratedVariable sourceCallback = callSource.body().decl(8, (Type)this.ref(SourceCallback.class), "sourceCallback", ExpressionFactory._this());
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (Parameter variable : sourceMethod.getParameters()) {
            if (variable.asTypeMirror().toString().startsWith(SourceCallback.class.getName())) {
                parameters.add(sourceCallback);
                continue;
            }
            String fieldName = variable.getName();
            if (variable.hasAnnotation(Literal.class)) {
                GeneratedVariable decl = this.getGeneratedVariableWithoutExpresionEvaluation(callSource, variable);
                parameters.add(decl);
                continue;
            }
            if (SchemaTypeConversion.isSupported((String)fields.get(fieldName).getVariable().asTypeMirror().toString()) || fields.get(fieldName).getVariable().asType().isCollection() || fields.get(fieldName).getVariable().asType().isEnum()) {
                GeneratedVariable transformed = this.getTransformedGeneratedVariable(fields, callSource, variable, fieldName);
                parameters.add(transformed);
                continue;
            }
            parameters.add(fields.get(fieldName).getField());
        }
        GeneratedClass executionCallback = this.ctx().getCodeModel().anonymousClass(this.ref(ProcessCallback.class).narrow(this.ref(Object.class)).narrow(this.ref(Object.class)));
        GeneratedMethod getManagedExceptions = executionCallback.method(1, (Type)this.ref(List.class).narrow(this.ref(Class.class).narrow(this.ref(Exception.class).wildcard())), "getManagedExceptions");
        this.generateManagedExceptions(module, sourceMethod, getManagedExceptions);
        GeneratedMethod isProtected = executionCallback.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isProtected");
        isProtected.body()._return(ExpressionFactory.FALSE);
        GeneratedMethod process = executionCallback.method(1, (Type)this.ref(Object.class), "process");
        GeneratedVariable object2 = process.param((Type)this.ref(Object.class), "object");
        process._throws(this.ref(Exception.class));
        GeneratedInvocation methodCall = ExpressionFactory.cast((Type)this.searchForModuleWithMethod(module, methodName), (GeneratedExpression)object2).invoke(methodName);
        for (GeneratedExpression generatedExpression : parameters) {
            methodCall.arg(generatedExpression);
        }
        this.generateMessageSourceCallbackExecution(sourceMethod, callSource, processTemplate, executionCallback);
        if (sourceMethod.getReturnType().toString().contains("StopSourceCallback")) {
            process.body().assign((AssignmentTarget)stopSourceCallback, (GeneratedExpression)methodCall);
            process.body()._return(ExpressionFactory._null());
        } else {
            process.body().add((Statement)methodCall);
            process.body()._return(ExpressionFactory._null());
        }
        if (sourceMethod.getThrownTypes().size() > 0) {
            GeneratedCatchBlock catchMessagingException = callSource._catch(this.ref(MessagingException.class));
            GeneratedVariable generatedVariable = catchMessagingException.param("e");
            catchMessagingException.body().add((Statement)ExpressionFactory.invoke((String)"getFlowConstruct").invoke("getExceptionListener").invoke("handleException").arg((GeneratedExpression)generatedVariable).arg((GeneratedExpression)generatedVariable.invoke("getEvent")));
        }
        GeneratedCatchBlock catchException = callSource._catch(this.ref(Exception.class));
        GeneratedVariable generatedVariable = catchException.param("e");
        catchException.body().add((Statement)ExpressionFactory.invoke((String)"getMuleContext").invoke("getExceptionListener").invoke("handleException").arg((GeneratedExpression)generatedVariable));
        if (poolObjectClass != null) {
            GeneratedBlock fin = callSource._finally();
            GeneratedBlock poolObjectNotNull = fin._if(poolObject.isNotNull())._then();
            poolObjectNotNull.add((Statement)ExpressionFactory.cast((Type)((TypeReference)this.ctx().getProduct(Product.POOL_MANAGER_INTERFACE)), (GeneratedExpression)moduleObject).invoke("getLifecyleEnabledObjectPool").invoke("returnObject").arg((GeneratedExpression)poolObject));
        }
    }

    private GeneratedVariable getTransformedGeneratedVariable(Map<String, AbstractMuleGenerator.FieldVariableElement> fields, GeneratedTry callSource, Parameter variable, String fieldName) {
        GeneratedInvocation getGenericType = ExpressionFactory.invoke((String)"getClass").invoke("getDeclaredField").arg(ExpressionFactory.lit((String)("_" + variable.getName() + "Type"))).invoke("getGenericType");
        GeneratedInvocation transform = ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext")).arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (GeneratedExpression)ExpressionFactory._null())).arg((GeneratedExpression)getGenericType);
        Mime mime = (Mime)variable.getAnnotation(Mime.class);
        if (mime != null) {
            transform.arg(ExpressionFactory.lit((String)mime.value()));
        } else {
            transform.arg(ExpressionFactory._null());
        }
        transform.arg((GeneratedExpression)ExpressionFactory.ref((String)variable.getName()));
        Type typeRef = this.ref(fields.get(fieldName).getVariable().asTypeMirror());
        return callSource.body().decl(8, (Type)typeRef.boxify(), "transformed" + org.apache.commons.lang.StringUtils.capitalize((String)fieldName), (GeneratedExpression)ExpressionFactory.cast((Type)typeRef.boxify(), (GeneratedExpression)transform));
    }

    private GeneratedVariable getGeneratedVariableWithoutExpresionEvaluation(GeneratedTry callSource, Parameter variable) {
        TypeReference varType = variable.getJavaType().equals(new TypeToken<List<String>>(){}.getType().toString()) ? this.ref(List.class) : this.ref(String.class);
        GeneratedCast cast = ExpressionFactory.cast((Type)varType, (GeneratedExpression)ExpressionFactory._this().ref(variable.getName()));
        return callSource.body().decl(8, (Type)varType, "_not_evaluated" + StringUtils.capitalize((String)variable.getName()), (GeneratedExpression)cast);
    }

    private Type searchForModuleWithMethod(Module module, String methodName) {
        if (module.hasMethodWithName(methodName)) {
            return this.ref((org.mule.devkit.model.Type)module);
        }
        if (!module.getName().equals("Object")) {
            return this.searchForModuleWithMethod(module.parentModule(), methodName);
        }
        return this.ref((org.mule.devkit.model.Type)module);
    }

    private void generateSingleThreadStartMethod(GeneratedClass messageSourceClass, GeneratedField thread) {
        GeneratedMethod start = messageSourceClass.method(1, (Type)this.ctx().getCodeModel().VOID, "start");
        start.javadoc().add((Object)"Method to be called when Mule instance gets started.");
        start._throws(this.ref(MuleException.class));
        GeneratedConditional ifNoThread = start.body()._if(thread.isNull());
        GeneratedInvocation newThread = ExpressionFactory._new((TypeReference)this.ref(Thread.class));
        newThread.arg(ExpressionFactory._this());
        newThread.arg("Receiving Thread");
        ifNoThread._then().assign((AssignmentTarget)thread, (GeneratedExpression)newThread);
        start.body().add((Statement)thread.invoke("start"));
    }

    private void generateSingleThreadStopMethod(GeneratedClass messageSourceClass, GeneratedField thread) {
        GeneratedMethod stop = messageSourceClass.method(1, (Type)this.ctx().getCodeModel().VOID, "stop");
        stop.javadoc().add((Object)"Method to be called when Mule instance gets stopped.");
        stop._throws(this.ref(MuleException.class));
        stop.body().add((Statement)thread.invoke("interrupt"));
    }

    private void generateNoThreadStartMethod(GeneratedClass messageSourceClass, Module module, SourceMethod sourceMethod, Map<String, AbstractMuleGenerator.FieldVariableElement> fields, GeneratedField stopSourceCallback) {
        this.generateNoThreadStartMethod(messageSourceClass, module, sourceMethod, fields, null, stopSourceCallback);
    }

    private void generateNoThreadStartMethod(GeneratedClass messageSourceClass, Module module, SourceMethod sourceMethod, Map<String, AbstractMuleGenerator.FieldVariableElement> fields, GeneratedClass poolObjectClass, GeneratedField stopSourceCallback) {
        String methodName = sourceMethod.getName();
        GeneratedMethod start = messageSourceClass.method(1, (Type)this.ctx().getCodeModel().VOID, "start");
        start.javadoc().add((Object)"Method to be called when Mule instance gets started.");
        start._throws(this.ref(MuleException.class));
        this.generateSourceExecution(start.body(), module, sourceMethod, fields, poolObjectClass, methodName, stopSourceCallback);
    }

    private void generateNoThreadStopMethod(GeneratedClass messageSourceClass, GeneratedField stopSourceCallback, SourceMethod sourceMethod) {
        String methodName = sourceMethod.getName();
        GeneratedMethod stop = messageSourceClass.method(1, (Type)this.ctx().getCodeModel().VOID, "stop");
        stop.javadoc().add((Object)"Method to be called when Mule instance gets stopped.");
        stop._throws(this.ref(MuleException.class));
        if (stopSourceCallback != null) {
            GeneratedConditional ifStopCallbackNotNull = stop.body()._if(stopSourceCallback.isNotNull());
            GeneratedTry tryToStop = ifStopCallbackNotNull._then()._try();
            tryToStop.body().add((Statement)stopSourceCallback.invoke("stop"));
            GeneratedCatchBlock catchException = tryToStop._catch(this.ref(Exception.class));
            GeneratedVariable e = catchException.param("e");
            GeneratedInvocation messagingException = ExpressionFactory._new((TypeReference)this.ref(MessagingException.class));
            messagingException.arg((GeneratedExpression)this.ref(CoreMessages.class).staticInvoke("failedToStop").arg(methodName));
            messagingException.arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (GeneratedExpression)ExpressionFactory._null()));
            messagingException.arg((GeneratedExpression)e);
            catchException.body()._throw((GeneratedExpression)messagingException);
        }
    }

    private GeneratedClass getMessageSourceClass(SourceMethod sourceMethod) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((org.mule.devkit.model.Type)sourceMethod.parent()).getPackage().getName() + ".sources");
        ArrayList<Class<MessageSource>> inherits = new ArrayList<Class<MessageSource>>();
        inherits.add(MuleContextAware.class);
        inherits.add(Startable.class);
        inherits.add(Stoppable.class);
        inherits.add(FlowConstructAware.class);
        if (((Source)sourceMethod.getAnnotation(Source.class)).threadingModel() == SourceThreadingModel.SINGLE_THREAD) {
            inherits.add(Runnable.class);
        }
        if (((Source)sourceMethod.getAnnotation(Source.class)).primaryNodeOnly()) {
            inherits.add(ClusterizableMessageSource.class);
        } else {
            inherits.add(MessageSource.class);
        }
        GeneratedClass clazz = pkg._class(sourceMethod.getCapitalizedName() + "MessageSource", this.ref(AbstractListeningMessageProcessor.class), inherits.toArray(new Class[inherits.size()]));
        this.ctx().registerProduct(Product.MESSAGE_SOURCE, sourceMethod.parent(), sourceMethod.getName(), (Object)clazz);
        return clazz;
    }

    public void generateManagedExceptions(Module module, SourceMethod sourceMethod, GeneratedMethod getManagedExceptions) {
        ArrayList<GeneratedExpression> exceptionClasses = new ArrayList<GeneratedExpression>();
        List reconnectionModuleExceptions = module.reconnectOn();
        List reconnectionSourceExceptions = sourceMethod.reconnectOn();
        if (!reconnectionSourceExceptions.isEmpty()) {
            for (AnnotationValue reconnectionException : reconnectionSourceExceptions) {
                exceptionClasses.add(this.ref(reconnectionException.getValue().toString()).boxify().dotclass());
            }
        } else if (!reconnectionModuleExceptions.isEmpty()) {
            for (AnnotationValue reconnectionException : reconnectionModuleExceptions) {
                exceptionClasses.add(this.ref(reconnectionException.getValue().toString()).boxify().dotclass());
            }
        }
        if (exceptionClasses.isEmpty()) {
            getManagedExceptions.body()._return(ExpressionFactory._null());
        } else {
            GeneratedArray newExceptionArray = ExpressionFactory.newArray((Type)this.ref(Class.class));
            for (GeneratedExpression generatedExpression : exceptionClasses) {
                newExceptionArray.add(generatedExpression);
            }
            getManagedExceptions.body()._return((GeneratedExpression)this.ref(Arrays.class).staticInvoke("asList").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(Class.class).narrow(this.ref(Exception.class).wildcard()).array(), (GeneratedExpression)newExceptionArray)));
        }
    }

    private void generateMessageSourceCallbackExecution(SourceMethod sourceMethod, GeneratedTry callSource, GeneratedVariable processTemplate, GeneratedClass executionCallback) {
        if (sourceMethod.isPolling()) {
            GeneratedWhileLoop callSourceWhile = callSource.body()._while(ExpressionFactory.ref((String)"Thread").invoke("currentThread").invoke("isInterrupted").not());
            callSourceWhile.body().add((Statement)processTemplate.invoke("execute").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)executionCallback)).arg(ExpressionFactory._null()).arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (GeneratedExpression)ExpressionFactory._null())));
            callSourceWhile.body().add((Statement)ExpressionFactory.ref((String)"Thread").invoke("currentThread").invoke("sleep").arg((GeneratedExpression)ExpressionFactory.ref((String)"pollingPeriod")));
        } else {
            callSource.body().add((Statement)processTemplate.invoke("execute").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)executionCallback)).arg(ExpressionFactory._null()).arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (GeneratedExpression)ExpressionFactory._null())));
        }
    }
}

