/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.connectivity.AbstractConnectedProcessorGenerator;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.security.oauth.processor.AbstractListeningMessageProcessor;

public class AbstractConnectedInterceptingProcessorGenerator
extends AbstractConnectedProcessorGenerator {
    private static final List<Product> PRODUCES = Arrays.asList(Product.ABSTRACT_CONNECTED_INTERCEPTING_PROCESSOR);

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public boolean shouldGenerate(List<Module> modules) {
        if (super.shouldGenerate(modules)) {
            return this.hasInterceptingProcessors(modules);
        }
        return false;
    }

    @Override
    protected boolean isProductRegistered() {
        return this.ctx().getProduct(Product.ABSTRACT_CONNECTED_INTERCEPTING_PROCESSOR) != null;
    }

    @Override
    protected GeneratedClass getAbstractConnectedProcessorClass(Module type) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(type.getPackage().getName() + ".processors");
        GeneratedClass clazz = pkg._class(33, "AbstractConnectedInterceptingProcessor", this.ref(AbstractListeningMessageProcessor.class));
        GeneratedClass connectivityProcessorInterface = (GeneratedClass)this.ctx().getProduct(Product.CONNECTIVITY_PROCESSOR_INTERFACE);
        clazz._implements((TypeReference)connectivityProcessorInterface);
        this.ctx().registerProduct(Product.ABSTRACT_CONNECTED_INTERCEPTING_PROCESSOR, (Object)clazz);
        return clazz;
    }

    private boolean hasInterceptingProcessors(List<Module> modules) {
        for (Module module : modules) {
            for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
                if (!processorMethod.isIntercepting()) continue;
                return true;
            }
        }
        return false;
    }
}

