/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.strategies;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.TestConnectivity;
import org.mule.api.annotations.ws.WsdlSecurityStrategyResolver;
import org.mule.api.annotations.ws.WsdlServiceAddressResolver;
import org.mule.api.annotations.ws.WsdlServiceDefinitionRetriever;
import org.mule.api.annotations.ws.WsdlTransportResolver;
import org.mule.devkit.api.ws.authentication.WsdlSecurityStrategy;
import org.mule.devkit.api.ws.definition.ServiceDefinition;
import org.mule.devkit.api.ws.transport.WsdlTransport;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.WsdlProviderComponent;
import org.mule.devkit.verifiers.metadata.MetaDataAnnotationVerifierUtils;
import org.mule.devkit.verifiers.strategies.ConnectionStrategiesVerifierUtils;
import org.mule.devkit.verifiers.util.VerifierUtils;

public class WsdlProviderAnnotationVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return !module.manager().wsdlProviderComponent().isEmpty();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        for (WsdlProviderComponent wsdlProviderComponent : module.manager().wsdlProviderComponent()) {
            this.verifyWsdlComponent(module, gatherer, wsdlProviderComponent);
        }
        this.verifyNoProcessors(module, gatherer);
        this.verifyNoConfigurables(module, gatherer);
        this.verifyCompatibleComponents(module, module.manager().wsdlProviderComponent(), gatherer);
        this.verifyMinMuleVersion(module, gatherer);
    }

    private void verifyMinMuleVersion(Module module, NotificationGatherer gatherer) {
        String minSupporterWsdlProviderVersion = "3.7";
        if (!module.getMinMuleVersion().atLeast(minSupporterWsdlProviderVersion)) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.MIN_MULE_VERSION_FEATURE_SUPPORT, new Object[]{minSupporterWsdlProviderVersion, "@WsdlProvider", module.getMinMuleVersion().toString()});
        }
    }

    private void verifyCompatibleComponents(Module module, List<WsdlProviderComponent> components, NotificationGatherer gatherer) {
        if (!components.isEmpty()) {
            LinkedList<String> foundSeparators = new LinkedList<String>();
            LinkedList<String> foundLabels = new LinkedList<String>();
            LinkedList<String> serviceDefinitionRetrieverReturnTypes = new LinkedList<String>();
            for (WsdlProviderComponent component : components) {
                if (!foundSeparators.contains(component.keySeparator())) {
                    foundSeparators.add(component.keySeparator());
                }
                if (!foundLabels.contains(component.plainedKeyLabels())) {
                    foundLabels.add(component.plainedKeyLabels());
                }
                if (serviceDefinitionRetrieverReturnTypes.contains(component.wsdlServiceDefinitionRetrieverMethod().getReturnType().toString())) continue;
                serviceDefinitionRetrieverReturnTypes.add(component.wsdlServiceDefinitionRetrieverMethod().getReturnType().toString());
            }
            this.verifySameSeparator(module, gatherer, foundSeparators);
            this.verifySameLabels(module, gatherer, foundLabels);
            this.verifySameReturnTypes(module, gatherer, serviceDefinitionRetrieverReturnTypes);
        }
    }

    private void verifySameReturnTypes(Module module, NotificationGatherer gatherer, List<String> serviceDefinitionRetrieverReturnTypes) {
        if (serviceDefinitionRetrieverReturnTypes.size() != 1) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.SERVICE_DEFINITION_MULTIPLE_RETURN_TYPES, new Object[]{StringUtils.join(serviceDefinitionRetrieverReturnTypes, (String)" - ")});
        }
    }

    private void verifySameLabels(Module module, NotificationGatherer gatherer, List<String> foundLabels) {
        if (foundLabels.size() != 1) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.INVALID_KEY_SEPARATOR_INCONSISTENT, new Object[]{StringUtils.join(foundLabels, (String)" - ")});
        }
    }

    private void verifySameSeparator(Module module, NotificationGatherer gatherer, List<String> foundSeparators) {
        if (foundSeparators.size() != 1) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.INVALID_KEY_SEPARATOR_INCONSISTENT, new Object[]{StringUtils.join(foundSeparators, (String)" - ")});
        }
    }

    private void verifyWsdlComponent(Module module, NotificationGatherer gatherer, WsdlProviderComponent wsdlProviderComponent) {
        this.verifyServiceDefinitionRetriever(module, wsdlProviderComponent, gatherer);
        this.verifyServiceAddressResolver(module, wsdlProviderComponent, gatherer);
        this.verifyWsdlSecurityStrategyResolver(module, wsdlProviderComponent, gatherer);
        this.verifyWsdlTransportResolver(module, wsdlProviderComponent, gatherer);
        this.verifyKeySeparator(module, wsdlProviderComponent, gatherer);
        this.verifyKeyLabels(module, wsdlProviderComponent, gatherer);
        ConnectionStrategiesVerifierUtils.verifyConnectionComponentConfigurablesGetterAndSetter(gatherer, (ConnectionComponent)wsdlProviderComponent);
        ConnectionStrategiesVerifierUtils.verifyConfigurablesNames(module, gatherer, (ConnectionComponent)wsdlProviderComponent);
        ConnectionStrategiesVerifierUtils.verifyTestConnectionMethod((ConnectionComponent)wsdlProviderComponent, wsdlProviderComponent.getMethodsAnnotatedWith(TestConnectivity.class), gatherer);
    }

    private void verifyNoProcessors(Module module, NotificationGatherer gatherer) {
        if (!module.getMethodsAnnotatedWith(Processor.class).isEmpty()) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.NO_PROCESSORS_ALLOWED_IN_CLASS_WITH_WSDL_PROVIDER, new Object[]{module.getClassName()});
        }
    }

    private void verifyNoConfigurables(Module module, NotificationGatherer gatherer) {
        if (!module.getConfigurableFields().isEmpty()) {
            gatherer.errorAll(module.getConfigurableFields(), (DevkitNotification)Message.NO_CONFIGURABLES_ALLOWED_IN_CLASS_WITH_WSDL_PROVIDER, new Object[]{module.getClassName()});
        }
    }

    private void verifyServiceDefinitionRetriever(Module module, WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        Method serviceRetriever = wsdlProviderComponent.getFirstMethodAnnotatedWith(WsdlServiceDefinitionRetriever.class);
        if (serviceRetriever != null) {
            Type wsdlServiceList;
            if (wsdlProviderComponent.getRecursivelyMethodsAnnotatedWith(WsdlServiceDefinitionRetriever.class).size() != 1) {
                gatherer.error((Identifiable)serviceRetriever, (DevkitNotification)Message.TOO_MANY_METHODS_ANNOTATED_WITH_IN_WSDL_PROVIDER, new Object[]{WsdlServiceDefinitionRetriever.class.getName(), 1, wsdlProviderComponent.getMethodsAnnotatedWith(WsdlServiceDefinitionRetriever.class).size()});
            }
            if (!VerifierUtils.returnTypeEqualsType(serviceRetriever, (wsdlServiceList = new TypeToken<List<ServiceDefinition>>(){}.getType()).toString()) && !VerifierUtils.returnTypeEqualsType(serviceRetriever, ServiceDefinition.class.getName())) {
                gatherer.error((Identifiable)serviceRetriever, (DevkitNotification)Message.ANNOTATED_METHOD_RETURN_TYPE, new Object[]{WsdlServiceDefinitionRetriever.class.getName(), wsdlServiceList.toString() + " or " + ServiceDefinition.class.getName()});
            }
            if (!serviceRetriever.getParameters().isEmpty()) {
                gatherer.error((Identifiable)serviceRetriever, (DevkitNotification)Message.ANNOTATED_METHOD_NO_PARAMS, new Object[]{WsdlServiceDefinitionRetriever.class.getName()});
            }
        } else {
            gatherer.error((Identifiable)wsdlProviderComponent, (DevkitNotification)Message.MISSING_METHOD_ANNOTATED_WITH_IN_WSDL_PROVIDER, new Object[]{WsdlServiceDefinitionRetriever.class.getName()});
        }
    }

    private void verifyServiceAddressResolver(Module module, WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        Method addressResolver = wsdlProviderComponent.getFirstMethodAnnotatedWith(WsdlServiceAddressResolver.class);
        if (addressResolver != null) {
            if (wsdlProviderComponent.getRecursivelyMethodsAnnotatedWith(WsdlServiceAddressResolver.class).size() != 1) {
                gatherer.error((Identifiable)addressResolver, (DevkitNotification)Message.TOO_MANY_METHODS_ANNOTATED_WITH_IN_WSDL_PROVIDER, new Object[]{WsdlServiceAddressResolver.class.getName(), 1, wsdlProviderComponent.getMethodsAnnotatedWith(WsdlServiceAddressResolver.class).size()});
            }
            if (!VerifierUtils.returnTypeEqualsType(addressResolver, String.class.getName())) {
                gatherer.error((Identifiable)addressResolver, (DevkitNotification)Message.ANNOTATED_METHOD_RETURN_TYPE, new Object[]{WsdlServiceAddressResolver.class.getName(), String.class.getName()});
            }
            if (!VerifierUtils.parametersMatchExpectedTypes(addressResolver, ServiceDefinition.class)) {
                gatherer.error((Identifiable)addressResolver, (DevkitNotification)Message.INVALID_PARAMETERS_FOR_METHOD_ONLY_ALLOWED, new Object[]{WsdlServiceAddressResolver.class.getName(), ServiceDefinition.class.getName()});
            }
        } else {
            gatherer.error((Identifiable)wsdlProviderComponent, (DevkitNotification)Message.MISSING_METHOD_ANNOTATED_WITH_IN_WSDL_PROVIDER, new Object[]{WsdlServiceAddressResolver.class.getName()});
        }
    }

    private void verifyWsdlSecurityStrategyResolver(Module module, WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        Method strategyResolver = wsdlProviderComponent.getFirstMethodAnnotatedWith(WsdlSecurityStrategyResolver.class);
        if (strategyResolver != null) {
            Type wsdlSecurityList = new TypeToken<List<WsdlSecurityStrategy>>(){}.getType();
            if (!VerifierUtils.returnTypeEqualsType(strategyResolver, wsdlSecurityList.toString())) {
                gatherer.error((Identifiable)strategyResolver, (DevkitNotification)Message.ANNOTATED_METHOD_RETURN_TYPE, new Object[]{WsdlSecurityStrategyResolver.class.getName(), wsdlSecurityList.toString()});
            }
            if (!strategyResolver.getParameters().isEmpty()) {
                gatherer.error((Identifiable)strategyResolver, (DevkitNotification)Message.ANNOTATED_METHOD_NO_PARAMS, new Object[]{WsdlSecurityStrategyResolver.class.getName()});
            }
        }
    }

    private void verifyWsdlTransportResolver(Module module, WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        Method transportResolver = wsdlProviderComponent.getFirstMethodAnnotatedWith(WsdlTransportResolver.class);
        if (transportResolver != null) {
            if (!VerifierUtils.returnTypeEqualsType(transportResolver, WsdlTransport.class.getName())) {
                gatherer.error((Identifiable)transportResolver, (DevkitNotification)Message.ANNOTATED_METHOD_RETURN_TYPE, new Object[]{WsdlTransportResolver.class.getName(), WsdlTransport.class.getName()});
            }
            if (!VerifierUtils.parametersMatchExpectedTypes(transportResolver, ServiceDefinition.class)) {
                gatherer.error((Identifiable)transportResolver, (DevkitNotification)Message.INVALID_PARAMETERS_FOR_METHOD_ONLY_ALLOWED, new Object[]{WsdlTransportResolver.class.getName(), ServiceDefinition.class.getName()});
            }
        }
    }

    private void verifyKeySeparator(Module module, WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        MetaDataAnnotationVerifierUtils.verifyMetaDataKeySeparator(wsdlProviderComponent.wsdlServiceDefinitionRetrieverMethod(), wsdlProviderComponent.keySeparator(), gatherer);
    }

    private void verifyKeyLabels(Module module, WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        List labels = wsdlProviderComponent.keyLabels();
        MetaDataAnnotationVerifierUtils.verifyMetaDataKeyLabels(wsdlProviderComponent.wsdlServiceDefinitionRetrieverMethod(), labels, gatherer);
        Type wsdlServiceList = new TypeToken<List<ServiceDefinition>>(){}.getType();
        if (VerifierUtils.returnTypeEqualsType(wsdlProviderComponent.wsdlServiceDefinitionRetrieverMethod(), ServiceDefinition.class.getName()) && labels.size() != 1) {
            gatherer.error((Identifiable)wsdlProviderComponent.wsdlServiceDefinitionRetrieverMethod(), (DevkitNotification)Message.INVALID_NUMBER_OF_KEY_LABELS, new Object[]{String.format("Expected 1 label but %s were found. Override the default labels when returning a single ServiceDefinition", labels.size())});
        } else if (VerifierUtils.returnTypeEqualsType(wsdlProviderComponent.wsdlServiceDefinitionRetrieverMethod(), wsdlServiceList.toString()) && labels.size() != 2) {
            gatherer.error((Identifiable)wsdlProviderComponent.wsdlServiceDefinitionRetrieverMethod(), (DevkitNotification)Message.INVALID_NUMBER_OF_KEY_LABELS, new Object[]{String.format("Expected 2 labels but %s were found. Two labels are required when overriding the defaults", labels.size())});
        }
    }
}

