/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.strategies;

import org.mule.api.annotations.TestConnectivity;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConfigurationComponent;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.verifiers.strategies.ConnectionStrategiesVerifierUtils;

public class ConfigurationVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return !module.manager().configurationComponents().isEmpty();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.verifyOnlyStrategyIsUsed(module, gatherer);
        for (ConfigurationComponent component : module.manager().configurationComponents()) {
            if (!component.hasNoArgConstructor()) {
                gatherer.error((Identifiable)component, (DevkitNotification)Message.NO_ARGS_CONSTRUCTOR_REQUIRED, new Object[0]);
            }
            this.verifyTestConnectionMethod(component, gatherer);
            ConnectionStrategiesVerifierUtils.verifyConfigurablesNames(module, gatherer, (ConnectionComponent)component);
            ConnectionStrategiesVerifierUtils.verifyConnectionComponentConfigurablesGetterAndSetter(gatherer, (ConnectionComponent)component);
            ConnectionStrategiesVerifierUtils.verifyConfigurablesNames(module, gatherer, (ConnectionComponent)component);
            ConnectionStrategiesVerifierUtils.verifyNoConnectMethods(module, gatherer, (ConnectionComponent)component);
        }
    }

    private void verifyTestConnectionMethod(ConfigurationComponent configurationComponent, NotificationGatherer gatherer) {
        ConnectionStrategiesVerifierUtils.verifyTestConnectionMethod((ConnectionComponent)configurationComponent, configurationComponent.getMethodsAnnotatedWith(TestConnectivity.class), gatherer);
    }

    private void verifyOnlyStrategyIsUsed(Module module, NotificationGatherer gatherer) {
        if (module instanceof ManagedConnectionModule) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.CONNECTOR_HAS_CONNECTIONSTRATEGY_AND_CONNECT_ANNOTATIONS, new Object[]{module.getName()});
        }
    }
}

