/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;

public class ParamAnnotationVerifierTemplate {
    private List<Method> unSupportedMethods;
    private List<Method> supportedMethods;
    private List<String> supportedTypes;
    private Class<? extends Annotation> annotation;
    private Message supportedTypesMessage = Message.LITERAL_SUPPORTS_STRING_OR_LIST;
    private Message supportedMethodsMessage = Message.LITERAL_SUPPORT;

    public ParamAnnotationVerifierTemplate(Class<? extends Annotation> annotation, Message supportedTypesMessage, Message supportedMethodsMessage) {
        this.annotation = annotation;
        this.supportedMethodsMessage = supportedMethodsMessage;
        this.supportedTypesMessage = supportedTypesMessage;
        this.supportedMethods = new LinkedList<Method>();
        this.unSupportedMethods = new LinkedList<Method>();
        this.supportedTypes = new LinkedList<String>();
    }

    public void addUnSupportedMethods(List<? extends Method> methods) {
        this.unSupportedMethods.addAll(methods);
    }

    public void addSupportedMethods(List<? extends Method> methods) {
        this.supportedMethods.addAll(methods);
    }

    public void addSupportedType(String type) {
        this.supportedTypes.add(type);
    }

    public void checkAnnotation(Module module, NotificationGatherer gatherer) {
        this.verifyOnUnsupportedMethods(module, gatherer);
        this.verifyOnSupportedMethods(module, gatherer);
    }

    private void verifyOnSupportedMethods(Module module, NotificationGatherer gatherer) {
        for (Method method : this.supportedMethods) {
            this.checkSupportedType(module, (Method<Type>)method, gatherer);
        }
    }

    private void verifyOnUnsupportedMethods(Module module, NotificationGatherer gatherer) {
        for (Method method : this.unSupportedMethods) {
            this.checkMustNotUse(module, (Method<Type>)method, gatherer);
        }
    }

    private void checkMustNotUse(Module module, Method<Type> method, NotificationGatherer gatherer) {
        for (Parameter variable : method.getParameters()) {
            if (!variable.hasAnnotation(this.annotation)) continue;
            gatherer.error((Identifiable)variable, (DevkitNotification)this.supportedMethodsMessage, new Object[0]);
        }
    }

    private void checkSupportedType(Module module, Method<Type> method, NotificationGatherer gatherer) {
        for (Parameter variable : method.getParameters()) {
            if (!variable.hasAnnotation(this.annotation) || this.typeIsSupportedBy(variable)) continue;
            gatherer.error((Identifiable)variable, (DevkitNotification)this.supportedTypesMessage, new Object[0]);
        }
    }

    private boolean typeIsSupportedBy(Parameter variable) {
        return this.supportedTypes.contains(variable.getJavaType());
    }
}

