/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.schema.global;

import java.util.List;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.spring.schema.RegisteredElements;
import org.mule.devkit.generation.spring.schema.global.AbstractGlobalElementSchemaBuilder;
import org.mule.devkit.generation.spring.schema.global.util.GlobalElementSchemaBuilderResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.WsdlProviderComponent;
import org.mule.devkit.model.schema.Attribute;
import org.mule.devkit.model.schema.ComplexContent;
import org.mule.devkit.model.schema.ExplicitGroup;
import org.mule.devkit.model.schema.ExtensionType;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.devkit.model.schema.TopLevelComplexType;

public class WsdlProviderSchemaResolver
extends AbstractGlobalElementSchemaBuilder {
    private RegisteredElements registeredElements;

    public WsdlProviderSchemaResolver(RegisteredElements registeredElements) {
        this.registeredElements = registeredElements;
    }

    @Override
    protected RegisteredElements getRegisteredElements() {
        return this.registeredElements;
    }

    @Override
    public void buildGlobalElementElement(Module module, Context ctx) {
        for (WsdlProviderComponent wsdlProviderComponent : module.manager().wsdlProviderComponent()) {
            this.registerGlobalElementElement(module, ctx, new WsdlProviderSchemaBuilderResolver(wsdlProviderComponent));
        }
    }

    @Override
    public void registerProcessorsAndSourcesAndFilters(Module module) {
        this.registerProcessorElement(false, "invoke", "WSDLInvokeType", "Starts an execution with the underlying WSC.");
        this.registerWSDLInvokeType();
    }

    private void registerWSDLInvokeType() {
        TopLevelComplexType complexType = new TopLevelComplexType();
        complexType.setName("WSDLInvokeType");
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(SchemaConstants.MULE_ABSTRACT_MESSAGE_PROCESSOR_TYPE);
        complexContent.setExtension(complexContentExtension);
        complexContentExtension.getAttributeOrAttributeGroup().add(this.createAttribute("type", true, SchemaTypeConversion.convertType((String)this.getSchema().getTargetNamespace(), (String)"java.lang.String"), "The representation of the WSDL file plus an operation."));
        Attribute configRefAttr = this.createAttribute("config-ref", false, SchemaConstants.STRING, "Specify which configuration to use for this invocation.");
        complexContentExtension.getAttributeOrAttributeGroup().add(configRefAttr);
        this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(complexType);
    }

    private class WsdlProviderSchemaBuilderResolver
    implements GlobalElementSchemaBuilderResolver {
        private WsdlProviderComponent wsdlProviderComponent;

        public WsdlProviderSchemaBuilderResolver(WsdlProviderComponent wsdlProviderComponent) {
            this.wsdlProviderComponent = wsdlProviderComponent;
        }

        @Override
        public String resolveConfigElementName(Module module) {
            return this.wsdlProviderComponent.configElementName();
        }

        @Override
        public List<Field> resolveConfigurableFields(Module module) {
            return this.wsdlProviderComponent.getConfigurableFields();
        }

        @Override
        public void resolvePostGenerationGroup(Module module, ExtensionType config, ExplicitGroup all) {
        }

        @Override
        public String resolveJavaDocSummary(Module module) {
            return this.wsdlProviderComponent.getJavaDocSummary();
        }
    }
}

