/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.schema.global;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.mule.api.annotations.ConnectStrategy;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.connectivity.CacheConfig;
import org.mule.devkit.generation.spring.schema.RegisteredElements;
import org.mule.devkit.generation.spring.schema.global.AbstractGlobalElementSchemaBuilder;
import org.mule.devkit.generation.spring.schema.global.util.GlobalElementSchemaBuilderResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ConnectionManagementCapability;
import org.mule.devkit.model.schema.ExplicitGroup;
import org.mule.devkit.model.schema.ExtensionType;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.schema.TopLevelElement;
import org.mule.devkit.utils.NameUtils;

public class ConnectionManagerSchemaResolver
extends AbstractGlobalElementSchemaBuilder {
    private RegisteredElements registeredElements;

    public ConnectionManagerSchemaResolver(RegisteredElements registeredElements) {
        this.registeredElements = registeredElements;
    }

    @Override
    protected RegisteredElements getRegisteredElements() {
        return this.registeredElements;
    }

    @Override
    public void buildGlobalElementElement(Module module, Context ctx) {
        for (GlobalElementSchemaBuilderResolver globalElementSchemaBuilderResolver : this.getGlobalElementSchemaBuilderResolver(module)) {
            this.registerGlobalElementElement(module, ctx, globalElementSchemaBuilderResolver);
        }
    }

    @Override
    public void registerProcessorsAndSourcesAndFilters(Module module) {
    }

    private List<GlobalElementSchemaBuilderResolver> getGlobalElementSchemaBuilderResolver(Module module) {
        ArrayList<GlobalElementSchemaBuilderResolver> connectionManagementSchemaBuilderResolver = new ArrayList<GlobalElementSchemaBuilderResolver>();
        if (!module.manager().connectionManagementComponents().isEmpty()) {
            for (ConnectionManagementComponent connectionManagementComponent : module.manager().connectionManagementComponents()) {
                connectionManagementSchemaBuilderResolver.add(new ConnectionManagementGlobalElementSchemaBuilderResolver((ConnectionManagementCapability)connectionManagementComponent, connectionManagementComponent));
            }
        } else {
            connectionManagementSchemaBuilderResolver.add(new ConnectionManagementGlobalElementSchemaBuilderResolver((ConnectionManagementCapability)module, null));
        }
        return connectionManagementSchemaBuilderResolver;
    }

    private void registerGlobalElementPoolingProfileAndReconnectStrategy(ExplicitGroup all) {
        TopLevelElement poolingProfile = new TopLevelElement();
        poolingProfile.setName("connection-pooling-profile");
        poolingProfile.setType(SchemaConstants.MULE_POOLING_PROFILE_TYPE);
        poolingProfile.setMinOccurs(BigInteger.ZERO);
        poolingProfile.setAnnotation(this.createDocAnnotation("Characteristics of the connection pool."));
        all.getParticle().add(this.getObjectFactory().createElement(poolingProfile));
        TopLevelElement abstractReconnectStrategy = new TopLevelElement();
        abstractReconnectStrategy.setRef(SchemaConstants.MULE_ABSTRACT_RECONNECTION_STRATEGY);
        abstractReconnectStrategy.setMinOccurs(BigInteger.ZERO);
        abstractReconnectStrategy.setAnnotation(this.createDocAnnotation("Reconnection strategy that defines how Mule should handle a connection failure."));
        all.getParticle().add(this.getObjectFactory().createElement(abstractReconnectStrategy));
    }

    private void registerGlobalElementCacheProfile(ExplicitGroup all, ConnectMethod connectMethod) {
        String configName = NameUtils.uncamel((String)CacheConfig.class.getSimpleName());
        Type connectConfig = connectMethod.getCacheConfig();
        String type = this.registerComplexTypeWithoutRef(connectConfig);
        TopLevelElement strategyConfigElement = new TopLevelElement();
        strategyConfigElement.setName(configName);
        strategyConfigElement.setType(new QName(this.getSchema().getTargetNamespace(), type));
        strategyConfigElement.setMinOccurs(BigInteger.ZERO);
        all.getParticle().add(this.getObjectFactory().createElement(strategyConfigElement));
        TopLevelElement abstractReconnectStrategy = new TopLevelElement();
        abstractReconnectStrategy.setRef(SchemaConstants.MULE_ABSTRACT_RECONNECTION_STRATEGY);
        abstractReconnectStrategy.setMinOccurs(BigInteger.ZERO);
        abstractReconnectStrategy.setAnnotation(this.createDocAnnotation("Reconnection strategy that defines how Mule should handle a connection failure."));
        all.getParticle().add(this.getObjectFactory().createElement(abstractReconnectStrategy));
    }

    private void registerGlobalElementConnectParameters(ConnectMethod connectMethod, ExtensionType config, ExplicitGroup all, boolean forceOptional) {
        for (Parameter parameter : connectMethod.getParameters()) {
            if (parameter.asType().isCollection()) {
                this.generateCollectionElement(all, (Variable)parameter, forceOptional);
                continue;
            }
            config.getAttributeOrAttributeGroup().add(this.createParameterAttribute((Variable)parameter, forceOptional));
        }
    }

    private class ConnectionManagementGlobalElementSchemaBuilderResolver
    implements GlobalElementSchemaBuilderResolver {
        private ConnectionManagementCapability connectionManagementCapability;
        private ConnectionManagementComponent connectionManagementComponent;

        public ConnectionManagementGlobalElementSchemaBuilderResolver(ConnectionManagementCapability connectionManagementCapability, ConnectionManagementComponent connectionManagementComponent) {
            this.connectionManagementCapability = connectionManagementCapability;
            this.connectionManagementComponent = connectionManagementComponent;
        }

        @Override
        public String resolveConfigElementName(Module module) {
            String configElementName = module.getConfigElementName();
            if (this.hasConnectionManagementComponent()) {
                configElementName = this.connectionManagementComponent.configElementName();
            }
            return configElementName;
        }

        @Override
        public List<Field> resolveConfigurableFields(Module module) {
            List configurableFields = module.getConfigurableFields();
            if (this.hasConnectionManagementComponent()) {
                configurableFields.addAll(this.connectionManagementComponent.getConfigurableFields());
            }
            return configurableFields;
        }

        @Override
        public void resolvePostGenerationGroup(Module module, ExtensionType config, ExplicitGroup all) {
            ConnectMethod connectMethod = this.connectionManagementCapability.getConnectMethod();
            ConnectionManagerSchemaResolver.this.registerGlobalElementConnectParameters(connectMethod, config, all, this.hasOverrideParameters());
            if (ConnectStrategy.MULTIPLE_INSTANCES.equals((Object)connectMethod.getStrategy())) {
                ConnectionManagerSchemaResolver.this.registerGlobalElementPoolingProfileAndReconnectStrategy(all);
            } else {
                ConnectionManagerSchemaResolver.this.registerGlobalElementCacheProfile(all, connectMethod);
            }
        }

        private boolean hasOverrideParameters() {
            if (!this.hasConnectionManagementComponent()) {
                return true;
            }
            return this.connectionManagementComponent.overridesAtMessageProcessor();
        }

        @Override
        public String resolveJavaDocSummary(Module module) {
            String javaDocSummary = module.getJavaDocSummary();
            if (this.hasConnectionManagementComponent()) {
                javaDocSummary = this.connectionManagementComponent.getJavaDocSummary();
            }
            return javaDocSummary;
        }

        private boolean hasConnectionManagementComponent() {
            return this.connectionManagementComponent != null;
        }
    }
}

