/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.transformer.resolver;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.mule.transformer.resolver.AbstractTransformerResolverGenerator;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

public class TransformerResolverGenerator
extends AbstractTransformerResolverGenerator {
    private static final List<Product> CONSUMES = Collections.emptyList();
    private static final List<Product> PRODUCES = Arrays.asList(Product.TRANSFORMER_RESOLVER, Product.REGISTRY_BOOTSTRAP_ENTRY);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) && module.hasTransformerResolver();
    }

    public void generate(Module module) {
        for (Method executableElement : module.getTransformerResolverMethods()) {
            GeneratedClass transformerResolverClass = this.getTransformerResolverClass((Method<? extends Type>)executableElement);
            GeneratedField muleContext = transformerResolverClass.field(4, (org.mule.devkit.model.code.Type)this.ref(MuleContext.class), "muleContext");
            transformerResolverClass.field(4, (org.mule.devkit.model.code.Type)this.ref(Map.class).narrow(String.class).narrow(Transformer.class), "transformerCache", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ConcurrentHashMap.class).narrow(String.class).narrow(Transformer.class)));
            this.generateSetMuleContext(transformerResolverClass, muleContext);
            this.generateTransformerChange(transformerResolverClass);
            this.generateDispose(transformerResolverClass);
            this.generateResolve(transformerResolverClass, executableElement);
        }
    }

    private void generateResolve(GeneratedClass transformerResolverClass, Method executableElement) {
        GeneratedMethod resolve = transformerResolverClass.method(1, (org.mule.devkit.model.code.Type)this.ref(Transformer.class), "resolve");
        GeneratedVariable source = resolve.param((org.mule.devkit.model.code.Type)this.ref(DataType.class).narrow(this.ctx().getCodeModel().wildcard()), "source");
        GeneratedVariable result = resolve.param((org.mule.devkit.model.code.Type)this.ref(DataType.class).narrow(this.ctx().getCodeModel().wildcard()), "result");
        resolve._throws(this.ref(ResolverException.class));
        GeneratedVariable t = resolve.body().decl((org.mule.devkit.model.code.Type)this.ref(Transformer.class), "t");
        resolve.body().assign((AssignmentTarget)t, (GeneratedExpression)((GeneratedField)transformerResolverClass.fields().get("transformerCache")).invoke("get").arg((GeneratedExpression)source.invoke("toString").invoke("concat").arg((GeneratedExpression)result.invoke("toString"))));
        GeneratedConditional ifCacheTransformer = resolve.body()._if(t.isNotNull());
        ifCacheTransformer._then()._return((GeneratedExpression)t);
        GeneratedTry tryInvocation = resolve.body()._try();
        GeneratedInvocation invoke = this.ref(executableElement.parent().asTypeMirror()).boxify().staticInvoke(executableElement.getName()).arg((GeneratedExpression)source).arg((GeneratedExpression)result).arg((GeneratedExpression)transformerResolverClass.fields().get("muleContext"));
        tryInvocation.body().assign((AssignmentTarget)t, (GeneratedExpression)invoke);
        GeneratedCatchBlock invocationCatch = tryInvocation._catch(this.ref(Exception.class));
        GeneratedVariable invocationException = invocationCatch.param("e");
        invocationCatch.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ResolverException.class)).arg((GeneratedExpression)this.ref(CoreMessages.class).staticInvoke("createStaticMessage").arg("Error resolving transformer.")).arg((GeneratedExpression)invocationException));
        GeneratedConditional ifTransformer = resolve.body()._if(t.isNotNull());
        ifTransformer._then().invoke((GeneratedExpression)transformerResolverClass.fields().get("transformerCache"), "put").arg((GeneratedExpression)source.invoke("toString").invoke("concat").arg((GeneratedExpression)result.invoke("toString"))).arg((GeneratedExpression)t);
        resolve.body()._return((GeneratedExpression)t);
    }

    private void generateTransformerChange(GeneratedClass transformerResolverClass) {
        GeneratedMethod transformerChange = transformerResolverClass.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, "transformerChange");
        transformerChange.param((org.mule.devkit.model.code.Type)this.ref(Transformer.class), "transformer");
        transformerChange.param((org.mule.devkit.model.code.Type)this.ref(TransformerResolver.RegistryAction.class), "registryAction");
    }

    private void generateDispose(GeneratedClass transformerResolverClass) {
        GeneratedMethod dispose = transformerResolverClass.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, "dispose");
        dispose.body().invoke((GeneratedExpression)transformerResolverClass.fields().get("transformerCache"), "clear");
    }

    private void generateSetMuleContext(GeneratedClass transformerResolverClass, GeneratedField muleContext) {
        GeneratedMethod setMuleContext = transformerResolverClass.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, "setMuleContext");
        GeneratedVariable context = setMuleContext.param((org.mule.devkit.model.code.Type)this.ref(MuleContext.class), "context");
        setMuleContext.body().assign((AssignmentTarget)muleContext, (GeneratedExpression)context);
    }

    private GeneratedClass getTransformerResolverClass(Method<? extends Type> executableElement) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((Type)executableElement.parent()).getPackage().getName() + ".transformerResolvers");
        GeneratedClass transformerResolver = pkg._class(executableElement.getCapitalizedName() + "TransformerResolver", new Class[]{TransformerResolver.class, MuleContextAware.class, Disposable.class});
        this.ctx().registerProduct(Product.REGISTRY_BOOTSTRAP_ENTRY, executableElement.parent(), executableElement.getName(), (Object)transformerResolver);
        return transformerResolver;
    }
}

