/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.devkit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

@JustOnce
public class DevkitInterfacesGenerator
implements ModuleGenerator {
    private static final String SPLASH_SCREEN_AGENT_INTERFACE = "SplashScreenAgent";
    private static final String DEVKIT_NAMESPACE = ".devkit";
    protected Context context;

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        try {
            this.generateSplashScreenAgentInterface(module);
        }
        catch (ClassAlreadyExistsException classAlreadyExistsException) {
            // empty catch block
        }
    }

    private void generateSplashScreenAgentInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + DEVKIT_NAMESPACE);
        GeneratedClass clazz = pkg._interface(SPLASH_SCREEN_AGENT_INTERFACE);
        this.ctx().registerProduct(Product.SPLASH_SCREEN_AGENT_INTERFACE, (Object)clazz);
        clazz.javadoc().append((Object)"Marks DevKit {@link org.mule.api.agent.Agent} implementations to take care of logging information at Mule app level mainly for troubleshooting purposes.");
        clazz.direct("  /**\n     * Print version information for all the modules used by the application\n     */\n    void splash();\n\n    /**\n     * Retrieve the count of modules used by the application\n     *\n     * @return\n     */\n    int getExtensionsCount();");
    }

    public List<Product> consumes() {
        return new ArrayList<Product>();
    }

    public List<Product> produces() {
        return Arrays.asList(Product.DEVKIT_INTERFACES);
    }

    public Context ctx() {
        return this.context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }

    protected TypeReference ref(Class<?> clazz) {
        return this.ctx().getCodeModel().ref(clazz);
    }

    protected Type ref(TypeMirror typeMirror) {
        return this.ctx().getCodeModel().ref(typeMirror);
    }

    protected Type ref(Module module) {
        return this.ctx().getCodeModel().ref(module.asTypeMirror());
    }
}

