/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.api.ConnectionException;
import org.mule.devkit.generation.AbstractMetadataCodeGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.internal.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;

public class StrategyAdapterGenerator
extends AbstractMetadataCodeGenerator
implements MultiModuleGenerator {
    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.manager().connectionManagementComponents().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> res = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.manager().connectionManagementComponents().isEmpty()) continue;
            res.add(module);
        }
        return res;
    }

    public void generate(List<Module> modules) throws GenerationException {
        for (Module module : modules) {
            for (ConnectionManagementComponent component : module.manager().connectionManagementComponents()) {
                GeneratedClass adapter = this.generateAdapter(module, component);
                this.generateConnectMethod(module, adapter, component);
                this.generateDisconnectMethod(adapter, component);
                this.generateConnectionIdMethod(adapter, component);
                this.generateIsConnectedMethod(adapter, component);
                this.generateGetStrategyMethod(adapter, component);
            }
        }
    }

    private void generateGetStrategyMethod(GeneratedClass adapter, ConnectionManagementComponent component) {
        GeneratedMethod getStrategy = adapter.method(1, this.ref(component.asTypeMirror()), "getStrategy");
        getStrategy.annotate(Override.class);
        getStrategy.body()._return(ExpressionFactory._this());
    }

    private void generateIsConnectedMethod(GeneratedClass adapter, ConnectionManagementComponent component) {
        GeneratedMethod isConnected = adapter.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isConnected");
        isConnected.annotate(Override.class);
        isConnected.body()._return((GeneratedExpression)ExpressionFactory._super().invoke(component.getValidateConnectionMethod().getName()));
    }

    private void generateConnectionIdMethod(GeneratedClass adapter, ConnectionManagementComponent component) {
        GeneratedMethod connectionId = adapter.method(1, String.class, "connectionId");
        connectionId.annotate(Override.class);
        connectionId.body()._return((GeneratedExpression)ExpressionFactory._super().invoke(component.getConnectionIdentifierMethod().getName()));
    }

    private void generateDisconnectMethod(GeneratedClass adapter, ConnectionManagementComponent component) {
        GeneratedMethod disconnect = adapter.method(1, (Type)this.ctx().getCodeModel().VOID, "disconnect");
        disconnect.annotate(Override.class);
        disconnect.body().add((Statement)ExpressionFactory._super().invoke(component.getDisconnectMethod().getName()));
    }

    private void generateConnectMethod(Module module, GeneratedClass adapter, ConnectionManagementComponent component) {
        GeneratedMethod connect = adapter.method(1, (Type)this.ctx().getCodeModel().VOID, "connect");
        connect.annotate(Override.class);
        connect._throws(ConnectionException.class);
        GeneratedClass connectionKeyClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)component, module.getName())).topLevelClass();
        GeneratedVariable connectionKey = connect.param((Type)connectionKeyClass, "connectionKey");
        GeneratedInvocation connectInvoke = ExpressionFactory._super().invoke(component.getConnectMethod().getName());
        for (Parameter methodParameter : component.getConnectMethod().getParameters()) {
            connectInvoke.arg((GeneratedExpression)connectionKey.invoke("get" + StringUtils.capitalize((String)methodParameter.getName())));
        }
        connect.body().add((Statement)connectInvoke);
    }

    private GeneratedClass generateAdapter(Module module, ConnectionManagementComponent basicComponent) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".connectivity");
        GeneratedClass connectionKeyClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)basicComponent, module.getName())).topLevelClass();
        TypeReference componentClass = (TypeReference)this.ref(basicComponent.asType());
        GeneratedClass strategyAdapter = pkg._class(basicComponent.asType().getClassName() + module.getName() + "Adapter", componentClass);
        strategyAdapter._implements(this.ref(ConnectionManagementConnectionAdapter.class).narrow(this.ref(basicComponent.asType())).narrow((TypeReference)connectionKeyClass));
        this.ctx().registerProduct(Product.STRATEGY_ADAPTER, (Identifiable)basicComponent, module.getName(), (Object)strategyAdapter);
        return strategyAdapter;
    }

    public List<Product> consumes() {
        return Arrays.asList(Product.CONNECTION_KEY);
    }

    public List<Product> produces() {
        return Arrays.asList(Product.STRATEGY_ADAPTER);
    }
}

