/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.util;

import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;

public class VerifierUtils {
    private static final Pattern VALID_NAME_REGEX = Pattern.compile("[A-Za-z]+[a-zA-Z0-9\\-_]*");

    public static void verifyGlobalElementName(Identifiable element, String name, NotificationGatherer gatherer) {
        if (StringUtils.isEmpty((String)name)) {
            gatherer.error(element, (DevkitNotification)Message.NAME_ATTRIBUTE_CANNOT_BE_EMPTY, new Object[0]);
        } else {
            if (!VALID_NAME_REGEX.matcher(name).matches()) {
                gatherer.error(element, (DevkitNotification)Message.NAME_ATTRIBUTE_INCORRECT_PATTERN, new Object[]{name});
            }
            if (!name.equals(StringUtils.trim((String)name))) {
                gatherer.error(element, (DevkitNotification)Message.NAME_ATTRIBUTE_MUST_NOT_CONTAIN_WHITESPACE, new Object[]{name});
            }
            if (name.toLowerCase().equals("test")) {
                gatherer.error(element, (DevkitNotification)Message.NAME_ATTRIBUTE_CANNOT_BE_TEST, new Object[0]);
            }
        }
    }

    public static void verifyConfigurableNamesDistinctConnectParamNames(List<Field> configurableElements, NotificationGatherer gatherer, Set<String> connectionParameterNames) {
        for (Field field : configurableElements) {
            if (!connectionParameterNames.contains(field.getName())) continue;
            gatherer.error((Identifiable)field, (DevkitNotification)Message.CONFIGURABLE_FORBIDDEN_NAME, new Object[0]);
        }
    }

    public static void verifyConnectorProcessorsParams(Module module, NotificationGatherer gatherer, Set<String> connectionParameterNames) {
        for (ProcessorMethod processor : module.getProcessorMethods()) {
            for (Parameter param : processor.getParameters()) {
                if (!connectionParameterNames.contains(param.getName())) continue;
                gatherer.error((Identifiable)param, (DevkitNotification)Message.PROCESSOR_PARAM_NAME_SAME_AS_CON_MANAGEMENT_CONNECT_PARAM, new Object[0]);
            }
        }
    }

    private static void verifyTestConnectionMethod(ConnectionComponent connectionComponent, List<Method<Type>> methodsAnnotatedWithTestConnectivity, boolean shouldCheckZeroParameters, NotificationGatherer gatherer) {
        if (connectionComponent.testConnectivityMethod().isPresent()) {
            Method testConnectivityMethod = (Method)connectionComponent.testConnectivityMethod().get();
            if (!testConnectivityMethod.isPublic()) {
                gatherer.error((Identifiable)testConnectivityMethod, (DevkitNotification)Message.TEST_CONNECTIVITY_MUST_BE_PUBLIC, new Object[0]);
            }
            if (testConnectivityMethod.getThrownTypes().isEmpty()) {
                gatherer.error((Identifiable)testConnectivityMethod, (DevkitNotification)Message.TEST_CONNECTIVITY_MUST_THROW_CONNECTION_EXCEPTION, new Object[0]);
            }
            if (!testConnectivityMethod.getThrownTypes().isEmpty() && !testConnectivityMethod.getThrownTypes().get(0).toString().equals("org.mule.api.ConnectionException")) {
                gatherer.error((Identifiable)testConnectivityMethod, (DevkitNotification)Message.TEST_CONNECTIVITY_MUST_THROW_CONNECTION_EXCEPTION, new Object[0]);
            }
            if (!testConnectivityMethod.getReturnType().toString().equals("void")) {
                gatherer.error((Identifiable)testConnectivityMethod, (DevkitNotification)Message.TEST_CONNECTIVITY_NO_RETURN, new Object[0]);
            }
            if (shouldCheckZeroParameters && !testConnectivityMethod.getParameters().isEmpty()) {
                gatherer.error((Identifiable)testConnectivityMethod, (DevkitNotification)Message.TEST_CONNECTIVITY_ZERO_PARAM, new Object[0]);
            }
        }
        if (methodsAnnotatedWithTestConnectivity.size() > 1) {
            gatherer.errorAll(methodsAnnotatedWithTestConnectivity, (DevkitNotification)Message.TEST_CONNECTIVITY_ONE_METHOD_ONLY, new Object[0]);
        }
    }

    public static void verifyTestConnectionMethod(ConnectionComponent connectionComponent, List<Method<Type>> methodsAnnotatedWithTestConnectivity, NotificationGatherer gatherer) {
        VerifierUtils.verifyTestConnectionMethod(connectionComponent, methodsAnnotatedWithTestConnectivity, true, gatherer);
    }

    public static void verifyFieldGetterAndSetter(Field field, NotificationGatherer gatherer) {
        if (!field.hasSetter()) {
            gatherer.error((Identifiable)field, (DevkitNotification)Message.CONFIGURABLE_MISSING_SETTER, new Object[]{field.getName()});
        }
        if (!field.hasGetter()) {
            gatherer.error((Identifiable)field, (DevkitNotification)Message.CONFIGURABLE_MISSING_GETTER, new Object[]{field.getName()});
        }
    }

    public static void verifyConnectionComponentConfigurablesGetterAndSetter(ConnectionComponent component, NotificationGatherer gatherer) {
        for (Field field : component.getConfigurableFields()) {
            VerifierUtils.verifyFieldGetterAndSetter(field, gatherer);
        }
    }
}

