/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.oauth;

import org.mule.api.annotations.Connector;
import org.mule.api.annotations.components.ConnectionManagement;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.OAuth2Component;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.verifiers.oauth.AbstractOAuthVerifier;
import org.mule.devkit.verifiers.util.VerifierUtils;

public class OAuth2ComponentVerifier
extends AbstractOAuthVerifier {
    public boolean shouldVerify(Module module) {
        return module.manager().oauth2Component().isPresent();
    }

    @Override
    protected OAuthCapability getOAuthCapability(Module module) {
        return this.getOAuth2Component(module);
    }

    @Override
    protected Identifiable getConcreteIdentifiable(Module module) {
        return this.getOAuth2Component(module);
    }

    private OAuth2Component getOAuth2Component(Module module) {
        return (OAuth2Component)module.manager().oauth2Component().get();
    }

    @Override
    public void doVerify(Module module, NotificationGatherer gatherer) {
        OAuth2Component oAuth2Component = this.getOAuth2Component(module);
        this.verifyValidName(gatherer, oAuth2Component);
        this.verifyIsNotConnector(gatherer, oAuth2Component);
        this.verifyIsNotModule(gatherer, oAuth2Component);
        this.verifyIsNotConnectionManagement(gatherer, oAuth2Component);
        VerifierUtils.verifyConnectionComponentConfigurablesGetterAndSetter((ConnectionComponent)oAuth2Component, gatherer);
    }

    private void verifyIsNotConnectionManagement(NotificationGatherer gatherer, OAuth2Component oAuth2Component) {
        if (oAuth2Component.hasAnnotation(ConnectionManagement.class)) {
            gatherer.error((Identifiable)oAuth2Component, (DevkitNotification)Message.CON_MANAGEMENT_CANNOT_BE_OAUTH2, new Object[0]);
        }
    }

    private void verifyIsNotModule(NotificationGatherer gatherer, OAuth2Component oAuth2Component) {
        if (oAuth2Component.hasAnnotation(org.mule.api.annotations.Module.class)) {
            gatherer.error((Identifiable)oAuth2Component, (DevkitNotification)Message.OAUTH2_COMPONENT_CANNOT_BE_MODULE, new Object[0]);
        }
    }

    private void verifyIsNotConnector(NotificationGatherer gatherer, OAuth2Component oAuth2Component) {
        if (oAuth2Component.hasAnnotation(Connector.class)) {
            gatherer.error((Identifiable)oAuth2Component, (DevkitNotification)Message.OAUTH2_COMPONENT_CANNOT_BE_CONNECTOR, new Object[0]);
        }
    }

    private void verifyValidName(NotificationGatherer gatherer, OAuth2Component oAuth2Component) {
        VerifierUtils.verifyGlobalElementName((Identifiable)oAuth2Component, oAuth2Component.configElementName(), gatherer);
    }
}

