/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import org.mule.api.MuleContext;
import org.mule.api.transformer.DataType;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

public class TransformerResolverAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) && module.hasTransformerResolver();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        for (Method method : module.getTransformerResolverMethods()) {
            if (!method.isStatic()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.TRANSFORMERRESOLVER_MUST_BE_STATIC, new Object[0]);
            }
            if (!method.isPublic()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.TRANSFORMERRESOLVER_MUST_BE_PUBLIC, new Object[0]);
            }
            if (!method.getReturnType().toString().equals("org.mule.api.transformer.Transformer")) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.TRANSFORMERRESOLVER_MUST_RETURN_TRANSFORMER, new Object[0]);
            }
            if (method.getParameters().size() != 3) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.TRANSFORMERRESOLVER_MUST_RECEIVE_3_ARGUMENTS, new Object[0]);
            }
            if (((Parameter)method.getParameters().get(0)).asType().inheritsFrom(DataType.class) && ((Parameter)method.getParameters().get(1)).asType().inheritsFrom(DataType.class) && ((Parameter)method.getParameters().get(2)).asType().inheritsFrom(MuleContext.class)) continue;
            gatherer.error((Identifiable)method, (DevkitNotification)Message.TRANSFORMERRESOLVER_INCORRECT_PARAMETERS, new Object[0]);
        }
    }
}

