/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.List;
import javax.lang.model.type.TypeKind;
import org.mule.api.annotations.Handle;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.lifecycle.OnException;
import org.mule.api.annotations.rest.RestCall;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.exceptionhandler.OnExceptionHandlerComponent;

public class OnExceptionHandlerVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.hasAnnotation(OnException.class) || this.hasProcessorAnnotatedWithOnException(module);
    }

    private boolean hasProcessorAnnotatedWithOnException(Module module) {
        boolean hasOnException = false;
        for (Method method : module.getProcessorMethods()) {
            if (!method.hasAnnotation(OnException.class)) continue;
            hasOnException = true;
            break;
        }
        return hasOnException;
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setGatherer(gatherer);
        this.checkModuleLevelExceptionHandling(module);
        this.checkMethodLevelExceptionHandling(module.getProcessorMethods());
    }

    private void checkModuleLevelExceptionHandling(Module module) {
        if (module.hasAnnotation(OnException.class)) {
            if (!module.manager().handlerComponent().isPresent()) {
                this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.DECLARED_HANDLER_NOT_ANNOTATED, new Object[0]);
            } else {
                this.verifyHandler((OnExceptionHandlerComponent)module.manager().handlerComponent().get());
            }
        }
    }

    private void checkMethodLevelExceptionHandling(List<ProcessorMethod> methods) {
        for (ProcessorMethod method : methods) {
            if (!method.hasAnnotation(OnException.class)) continue;
            if (!method.hasAnnotation(Processor.class) || method.hasAnnotation(RestCall.class)) {
                this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.METHOD_TYPE_NOT_SUPPORTED_FOR_ON_EXCEPTION, new Object[0]);
                continue;
            }
            if (!method.manager().handlerComponent().isPresent()) {
                this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.DECLARED_HANDLER_NOT_ANNOTATED, new Object[0]);
                continue;
            }
            this.verifyHandler((OnExceptionHandlerComponent)method.manager().handlerComponent().get());
        }
    }

    private void verifyHandler(OnExceptionHandlerComponent handler) {
        List handleMethods = handler.getMethodsAnnotatedWith(Handle.class);
        this.checkNumberOfHandles(handler, handleMethods);
        this.checkHandleDeclaration(handleMethods);
    }

    private void checkHandleDeclaration(List<Method<Type>> handleMethods) {
        for (Method<Type> method : handleMethods) {
            this.checkReturnsVoid(method);
            this.checkReceivesException(method);
            this.checkThrowsException(method);
            this.checkHandleIsPublic(method);
        }
    }

    private void checkReturnsVoid(Method method) {
        if (!method.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
            this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.RETURN_TYPE_FOR_EXCEPTION_HANDLE, new Object[]{method.getReturnType().toString()});
        }
    }

    private void checkReceivesException(Method method) {
        Parameter param;
        if (method.getParameters().size() < 1 || method.getParameters().size() > 1) {
            this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.PARAMETERS_COUNT_FOR_EXCEPTION_HANDLE, new Object[]{method.getParameters().size()});
        }
        if (method.getParameters().size() == 1 && !(param = (Parameter)method.getParameters().get(0)).getJavaType().equals(Exception.class.getCanonicalName())) {
            this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.EXCEPTION_HANDLE_PARAMETER_EXCEPTION_ONLY, new Object[]{param.getJavaType()});
        }
    }

    private void checkThrowsException(Method method) {
        boolean throwsException = false;
        for (Object type : method.getThrownTypes()) {
            if (!type.toString().equals(Exception.class.getCanonicalName())) continue;
            throwsException = true;
            break;
        }
        if (!throwsException) {
            this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.EXCEPTION_HANDLE_NO_THROWS_DECLARED, new Object[0]);
        }
    }

    private void checkHandleIsPublic(Method method) {
        if (method.isStatic() || method.isAbstract() || !method.isPublic()) {
            this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.METHOD_VISIBILITY_ON_EXCEPTION_HANDLE, new Object[0]);
        }
    }

    private void checkNumberOfHandles(OnExceptionHandlerComponent handler, List<Method<Type>> handleMethods) {
        int countOfHandles = handleMethods.size();
        if (countOfHandles < 1 || countOfHandles > 1) {
            this.getGatherer().error((Identifiable)handler, (DevkitNotification)Message.INVALID_HANDLES_COUNT_FOR_EXCEPTION_HANDLER, new Object[]{countOfHandles});
        }
    }
}

