/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.type.TypeKind;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.ConnectionStrategy;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.TestConnectivity;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.components.ConnectionManagement;
import org.mule.api.annotations.components.HttpBasicAuth;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.util.StringUtils;

public class ConnectorAnnotationVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.GENERIC || module.getKind() == ModuleKind.CONNECTOR;
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setGatherer(gatherer);
        this.verifyIsNotConnectionManagement(module, gatherer);
        this.verifyConnectionMethods(module, gatherer);
        this.verifyConnectionStrategy(module);
        this.verifyIsNotOAuth2(module, gatherer);
        this.verifyIsNotHttpBasicAuth(module, gatherer);
    }

    private void verifyConnectionStrategy(Module module) {
        if (module.hasFieldAnnotatedWith(ConnectionStrategy.class)) {
            List connectionStrategies = module.getFieldsAnnotatedWith(ConnectionStrategy.class);
            if (connectionStrategies.size() > 1) {
                this.getGatherer().errorAll(connectionStrategies, (DevkitNotification)Message.MORE_THAN_ONE_STRATEGY_NOT_ALLOWED, new Object[0]);
            } else {
                Field connectionStrategy = (Field)connectionStrategies.get(0);
                if (!connectionStrategy.hasGetter()) {
                    this.getGatherer().error((Identifiable)connectionStrategy, (DevkitNotification)Message.CONNECTION_STRATEGY_MISSING_GETTER, new Object[]{connectionStrategy.getName()});
                }
                if (!connectionStrategy.hasSetter()) {
                    this.getGatherer().error((Identifiable)connectionStrategy, (DevkitNotification)Message.CONNECTION_STRATEGY_MISSING_SETTER, new Object[]{connectionStrategy.getName()});
                }
            }
            HashMap<String, ConnectionComponent> namesMap = new HashMap<String, ConnectionComponent>();
            for (ConnectionComponent connectionComponent : module.manager().connectionComponents()) {
                String configElementName = connectionComponent.configElementName();
                if (namesMap.containsKey(configElementName)) {
                    this.getGatherer().error((Identifiable)connectionComponent, (DevkitNotification)Message.CONNECTION_STRATEGIES_NAMES_MUST_BE_UNIQUE, new Object[]{configElementName});
                    this.getGatherer().error((Identifiable)namesMap.get(configElementName), (DevkitNotification)Message.CONNECTION_STRATEGIES_NAMES_MUST_BE_UNIQUE, new Object[]{configElementName});
                    continue;
                }
                namesMap.put(configElementName, connectionComponent);
            }
        }
    }

    private void verifyIsNotConnectionManagement(Module module, NotificationGatherer gatherer) {
        if (module.hasAnnotation(ConnectionManagement.class)) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.CONNECTOR_CANNOT_BE_ANNOTATED_WITH_CONNECTION_MANAGEMENT, new Object[]{module.getName()});
        }
    }

    public void verifyConnectionMethods(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        List connectMethods = module.getRecursivelyMethodsAnnotatedWith(Connect.class);
        List validateConnectionMethods = module.getRecursivelyMethodsAnnotatedWith(ValidateConnection.class);
        List disconnectMethods = module.getRecursivelyMethodsAnnotatedWith(Disconnect.class);
        List connectionIdentifierMethods = module.getRecursivelyMethodsAnnotatedWith(ConnectionIdentifier.class);
        if (module instanceof Module && module.getKind() == ModuleKind.GENERIC) {
            if (!connectMethods.isEmpty()) {
                gatherer.error((Identifiable)connectMethods.get(0), (DevkitNotification)Message.MODULE_CANNOT_HAVE_CONNECT, new Object[0]);
            }
            if (!validateConnectionMethods.isEmpty()) {
                gatherer.error((Identifiable)validateConnectionMethods.get(0), (DevkitNotification)Message.MODULE_CANNOT_HAVE_VALIDATE_CONNECTION, new Object[0]);
            }
            if (!disconnectMethods.isEmpty()) {
                gatherer.error((Identifiable)disconnectMethods.get(0), (DevkitNotification)Message.MODULE_CANNOT_HAVE_DISCONNECT, new Object[0]);
            }
            if (!connectionIdentifierMethods.isEmpty()) {
                gatherer.error((Identifiable)connectionIdentifierMethods.get(0), (DevkitNotification)Message.MODULE_CANNOT_HAVE_CONNECTION_IDENTIFIER, new Object[0]);
            }
            return;
        }
        this.checkConnectorMethodsConsistency((Type)module, connectMethods, validateConnectionMethods, disconnectMethods, connectionIdentifierMethods);
        this.checkConnectMethod(module, connectMethods);
        if (!connectMethods.isEmpty()) {
            gatherer.warn((Identifiable)connectMethods.get(0), (DevkitNotification)Message.CONNECTION_METHODS_AT_CONNECTOR_LEVEL_DEPRECATED, new Object[]{((Method)connectMethods.get(0)).getName()});
        }
        this.checkDisconnectMethod(disconnectMethods);
        this.checkConnectionIdentifierMethod(connectionIdentifierMethods);
        this.checkValidateConnectionMethod(validateConnectionMethods);
    }

    private void checkConnectorMethodsConsistency(Type module, List<Method<Type>> connectMethods, List<Method<Type>> validateConnectionMethods, List<Method<Type>> disconnectMethods, List<Method<Type>> connectionIdentifierMethods) throws AnnotationVerificationException {
        ArrayList<String> implementedConnectorMethods = new ArrayList<String>();
        if (!connectMethods.isEmpty()) {
            implementedConnectorMethods.add("@Connect");
        }
        if (!disconnectMethods.isEmpty()) {
            implementedConnectorMethods.add("@Disconnect");
        }
        if (!connectionIdentifierMethods.isEmpty()) {
            implementedConnectorMethods.add("@ConnectionIdentifier");
        }
        if (!validateConnectionMethods.isEmpty()) {
            implementedConnectorMethods.add("@ValidateConnection");
        }
        if (!implementedConnectorMethods.isEmpty()) {
            if (implementedConnectorMethods.size() != 4) {
                String alreadyImplementedMethods = StringUtils.join(implementedConnectorMethods, (String)", ");
                this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.CONNECTOR_MISSING_CONNECTION_METHODS, new Object[]{alreadyImplementedMethods});
            }
            if (module.hasAnnotation(OAuth.class) || module.hasAnnotation(OAuth2.class)) {
                this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.CONNECTOR_USES_CONN_MGMT_AND_OAUTH, new Object[]{module.getClassName()});
            }
        }
    }

    private void checkConnectMethod(Module module, List<Method<Type>> connectMethods) throws AnnotationVerificationException {
        if (connectMethods.size() > 1) {
            this.getGatherer().errorAll(connectMethods, (DevkitNotification)Message.CONNECT_ONE_METHOD_ONLY, new Object[0]);
            return;
        }
        if (connectMethods.size() > 0) {
            Method<Type> connectMethod = connectMethods.get(0);
            if (!connectMethod.isPublic()) {
                this.getGatherer().error(connectMethod, (DevkitNotification)Message.CONNECT_MUST_BE_PUBLIC, new Object[0]);
            }
            if (connectMethod.getThrownTypes().isEmpty()) {
                this.getGatherer().error(connectMethod, (DevkitNotification)Message.CONNECT_MUST_THROW_CONNECTION_EXCEPTION, new Object[0]);
            }
            if (!connectMethod.getThrownTypes().isEmpty() && !connectMethod.getThrownTypes().get(0).toString().equals("org.mule.api.ConnectionException")) {
                this.getGatherer().error(connectMethod, (DevkitNotification)Message.CONNECT_MUST_THROW_CONNECTION_EXCEPTION, new Object[0]);
            }
            if (!connectMethod.getReturnType().toString().equals("void")) {
                this.getGatherer().error(connectMethod, (DevkitNotification)Message.CONNECT_NO_RETURN, new Object[0]);
            }
            this.checkConnectMethodParameters(connectMethod);
            Method methodsAnnotatedWithTestConnectivity = module.getRecursivelyFirstMethodAnnotatedWith(TestConnectivity.class);
            if (methodsAnnotatedWithTestConnectivity == null || !methodsAnnotatedWithTestConnectivity.getName().equals(connectMethod.getName())) {
                this.getGatherer().error(connectMethod, (DevkitNotification)Message.CONNECT_MUST_BE_TEST_CONNECTIVITY, new Object[0]);
            }
        }
    }

    private void checkConnectMethodParameters(Method<Type> method) throws AnnotationVerificationException {
        int connectionKeys = 0;
        for (Parameter parameter : method.getParameters()) {
            TypeKind parameterKind;
            if (parameter.isReservedIdentifier()) {
                this.getGatherer().error((Identifiable)parameter, (DevkitNotification)Message.CONNECTOR_USES_RESERVED_IDENTIFIER, new Object[]{parameter.getName(), parameter.getName()});
            }
            if (parameter.hasAnnotation(ConnectionKey.class)) {
                ++connectionKeys;
                if (parameter.hasDefaultValue()) {
                    this.getGatherer().error((Identifiable)parameter, (DevkitNotification)Message.CONNECTIONKEY_PARAMETER_HAS_DEFAULT_VALUE, new Object[0]);
                }
            }
            if (parameter.asType().isEnum()) {
                this.getGatherer().error((Identifiable)parameter, (DevkitNotification)Message.CONNECT_PARAM_RESTRICTED_TYPES, new Object[]{parameter.getName(), "Enum"});
            }
            if (parameter.asType().isCollection()) {
                this.getGatherer().error((Identifiable)parameter, (DevkitNotification)Message.CONNECT_PARAM_RESTRICTED_TYPES, new Object[]{parameter.getName(), "Collection"});
            }
            if ((parameterKind = parameter.asTypeMirror().getKind()) != TypeKind.BYTE && !parameter.getJavaType().equals(Byte.class.getName()) && parameterKind != TypeKind.SHORT && !parameter.getJavaType().equals(Short.class.getName())) continue;
            this.getGatherer().error((Identifiable)parameter, (DevkitNotification)Message.PARAMS_NOT_SUPPORTED, new Object[]{Arrays.toString(new String[]{"byte", "short"}), parameter.getName()});
        }
        if (connectionKeys == 0) {
            this.getGatherer().error(method, (DevkitNotification)Message.CONNECTOR_MISSING_CONNECTION_KEY_PARAM, new Object[0]);
        }
    }

    private void checkDisconnectMethod(List<Method<Type>> disconnectMethods) throws AnnotationVerificationException {
        if (disconnectMethods.size() > 1) {
            this.getGatherer().errorAll(disconnectMethods, (DevkitNotification)Message.DISCONNECT_ONE_METHOD_ONLY, new Object[0]);
            return;
        }
        if (disconnectMethods.size() > 0) {
            Method<Type> disconnectMethod = disconnectMethods.get(0);
            if (!disconnectMethod.isPublic()) {
                this.getGatherer().error(disconnectMethod, (DevkitNotification)Message.DISCONNECT_MUST_BE_PUBLIC, new Object[0]);
            }
            if (!disconnectMethod.getParameters().isEmpty()) {
                this.getGatherer().error(disconnectMethod, (DevkitNotification)Message.DISCONNECT_NO_ARGS, new Object[0]);
            }
            boolean throwsProperException = true;
            for (Object exObject : disconnectMethod.getThrownTypes()) {
                if (exObject.toString().equals(RuntimeException.class.getCanonicalName())) continue;
                throwsProperException = false;
                break;
            }
            if (!throwsProperException) {
                this.getGatherer().error(disconnectMethod, (DevkitNotification)Message.DISCONNECT_THROW, new Object[0]);
            }
        }
    }

    private void checkValidateConnectionMethod(List<Method<Type>> validateConnectionMethods) throws AnnotationVerificationException {
        if (validateConnectionMethods.size() > 1) {
            this.getGatherer().errorAll(validateConnectionMethods, (DevkitNotification)Message.VALIDATE_CONNECTION_ONE_METHOD_ONLY, new Object[0]);
            return;
        }
        if (validateConnectionMethods.size() > 0) {
            Method<Type> validateConnectionMethod = validateConnectionMethods.get(0);
            if (!validateConnectionMethod.isPublic()) {
                this.getGatherer().error(validateConnectionMethod, (DevkitNotification)Message.VALIDATE_CONNECTION_PUBLIC, new Object[0]);
            }
            if (!validateConnectionMethod.getReturnType().toString().equals("boolean") && !validateConnectionMethod.getReturnType().toString().equals("java.lang.Boolean")) {
                this.getGatherer().error(validateConnectionMethod, (DevkitNotification)Message.VALIDATE_CONNECTION_MUST_RETURN_BOOLEAN, new Object[0]);
            }
            if (!validateConnectionMethod.getParameters().isEmpty()) {
                this.getGatherer().error(validateConnectionMethod, (DevkitNotification)Message.VALIDATE_CONNECTION_NO_ARGS, new Object[0]);
            }
        }
    }

    private void checkConnectionIdentifierMethod(List<Method<Type>> connectionIdentifierMethods) throws AnnotationVerificationException {
        if (connectionIdentifierMethods.size() > 1) {
            this.getGatherer().errorAll(connectionIdentifierMethods, (DevkitNotification)Message.CONN_IDENTIFIER_ONE_METHOD_ONLY, new Object[0]);
            return;
        }
        if (connectionIdentifierMethods.size() > 0) {
            Method<Type> connectionIdentifierMethod = connectionIdentifierMethods.get(0);
            if (!connectionIdentifierMethod.getReturnType().toString().equals("java.lang.String")) {
                this.getGatherer().error(connectionIdentifierMethod, (DevkitNotification)Message.CONN_IDENTIFIER_MUST_RETURN_STRING, new Object[0]);
            }
            if (!connectionIdentifierMethod.isPublic()) {
                this.getGatherer().error(connectionIdentifierMethod, (DevkitNotification)Message.CONN_IDENTIFIER_MUST_BE_PUBLIC, new Object[0]);
            }
            if (connectionIdentifierMethod.isStatic()) {
                this.getGatherer().error(connectionIdentifierMethod, (DevkitNotification)Message.CONN_IDENTIFIER_MUST_BE_STATIC, new Object[0]);
            }
            if (!connectionIdentifierMethod.getParameters().isEmpty()) {
                this.getGatherer().error(connectionIdentifierMethod, (DevkitNotification)Message.CONN_IDENTIFIER_NO_ARGS, new Object[0]);
            }
        }
    }

    private void verifyIsNotOAuth2(Module module, NotificationGatherer gatherer) {
        if (module.hasAnnotation(OAuth2.class)) {
            gatherer.warn((Identifiable)module, (DevkitNotification)Message.OAUTH2_AT_CONNECTOR_LEVEL_DEPRECATED, new Object[0]);
        }
    }

    private void verifyIsNotHttpBasicAuth(Module module, NotificationGatherer gatherer) {
        if (module.hasAnnotation(HttpBasicAuth.class)) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.CONNECTOR_CANNOT_BE_ANNOTATED_WITH_HTTP_BASIC_AUTH, new Object[0]);
        }
    }
}

