/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.TestConnectivity;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.verifiers.ConnectorAnnotationVerifier;
import org.mule.devkit.verifiers.util.VerifierUtils;
import org.mule.util.StringUtils;

public class ConnectionManagementVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return !module.manager().connectionManagementComponents().isEmpty();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.verifyOnlyStrategyIsUsed(module, gatherer);
        this.verifyConnectionComponent(module, gatherer);
        this.verifyOnlyOneOverrideAtProcessors(module, gatherer);
    }

    private void VerifyConnectParameters(Module module, NotificationGatherer gatherer, ConnectionManagementComponent connectionManagementComponent) {
        HashSet<String> connectionParameterNames = new HashSet<String>();
        for (Parameter pm : connectionManagementComponent.getConnectMethod().getParameters()) {
            connectionParameterNames.add(pm.getName());
        }
        if (connectionManagementComponent.overridesAtMessageProcessor()) {
            VerifierUtils.verifyConnectorProcessorsParams(module, gatherer, connectionParameterNames);
        }
        VerifierUtils.verifyConfigurableNamesDistinctConnectParamNames(module.getConfigurableFields(), gatherer, connectionParameterNames);
        VerifierUtils.verifyConfigurableNamesDistinctConnectParamNames(connectionManagementComponent.getConfigurableFields(), gatherer, connectionParameterNames);
        this.verifyConfigurablesNames(module, gatherer, connectionManagementComponent);
    }

    private void verifyConfigurablesNames(Module module, NotificationGatherer gatherer, ConnectionManagementComponent connectionManagementComponent) {
        HashSet<String> configurableNames = new HashSet<String>();
        for (Field field : module.getConfigurableFields()) {
            configurableNames.add(field.getName());
        }
        for (Field field : connectionManagementComponent.getConfigurableFields()) {
            if (!configurableNames.contains(field.getName())) continue;
            gatherer.error((Identifiable)field, (DevkitNotification)Message.CONFIGURABLE_FIELDS_CRASHES, new Object[]{field.getName(), connectionManagementComponent.getName(), module.getName()});
        }
    }

    private void verifyOnlyOneOverrideAtProcessors(Module module, NotificationGatherer gatherer) {
        ArrayList<ConnectionManagementComponent> overrideAtProcessors = new ArrayList<ConnectionManagementComponent>();
        for (ConnectionManagementComponent connectionManagementComponent : module.manager().connectionManagementComponents()) {
            if (!connectionManagementComponent.overridesAtMessageProcessor()) continue;
            overrideAtProcessors.add(connectionManagementComponent);
        }
        if (overrideAtProcessors.size() > 1) {
            gatherer.errorAll(overrideAtProcessors, (DevkitNotification)Message.OVERRIDE_AT_PROCESSORS_ONLY_ONCE, new Object[0]);
        }
    }

    private void verifyConnectionComponent(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        ConnectorAnnotationVerifier connectionVerifier = new ConnectorAnnotationVerifier();
        connectionVerifier.setGatherer(gatherer);
        for (ConnectionManagementComponent connectionManagementComponent : module.manager().connectionManagementComponents()) {
            this.checkConnectionMethods(module, connectionManagementComponent, gatherer);
            VerifierUtils.verifyConnectionComponentConfigurablesGetterAndSetter((ConnectionComponent)connectionManagementComponent, gatherer);
        }
    }

    private void verifyOnlyStrategyIsUsed(Module module, NotificationGatherer gatherer) {
        if (module instanceof ManagedConnectionModule) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.CONNECTOR_HAS_CONNECTIONSTRATEGY_AND_CONNECT_ANNOTATIONS, new Object[]{module.getName()});
        }
    }

    public void checkConnectionMethods(Module module, ConnectionManagementComponent connectionManagementComponent, NotificationGatherer gatherer) throws AnnotationVerificationException {
        List connectMethods = connectionManagementComponent.getMethodsAnnotatedWith(Connect.class);
        ConnectMethod connectMethod = connectionManagementComponent.getConnectMethod();
        List validateConnectionMethods = connectionManagementComponent.getMethodsAnnotatedWith(ValidateConnection.class);
        Method validateConnectionMethod = connectionManagementComponent.getValidateConnectionMethod();
        List disconnectMethods = connectionManagementComponent.getMethodsAnnotatedWith(Disconnect.class);
        Method disconnectMethod = connectionManagementComponent.getDisconnectMethod();
        List connectionIdentifierMethods = connectionManagementComponent.getMethodsAnnotatedWith(ConnectionIdentifier.class);
        Method connectionIdentifierMethod = connectionManagementComponent.getConnectionIdentifierMethod();
        this.checkConnectorMethodsConsistency(connectionManagementComponent, connectMethod, (Method<ManagedConnectionModule>)disconnectMethod, (Method<ManagedConnectionModule>)connectionIdentifierMethod, (Method<ManagedConnectionModule>)validateConnectionMethod, gatherer);
        this.checkConnectMethod(module, connectionManagementComponent, connectMethod, connectMethods, gatherer);
        this.checkDisconnectMethod(connectionManagementComponent, (Method<ManagedConnectionModule>)disconnectMethod, disconnectMethods, gatherer);
        this.checkConnectionIdentifierMethod(connectionManagementComponent, (Method<ManagedConnectionModule>)connectionIdentifierMethod, connectionIdentifierMethods, gatherer);
        this.checkValidateConnectionMethod(connectionManagementComponent, (Method<ManagedConnectionModule>)validateConnectionMethod, validateConnectionMethods, gatherer);
    }

    private void checkConnectorMethodsConsistency(ConnectionManagementComponent connectionManagementComponent, ConnectMethod connectMethod, Method<ManagedConnectionModule> validateConnectionMethod, Method<ManagedConnectionModule> disconnectMethod, Method<ManagedConnectionModule> connectionIdentifierMethod, NotificationGatherer gatherer) throws AnnotationVerificationException {
        ArrayList<String> nonImplementedConnectorMethods = new ArrayList<String>();
        if (connectMethod == null) {
            nonImplementedConnectorMethods.add("@Connect");
        }
        if (disconnectMethod == null) {
            nonImplementedConnectorMethods.add("@Disconnect");
        }
        if (connectionIdentifierMethod == null) {
            nonImplementedConnectorMethods.add("@ConnectionIdentifier");
        }
        if (validateConnectionMethod == null) {
            nonImplementedConnectorMethods.add("@ValidateConnection");
        }
        if (!nonImplementedConnectorMethods.isEmpty()) {
            String alreadyImplementedMethods = StringUtils.join(nonImplementedConnectorMethods, (String)", ");
            gatherer.error((Identifiable)connectionManagementComponent, (DevkitNotification)Message.CONNECTION_MANAGEMENT_MISSING_CONNECTION_METHODS, new Object[]{alreadyImplementedMethods});
        }
        if (connectionManagementComponent.hasAnnotation(OAuth.class) || connectionManagementComponent.hasAnnotation(OAuth2.class)) {
            gatherer.error((Identifiable)connectionManagementComponent, (DevkitNotification)Message.CONNECTOR_USES_CONN_MGMT_AND_OAUTH, new Object[]{connectionManagementComponent.getClassName()});
        }
    }

    private void checkConnectMethod(Module module, ConnectionManagementComponent connectionManagementComponent, ConnectMethod connectMethod, List<Method<Type>> connectMethods, NotificationGatherer gatherer) throws AnnotationVerificationException {
        if (connectMethod != null) {
            if (!connectMethod.isPublic()) {
                gatherer.error((Identifiable)connectMethod, (DevkitNotification)Message.CONNECT_MUST_BE_PUBLIC, new Object[0]);
            }
            if (connectMethod.getThrownTypes().isEmpty()) {
                gatherer.error((Identifiable)connectMethod, (DevkitNotification)Message.CONNECT_MUST_THROW_CONNECTION_EXCEPTION, new Object[0]);
            }
            if (!connectMethod.getThrownTypes().isEmpty() && !((TypeMirror)connectMethod.getThrownTypes().get(0)).toString().equals("org.mule.api.ConnectionException")) {
                gatherer.error((Identifiable)connectMethod, (DevkitNotification)Message.CONNECT_MUST_THROW_CONNECTION_EXCEPTION, new Object[0]);
            }
            if (!connectMethod.getReturnType().toString().equals("void")) {
                gatherer.error((Identifiable)connectMethod, (DevkitNotification)Message.CONNECT_NO_RETURN, new Object[0]);
            }
            this.checkConnectMethodParameters(connectMethod, gatherer);
            this.VerifyConnectParameters(module, gatherer, connectionManagementComponent);
            Method methodsAnnotatedWithTestConnectivity = connectionManagementComponent.getRecursivelyFirstMethodAnnotatedWith(TestConnectivity.class);
            if (methodsAnnotatedWithTestConnectivity == null || !methodsAnnotatedWithTestConnectivity.getName().equals(connectMethod.getName())) {
                gatherer.error((Identifiable)connectMethod, (DevkitNotification)Message.CONNECT_MUST_BE_TEST_CONNECTIVITY, new Object[0]);
            }
        }
        if (connectMethods != null && connectMethods.size() > 1) {
            for (Method<Type> method : connectMethods) {
                gatherer.error(method, (DevkitNotification)Message.CON_MANAGEMENT_DUPLICATED_CONNECT_METHOD, new Object[]{connectionManagementComponent.getClassName()});
            }
        }
    }

    private void checkDisconnectMethod(ConnectionManagementComponent connectionManagementComponent, Method<ManagedConnectionModule> disconnectMethod, List<Method<Type>> disconnectMethods, NotificationGatherer gatherer) throws AnnotationVerificationException {
        if (disconnectMethod != null) {
            if (!disconnectMethod.isPublic()) {
                gatherer.error(disconnectMethod, (DevkitNotification)Message.DISCONNECT_MUST_BE_PUBLIC, new Object[0]);
            }
            if (!disconnectMethod.getParameters().isEmpty()) {
                gatherer.error(disconnectMethod, (DevkitNotification)Message.DISCONNECT_NO_ARGS, new Object[0]);
            }
            boolean throwsProperException = true;
            for (TypeMirror typeMirror : disconnectMethod.getThrownTypes()) {
                if (typeMirror.toString().equals(RuntimeException.class.getCanonicalName())) continue;
                throwsProperException = false;
                break;
            }
            if (!throwsProperException) {
                gatherer.error(disconnectMethod, (DevkitNotification)Message.DISCONNECT_THROW, new Object[0]);
            }
        }
        if (disconnectMethods != null && disconnectMethods.size() > 1) {
            for (Method<Type> method : disconnectMethods) {
                gatherer.error(method, (DevkitNotification)Message.DISCONNECT_ONE_METHOD_ONLY, new Object[]{connectionManagementComponent.getClassName()});
            }
        }
    }

    private void checkValidateConnectionMethod(ConnectionManagementComponent connectionManagementComponent, Method<ManagedConnectionModule> validateConnectionMethod, List<Method<Type>> validateConnectionMethods, NotificationGatherer gatherer) throws AnnotationVerificationException {
        if (validateConnectionMethod != null) {
            if (!validateConnectionMethod.isPublic()) {
                gatherer.error(validateConnectionMethod, (DevkitNotification)Message.VALIDATE_CONNECTION_PUBLIC, new Object[0]);
            }
            if (!validateConnectionMethod.getReturnType().toString().equals("boolean") && !validateConnectionMethod.getReturnType().toString().equals("java.lang.Boolean")) {
                gatherer.error(validateConnectionMethod, (DevkitNotification)Message.VALIDATE_CONNECTION_MUST_RETURN_BOOLEAN, new Object[0]);
            }
            if (!validateConnectionMethod.getParameters().isEmpty()) {
                gatherer.error(validateConnectionMethod, (DevkitNotification)Message.VALIDATE_CONNECTION_NO_ARGS, new Object[0]);
            }
        }
        if (validateConnectionMethods != null && validateConnectionMethods.size() > 1) {
            for (Method<Type> method : validateConnectionMethods) {
                gatherer.error(method, (DevkitNotification)Message.VALIDATE_CONNECTION_ONE_METHOD_ONLY, new Object[]{connectionManagementComponent.getClassName()});
            }
        }
    }

    private void checkConnectionIdentifierMethod(ConnectionManagementComponent connectionManagementComponent, Method<ManagedConnectionModule> connectionIdentifierMethod, List<Method<Type>> connectionIdentifierMethods, NotificationGatherer gatherer) throws AnnotationVerificationException {
        if (connectionIdentifierMethod != null) {
            if (!connectionIdentifierMethod.getReturnType().toString().equals("java.lang.String")) {
                gatherer.error(connectionIdentifierMethod, (DevkitNotification)Message.CONN_IDENTIFIER_MUST_RETURN_STRING, new Object[0]);
            }
            if (!connectionIdentifierMethod.isPublic()) {
                gatherer.error(connectionIdentifierMethod, (DevkitNotification)Message.CONN_IDENTIFIER_MUST_BE_PUBLIC, new Object[0]);
            }
            if (connectionIdentifierMethod.isStatic()) {
                gatherer.error(connectionIdentifierMethod, (DevkitNotification)Message.CONN_IDENTIFIER_MUST_BE_STATIC, new Object[0]);
            }
            if (!connectionIdentifierMethod.getParameters().isEmpty()) {
                gatherer.error(connectionIdentifierMethod, (DevkitNotification)Message.CONN_IDENTIFIER_NO_ARGS, new Object[0]);
            }
        }
        if (connectionIdentifierMethods != null && connectionIdentifierMethods.size() > 1) {
            for (Method<Type> method : connectionIdentifierMethods) {
                gatherer.error(method, (DevkitNotification)Message.CONN_IDENTIFIER_ONE_METHOD_ONLY, new Object[]{connectionManagementComponent.getClassName()});
            }
        }
    }

    private void checkConnectMethodParameters(ConnectMethod method, NotificationGatherer gatherer) throws AnnotationVerificationException {
        int connectionKeys = 0;
        for (Parameter parameter : method.getParameters()) {
            TypeKind parameterKind;
            if (parameter.isReservedIdentifier()) {
                gatherer.error((Identifiable)parameter, (DevkitNotification)Message.CONNECTOR_USES_RESERVED_IDENTIFIER, new Object[]{parameter.getName(), parameter.getName()});
            }
            if (parameter.hasAnnotation(ConnectionKey.class)) {
                ++connectionKeys;
                if (parameter.hasDefaultValue()) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.CONNECTIONKEY_PARAMETER_HAS_DEFAULT_VALUE, new Object[0]);
                }
            }
            if (parameter.asType().isEnum()) {
                gatherer.error((Identifiable)parameter, (DevkitNotification)Message.CONNECT_PARAM_RESTRICTED_TYPES, new Object[]{parameter.getName(), "Enum"});
            }
            if (parameter.asType().isCollection()) {
                gatherer.error((Identifiable)parameter, (DevkitNotification)Message.CONNECT_PARAM_RESTRICTED_TYPES, new Object[]{parameter.getName(), "Collection"});
            }
            if ((parameterKind = parameter.asTypeMirror().getKind()) != TypeKind.BYTE && !parameter.getJavaType().equals(Byte.class.getName()) && parameterKind != TypeKind.SHORT && !parameter.getJavaType().equals(Short.class.getName())) continue;
            this.getGatherer().error((Identifiable)parameter, (DevkitNotification)Message.PARAMS_NOT_SUPPORTED, new Object[]{Arrays.toString(new String[]{"byte", "short"}), parameter.getName()});
        }
        if (connectionKeys == 0) {
            gatherer.error((Identifiable)method, (DevkitNotification)Message.CONNECTOR_MISSING_CONNECTION_KEY_PARAM, new Object[0]);
        }
    }
}

