/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.HashSet;
import org.mule.api.annotations.TestConnectivity;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConfigurationComponent;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.verifiers.util.VerifierUtils;

public class ConfigurationVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return !module.manager().configurationComponents().isEmpty();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.verifyOnlyStrategyIsUsed(module, gatherer);
        for (ConfigurationComponent configurationComponent : module.manager().configurationComponents()) {
            this.verifyBasicComponent(module, configurationComponent, gatherer);
        }
    }

    private void verifyBasicComponent(Module module, ConfigurationComponent configurationComponent, NotificationGatherer gatherer) {
        if (!configurationComponent.hasNoArgConstructor()) {
            gatherer.error((Identifiable)configurationComponent, (DevkitNotification)Message.NO_ARGS_CONSTRUCTOR_REQUIRED, new Object[0]);
        }
        this.verifyTestConnectionMethod(configurationComponent, gatherer);
        this.verifyConfigurablesNames(module, gatherer, (ConnectionComponent)configurationComponent);
        VerifierUtils.verifyConnectionComponentConfigurablesGetterAndSetter((ConnectionComponent)configurationComponent, gatherer);
    }

    private void verifyTestConnectionMethod(ConfigurationComponent configurationComponent, NotificationGatherer gatherer) {
        VerifierUtils.verifyTestConnectionMethod((ConnectionComponent)configurationComponent, configurationComponent.getMethodsAnnotatedWith(TestConnectivity.class), gatherer);
    }

    private void verifyConfigurablesNames(Module module, NotificationGatherer gatherer, ConnectionComponent component) {
        HashSet<String> configurableNames = new HashSet<String>();
        for (Field field : module.getConfigurableFields()) {
            configurableNames.add(field.getName());
        }
        for (Field field : component.getConfigurableFields()) {
            if (!configurableNames.contains(field.getName())) continue;
            gatherer.error((Identifiable)field, (DevkitNotification)Message.CONFIGURABLE_FIELDS_CRASHES, new Object[]{field.getName(), component.getName(), module.getName()});
        }
    }

    private void verifyOnlyStrategyIsUsed(Module module, NotificationGatherer gatherer) {
        if (module instanceof ManagedConnectionModule) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.CONNECTOR_HAS_CONNECTIONSTRATEGY_AND_CONNECT_ANNOTATIONS, new Object[]{module.getName()});
        }
    }
}

