/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.ConnectivityTesting;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Filter;
import org.mule.api.annotations.MetaDataSwitch;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.Transformer;
import org.mule.api.annotations.TransformerResolver;
import org.mule.api.annotations.param.Literal;
import org.mule.api.annotations.param.Optional;
import org.mule.api.context.MuleContextAware;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.EnumType;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.visitor.ModelVisitor;
import org.mule.devkit.model.visitor.VerifyAllClassesAvailableInClasspathVisitor;
import org.mule.devkit.utils.NameUtils;
import org.mule.devkit.verifiers.util.VerifierUtils;

public class BasicAnnotationVerifier
extends AbstractBaseAnnotationVerifier {
    private static final Pattern VALID_MODULE_NAME = Pattern.compile("[A-Za-z]+[a-zA-Z0-9\\-_]*");
    static List<Class<? extends Annotation>> METHOD_ANNOTATIONS = Arrays.asList(Processor.class, Filter.class, Source.class, Transformer.class, TransformerResolver.class);

    public boolean shouldVerify(org.mule.devkit.model.module.Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void verify(org.mule.devkit.model.module.Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setGatherer(gatherer);
        this.verifyAnnotationModule(module);
        if (module.isInterface()) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.MODULE_CONNECTOR_ASSIGNED_TO_INTERFACE, new Object[0]);
        }
        if (module.isParametrized()) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.MODULE_CONNECTOR_CANNOT_HAVE_TYPE_PARAMS, new Object[0]);
        }
        if (!module.isPublic()) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.MODULE_CONNECTOR_MUST_BE_PUBLIC, new Object[0]);
        }
        for (Field variable : module.getConfigurableFields()) {
            if (variable.isFinal()) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.CONFIGURABLE_CANNOT_BE_FINAL, new Object[0]);
            }
            if (variable.isStatic()) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.CONFIGURABLE_CANNOT_BE_STATIC, new Object[0]);
            }
            if (variable.asTypeMirror().getKind() == TypeKind.ARRAY) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.CONFIGURABLE_CANNOT_BE_ARRAY, new Object[0]);
            }
            if (variable.isReservedIdentifier()) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.CONFIGURABLE_USES_RESERVED_IDENTIFIER, new Object[]{variable.getName(), variable.getName()});
            }
            if (!variable.hasGetter()) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.CONFIGURABLE_MISSING_GETTER, new Object[]{variable.getName()});
            }
            if (!variable.hasSetter()) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.CONFIGURABLE_MISSING_SETTER, new Object[]{variable.getName()});
            }
            if (variable.asTypeMirror().getKind().isPrimitive() && variable.isOptional() && (!variable.hasDefaultValue() || variable.getDefaultValue().isEmpty())) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.CONFIGURABLE_OPTIONAL_CANNOT_BE_PRIMITIVE, new Object[0]);
            }
            if (variable.hasDefaultValue() && variable.hasAnnotation(Optional.class)) {
                gatherer.warn((Identifiable)variable, (DevkitNotification)Message.OPTIONAL_REDUNDANT, new Object[]{variable.getName()});
            }
            if (!variable.hasDefaultValue() || !variable.asType().isEnum() || this.isDefaultValueValidForEnum((Variable)variable)) continue;
            gatherer.error((Identifiable)variable, (DevkitNotification)Message.DEFAULT_ENUM_NOT_VALID, new Object[0]);
        }
        this.checkRecursiveAllClassesArePresent(module);
        this.checkProcessors(module, gatherer);
        this.checkRepeatedNamesInOperations(module, gatherer);
        this.checkNotUsingConnectivityTestingEnum(module, gatherer);
        this.checkNotUsingMetaDataSwitchEnum(module, gatherer);
        this.checkLiteralAnnotation(module, gatherer);
        this.checkModuleHasExecutableElements(module, gatherer);
        this.checkModuleHasConfigurablesWithOnlyTransformers(module, gatherer);
        this.checkNotImplementingMuleInterfaces(module, gatherer);
    }

    private void checkNotImplementingMuleInterfaces(org.mule.devkit.model.module.Module module, NotificationGatherer gatherer) {
        if (module.inheritsFrom(ConnectorMetaDataEnabled.class)) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.METADATA_CONNECTOR_METADATA_ENABLED, new Object[0]);
        }
        if (module.inheritsFrom(MuleContextAware.class)) {
            gatherer.warn((Identifiable)module, (DevkitNotification)Message.MULE_CONTEXT_AWARE_INTERFACE, new Object[0]);
        }
    }

    private void checkLiteralAnnotation(org.mule.devkit.model.module.Module module, NotificationGatherer gatherer) {
        this.verifyLiteralOnUnsupportedMethods(module, gatherer);
        for (ProcessorMethod method : module.getProcessorMethods()) {
            this.checkLiteralSupportedType(module, (Method<Type>)method, gatherer);
        }
        for (ProcessorMethod method : module.getSourceMethods()) {
            this.checkLiteralSupportedType(module, (Method<Type>)method, gatherer);
        }
        for (ProcessorMethod method : module.getFilterMethods()) {
            this.checkLiteralSupportedType(module, (Method<Type>)method, gatherer);
        }
    }

    private void verifyLiteralOnUnsupportedMethods(org.mule.devkit.model.module.Module module, NotificationGatherer gatherer) {
        for (Method method : module.getTransformerResolverMethods()) {
            this.checkMustNotUseLiteral(module, (Method<Type>)method, gatherer);
        }
        for (Method method : module.getTransformerMethods()) {
            this.checkMustNotUseLiteral(module, (Method<Type>)method, gatherer);
        }
    }

    private void checkMustNotUseLiteral(org.mule.devkit.model.module.Module module, Method<Type> method, NotificationGatherer gatherer) {
        for (Parameter variable : method.getParameters()) {
            if (!variable.hasAnnotation(Literal.class)) continue;
            gatherer.error((Identifiable)variable, (DevkitNotification)Message.LITERAL_SUPPORT, new Object[0]);
        }
    }

    private void checkLiteralSupportedType(org.mule.devkit.model.module.Module module, Method<Type> method, NotificationGatherer gatherer) {
        for (Parameter variable : method.getParameters()) {
            if (!variable.hasAnnotation(Literal.class) || this.typeIsSupportedByLiteral(variable)) continue;
            gatherer.error((Identifiable)variable, (DevkitNotification)Message.LITERAL_SUPPORTS_STRING_OR_LIST, new Object[0]);
        }
    }

    private boolean typeIsSupportedByLiteral(Parameter variable) {
        String typeName = variable.getJavaType();
        return typeName.equals(String.class.getCanonicalName()) || typeName.equals(new TypeToken<List<String>>(){}.getType().toString());
    }

    private void checkNotUsingConnectivityTestingEnum(org.mule.devkit.model.module.Module module, NotificationGatherer gatherer) {
        ConnectivityTesting connectivityTesting = null;
        if (module.hasAnnotation(Module.class)) {
            connectivityTesting = ((Module)module.getAnnotation(Module.class)).connectivityTesting();
        }
        if (module.hasAnnotation(Connector.class)) {
            connectivityTesting = ((Connector)module.getAnnotation(Connector.class)).connectivityTesting();
        }
        if (!ConnectivityTesting._DEPRECATED.equals((Object)connectivityTesting)) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.TEST_CONNECTIVITY_ANNOTATION_MUST_BE_USED, new Object[0]);
        }
    }

    private void checkNotUsingMetaDataSwitchEnum(org.mule.devkit.model.module.Module module, NotificationGatherer gatherer) {
        MetaDataSwitch metaDataSwitch = null;
        if (module.hasAnnotation(Module.class)) {
            metaDataSwitch = ((Module)module.getAnnotation(Module.class)).metaData();
        }
        if (module.hasAnnotation(Connector.class)) {
            metaDataSwitch = ((Connector)module.getAnnotation(Connector.class)).metaData();
        }
        if (!MetaDataSwitch._DEPRECATED.equals((Object)metaDataSwitch)) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.METADATASWITCH_NO_LONGER_SUPPORTED, new Object[0]);
        }
    }

    private void checkRepeatedNamesInOperations(org.mule.devkit.model.module.Module module, NotificationGatherer gatherer) {
        HashMap gatheredMethods = new HashMap();
        for (Method method : module.getMethods()) {
            if (!this.needsToBeChecked((Method<Type>)method)) continue;
            String methodName = this.getMethodName(method);
            if (!gatheredMethods.containsKey(methodName)) {
                gatheredMethods.put(methodName, new ArrayList());
            }
            ((List)gatheredMethods.get(methodName)).add(method);
        }
        for (Map.Entry entry : gatheredMethods.entrySet()) {
            if (((List)entry.getValue()).size() > 1) {
                gatherer.errorAll((List)entry.getValue(), (DevkitNotification)Message.PROCESSOR_NAME_ALREADY_IN_USE, new Object[]{entry.getKey()});
            }
            if (!NameUtils.uncamel((String)((String)entry.getKey())).startsWith("no-operation-selected")) continue;
            gatherer.errorAll((List)entry.getValue(), (DevkitNotification)Message.LITERAL_CANNOT_BE_USED_AS_A_NAME, new Object[]{"@Processor/@Source/@Filter"});
        }
    }

    private String getMethodName(Method method) {
        String methodName = method.getName();
        String customName = "";
        if (method.hasAnnotation(Processor.class)) {
            customName = ((Processor)method.getAnnotation(Processor.class)).name();
        } else if (method.hasAnnotation(Filter.class)) {
            customName = ((Filter)method.getAnnotation(Filter.class)).name();
        } else if (method.hasAnnotation(Source.class)) {
            customName = ((Source)method.getAnnotation(Source.class)).name();
        }
        if (!customName.isEmpty()) {
            methodName = customName;
        }
        return StringUtils.lowerCase((String)methodName);
    }

    private boolean needsToBeChecked(Method<Type> method) {
        for (Class<? extends Annotation> allowedAnnotation : METHOD_ANNOTATIONS) {
            if (!method.hasAnnotation(allowedAnnotation)) continue;
            return true;
        }
        return false;
    }

    private void checkProcessors(org.mule.devkit.model.module.Module module, NotificationGatherer gatherer) {
        HashMap<String, Integer> exceptionsFullQualifiedNames = new HashMap<String, Integer>();
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            this.checkInvalidationAnnotation(module, processorMethod, gatherer, exceptionsFullQualifiedNames, processorMethod.invalidateConnectionOn(), Message.INVALIDATECONNECTIONON_IS_DEPRECATED, Message.INVALIDATECONNECTIONON_CANNOT_BE_USED_WITH_RECONNECTON);
            this.checkInvalidationAnnotation(module, processorMethod, gatherer, exceptionsFullQualifiedNames, processorMethod.invalidateAccessTokenOn(), Message.INVALIDATEACCESSTOKENON_IS_DEPRECATED, Message.OAUTHINVALIDATEACCESSTOKENON_CANNOT_BE_USED_WITH_RECONNECTON);
        }
        if (!exceptionsFullQualifiedNames.isEmpty()) {
            ArrayList<String> gatheredList = new ArrayList<String>();
            for (Map.Entry exceptionCount : exceptionsFullQualifiedNames.entrySet()) {
                if ((Integer)exceptionCount.getValue() <= 1) continue;
                gatheredList.add("exception " + (String)exceptionCount.getKey() + " has been used " + exceptionCount.getValue() + " times");
            }
            if (!gatheredList.isEmpty()) {
                gatherer.note((Identifiable)module, (DevkitNotification)Message.PROCESSORS_RECONNECT_ON_SAME_EXCEPTIONS, new Object[]{StringUtils.join(gatheredList, (String)";")});
            }
        }
    }

    private void checkInvalidationAnnotation(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod, NotificationGatherer gatherer, Map<String, Integer> exceptionsFullQualifiedNames, DeclaredType declaredTypeInvalidateOn, Message messageWarn, Message messageError) {
        boolean hasReconnectExceptionInProcessor;
        boolean hasReconnectExceptionsInModule = !module.reconnectOn().isEmpty();
        boolean bl = hasReconnectExceptionInProcessor = !processorMethod.reconnectOn().isEmpty();
        if (declaredTypeInvalidateOn != null) {
            if (!exceptionsFullQualifiedNames.containsKey(declaredTypeInvalidateOn.toString())) {
                exceptionsFullQualifiedNames.put(declaredTypeInvalidateOn.toString(), 0);
            }
            exceptionsFullQualifiedNames.put(declaredTypeInvalidateOn.toString(), exceptionsFullQualifiedNames.get(declaredTypeInvalidateOn.toString()) + 1);
            gatherer.warn((Identifiable)processorMethod, (DevkitNotification)messageWarn, new Object[0]);
            if (hasReconnectExceptionInProcessor || hasReconnectExceptionsInModule) {
                gatherer.error((Identifiable)processorMethod, (DevkitNotification)messageError, new Object[0]);
            }
        }
    }

    private void verifyAnnotationModule(org.mule.devkit.model.module.Module module) {
        VerifierUtils.verifyGlobalElementName((Identifiable)module, module.getModuleName(), this.getGatherer());
        if (StringUtils.isBlank((String)this.resolveFriendlyName(module))) {
            this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.FRIENDLYNAME_ATTRIBUTE_CANNOT_BE_EMPTY, new Object[0]);
        }
    }

    private String resolveFriendlyName(org.mule.devkit.model.module.Module module) {
        String friendlyName = null;
        if (module.hasAnnotation(Module.class)) {
            friendlyName = ((Module)module.getAnnotation(Module.class)).friendlyName();
        }
        if (module.hasAnnotation(Connector.class)) {
            friendlyName = ((Connector)module.getAnnotation(Connector.class)).friendlyName();
        }
        return friendlyName;
    }

    private void checkRecursiveAllClassesArePresent(org.mule.devkit.model.module.Module module) throws AnnotationVerificationException {
        VerifyAllClassesAvailableInClasspathVisitor verifyAllClassesAvailableInClasspathVisitor = new VerifyAllClassesAvailableInClasspathVisitor();
        module.accept((ModelVisitor)verifyAllClassesAvailableInClasspathVisitor);
        if (!verifyAllClassesAvailableInClasspathVisitor.isAllClassesAvailable()) {
            this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.REQUIRED_CLASSES_NOT_FOUND, new Object[]{verifyAllClassesAvailableInClasspathVisitor.getClassesNotAvailable().toString()});
        }
    }

    private boolean isDefaultValueValidForEnum(Variable variable) {
        for (Identifiable enumMember : ((EnumType)variable.asType()).getEnumConstants()) {
            String enumConstant = enumMember.getName();
            if (!variable.getDefaultValue().equals(enumConstant)) continue;
            return true;
        }
        return false;
    }

    private void checkModuleHasExecutableElements(org.mule.devkit.model.module.Module module, NotificationGatherer gatherer) {
        if (!(module.hasProcessors() || module.hasTransformers() || module.hasTransformerResolver() || module.hasSources() || module.hasFilters())) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.CONNECTOR_HAS_NO_EXECUTABLE_ELEMENTS, new Object[]{module.getClassName()});
        }
    }

    private void checkModuleHasConfigurablesWithOnlyTransformers(org.mule.devkit.model.module.Module module, NotificationGatherer gatherer) {
        if (!(module.hasProcessors() || module.hasSources() || module.hasFilters() || !module.hasTransformers() && !module.hasTransformerResolver() || module.getConfigurableFields().isEmpty())) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.CONFIGURABLE_FOR_PURE_TRANSFORMER, new Object[]{module.getClassName()});
        }
    }
}

