/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.beans;

import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.spring.beans.MethodsBeanDefinitionParserGenerator;
import org.mule.devkit.generation.spring.beans.global.AbstractGlobalElementDefinitionParserGenerator;
import org.mule.devkit.generation.spring.beans.global.ConfigurationDefinitionParserGenerator;
import org.mule.devkit.generation.spring.beans.global.ConnectionManagementDefinitionParserGenerator;
import org.mule.devkit.generation.spring.beans.global.HttpBasicAuthDefinitionParserGenerator;
import org.mule.devkit.generation.spring.beans.global.ModuleDefinitionParserGenerator;
import org.mule.devkit.generation.spring.beans.global.OAuthDefinitionParserGenerator;
import org.mule.devkit.generation.spring.global.factory.AbstractGlobalElementResolver;
import org.mule.devkit.generation.utils.global.element.GlobalElementFactory;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

public class BeanDefinitionParserGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.DEFAULT_SAVE_ACCESS_TOKEN_CALLBACK_FACTORY, Product.DEFAULT_RESTORE_ACCESS_TOKEN_CALLBACK_FACTORY, Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, Product.BASIC_CONNECTOR_ADAPTER, Product.INJECTION_ADAPTER, Product.OAUTH_ADAPTER, Product.MESSAGE_PROCESSOR, Product.MESSAGE_SOURCE, Product.FILTER, Product.EXPRESSION_HOLDER, Product.OAUTH_MANAGER, Product.POOL_CONFIG, Product.POOL_IMPL);
    private static final List<Product> PRODUCES = Arrays.asList(Product.BEAN_DEFINITION_PARSER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void generate(Module module) throws GenerationException {
        for (AbstractGlobalElementDefinitionParserGenerator globalElement : this.getGlobalElementBeanDefinitionGenerator(module)) {
            globalElement.setCtx(this.ctx());
            globalElement.generateGlobalElement(module);
        }
        MethodsBeanDefinitionParserGenerator methodsBeanDefinitionParserGenerator = new MethodsBeanDefinitionParserGenerator();
        methodsBeanDefinitionParserGenerator.setCtx(this.ctx());
        methodsBeanDefinitionParserGenerator.generate(module);
    }

    private List<AbstractGlobalElementDefinitionParserGenerator> getGlobalElementBeanDefinitionGenerator(Module module) {
        return GlobalElementFactory.getGlobalElementBeanDefinitionGenerator(module, new AbstractGlobalElementResolver<AbstractGlobalElementDefinitionParserGenerator>(){

            @Override
            public AbstractGlobalElementDefinitionParserGenerator genericGlobalElement() {
                return new ModuleDefinitionParserGenerator();
            }

            @Override
            public List<? extends AbstractGlobalElementDefinitionParserGenerator> connectionManagementGlobalElement() {
                return Arrays.asList(new ConnectionManagementDefinitionParserGenerator());
            }

            @Override
            public AbstractGlobalElementDefinitionParserGenerator oauthGlobalElement() {
                return new OAuthDefinitionParserGenerator();
            }

            @Override
            public AbstractGlobalElementDefinitionParserGenerator httpBasicAuthGlobalElement() {
                return new HttpBasicAuthDefinitionParserGenerator();
            }

            @Override
            public List<? extends AbstractGlobalElementDefinitionParserGenerator> basicGlobalElement() {
                return Arrays.asList(new ConfigurationDefinitionParserGenerator());
            }
        });
    }
}

