/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.annotations.Filter;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.config.MuleManifest;
import org.mule.config.spring.parsers.specific.MessageProcessorDefinitionParser;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.utils.NameUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class NamespaceHandlerGenerator
extends AbstractMuleGenerator
implements MultiModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.BEAN_DEFINITION_PARSER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.NAMESPACE_HANDLER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> processableModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            processableModules.add(module);
        }
        return processableModules;
    }

    public void generate(List<Module> modules) {
        Map<String, Module> targetNamespaces = this.getTargetNamespaces(modules);
        for (String targetNamespace : targetNamespaces.keySet()) {
            GeneratedClass namespaceHandlerClass = this.getNamespaceHandlerClass(targetNamespaces.get(targetNamespace));
            GeneratedField loggerField = this.generateLoggerField(namespaceHandlerClass);
            GeneratedMethod handleExceptionMethod = this.generateHandleExceptionMethod(namespaceHandlerClass, loggerField, modules.get(0));
            GeneratedMethod init = namespaceHandlerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "init");
            init.javadoc().add((Object)"Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. \n@see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)");
            for (Module module : modules) {
                if (!module.getXmlNamespace().equals(targetNamespace)) continue;
                this.registerConfigOrStrategyElement(init, module, handleExceptionMethod);
                this.registerBeanDefinitionParserForEachFilter(module, init, handleExceptionMethod);
                this.registerBeanDefinitionParserForEachProcessor(module, init, handleExceptionMethod);
                this.registerBeanDefinitionParserForEachSource(module, init, handleExceptionMethod);
                this.registerBeanDefinitionParserForEachTransformer(module, init, handleExceptionMethod);
            }
        }
    }

    private GeneratedMethod generateHandleExceptionMethod(GeneratedClass namespaceHandlerClass, GeneratedField loggerField, Module module) {
        GeneratedMethod handleExceptionMethod = namespaceHandlerClass.method(4, (Type)this.context.getCodeModel().VOID, "handleException");
        GeneratedVariable beanNameParameter = handleExceptionMethod.param(String.class, "beanName");
        GeneratedVariable beanScopeParameter = handleExceptionMethod.param(String.class, "beanScope");
        GeneratedVariable noClassDefFoundErrorParameter = handleExceptionMethod.param(NoClassDefFoundError.class, "noClassDefFoundError");
        GeneratedVariable muleVersion = handleExceptionMethod.body().decl((Type)this.ref(String.class), "muleVersion", ExpressionFactory.lit((String)""));
        GeneratedTry muleVersionManifestTry = handleExceptionMethod.body()._try();
        muleVersionManifestTry.body().assign((AssignmentTarget)muleVersion, (GeneratedExpression)this.ref(MuleManifest.class).staticInvoke("getProductVersion"));
        muleVersionManifestTry._catch(this.ref(Exception.class)).body().add((Statement)loggerField.invoke("error").arg(ExpressionFactory.lit((String)"Problem while reading mule version")));
        GeneratedExpression concatenatedParameter = ExpressionFactory.lit((String)"Cannot launch the mule app, the  ").plus((GeneratedExpression)beanScopeParameter).plus(ExpressionFactory.lit((String)" [")).plus((GeneratedExpression)beanNameParameter).plus(ExpressionFactory.lit((String)("] within the connector [" + module.getModuleName() + "] is not supported in mule "))).plus((GeneratedExpression)muleVersion);
        handleExceptionMethod.body().add((Statement)loggerField.invoke("error").arg(concatenatedParameter));
        handleExceptionMethod.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(FatalBeanException.class)).arg(concatenatedParameter).arg((GeneratedExpression)noClassDefFoundErrorParameter));
        return handleExceptionMethod;
    }

    private Map<String, Module> getTargetNamespaces(List<Module> modules) {
        HashMap<String, Module> targetNamespaces = new HashMap<String, Module>();
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC || targetNamespaces.containsKey(module.getXmlNamespace())) continue;
            targetNamespaces.put(module.getXmlNamespace(), module);
        }
        return targetNamespaces;
    }

    private GeneratedClass getNamespaceHandlerClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".config");
        GeneratedClass clazz = pkg._class(NameUtils.camel((String)module.getModuleName()) + "NamespaceHandler", NamespaceHandlerSupport.class);
        clazz.javadoc().add((Object)("Registers bean definitions parsers for handling elements in <code>" + module.getXmlNamespace() + "</code>."));
        this.ctx().registerProduct(Product.NAMESPACE_HANDLER, null, module.getXmlNamespace(), (Object)clazz);
        return clazz;
    }

    private void registerConfigOrStrategyElement(GeneratedMethod init, Module module, GeneratedMethod handleExceptionMethod) {
        if (module.manager().connectionComponents().isEmpty()) {
            this.registerConfigGlobalElement(init, module, handleExceptionMethod, "config", module.getConfigElementName());
        } else {
            for (ConnectionComponent connectionComponent : module.manager().connectionComponents()) {
                this.registerConfigGlobalElement(init, module, handleExceptionMethod, connectionComponent.configElementName(), connectionComponent.configElementName());
            }
        }
    }

    private void registerConfigGlobalElement(GeneratedMethod init, Module module, GeneratedMethod handleExceptionMethod, String productName, String configElementName) {
        GeneratedClass configBeanDefinitionParser = (GeneratedClass)this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, (Identifiable)module, productName);
        GeneratedInvocation invocation = ExpressionFactory._this().invoke("registerBeanDefinitionParser").arg(configElementName).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)configBeanDefinitionParser));
        this.wrapRegisterBeanForException(init, handleExceptionMethod, invocation, productName, "@Config");
    }

    private void wrapRegisterBeanForException(GeneratedMethod init, GeneratedMethod handleExceptionMethod, GeneratedInvocation invocation, String beanName, String beanScope) {
        GeneratedTry generatedTry = init.body()._try();
        generatedTry.body().add((Statement)invocation);
        GeneratedCatchBlock generatedCatchBlock = generatedTry._catch(this.ref(NoClassDefFoundError.class));
        GeneratedVariable ex = generatedCatchBlock.param("ex");
        generatedCatchBlock.body().invoke(handleExceptionMethod).arg(ExpressionFactory.lit((String)beanName)).arg(ExpressionFactory.lit((String)beanScope)).arg((GeneratedExpression)ex);
    }

    private void registerBeanDefinitionParserForEachProcessor(Module module, GeneratedMethod init, GeneratedMethod exHandler) {
        if (module instanceof OAuthModule || module.manager().oauth2Component().isPresent()) {
            GeneratedClass authorizeMessageProcessorClass = (GeneratedClass)this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, (Identifiable)module, "authorize");
            GeneratedInvocation invocationAuthorize = ExpressionFactory._this().invoke("registerBeanDefinitionParser").arg(ExpressionFactory.lit((String)"authorize")).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)authorizeMessageProcessorClass));
            this.wrapRegisterBeanForException(init, exHandler, invocationAuthorize, "authorize", "@Processor");
            GeneratedClass unauthorizeMessageProcessorClass = (GeneratedClass)this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, (Identifiable)module, "unauthorize");
            GeneratedInvocation invocationUnauthorize = ExpressionFactory._this().invoke("registerBeanDefinitionParser").arg(ExpressionFactory.lit((String)"unauthorize")).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)unauthorizeMessageProcessorClass));
            this.wrapRegisterBeanForException(init, exHandler, invocationUnauthorize, "unauthorize", "@Processor");
        }
        for (Method executableElement : module.getProcessorMethods()) {
            this.registerBeanDefinitionParserForProcessor(init, executableElement, exHandler);
        }
    }

    private void registerBeanDefinitionParserForEachSource(Module module, GeneratedMethod init, GeneratedMethod exHandler) {
        for (Method executableElement : module.getSourceMethods()) {
            this.registerBeanDefinitionParserForSource(init, executableElement, exHandler);
        }
    }

    private void registerBeanDefinitionParserForEachFilter(Module module, GeneratedMethod init, GeneratedMethod exHandler) {
        for (Method executableElement : module.getFilterMethods()) {
            this.registerBeanDefinitionParserForFilter(init, executableElement, exHandler);
        }
    }

    private void registerBeanDefinitionParserForEachTransformer(Module module, GeneratedMethod init, GeneratedMethod exHandler) {
        for (Method executableElement : module.getTransformerMethods()) {
            GeneratedInvocation invocation = ExpressionFactory._this().invoke("registerBeanDefinitionParser");
            invocation.arg(ExpressionFactory.lit((String)NameUtils.uncamel((String)executableElement.getName())));
            String transformerClassName = module.getPackage().getName() + ".transformers" + "." + executableElement.getCapitalizedName() + "Transformer";
            invocation.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(MessageProcessorDefinitionParser.class)).arg(this.ref(transformerClassName).boxify().dotclass()));
            this.wrapRegisterBeanForException(init, exHandler, invocation, NameUtils.uncamel((String)executableElement.getName()), "@Transformer");
        }
    }

    private void registerBeanDefinitionParserForProcessor(GeneratedMethod init, Method processorMethod, GeneratedMethod exHandler) {
        GeneratedClass beanDefinitionParser = (GeneratedClass)this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, processorMethod.parent(), processorMethod.getName());
        Processor processor = (Processor)processorMethod.getAnnotation(Processor.class);
        String elementName = processorMethod.getName();
        if (processor.name().length() != 0) {
            elementName = processor.name();
        }
        GeneratedInvocation invocation = ExpressionFactory._this().invoke("registerBeanDefinitionParser").arg(ExpressionFactory.lit((String)NameUtils.uncamel((String)elementName))).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)beanDefinitionParser));
        this.wrapRegisterBeanForException(init, exHandler, invocation, NameUtils.uncamel((String)elementName), "@Processor");
    }

    private void registerBeanDefinitionParserForSource(GeneratedMethod init, Method sourceMethod, GeneratedMethod exHandler) {
        GeneratedClass beanDefinitionParser = (GeneratedClass)this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, sourceMethod.parent(), sourceMethod.getName());
        Source source = (Source)sourceMethod.getAnnotation(Source.class);
        String elementName = sourceMethod.getName();
        if (source.name().length() != 0) {
            elementName = source.name();
        }
        GeneratedInvocation invocation = ExpressionFactory._this().invoke("registerBeanDefinitionParser").arg(ExpressionFactory.lit((String)NameUtils.uncamel((String)elementName))).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)beanDefinitionParser));
        this.wrapRegisterBeanForException(init, exHandler, invocation, NameUtils.uncamel((String)elementName), "@Source");
    }

    private void registerBeanDefinitionParserForFilter(GeneratedMethod init, Method filterMethod, GeneratedMethod exHandler) {
        GeneratedClass beanDefinitionParser = (GeneratedClass)this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, filterMethod.parent(), filterMethod.getName());
        Filter filter = (Filter)filterMethod.getAnnotation(Filter.class);
        String elementName = filterMethod.getName();
        if (filter.name().length() != 0) {
            elementName = filter.name();
        }
        GeneratedInvocation invocation = ExpressionFactory._this().invoke("registerBeanDefinitionParser").arg(ExpressionFactory.lit((String)NameUtils.uncamel((String)elementName))).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)beanDefinitionParser));
        this.wrapRegisterBeanForException(init, exHandler, invocation, NameUtils.uncamel((String)elementName), "@Filter");
    }
}

