/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.pooling;

import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.security.oauth.callback.ProcessCallback;
import org.mule.util.pool.LifecyleEnabledObjectPool;

@JustOnce
public class PoolProcessTemplateGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, Product.INJECTION_ADAPTER, Product.OAUTH_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.POOL_PROCESS_TEMPLATE);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.usesPooling();
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass processTemplate = this.getPoolProcessTemplateClass(module);
        GeneratedField pool = this.generatePoolField(processTemplate);
        this.generateConstructor(processTemplate, pool);
        this.generateExecuteMethod(module, processTemplate, pool);
        this.generateExecuteMethodForMessage(module, processTemplate, pool);
    }

    private void generateExecuteMethod(Module module, GeneratedClass processTemplate, GeneratedField pool) {
        GeneratedClass capabilitiesAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module);
        GeneratedMethod execute = processTemplate.method(1, (Type)processTemplate.typeParams()[0], "execute");
        execute._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = execute.param((Type)this.ref(ProcessCallback.class).narrow((TypeReference)processTemplate.typeParams()[0]).narrow((TypeReference)capabilitiesAdapterClass), "processCallback");
        execute.param((Type)this.ref(MessageProcessor.class), "messageProcessors");
        execute.param((Type)this.ref(MuleEvent.class), "event");
        GeneratedVariable object = execute.body().decl((Type)capabilitiesAdapterClass, "object", (GeneratedExpression)ExpressionFactory.cast((Type)capabilitiesAdapterClass, (GeneratedExpression)pool.invoke("borrowObject")));
        GeneratedTry tryStatement = execute.body()._try();
        tryStatement.body()._return((GeneratedExpression)processCallback.invoke("process").arg((GeneratedExpression)object));
        tryStatement._finally().add((Statement)pool.invoke("returnObject").arg((GeneratedExpression)object));
    }

    private void generateExecuteMethodForMessage(Module module, GeneratedClass processTemplate, GeneratedField pool) {
        GeneratedClass capabilitiesAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module);
        GeneratedMethod execute = processTemplate.method(1, (Type)processTemplate.typeParams()[0], "execute");
        execute._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = execute.param((Type)this.ref(ProcessCallback.class).narrow((TypeReference)processTemplate.typeParams()[0]).narrow((TypeReference)capabilitiesAdapterClass), "processCallback");
        execute.param((Type)this.ref(Filter.class), "filter");
        execute.param((Type)this.ref(MuleMessage.class), "message");
        GeneratedVariable object = execute.body().decl((Type)capabilitiesAdapterClass, "object", (GeneratedExpression)ExpressionFactory.cast((Type)capabilitiesAdapterClass, (GeneratedExpression)pool.invoke("borrowObject")));
        GeneratedTry tryStatement = execute.body()._try();
        tryStatement.body()._return((GeneratedExpression)processCallback.invoke("process").arg((GeneratedExpression)object));
        tryStatement._finally().add((Statement)pool.invoke("returnObject").arg((GeneratedExpression)object));
    }

    private void generateConstructor(GeneratedClass processTemplate, GeneratedField pool) {
        GeneratedMethod constructor = processTemplate.constructor(1);
        GeneratedVariable newPool = constructor.param((Type)this.ref(LifecyleEnabledObjectPool.class), "pool");
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)pool), (GeneratedExpression)newPool);
    }

    private GeneratedField generatePoolField(GeneratedClass processTemplate) {
        return processTemplate.field(12, (Type)this.ref(LifecyleEnabledObjectPool.class), "pool");
    }

    private GeneratedClass getPoolProcessTemplateClass(Module module) {
        GeneratedClass capabilitiesAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module);
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".pooling");
        GeneratedClass processTemplateClass = pkg._class(1, "PoolProcessTemplate");
        TypeVariable payload = processTemplateClass.generify("P");
        processTemplateClass._implements(this.ref(ProcessTemplate.class).narrow((TypeReference)payload).narrow((TypeReference)capabilitiesAdapterClass));
        this.ctx().registerProduct(Product.POOL_PROCESS_TEMPLATE, (Object)processTemplateClass);
        return processTemplateClass;
    }
}

