/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.AbstractCapabilityGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectorAdapter;

public class ConnectionManagementConnectorAdapterGenerator
extends AbstractCapabilityGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.PROCESS_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof ManagedConnectionModule || !module.manager().connectionManagementComponents().isEmpty();
    }

    public void generate(Module module) {
        GeneratedClass connectionManagementAdapterClass = this.createConnectionManagementAdapter(module);
        connectionManagementAdapterClass.javadoc().add((Object)("A <code>" + connectionManagementAdapterClass.name() + "</code> is a wrapper around "));
        connectionManagementAdapterClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        connectionManagementAdapterClass.javadoc().add((Object)" that implements {@link org.mule.devkit.dynamic.api.helper.Connection} interface.");
    }

    private GeneratedClass createConnectionManagementAdapter(Module module) {
        GeneratedClass previous = this.ctx().getProduct(Product.INJECTION_ADAPTER, (Identifiable)module) != null ? (GeneratedClass)this.ctx().getProduct(Product.INJECTION_ADAPTER, (Identifiable)module) : (GeneratedClass)this.ctx().getProduct(Product.PROCESS_ADAPTER, (Identifiable)module);
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".adapters");
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass clazz = pkg._class(modifiers, module.getClassName() + "ConnectionManagementAdapter", (TypeReference)previous);
        clazz._implements(this.ref(ConnectionManagementConnectorAdapter.class));
        this.ctx().registerProduct(Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, (Identifiable)module, (Object)clazz);
        return clazz;
    }
}

